/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.index.ProxiedHit;
import com.zimbra.cs.index.ProxiedQueryInfo;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.util.ParseMailboxID;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ProxyTarget;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxiedQueryResults
extends ZimbraQueryResultsImpl {
    public static final int SEARCH_ALL_MAILBOXES = 1234;
    protected static final int MIN_BUFFER_CHUNK_SIZE = 25;
    protected ArrayList<ProxiedHit> mHitBuffer;
    protected int mBufferStartOffset = 0;
    protected int mBufferEndOffset = 0;
    protected int mIterOffset = 0;
    protected boolean mAtEndOfList = false;
    protected String mServer;
    protected AuthToken mAuthToken;
    protected String mTargetAcctId = null;
    protected SoapProtocol mResponseProto = null;
    private SearchParams mSearchParams;
    private boolean isMultipleMailboxes = false;
    private boolean isAllMailboxes = false;
    private List<ParseMailboxID> mMailboxes;
    private List<QueryInfo> mInfo = new ArrayList<QueryInfo>();

    private void setSearchParams(SearchParams params) {
        this.mSearchParams = (SearchParams)params.clone();
        this.mSearchParams.clearCursor();
        this.mSearchParams.setOffset(0);
    }

    public ProxiedQueryResults(SoapProtocol respProto, AuthToken authToken, String targetAccountId, String server, SearchParams params, Mailbox.SearchResultMode mode) {
        super(params.getTypes(), params.getSortBy(), mode);
        this.setSearchParams(params);
        this.mAuthToken = authToken;
        this.mServer = server;
        this.mTargetAcctId = targetAccountId;
        this.mResponseProto = respProto;
    }

    public ProxiedQueryResults(SoapProtocol respProto, AuthToken authToken, String server, SearchParams params, Mailbox.SearchResultMode mode) {
        super(params.getTypes(), params.getSortBy(), mode);
        this.setSearchParams(params);
        this.mSearchParams.setOffset(0);
        this.mAuthToken = authToken;
        this.mServer = server;
        this.mResponseProto = respProto;
    }

    public ProxiedQueryResults(SoapProtocol respProto, AuthToken authToken, String server, SearchParams params, Mailbox.SearchResultMode mode, int searchAllMailboxes) {
        super(params.getTypes(), params.getSortBy(), mode);
        assert (searchAllMailboxes == 1234);
        this.setSearchParams(params);
        this.mAuthToken = authToken;
        this.mServer = server;
        this.isMultipleMailboxes = true;
        this.isAllMailboxes = true;
        this.mResponseProto = respProto;
    }

    public ProxiedQueryResults(SoapProtocol respProto, AuthToken authToken, String server, SearchParams params, Mailbox.SearchResultMode mode, List<ParseMailboxID> mailboxes) {
        super(params.getTypes(), params.getSortBy(), mode);
        this.setSearchParams(params);
        this.mAuthToken = authToken;
        this.mServer = server;
        this.isMultipleMailboxes = true;
        this.mResponseProto = respProto;
        this.mMailboxes = mailboxes;
    }

    @Override
    public void doneWithSearchResults() {
    }

    @Override
    public ZimbraHit skipToHit(int hitNo) throws ServiceException {
        this.mIterOffset = hitNo;
        if (this.mIterOffset < this.mBufferStartOffset || this.mIterOffset > this.mBufferEndOffset) {
            if (this.mIterOffset > this.mBufferEndOffset && this.mAtEndOfList) {
                return null;
            }
            this.mBufferStartOffset = this.mIterOffset;
            this.mBufferEndOffset = this.mIterOffset;
            this.mHitBuffer = null;
            this.mAtEndOfList = false;
        }
        return this.getNext();
    }

    @Override
    public void resetIterator() {
        this.mIterOffset = 0;
        this.mAtEndOfList = false;
    }

    @Override
    public ZimbraHit getNext() throws ServiceException {
        ZimbraHit retVal = this.peekNext();
        if (retVal != null) {
            ++this.mIterOffset;
        }
        return retVal;
    }

    @Override
    public ZimbraHit peekNext() throws ServiceException {
        if (this.mIterOffset >= this.mBufferEndOffset && !this.bufferNextHits()) {
            return null;
        }
        return this.mHitBuffer.get(this.mIterOffset - this.mBufferStartOffset);
    }

    String getServer() {
        return this.mServer;
    }

    public String toString() {
        String url;
        try {
            Server server = Provisioning.getInstance().get(Provisioning.ServerBy.name, this.mServer);
            url = URLUtil.getAdminURL(server);
        }
        catch (ServiceException ex) {
            url = this.mServer;
        }
        return "ProxiedQueryResults(url=" + url + ", acctId=" + this.mTargetAcctId + ")";
    }

    private boolean bufferNextHits() throws ServiceException {
        if (this.mAtEndOfList || this.mSearchParams.getHopCount() > 5) {
            return false;
        }
        this.mBufferStartOffset = this.mIterOffset;
        int chunkSizeToUse = this.mSearchParams.getLimit() * 2;
        if (chunkSizeToUse < 25) {
            chunkSizeToUse = 25;
        }
        if (chunkSizeToUse > 500) {
            chunkSizeToUse = 500;
        }
        this.mBufferEndOffset = this.mBufferStartOffset + chunkSizeToUse;
        this.mHitBuffer = new ArrayList(chunkSizeToUse);
        QName qnrequest = this.isMultipleMailboxes ? AdminConstants.SEARCH_MULTIPLE_MAILBOXES_REQUEST : MailConstants.SEARCH_REQUEST;
        Element searchElt = Element.create(this.mResponseProto, qnrequest);
        this.mSearchParams.setOffset(this.mBufferStartOffset);
        this.mSearchParams.setLimit(chunkSizeToUse);
        this.mSearchParams.encodeParams(searchElt);
        if (this.isMultipleMailboxes) {
            if (this.isAllMailboxes) {
                Element mbxElt = searchElt.addElement("mbx");
                ParseMailboxID id = ParseMailboxID.serverAll(this.mServer);
                mbxElt.addAttribute("id", id.getString());
            } else {
                for (ParseMailboxID id : this.mMailboxes) {
                    searchElt.addElement("mbx").addAttribute("name", id.getEmailAddress());
                }
            }
        }
        Server server = Provisioning.getInstance().get(Provisioning.ServerBy.name, this.mServer);
        String baseurl = null;
        if (!this.isMultipleMailboxes) {
            try {
                baseurl = URLUtil.getSoapURL(server, false);
            }
            catch (ServiceException e) {
                // empty catch block
            }
        }
        if (baseurl == null) {
            baseurl = URLUtil.getAdminURL(server, "/service/admin/soap/", true);
        }
        ProxyTarget proxy = new ProxyTarget(server, this.mAuthToken, baseurl + qnrequest.getName());
        ZimbraSoapContext zscInbound = this.mSearchParams.getRequestContext();
        ZimbraSoapContext zscProxy = zscInbound != null ? new ZimbraSoapContext(zscInbound, this.mTargetAcctId) : new ZimbraSoapContext(this.mAuthToken, this.mTargetAcctId, this.mResponseProto, this.mResponseProto, this.mSearchParams.getHopCount() + 1);
        Element searchResp = null;
        try {
            searchResp = DocumentHandler.proxyWithNotification(searchElt, proxy, zscProxy, zscInbound);
        }
        catch (SoapFaultException sfe) {
            ZimbraLog.index.warn("Unable to (" + sfe.toString() + ") fetch search results from remote server " + proxy);
            this.mAtEndOfList = true;
            this.mBufferEndOffset = this.mIterOffset;
            return false;
        }
        catch (ServiceException e) {
            if ("service.PROXY_ERROR".equals(e.getCode())) {
                ZimbraLog.index.warn("Unable to (" + e.toString() + ") fetch search results from remote server " + proxy);
                this.mAtEndOfList = true;
                this.mBufferEndOffset = this.mIterOffset;
                return false;
            }
            throw e;
        }
        int hitOffset = (int)searchResp.getAttributeLong("offset");
        boolean hasMore = searchResp.getAttributeBool("more");
        assert (this.mBufferStartOffset == hitOffset);
        int bufferIdx = 0;
        int stop = this.mBufferEndOffset - this.mBufferStartOffset;
        Iterator<Element> iter = searchResp.elementIterator();
        while (iter.hasNext() && bufferIdx < stop) {
            Element e = iter.next();
            if (e.getName().equalsIgnoreCase("info")) {
                for (Element info : e.listElements()) {
                    this.mInfo.add(new ProxiedQueryInfo(info));
                }
                continue;
            }
            this.mHitBuffer.add(bufferIdx++, new ProxiedHit(this, e));
        }
        if (bufferIdx < stop || !hasMore) {
            this.mBufferEndOffset = this.mBufferStartOffset + bufferIdx;
            if (hasMore) assert (!hasMore);
            this.mAtEndOfList = true;
        } else assert (this.mBufferEndOffset == this.mBufferStartOffset + bufferIdx);
        assert (this.mBufferStartOffset <= this.mIterOffset);
        return this.mBufferEndOffset > this.mIterOffset;
    }

    @Override
    public List<QueryInfo> getResultInfo() {
        return this.mInfo;
    }

    @Override
    public int estimateResultSize() {
        return 0;
    }
}

