/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.index.ProxiedQueryResults;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.service.util.ItemId;

public class ProxiedHit
extends ZimbraHit {
    protected long mProxiedDate = -1L;
    protected int mProxiedConvId = -1;
    protected int mProxiedMsgId = -1;
    protected byte mProxiedItemType = (byte)-1;
    protected String mProxiedSubject = null;
    protected String mProxiedName = null;
    protected ItemId itemID = null;
    protected Element mElement;

    public ItemId getParsedItemID() throws ServiceException {
        if (this.itemID == null) {
            this.itemID = new ItemId(this.mElement.getAttribute("id"), (String)null);
        }
        return this.itemID;
    }

    public ProxiedHit(ProxiedQueryResults results, Element elt) {
        super(results, null, 0.0f);
        this.mElement = elt;
    }

    long getSize() throws ServiceException {
        return (int)this.mElement.getAttributeLong("s", 0L);
    }

    long getDate() throws ServiceException {
        if (this.mProxiedDate < 0L) {
            this.mProxiedDate = this.mElement.getAttributeLong("d", 0L);
            if (this.mProxiedDate == 0L) {
                this.mProxiedDate = this.mElement.getAttributeLong("sf", 0L);
            }
        }
        return this.mProxiedDate;
    }

    int getConversationId() throws ServiceException {
        if (this.mProxiedConvId <= 0) {
            this.mProxiedConvId = (int)this.mElement.getAttributeLong("cid", 0L);
        }
        return this.mProxiedConvId;
    }

    public MailItem getMailItem() {
        return null;
    }

    public int getItemId() throws ServiceException {
        if (this.mProxiedMsgId <= 0) {
            ItemId id = this.getParsedItemID();
            this.mProxiedMsgId = id.getId();
        }
        return this.mProxiedMsgId;
    }

    byte getItemType() throws ServiceException {
        if (this.mProxiedItemType <= 0) {
            this.mProxiedItemType = (byte)this.mElement.getAttributeLong("t");
        }
        return this.mProxiedItemType;
    }

    void setItem(MailItem item) {
        assert (false);
    }

    boolean itemIsLoaded() {
        return true;
    }

    String getSubject() throws ServiceException {
        if (this.mProxiedSubject == null) {
            this.mProxiedSubject = this.mElement.getAttribute("su", null);
            if (this.mProxiedSubject == null) {
                this.mProxiedSubject = this.mElement.getAttribute("sf");
            }
        }
        return this.mProxiedSubject;
    }

    String getFragment() {
        Element frag = this.mElement.getOptionalElement("fr");
        if (frag != null) {
            return frag.getText();
        }
        return "";
    }

    String getName() throws ServiceException {
        if (this.mProxiedName == null) {
            this.mProxiedName = this.mElement.getAttribute("sf");
        }
        return this.mProxiedName;
    }

    public String toString() {
        return this.mElement.toString();
    }

    public String getServer() {
        ProxiedQueryResults res = (ProxiedQueryResults)this.getResults();
        return res.getServer();
    }

    public Element getElement() {
        return this.mElement;
    }

    boolean isLocal() {
        return false;
    }
}

