/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Note;
import org.apache.lucene.document.Document;

public final class NoteHit
extends ZimbraHit {
    private Note mNote = null;
    private int mMailItemId;

    public NoteHit(ZimbraQueryResultsImpl results, Mailbox mbx, int mailItemId, Document d, float score, MailItem.UnderlyingData ud) throws ServiceException {
        super(results, mbx, score);
        this.mMailItemId = mailItemId;
        if (ud != null) {
            this.mNote = (Note)mbx.getItemFromUnderlyingData(ud);
        }
    }

    public long getDate() throws ServiceException {
        if (this.mCachedDate == -1L) {
            this.mCachedDate = this.getNote().getDate();
        }
        return this.mCachedDate;
    }

    public MailItem getMailItem() throws ServiceException {
        return this.getNote();
    }

    public Note getNote() throws ServiceException {
        if (this.mNote == null) {
            this.mNote = this.getMailbox().getNoteById(null, this.getItemId());
        }
        return this.mNote;
    }

    void setItem(MailItem item) {
        this.mNote = (Note)item;
    }

    boolean itemIsLoaded() {
        return this.mNote != null;
    }

    public String getSubject() throws ServiceException {
        if (this.mCachedSubj == null) {
            this.mCachedSubj = this.getNote().getSubject();
        }
        return this.mCachedSubj;
    }

    public String getName() throws ServiceException {
        if (this.mCachedName == null) {
            this.mCachedName = this.getNote().getSubject();
        }
        return this.mCachedName;
    }

    public int getConversationId() {
        return 0;
    }

    public int getItemId() {
        return this.mMailItemId;
    }

    public byte getItemType() {
        return 9;
    }

    public long getSize() throws ServiceException {
        return this.getNote().getSize();
    }

    public String toString() {
        int convId = this.getConversationId();
        String msgStr = "";
        String noteStr = "";
        try {
            msgStr = Integer.toString(this.getItemId());
            noteStr = this.getNote().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "NT: " + super.toString() + " C" + convId + " M" + msgStr + " " + noteStr;
    }

    public int getHitType() {
        return 4;
    }

    public int doitVirt() {
        return 0;
    }
}

