/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.HitIdGrouper;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiQueryResults
implements ZimbraQueryResults {
    SortBy mSortOrder;
    ZimbraQueryResults[] mResults;
    private ZimbraHit mCachedNextHit = null;

    @Override
    public SortBy getSortBy() {
        return this.mSortOrder;
    }

    public MultiQueryResults(ZimbraQueryResults[] res, SortBy sortOrder) {
        this.mSortOrder = sortOrder;
        this.mResults = new ZimbraQueryResults[res.length];
        for (int i = 0; i < res.length; ++i) {
            this.mResults[i] = HitIdGrouper.Create(res[i], sortOrder);
        }
    }

    @Override
    public ZimbraHit peekNext() throws ServiceException {
        this.bufferNextHit();
        return this.mCachedNextHit;
    }

    private void internalGetNextHit() throws ServiceException {
        if (this.mCachedNextHit == null) {
            if (this.mSortOrder == SortBy.NONE) {
                for (ZimbraQueryResults res : this.mResults) {
                    this.mCachedNextHit = res.getNext();
                    if (this.mCachedNextHit == null) continue;
                    return;
                }
            } else {
                int currentBestHitOffset = -1;
                ZimbraHit currentBestHit = null;
                for (int i = 0; i < this.mResults.length; ++i) {
                    ZimbraQueryResults op = this.mResults[i];
                    if (!op.hasNext()) continue;
                    if (currentBestHitOffset == -1) {
                        currentBestHitOffset = i;
                        currentBestHit = op.peekNext();
                        continue;
                    }
                    ZimbraHit opNext = op.peekNext();
                    int result = opNext.compareBySortField(this.mSortOrder, currentBestHit);
                    if (result >= 0) continue;
                    currentBestHitOffset = i;
                    currentBestHit = opNext;
                }
                if (currentBestHitOffset > -1) {
                    this.mCachedNextHit = this.mResults[currentBestHitOffset].getNext();
                    assert (this.mCachedNextHit == currentBestHit);
                }
            }
        }
    }

    @Override
    public ZimbraHit skipToHit(int hitNo) throws ServiceException {
        this.resetIterator();
        for (int i = 0; i < hitNo; ++i) {
            if (!this.hasNext()) {
                return null;
            }
            this.getNext();
        }
        return this.getNext();
    }

    @Override
    public boolean hasNext() throws ServiceException {
        return this.bufferNextHit();
    }

    public boolean bufferNextHit() throws ServiceException {
        if (this.mCachedNextHit == null) {
            this.internalGetNextHit();
        }
        return this.mCachedNextHit != null;
    }

    @Override
    public void resetIterator() throws ServiceException {
        for (int i = 0; i < this.mResults.length; ++i) {
            this.mResults[i].resetIterator();
        }
    }

    @Override
    public ZimbraHit getFirstHit() throws ServiceException {
        this.resetIterator();
        return this.getNext();
    }

    @Override
    public ZimbraHit getNext() throws ServiceException {
        this.bufferNextHit();
        ZimbraHit toRet = this.mCachedNextHit;
        this.mCachedNextHit = null;
        return toRet;
    }

    @Override
    public void doneWithSearchResults() throws ServiceException {
        for (int i = 0; i < this.mResults.length; ++i) {
            this.mResults[i].doneWithSearchResults();
        }
    }

    @Override
    public List<QueryInfo> getResultInfo() {
        ArrayList<QueryInfo> toRet = new ArrayList<QueryInfo>();
        for (ZimbraQueryResults results : this.mResults) {
            toRet.addAll(results.getResultInfo());
        }
        return toRet;
    }

    @Override
    public int estimateResultSize() throws ServiceException {
        long total = 0L;
        for (ZimbraQueryResults results : this.mResults) {
            total += (long)results.estimateResultSize();
        }
        if (total > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)total;
    }
}

