/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.ConversationHit;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.MessagePartHit;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.Mailbox;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MsgQueryResults
extends ZimbraQueryResultsImpl {
    ZimbraQueryResults mResults;
    ZimbraHit mNextHit = null;
    HashMap<Integer, MessageHit> mSeenMsgs = new ZimbraQueryResultsImpl.LRUHashMap<Integer, MessageHit>(256);

    MsgQueryResults(ZimbraQueryResults topLevelQueryOperation, byte[] types, SortBy searchOrder, Mailbox.SearchResultMode mode) {
        super(types, searchOrder, mode);
        this.mResults = topLevelQueryOperation;
    }

    private ZimbraHit internalGetNextHit() throws ServiceException {
        while (this.mResults.hasNext()) {
            ZimbraHit opNext = this.mResults.getNext();
            MessageHit curHit = null;
            Integer msgId = new Integer(opNext.getItemId());
            curHit = this.mSeenMsgs.get(msgId);
            if (curHit != null) continue;
            if (opNext instanceof ConversationHit) {
                assert (false);
            } else if (opNext instanceof MessageHit) {
                curHit = (MessageHit)opNext;
            } else if (opNext instanceof MessagePartHit) {
                curHit = ((MessagePartHit)opNext).getMessageResult();
            } else {
                return opNext;
            }
            this.mSeenMsgs.put(msgId, curHit);
            while (this.mResults.hasNext()) {
                ZimbraHit nextHit = this.mResults.peekNext();
                int newMsgId = nextHit.getItemId();
                if (newMsgId != msgId) {
                    return curHit;
                }
                this.mResults.getNext();
                if (!(nextHit instanceof MessagePartHit)) continue;
                curHit.addPart((MessagePartHit)nextHit);
            }
            return curHit;
        }
        return null;
    }

    private boolean bufferNextHit() throws ServiceException {
        if (this.mNextHit == null) {
            this.mNextHit = this.internalGetNextHit();
        }
        return this.mNextHit != null;
    }

    @Override
    public void resetIterator() throws ServiceException {
        this.mSeenMsgs.clear();
        this.mResults.resetIterator();
    }

    @Override
    public ZimbraHit getNext() throws ServiceException {
        this.bufferNextHit();
        ZimbraHit toRet = this.mNextHit;
        assert (this.mNextHit == null || !(this.mNextHit instanceof MessagePartHit) && !(this.mNextHit instanceof ConversationHit));
        this.mNextHit = null;
        return toRet;
    }

    @Override
    public ZimbraHit peekNext() throws ServiceException {
        this.bufferNextHit();
        assert (this.mNextHit == null || !(this.mNextHit instanceof MessagePartHit) && !(this.mNextHit instanceof ConversationHit));
        return this.mNextHit;
    }

    @Override
    public void doneWithSearchResults() throws ServiceException {
        this.mResults.doneWithSearchResults();
    }

    @Override
    public ZimbraHit skipToHit(int hitNo) throws ServiceException {
        if (hitNo > 0) {
            this.mResults.skipToHit(hitNo - 1);
        } else {
            this.resetIterator();
        }
        return this.getNext();
    }

    @Override
    public List<QueryInfo> getResultInfo() {
        return this.mResults.getResultInfo();
    }

    @Override
    public int estimateResultSize() throws ServiceException {
        return this.mResults.estimateResultSize();
    }
}

