/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.ZimbraAnalyzer;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import org.apache.lucene.document.Document;

public final class MessagePartHit
extends ZimbraHit {
    private Document mDoc = null;
    private MessageHit mMessage = null;
    int mMailItemId = 0;

    protected MessagePartHit(ZimbraQueryResultsImpl res, Mailbox mbx, int mailItemId, Document d, float score, MailItem.UnderlyingData ud) throws ServiceException {
        super(res, mbx, score);
        this.mMailItemId = mailItemId;
        this.mDoc = d;
        if (ud != null) {
            this.getMessageResult(ud);
        }
    }

    public long getDate() throws ServiceException {
        if (this.mCachedDate == -1L) {
            this.mCachedDate = this.getMessageResult().getDate();
        }
        return this.mCachedDate;
    }

    public int getConversationId() throws ServiceException {
        return this.getMessageResult().getConversationId();
    }

    public String getSubject() throws ServiceException {
        if (this.mCachedSubj == null) {
            this.mCachedSubj = this.getMessageResult().getSubject();
        }
        return this.mCachedSubj;
    }

    public String getName() throws ServiceException {
        if (this.mCachedName == null) {
            this.mCachedName = this.getMessageResult().getSender();
        }
        return this.mCachedName;
    }

    public int getItemId() {
        return this.mMailItemId;
    }

    void setItem(MailItem item) throws ServiceException {
        MessageHit mh = this.getMessageResult();
        mh.setItem(item);
    }

    boolean itemIsLoaded() throws ServiceException {
        return this.getMessageResult().itemIsLoaded();
    }

    public byte getItemType() {
        return 5;
    }

    public String toString() {
        int convId = 0;
        try {
            convId = this.getConversationId();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        long size = this.getSize();
        return "MP: " + super.toString() + " C" + convId + " M" + this.getItemId() + " P" + Integer.toString(this.getItemId()) + "-" + this.getPartName() + " S=" + size;
    }

    public String getFilename() {
        if (this.mDoc != null) {
            return this.mDoc.get("filename");
        }
        return null;
    }

    public String getType() {
        if (this.mDoc != null) {
            return this.mDoc.get("type");
        }
        return null;
    }

    public String getPartName() {
        String retVal;
        if (this.mDoc != null && !(retVal = this.mDoc.get("l.partname")).equals("top")) {
            return retVal;
        }
        return "";
    }

    public long getSize() {
        if (this.mDoc != null) {
            String sizeStr = this.mDoc.get("l.size");
            long sizeLong = ZimbraAnalyzer.SizeTokenFilter.decodeSize(sizeStr);
            return (int)sizeLong;
        }
        assert (false);
        return 0L;
    }

    public MessageHit getMessageResult() throws ServiceException {
        return this.getMessageResult(null);
    }

    public MessageHit getMessageResult(MailItem.UnderlyingData ud) throws ServiceException {
        if (this.mMessage == null) {
            this.mMessage = this.getResults().getMessageHit(this.getMailbox(), new Integer(this.getItemId()), this.mDoc, this.getScore(), ud);
            this.mMessage.addPart(this);
            this.mMessage.cacheImapMessage(this.mCachedImapMessage);
            this.mMessage.cacheModifiedSequence(this.mCachedModseq);
            this.mMessage.cacheParentId(this.mCachedParentId);
        }
        return this.mMessage;
    }

    public MailItem getMailItem() throws ServiceException {
        return this.getMessageResult().getMailItem();
    }
}

