/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.index.ConversationHit;
import com.zimbra.cs.index.MessagePartHit;
import com.zimbra.cs.index.ZimbraAnalyzer;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mime.ParsedAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHit
extends ZimbraHit {
    private static Log mLog = LogFactory.getLog(MessageHit.class);
    private Document mDoc = null;
    private Message mMessage = null;
    private List<MessagePartHit> mMatchedParts = null;
    private int mConversationId = 0;
    private int mMessageId = 0;
    private ConversationHit mConversationHit = null;

    protected MessageHit(ZimbraQueryResultsImpl results, Mailbox mbx, int mailItemId, Document d, float score, MailItem.UnderlyingData underlyingData) throws ServiceException {
        super(results, mbx, score);
        this.mDoc = d;
        assert (d != null);
        this.mMessageId = mailItemId;
        assert (mailItemId != 0);
        if (underlyingData != null && results.getSearchMode() != Mailbox.SearchResultMode.IDS) {
            this.mMessage = (Message)mbx.getItemFromUnderlyingData(underlyingData);
        }
    }

    protected MessageHit(ZimbraQueryResultsImpl results, Mailbox mbx, int mailItemId, float score, MailItem.UnderlyingData underlyingData) throws ServiceException {
        super(results, mbx, score);
        this.mMessageId = mailItemId;
        assert (mailItemId != 0);
        if (underlyingData != null && results.getSearchMode() != Mailbox.SearchResultMode.IDS) {
            this.mMessage = (Message)mbx.getItemFromUnderlyingData(underlyingData);
        }
    }

    int getFolderId() throws ServiceException {
        return this.getMessage().getFolderId();
    }

    @Override
    public int getConversationId() throws ServiceException {
        if (this.mConversationId == 0) {
            this.mConversationId = this.getMessage().getConversationId();
        }
        return this.mConversationId;
    }

    @Override
    public long getDate() throws ServiceException {
        if (this.mCachedDate == -1L) {
            String dateStr;
            if (this.mMessage == null && this.mDoc != null && (dateStr = this.mDoc.get("l.date")) != null) {
                this.mCachedDate = DateField.stringToTime(dateStr);
                return this.mCachedDate;
            }
            this.mCachedDate = this.getMessage().getDate();
        }
        return this.mCachedDate;
    }

    public void addPart(MessagePartHit part) {
        if (this.mMatchedParts == null) {
            this.mMatchedParts = new ArrayList<MessagePartHit>();
        }
        if (!this.mMatchedParts.contains(part)) {
            this.mMatchedParts.add(part);
        }
    }

    public List<MessagePartHit> getMatchedMimePartNames() {
        return this.mMatchedParts;
    }

    @Override
    public int getItemId() {
        return this.mMessageId;
    }

    public byte getItemType() {
        return 5;
    }

    @Override
    public String toString() {
        int convId = 0;
        boolean convIdUnknown = false;
        try {
            if (this.mConversationId == 0 && this.mMessage == null) {
                convIdUnknown = true;
            } else {
                convId = this.getConversationId();
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        long size = 0L;
        try {
            size = this.mCachedSize == -1L && this.mMessage == null ? -1L : this.getSize();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        if (this.mMessage == null) {
            return "MS: " + this.getItemId();
        }
        return "MS: " + super.toString() + " C" + (convIdUnknown ? "?" : Integer.valueOf(convId)) + " M" + Integer.toString(this.getItemId()) + " S=" + size;
    }

    @Override
    public long getSize() throws ServiceException {
        if (this.mCachedSize == -1L) {
            String sizeStr;
            if (this.mMessage == null && this.mDoc != null && (sizeStr = this.mDoc.get("l.size")) != null) {
                this.mCachedSize = ZimbraAnalyzer.SizeTokenFilter.decodeSize(sizeStr);
                return this.mCachedSize;
            }
            this.mCachedSize = this.getMessage().getSize();
        }
        return this.mCachedSize;
    }

    public boolean isTagged(Tag tag) throws ServiceException {
        return this.getMessage().isTagged(tag);
    }

    @Override
    void setItem(MailItem item) {
        this.mMessage = (Message)item;
    }

    @Override
    boolean itemIsLoaded() {
        return this.mMessage != null;
    }

    @Override
    public MailItem getMailItem() throws ServiceException {
        return this.getMessage();
    }

    public Message getMessage() throws ServiceException {
        if (this.mMessage == null) {
            Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailbox().getId());
            int messageId = this.getItemId();
            try {
                this.mMessage = mbox.getMessageById(null, messageId);
            }
            catch (ServiceException e) {
                mLog.error((Object)("Error getting message id=" + messageId + " from mailbox " + mbox.getId()), e);
                e.printStackTrace();
                throw e;
            }
        }
        return this.mMessage;
    }

    @Override
    public String getSubject() throws ServiceException {
        if (this.mCachedSubj == null) {
            this.mCachedSubj = this.getMessage().getSortSubject();
        }
        return this.mCachedSubj;
    }

    @Override
    public String getName() throws ServiceException {
        if (this.mCachedName == null) {
            this.mCachedName = this.getSender();
        }
        return this.mCachedName;
    }

    public long getDateHeader() throws ServiceException {
        if (this.mMessage == null && this.mDoc != null) {
            String dateStr = this.mDoc.get("l.date");
            if (dateStr != null) {
                return DateField.stringToTime(dateStr);
            }
            return 0L;
        }
        return this.getMessage().getDate();
    }

    public String getSender() throws ServiceException {
        return new ParsedAddress(this.getMessage().getSender()).getSortString();
    }

    public ConversationHit getConversationResult() throws ServiceException {
        if (this.mConversationHit == null) {
            Integer cid = new Integer(this.getConversationId());
            this.mConversationHit = this.getResults().getConversationHit(this.getMailbox(), cid, this.getScore());
            this.mConversationHit.addMessageHit(this);
        }
        return this.mConversationHit;
    }
}

