/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.BrowseTerm;
import com.zimbra.cs.index.IIndexFactory;
import com.zimbra.cs.index.ILuceneIndex;
import com.zimbra.cs.index.ITextIndex;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.index.LuceneFactory;
import com.zimbra.cs.index.ReSortingQueryResults;
import com.zimbra.cs.index.RefCountedIndexSearcher;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.SpellSuggestQueryInfo;
import com.zimbra.cs.index.TextQueryOperation;
import com.zimbra.cs.index.ZimbraAnalyzer;
import com.zimbra.cs.index.ZimbraQuery;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.util.SyncToken;
import com.zimbra.cs.store.file.Volume;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MailboxIndex {
    private static IIndexFactory sIndexFactory = null;
    private ILuceneIndex mLucene;
    private ITextIndex mTextIndex;
    private long mMailboxId;
    private Mailbox mMailbox;
    private Analyzer mAnalyzer = null;
    public static final String GROUP_BY_CONVERSATION = "conversation";
    public static final String GROUP_BY_MESSAGE = "message";
    public static final String GROUP_BY_NONE = "none";
    public static final String SEARCH_FOR_APPOINTMENTS = "appointment";
    public static final String SEARCH_FOR_CHATS = "chat";
    public static final String SEARCH_FOR_CONTACTS = "contact";
    public static final String SEARCH_FOR_CONVERSATIONS = "conversation";
    public static final String SEARCH_FOR_DOCUMENTS = "document";
    public static final String SEARCH_FOR_BRIEFCASE = "briefcase";
    public static final String SEARCH_FOR_MESSAGES = "message";
    public static final String SEARCH_FOR_NOTES = "note";
    public static final String SEARCH_FOR_TAGS = "tag";
    public static final String SEARCH_FOR_TASKS = "task";
    public static final String SEARCH_FOR_WIKI = "wiki";
    public static final String SEARCH_FOR_EVERYTHING = "appointment,contact,document,briefcase,message,note,task,wiki";

    public static ZimbraQueryResults search(SoapProtocol proto, OperationContext octxt, Mailbox mbox, SearchParams params, boolean textIndexOutOfSync) throws IOException, ParseException, ServiceException {
        if (ZimbraLog.index_search.isDebugEnabled()) {
            ZimbraLog.index_search.debug("SearchRequest: " + params.getQueryStr());
        }
        String qs = params.getQueryStr();
        if (params.getCalItemExpandStart() > 0L || params.getCalItemExpandEnd() > 0L) {
            StringBuilder toAdd = new StringBuilder();
            toAdd.append('(').append(qs).append(')');
            if (params.getCalItemExpandStart() > 0L) {
                toAdd.append(" appt-end:>=").append(params.getCalItemExpandStart());
            }
            if (params.getCalItemExpandEnd() > 0L) {
                toAdd.append(" appt-start:<=").append(params.getCalItemExpandEnd());
            }
            qs = toAdd.toString();
            params.setQueryStr(qs);
        }
        boolean isTaskSort = false;
        boolean isLocalizedSort = false;
        SortBy originalSort = params.getSortBy();
        switch (originalSort.getType()) {
            case TASK_DUE_ASCENDING: {
                isTaskSort = true;
                params.setSortBy(SortBy.DATE_DESCENDING);
                break;
            }
            case TASK_DUE_DESCENDING: {
                isTaskSort = true;
                params.setSortBy(SortBy.DATE_DESCENDING);
                break;
            }
            case TASK_STATUS_ASCENDING: {
                isTaskSort = true;
                params.setSortBy(SortBy.DATE_DESCENDING);
                break;
            }
            case TASK_STATUS_DESCENDING: {
                isTaskSort = true;
                params.setSortBy(SortBy.DATE_DESCENDING);
                break;
            }
            case TASK_PERCENT_COMPLETE_ASCENDING: {
                isTaskSort = true;
                params.setSortBy(SortBy.DATE_DESCENDING);
                break;
            }
            case TASK_PERCENT_COMPLETE_DESCENDING: {
                isTaskSort = true;
                params.setSortBy(SortBy.DATE_DESCENDING);
                break;
            }
            case NAME_LOCALIZED_ASCENDING: 
            case NAME_LOCALIZED_DESCENDING: {
                isLocalizedSort = true;
            }
        }
        ZimbraQuery zq = new ZimbraQuery(octxt, proto, mbox, params);
        if (zq.countSearchTextOperations() > 0 && textIndexOutOfSync) {
            throw MailServiceException.TEXT_INDEX_OUT_OF_SYNC();
        }
        if (ZimbraLog.searchstats.isDebugEnabled()) {
            int textCount = zq.countSearchTextOperations();
            ZimbraLog.searchstats.debug("Executing search with [" + textCount + "] text parts");
        }
        try {
            ZimbraQueryResults results = zq.execute();
            if (isTaskSort) {
                results = new ReSortingQueryResults(results, originalSort, null);
            }
            if (isLocalizedSort) {
                results = new ReSortingQueryResults(results, originalSort, params);
            }
            return results;
        }
        catch (IOException e) {
            zq.doneWithQuery();
            throw e;
        }
        catch (ServiceException e) {
            zq.doneWithQuery();
            throw e;
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable t) {
            zq.doneWithQuery();
            throw ServiceException.FAILURE("Caught " + t.getMessage(), t);
        }
    }

    public long getBytesWritten() {
        if (this.mLucene != null) {
            return this.mLucene.getBytesWritten();
        }
        return 0L;
    }

    public long getBytesRead() {
        if (this.mLucene != null) {
            return this.mLucene.getBytesRead();
        }
        return 0L;
    }

    public int getBatchedIndexingCount() {
        try {
            return this.mMailbox.getAccount().getIntAttr("zimbraBatchedIndexingSize", 0);
        }
        catch (ServiceException e) {
            ZimbraLog.index.debug((Object)"Eating ServiceException trying to lookup BatchedIndexSize", e);
            return 0;
        }
    }

    public boolean useBatchedIndexing() throws ServiceException {
        return this.mMailbox.getAccount().getIntAttr("zimbraBatchedIndexingSize", 0) > 0;
    }

    public String generateIndexId(int itemId) {
        return this.mTextIndex.generateIndexId(itemId);
    }

    public void getDomainsForField(String fieldName, String regex, Collection<BrowseTerm> collection) throws IOException {
        this.mTextIndex.getDomainsForField(fieldName, regex, collection);
    }

    public void getAttachments(String regex, Collection<BrowseTerm> collection) throws IOException {
        this.mTextIndex.getAttachments(regex, collection);
    }

    public void getObjects(String regex, Collection<BrowseTerm> collection) throws IOException {
        this.mTextIndex.getObjects(regex, collection);
    }

    public void beginWriteOperation() throws IOException {
        this.mTextIndex.beginWriteOperation();
    }

    public void endWriteOperation() throws IOException {
        this.mTextIndex.endWriteOperation();
    }

    public void flush() {
        this.mTextIndex.flush();
    }

    public List<String> deleteDocuments(List<String> itemIds) throws IOException {
        return this.mTextIndex.deleteDocuments(itemIds);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("MailboxIndex(");
        ret.append(this.mMailboxId);
        ret.append(")");
        return ret.toString();
    }

    public MailboxIndex(Mailbox mbox, String root) throws ServiceException {
        String analyzerName;
        long mailboxId;
        this.mMailboxId = mailboxId = mbox.getId();
        this.mMailbox = mbox;
        Volume indexVol = Volume.getById(mbox.getIndexVolume());
        String idxParentDir = indexVol.getMailboxDir(mailboxId, 10);
        this.mTextIndex = sIndexFactory.create(this, idxParentDir, this.mMailboxId);
        if (this.mTextIndex instanceof ILuceneIndex) {
            this.mLucene = (ILuceneIndex)this.mTextIndex;
        }
        this.mAnalyzer = (analyzerName = mbox.getAccount().getAttr("zimbraTextAnalyzer", null)) != null ? ZimbraAnalyzer.getAnalyzer(analyzerName) : ZimbraAnalyzer.getDefaultAnalyzer();
        ZimbraLog.index.info("Initialized Index for mailbox " + mailboxId + " directory: " + this.mTextIndex.toString() + " Analyzer=" + this.mAnalyzer.toString());
    }

    TextQueryOperation createTextQueryOperation() {
        return sIndexFactory.createTextQueryOperation();
    }

    RefCountedIndexSearcher getCountedIndexSearcher(SortBy sort) throws IOException {
        RefCountedIndexSearcher toRet = this.mLucene.getCountedIndexSearcher();
        toRet.setSort(this.mLucene.getSort(sort));
        return toRet;
    }

    ILuceneIndex getLuceneIndex() {
        return this.mLucene;
    }

    ITextIndex getTextIndex() {
        return this.mTextIndex;
    }

    public static void startup() {
        if (DebugConfig.disableIndexing) {
            return;
        }
        sIndexFactory.startup();
    }

    public static void shutdown() {
        if (DebugConfig.disableIndexing) {
            return;
        }
        sIndexFactory.shutdown();
    }

    public static void flushAllWriters() {
        if (DebugConfig.disableIndexing) {
            return;
        }
        sIndexFactory.flushAllWriters();
    }

    boolean curThreadHoldsLock() {
        return Thread.holdsLock(this.getLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAnalyzer(Mailbox mbox) throws ServiceException {
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            Object object = this.getLock();
            synchronized (object) {
                String analyzerName = mbox.getAccount().getAttr("zimbraTextAnalyzer", null);
                this.mAnalyzer = analyzerName != null ? ZimbraAnalyzer.getAnalyzer(analyzerName) : ZimbraAnalyzer.getDefaultAnalyzer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Analyzer getAnalyzer() {
        Object object = this.getLock();
        synchronized (object) {
            return this.mAnalyzer;
        }
    }

    public static byte[] parseTypesString(String groupBy) throws ServiceException {
        String[] strs = groupBy.split("\\s*,\\s*");
        byte[] types = new byte[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            if ("conversation".equals(strs[i])) {
                types[i] = 4;
                continue;
            }
            if ("message".equals(strs[i])) {
                types[i] = 5;
                continue;
            }
            if (GROUP_BY_NONE.equals(strs[i])) {
                types[i] = 0;
                continue;
            }
            if (SEARCH_FOR_CHATS.equals(strs[i])) {
                types[i] = 16;
                continue;
            }
            if (SEARCH_FOR_CONTACTS.equals(strs[i])) {
                types[i] = 6;
                continue;
            }
            if (SEARCH_FOR_DOCUMENTS.equals(strs[i])) {
                types[i] = 8;
                continue;
            }
            if (SEARCH_FOR_BRIEFCASE.equals(strs[i])) {
                types[i] = 8;
                continue;
            }
            if (SEARCH_FOR_APPOINTMENTS.equals(strs[i])) {
                types[i] = 11;
                continue;
            }
            if (SEARCH_FOR_NOTES.equals(strs[i])) {
                types[i] = 9;
                continue;
            }
            if (SEARCH_FOR_TAGS.equals(strs[i])) {
                types[i] = 3;
                continue;
            }
            if (SEARCH_FOR_TASKS.equals(strs[i])) {
                types[i] = 15;
                continue;
            }
            if (SEARCH_FOR_WIKI.equals(strs[i])) {
                types[i] = 14;
                continue;
            }
            throw ServiceException.INVALID_REQUEST("unknown groupBy: " + strs[i], null);
        }
        return types;
    }

    public void deleteIndex() throws IOException {
        this.mTextIndex.deleteIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexMailItem(Mailbox mbox, boolean deleteFirst, List<IndexDocument> docList, MailItem mi, int modContent) throws ServiceException {
        this.initAnalyzer(mbox);
        Object object = this.getLock();
        synchronized (object) {
            String indexId = mi.getIndexId();
            try {
                if (docList != null) {
                    IndexDocument[] docs = new IndexDocument[docList.size()];
                    docs = docList.toArray(docs);
                    this.mTextIndex.addDocument(docs, mi, mi.getId(), indexId, modContent, mi.getDate(), mi.getSize(), mi.getSortSubject(), mi.getSortSender(), deleteFirst);
                }
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("indexMailItem caught IOException", e);
            }
        }
    }

    void indexingCompleted(int count, SyncToken highestToken, boolean succeeded) {
        if (count > 0) {
            if (ZimbraLog.index_add.isDebugEnabled()) {
                ZimbraLog.index_add.debug("indexingCompleted(" + count + "," + highestToken + "," + (succeeded ? "SUCCEEDED)" : "FAILED)"));
            }
            this.mMailbox.indexingCompleted(count, highestToken, succeeded);
        }
    }

    boolean expandWildcardToken(Collection<String> toRet, String field, String token, int maxToReturn) throws ServiceException {
        return this.mTextIndex.expandWildcardToken(toRet, field, token, maxToReturn);
    }

    List<SpellSuggestQueryInfo.Suggestion> suggestSpelling(String field, String token) throws ServiceException {
        return this.mTextIndex.suggestSpelling(field, token);
    }

    final Object getLock() {
        return this.mMailbox;
    }

    long getMailboxId() {
        return this.mMailboxId;
    }

    static {
        ZimbraLog.index.info("Using Lucene Jar version 2.3 or higher");
        String factClassname = LC.zimbra_index_factory_classname.value();
        if (factClassname != null && factClassname.length() > 0) {
            try {
                sIndexFactory = (IIndexFactory)Class.forName(factClassname).newInstance();
            }
            catch (Exception e) {
                ZimbraLog.index.fatal((Object)("Unable to instantiate Index Factory " + factClassname + " specified in LC.zimbra_index_factory_classname"), e);
                Zimbra.halt("Unable to instantiate Index Factory " + factClassname + " specified in LC.zimbra_index_factory_classname");
            }
        } else {
            sIndexFactory = new LuceneFactory();
        }
    }
}

