/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.DBQueryOperation;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.QueryOperation;
import com.zimbra.cs.index.RefCountedIndexSearcher;
import com.zimbra.cs.index.TermsFilter;
import com.zimbra.cs.index.TextQueryOperation;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;

class LuceneQueryOperation
extends TextQueryOperation {
    private TopDocs mTopDocs = null;
    private int mTopDocsLen = 0;
    private int mTopDocsChunkSize = 2000;
    private RefCountedIndexSearcher mSearcher = null;
    protected static final float sDbFirstTermFreqPerc;

    protected boolean shouldExecuteDbFirst() {
        Query q;
        if (this.mSearcher == null) {
            return true;
        }
        BooleanClause[] clauses = this.mQuery.getClauses();
        if (clauses.length <= 1 && (q = clauses[0].getQuery()) instanceof TermQuery) {
            TermQuery tq = (TermQuery)q;
            Term term = tq.getTerm();
            try {
                int freq = this.mSearcher.getSearcher().docFreq(term);
                int docsCutoff = (int)((float)this.mSearcher.getSearcher().maxDoc() * sDbFirstTermFreqPerc);
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    ZimbraLog.index_search.debug("Term matches " + freq + " docs.  DB-First cutoff (" + 100.0f * sDbFirstTermFreqPerc + "%) is " + docsCutoff + " docs");
                }
                if (freq > docsCutoff) {
                    return true;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        try {
            this.fetchFirstResults(1000);
            if (ZimbraLog.index_search.isDebugEnabled()) {
                ZimbraLog.index_search.debug("Lucene part has " + this.countHits() + " hits");
            }
            if (this.countHits() > 1000) {
                int dbHitCount = this.mDBOp.getDbHitCount();
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    ZimbraLog.index_search.debug("Lucene part has " + this.countHits() + " hits, db part has " + dbHitCount);
                }
                if (dbHitCount < this.countHits()) {
                    return true;
                }
            }
        }
        catch (ServiceException e) {
            return false;
        }
        return false;
    }

    public void doneWithSearchResults() throws ServiceException {
        if (this.mSearcher != null) {
            this.mSearcher.release();
        }
    }

    private void fetchFirstResults(int initialChunkSize) throws ServiceException {
        if (!this.mHaveRunSearch) {
            assert (this.mCurHitNo == 0);
            this.mTopDocsLen = 3 * initialChunkSize;
            long start = 0L;
            if (ZimbraLog.index_search.isDebugEnabled()) {
                start = System.currentTimeMillis();
            }
            this.runSearch();
            if (ZimbraLog.index_search.isDebugEnabled()) {
                long time = System.currentTimeMillis() - start;
                int totalResults = this.mTopDocs != null ? this.mTopDocs.totalHits : 0;
                ZimbraLog.index_search.debug("Fetched Initial " + this.mTopDocsLen + " (out of " + totalResults + " total) search results from Lucene in " + time + "ms");
            }
        }
    }

    protected TextQueryOperation.TextResultsChunk getNextResultsChunk(int maxChunkSize) throws ServiceException {
        try {
            if (!this.mHaveRunSearch) {
                this.fetchFirstResults(maxChunkSize);
            }
            TextQueryOperation.TextResultsChunk toRet = new TextQueryOperation.TextResultsChunk();
            int luceneLen = this.mTopDocs != null ? this.mTopDocs.totalHits : 0;
            long timeUsed = 0L;
            long start = 0L;
            long fetchFromLucene1 = 0L;
            long fetchFromLucene2 = 0L;
            MapFieldSelector f = new MapFieldSelector("l.mbox_blob_id");
            while (toRet.size() < maxChunkSize && this.mCurHitNo < luceneLen) {
                if (this.mTopDocsLen <= this.mCurHitNo) {
                    this.mTopDocsLen += this.mTopDocsChunkSize;
                    this.mTopDocsChunkSize *= 4;
                    if (this.mTopDocsChunkSize > 1000000) {
                        this.mTopDocsChunkSize = 1000000;
                    }
                    if (this.mTopDocsLen > luceneLen) {
                        this.mTopDocsLen = luceneLen;
                    }
                    if (ZimbraLog.index_search.isDebugEnabled()) {
                        start = System.currentTimeMillis();
                    }
                    this.runSearch();
                    if (ZimbraLog.index_search.isDebugEnabled()) {
                        long time = System.currentTimeMillis() - start;
                        ZimbraLog.index_search.debug("Fetched " + this.mTopDocsLen + " search results from Lucene in " + time + "ms");
                    }
                }
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    start = System.currentTimeMillis();
                }
                int docId = this.mTopDocs.scoreDocs[this.mCurHitNo].doc;
                Document d = this.mSearcher.getSearcher().doc(docId);
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    long now = System.currentTimeMillis();
                    fetchFromLucene1 += now - start;
                    start = now;
                }
                float score = this.mTopDocs.scoreDocs[this.mCurHitNo].score;
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    fetchFromLucene2 += System.currentTimeMillis() - start;
                }
                ++this.mCurHitNo;
                String mbid = d.get("l.mbox_blob_id");
                try {
                    if (mbid == null) continue;
                    start = System.currentTimeMillis();
                    toRet.addHit(mbid, d, score);
                    long end = System.currentTimeMillis();
                    timeUsed += end - start;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if (ZimbraLog.index_search.isDebugEnabled()) {
                ZimbraLog.index_search.debug("FetchFromLucene1 " + fetchFromLucene1 + "ms FetchFromLucene2 " + fetchFromLucene2 + "ms ");
            }
            return toRet;
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Caught IOException getting lucene results", e);
        }
    }

    protected static LuceneQueryOperation doCreate() {
        LuceneQueryOperation toRet = new LuceneQueryOperation();
        toRet.mQuery = new BooleanQuery();
        return toRet;
    }

    private LuceneQueryOperation() {
    }

    private void runSearch() {
        this.mHaveRunSearch = true;
        try {
            if (this.mQuery != null) {
                if (this.mSearcher != null) {
                    BooleanQuery outerQuery = new BooleanQuery();
                    outerQuery.add(new BooleanClause(new TermQuery(new Term("ALL", "yes")), BooleanClause.Occur.MUST));
                    outerQuery.add(new BooleanClause(this.mQuery, BooleanClause.Occur.MUST));
                    if (ZimbraLog.index_search.isDebugEnabled()) {
                        ZimbraLog.index_search.debug("Executing Lucene Query: " + outerQuery.toString());
                    }
                    TermsFilter filter = null;
                    if (this.mFilterTerms != null) {
                        filter = new TermsFilter();
                        for (Term t : this.mFilterTerms) {
                            filter.addTerm(t);
                        }
                    }
                    this.mTopDocs = this.mSearcher.search(outerQuery, filter, this.mTopDocsLen);
                } else {
                    this.mTopDocs = null;
                }
            } else assert (false);
        }
        catch (IOException e) {
            e.printStackTrace();
            if (this.mSearcher != null) {
                this.mSearcher.release();
                this.mSearcher = null;
            }
            this.mTopDocs = null;
        }
    }

    protected void prepareThisOperation(ZimbraQueryResultsImpl res, MailboxIndex mbidx) {
        block3: {
            try {
                if (mbidx != null) {
                    this.mSearcher = mbidx.getCountedIndexSearcher(res.getSortBy());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.mSearcher == null) break block3;
                this.mSearcher.release();
                this.mSearcher = null;
            }
        }
    }

    public String toString() {
        return "LUCENE(" + this.mQuery.toString() + (this.hasSpamTrashSetting() ? " <ANYWHERE>" : "") + ")";
    }

    protected LuceneQueryOperation cloneInternal() throws CloneNotSupportedException {
        LuceneQueryOperation toRet = (LuceneQueryOperation)super.clone();
        assert (!this.mHaveRunSearch);
        this.mQuery = (BooleanQuery)this.mQuery.clone();
        return toRet;
    }

    public Object clone() {
        try {
            assert (this.mSearcher == null);
            LuceneQueryOperation toRet = this.cloneInternal();
            if (this.mDBOp != null) {
                toRet.mDBOp = (DBQueryOperation)this.mDBOp.clone(this);
            }
            return toRet;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    protected Object clone(DBQueryOperation caller) throws CloneNotSupportedException {
        assert (this.mSearcher == null);
        LuceneQueryOperation toRet = this.cloneInternal();
        toRet.setDBOperation(caller);
        return toRet;
    }

    protected int countHits() {
        int totalResults = this.mTopDocs != null ? this.mTopDocs.totalHits : 0;
        return totalResults;
    }

    protected QueryOperation combineOps(QueryOperation other, boolean union) {
        assert (!this.mHaveRunSearch);
        if (union) {
            if (other.hasNoResults()) {
                this.mQueryInfo.addAll(other.getResultInfo());
                return this;
            }
        } else if (other.hasAllResults()) {
            if (other.hasSpamTrashSetting()) {
                this.forceHasSpamTrashSetting();
            }
            this.mQueryInfo.addAll(other.getResultInfo());
            return this;
        }
        if (other instanceof LuceneQueryOperation) {
            LuceneQueryOperation otherLuc = (LuceneQueryOperation)other;
            this.mQueryString = union ? '(' + this.mQueryString + ") OR (" + otherLuc.mQueryString + ')' : '(' + this.mQueryString + ") AND (" + otherLuc.mQueryString + ')';
            BooleanQuery top = new BooleanQuery();
            BooleanClause lhs = new BooleanClause(this.mQuery, union ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST);
            BooleanClause rhs = new BooleanClause(otherLuc.mQuery, union ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST);
            top.add(lhs);
            top.add(rhs);
            this.mQuery = top;
            this.mQueryInfo.addAll(other.getResultInfo());
            return this;
        }
        return null;
    }

    static {
        float f = 0.8f;
        try {
            f = Float.parseFloat(LC.search_dbfirst_term_percentage_cutoff.value());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((double)f < 0.0 || (double)f > 1.0) {
            f = 0.8f;
        }
        sDbFirstTermFreqPerc = f;
    }
}

