/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.BrowseTerm;
import com.zimbra.cs.index.DummyIndexWritersCache;
import com.zimbra.cs.index.IIndexWritersCache;
import com.zimbra.cs.index.ILuceneIndex;
import com.zimbra.cs.index.ITextIndex;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.index.IndexReadersCache;
import com.zimbra.cs.index.IndexWritersCache;
import com.zimbra.cs.index.LoggingOutputStream;
import com.zimbra.cs.index.LuceneConfigSettings;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.RefCountedIndexReader;
import com.zimbra.cs.index.RefCountedIndexSearcher;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.SpellSuggestQueryInfo;
import com.zimbra.cs.index.Z23FSDirectory;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.service.util.SyncToken;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyTermEnum;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.SingleInstanceLockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndex
extends IndexWritersCache.IndexWriter
implements ILuceneIndex,
ITextIndex {
    private static final int MAX_TERMS_PER_QUERY;
    private int beginWritingNestLevel = 0;
    private static IndexReadersCache sIndexReadersCache;
    private static IIndexWritersCache sIndexWritersCache;
    private static int sMaxUncommittedOps;
    private int[][] e = new int[1][1];
    private Z23FSDirectory mIdxDirectory = null;
    private IndexWriter mIndexWriter;
    private volatile long mLastWriteTime = 0L;
    private Sort mLatestSort = null;
    private SortBy mLatestSortBy = null;
    private MailboxIndex mMbidx;
    private int mNumUncommittedItems = 0;
    private SyncToken mHighestUncomittedModContent = new SyncToken(0);
    private List<RefCountedIndexReader> mOpenReaders = new ArrayList<RefCountedIndexReader>();

    static void flushAllWriters() {
        if (DebugConfig.disableIndexing) {
            return;
        }
        sIndexWritersCache.flushAllWriters();
    }

    static void shutdown() {
        if (DebugConfig.disableIndexing) {
            return;
        }
        sIndexReadersCache.signalShutdown();
        try {
            sIndexReadersCache.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        sIndexWritersCache.shutdown();
    }

    static void startup() {
        if (DebugConfig.disableIndexing) {
            ZimbraLog.index.info("Indexing is disabled by the localconfig 'debug_disable_indexing' flag");
            return;
        }
        if (sIndexWritersCache != null) {
            sIndexWritersCache.shutdown();
        }
        sMaxUncommittedOps = LC.zimbra_index_max_uncommitted_operations.intValue();
        sIndexReadersCache = new IndexReadersCache(LC.zimbra_index_reader_lru_size.intValue(), LC.zimbra_index_reader_idle_flush_time.longValue() * 1000L, LC.zimbra_index_reader_idle_sweep_frequency.longValue() * 1000L);
        sIndexReadersCache.start();
        sIndexWritersCache = LC.get("zimbra_index_use_dummy_writer_cache").length() != 0 ? new DummyIndexWritersCache() : new IndexWritersCache();
    }

    private static final int min(int a, int b, int c) {
        int t = a < b ? a : b;
        return t < c ? t : c;
    }

    @Override
    public long getBytesWritten() {
        return this.mIdxDirectory.getBytesWritten();
    }

    @Override
    public long getBytesRead() {
        return this.mIdxDirectory.getBytesRead();
    }

    @Override
    public String generateIndexId(int itemId) {
        return Integer.toString(itemId);
    }

    LuceneIndex(MailboxIndex mbidx, String idxParentDir, long mailboxId) throws ServiceException {
        File segments_new;
        this.mMbidx = mbidx;
        this.mIndexWriter = null;
        String idxPath = idxParentDir + File.separatorChar + '0';
        File parentDirFile = new File(idxParentDir);
        if (!parentDirFile.exists()) {
            parentDirFile.mkdirs();
        }
        if (!parentDirFile.canRead()) {
            throw ServiceException.FAILURE("Cannot READ index directory (mailbox=" + mailboxId + " idxPath=" + idxPath + ")", null);
        }
        if (!parentDirFile.canWrite()) {
            throw ServiceException.FAILURE("Cannot WRITE index directory (mailbox=" + mailboxId + " idxPath=" + idxPath + ")", null);
        }
        File segments = new File(idxPath, "segments");
        if (!segments.exists() && (segments_new = new File(idxPath, "segments.new")).exists()) {
            segments_new.renameTo(segments);
        }
        try {
            this.mIdxDirectory = (Z23FSDirectory)FSDirectory.getDirectory((String)idxPath);
            if (this.mIdxDirectory.getLockFactory() == null || !(this.mIdxDirectory.getLockFactory() instanceof SingleInstanceLockFactory)) {
                this.mIdxDirectory.setLockFactory(new SingleInstanceLockFactory());
            }
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Cannot create FSDirectory at path: " + idxPath, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocument(IndexDocument[] docs, MailItem item, int itemId, String indexId, int modContent, long receivedDate, long size, String sortSubject, String sortSender, boolean deleteFirst) throws IOException {
        if (docs.length == 0) {
            return;
        }
        Object object = this.getLock();
        synchronized (object) {
            this.beginWriting();
            try {
                assert (this.mIndexWriter != null);
                for (IndexDocument zdoc : docs) {
                    Document doc;
                    Document document = doc = (Document)zdoc.getWrappedDocument();
                    synchronized (document) {
                        doc.removeFields("subjSort");
                        doc.removeFields("nameSort");
                        doc.add(new Field("subjSort", sortSubject, Field.Store.NO, Field.Index.UN_TOKENIZED));
                        doc.add(new Field("nameSort", sortSender, Field.Store.NO, Field.Index.UN_TOKENIZED));
                        doc.removeFields("l.mbox_blob_id");
                        doc.add(new Field("l.mbox_blob_id", indexId, Field.Store.YES, Field.Index.UN_TOKENIZED));
                        doc.removeFields("l.date");
                        String dateString = DateField.timeToString(receivedDate);
                        doc.add(new Field("l.date", dateString, Field.Store.YES, Field.Index.UN_TOKENIZED));
                        doc.removeFields("l.size");
                        doc.add(new Field("l.size", Long.toString(size), Field.Store.YES, Field.Index.NO));
                        if (null == doc.get("ALL")) {
                            doc.add(new Field("ALL", "yes", Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                        }
                        if (deleteFirst) {
                            String itemIdStr = indexId;
                            Term toDelete = new Term("l.mbox_blob_id", itemIdStr);
                            this.mIndexWriter.updateDocument(toDelete, doc);
                        } else {
                            this.mIndexWriter.addDocument(doc);
                        }
                    }
                }
                if (modContent > 0) {
                    SyncToken token = new SyncToken(modContent, itemId);
                    ++this.mNumUncommittedItems;
                    assert (token.after(this.mHighestUncomittedModContent));
                    if (token.after(this.mHighestUncomittedModContent)) {
                        this.mHighestUncomittedModContent = token;
                    } else {
                        ZimbraLog.index_add.info("Index items not submitted in order: curHighest=" + this.mHighestUncomittedModContent + " new highest=" + modContent + "" + "indexId=" + indexId);
                    }
                }
                this.updateLastWriteTime();
                Object var25_22 = null;
            }
            catch (Throwable throwable) {
                Object var25_23 = null;
                this.doneWriting();
                throw throwable;
            }
            this.doneWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> deleteDocuments(List<String> itemIds) throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            this.beginWriting();
            try {
                int i = 0;
                for (String itemIdStr : itemIds) {
                    try {
                        Term toDelete = new Term("l.mbox_blob_id", itemIdStr);
                        this.mIndexWriter.deleteDocuments(toDelete);
                        if (ZimbraLog.index_add.isDebugEnabled()) {
                            ZimbraLog.index_add.debug("Deleted index documents for itemId " + itemIdStr);
                        }
                    }
                    catch (IOException ioe) {
                        ZimbraLog.index_add.debug("deleteDocuments exception on index " + i + " out of " + itemIds.size() + " (id=" + itemIds.get(i) + ")");
                        ArrayList<String> toRet = new ArrayList<String>(i);
                        int j = 0;
                        while (true) {
                            if (j >= i) {
                                ArrayList<String> arrayList = toRet;
                                Object var10_11 = null;
                                this.doneWriting();
                                return arrayList;
                            }
                            toRet.add(itemIds.get(j));
                            ++j;
                        }
                    }
                    ++i;
                }
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.doneWriting();
                throw throwable;
            }
            this.doneWriting();
            return itemIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIndex() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            String[] files;
            Object writer = null;
            this.flush();
            if (ZimbraLog.index_add.isDebugEnabled()) {
                ZimbraLog.index_add.debug("****Deleting index " + this.mIdxDirectory.toString());
            }
            if ((files = this.mIdxDirectory.list()) == null) {
                if (ZimbraLog.index_add.isDebugEnabled()) {
                    ZimbraLog.index_add.debug("****Deleting index unable to list directory " + this.mIdxDirectory.toString());
                }
                return;
            }
            for (String file : files) {
                this.mIdxDirectory.deleteFile(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enumerateTermsForField(String regex, Term firstTerm, TermEnumInterface callback) throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            RefCountedIndexSearcher searcher = this.getCountedIndexSearcher();
            try {
                IndexReader iReader = searcher.getReader();
                TermEnum terms = iReader.terms(firstTerm);
                boolean hasDeletions = iReader.hasDeletions();
                boolean stripAtBeforeRegex = false;
                if (callback instanceof DomainEnumCallback) {
                    stripAtBeforeRegex = true;
                }
                Pattern p = null;
                if (regex != null && regex.length() > 0) {
                    p = Pattern.compile(regex);
                }
                do {
                    Term cur;
                    if ((cur = terms.term()) == null) continue;
                    if (!cur.field().equals(firstTerm.field())) break;
                    boolean skipIt = false;
                    if (p != null) {
                        String compareTo = cur.text();
                        if (stripAtBeforeRegex && compareTo.length() > 1 && compareTo.charAt(0) == '@') {
                            compareTo = compareTo.substring(1);
                        }
                        if (!p.matcher(compareTo).matches()) {
                            skipIt = true;
                        }
                    }
                    if (skipIt || hasDeletions && !iReader.termDocs(cur).next()) continue;
                    callback.onTerm(cur, terms.docFreq());
                } while (terms.next());
                Object var15_14 = null;
                searcher.release();
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                searcher.release();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean expandWildcardToken(Collection<String> toRet, String field, String token, int maxToReturn) throws ServiceException {
        token = token.toLowerCase();
        try {
            boolean bl;
            RefCountedIndexSearcher searcher = this.getCountedIndexSearcher();
            try {
                Term firstTerm = new Term(field, token);
                IndexReader iReader = searcher.getReader();
                TermEnum terms = iReader.terms(firstTerm);
                do {
                    Term cur;
                    if ((cur = terms.term()) == null) continue;
                    if (!cur.field().equals(firstTerm.field())) break;
                    String curText = cur.text();
                    if (curText.startsWith(token)) {
                        if (toRet.size() >= maxToReturn) {
                            boolean bl2 = false;
                            Object var13_14 = null;
                            searcher.release();
                            return bl2;
                        }
                        toRet.add(cur.text());
                        continue;
                    }
                    if (curText.compareTo(token) > 0) break;
                } while (terms.next());
                bl = true;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                searcher.release();
                throw throwable;
            }
            Object var13_15 = null;
            searcher.release();
            return bl;
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Caught IOException opening index", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.getLock();
        synchronized (object) {
            sIndexWritersCache.flush(this);
            sIndexReadersCache.removeIndexReader(this);
        }
    }

    @Override
    public void getDomainsForField(String fieldName, String regex, Collection<BrowseTerm> collection) throws IOException {
        if (regex == null) {
            regex = "";
        }
        this.enumerateTermsForField(regex, new Term(fieldName, ""), new DomainEnumCallback(collection));
    }

    @Override
    public void getAttachments(String regex, Collection<BrowseTerm> collection) throws IOException {
        if (regex == null) {
            regex = "";
        }
        this.enumerateTermsForField(regex, new Term("attachment", ""), new TermEnumCallback(collection));
    }

    @Override
    public void getObjects(String regex, Collection<BrowseTerm> collection) throws IOException {
        if (regex == null) {
            regex = "";
        }
        this.enumerateTermsForField(regex, new Term("has", ""), new TermEnumCallback(collection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefCountedIndexSearcher getCountedIndexSearcher() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            RefCountedIndexSearcher searcher = null;
            RefCountedIndexReader cReader = this.getCountedIndexReader();
            searcher = new RefCountedIndexSearcher(cReader);
            return searcher;
        }
    }

    public String toString() {
        return "LuceneIndex at " + this.mIdxDirectory.toString();
    }

    @Override
    long getLastWriteTime() {
        return this.mLastWriteTime;
    }

    private final Object getLock() {
        return this.mMbidx.getLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sort getSort(SortBy searchOrder) {
        if (searchOrder == null || searchOrder == SortBy.NONE) {
            return null;
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.mLatestSortBy == null || searchOrder.getCriterion() != this.mLatestSortBy.getCriterion() || searchOrder.getDirection() != this.mLatestSortBy.getDirection()) {
                int type;
                String field;
                boolean reverse = false;
                if (searchOrder.getDirection() == SortBy.SortDirection.DESCENDING) {
                    reverse = true;
                }
                switch (searchOrder.getCriterion()) {
                    case NAME: 
                    case NAME_NATURAL_ORDER: 
                    case SENDER: {
                        field = "nameSort";
                        type = 3;
                        break;
                    }
                    case SUBJECT: {
                        field = "subjSort";
                        type = 3;
                        break;
                    }
                    case SIZE: {
                        field = "l.size";
                        type = 6;
                        break;
                    }
                    default: {
                        field = "l.date";
                        type = 3;
                        reverse = true;
                    }
                }
                this.mLatestSort = new Sort(new SortField(field, type, reverse));
                this.mLatestSortBy = searchOrder;
            }
            return this.mLatestSort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SpellSuggestQueryInfo.Suggestion> suggestSpelling(String field, String token) throws ServiceException {
        LinkedList<SpellSuggestQueryInfo.Suggestion> toRet = null;
        token = token.toLowerCase();
        try {
            RefCountedIndexSearcher searcher = this.getCountedIndexSearcher();
            try {
                IndexReader iReader = searcher.getReader();
                Term term = new Term(field, token);
                int freq = iReader.docFreq(term);
                int numDocs = iReader.numDocs();
                if (freq == 0 && numDocs > 0) {
                    toRet = new LinkedList<SpellSuggestQueryInfo.Suggestion>();
                    FuzzyTermEnum fuzzyEnum = new FuzzyTermEnum(iReader, term, 0.5f, 1);
                    if (fuzzyEnum != null) {
                        do {
                            Term cur;
                            if ((cur = fuzzyEnum.term()) == null) continue;
                            String curText = cur.text();
                            int curDiff = this.editDistance(curText, token, curText.length(), token.length());
                            SpellSuggestQueryInfo.Suggestion sug = new SpellSuggestQueryInfo.Suggestion();
                            sug.mStr = curText;
                            sug.mEditDist = curDiff;
                            sug.mDocs = fuzzyEnum.docFreq();
                            toRet.add(sug);
                        } while (fuzzyEnum.next());
                    }
                }
                Object var15_15 = null;
                searcher.release();
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                searcher.release();
                throw throwable;
            }
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Caught IOException opening index", e);
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mIdxDirectory != null) {
                this.mIdxDirectory.close();
            }
            this.mIdxDirectory = null;
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    private final int editDistance(String s, String t, int n, int m) {
        int j;
        int i;
        if (this.e.length <= n || this.e[0].length <= m) {
            this.e = new int[Math.max(this.e.length, n + 1)][Math.max(this.e[0].length, m + 1)];
        }
        int[][] d = this.e;
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                d[i][j] = s_i != t.charAt(j - 1) ? LuceneIndex.min(d[i - 1][j], d[i][j - 1], d[i - 1][j - 1]) + 1 : LuceneIndex.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1]);
            }
        }
        return d[n][m];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefCountedIndexReader getCountedIndexReader() throws IOException {
        BooleanQuery.setMaxClauseCount(MAX_TERMS_PER_QUERY);
        Object object = this.getLock();
        synchronized (object) {
            sIndexWritersCache.flush(this);
            RefCountedIndexReader toRet = sIndexReadersCache.getIndexReader(this);
            if (toRet != null) {
                return toRet;
            }
            IndexReader reader = null;
            try {
                reader = IndexReader.open(this.mIdxDirectory);
            }
            catch (IOException e) {
                File indexDir = this.mIdxDirectory.getFile();
                if (this.indexDirIsEmpty(indexDir)) {
                    this.beginWriting();
                    this.doneWriting();
                    this.flush();
                    try {
                        reader = IndexReader.open(this.mIdxDirectory);
                    }
                    catch (IOException e1) {
                        if (reader != null) {
                            reader.close();
                        }
                        throw e1;
                    }
                }
                if (reader != null) {
                    reader.close();
                }
                throw e;
            }
            List<RefCountedIndexReader> list = this.mOpenReaders;
            synchronized (list) {
                toRet = new RefCountedIndexReader(this, reader);
                this.mOpenReaders.add(toRet);
            }
            sIndexReadersCache.putIndexReader(this, toRet);
            return toRet;
        }
    }

    private boolean indexDirIsEmpty(File indexDir) {
        if (!indexDir.exists()) {
            indexDir.mkdirs();
            return true;
        }
        File[] files = indexDir.listFiles();
        int numFiles = 0;
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            String fname = f.getName();
            if (f.isDirectory() && (fname.equals(".") || fname.equals(".."))) continue;
            ++numFiles;
        }
        return numFiles <= 0;
    }

    private void doneWriting() throws IOException {
        assert (Thread.holdsLock(this.getLock()));
        assert (this.beginWritingNestLevel > 0);
        --this.beginWritingNestLevel;
        if (this.beginWritingNestLevel == 0) {
            if (this.mNumUncommittedItems > sMaxUncommittedOps) {
                if (ZimbraLog.index_add.isDebugEnabled()) {
                    ZimbraLog.index_add.debug("Flushing " + this.toString() + " because of too many uncommitted redo ops");
                }
                this.flush();
            } else {
                sIndexWritersCache.doneWriting(this);
            }
            this.updateLastWriteTime();
        }
    }

    @Override
    public void beginWriteOperation() throws IOException {
        assert (Thread.holdsLock(this.getLock()));
        this.beginWriting();
    }

    @Override
    public void endWriteOperation() throws IOException {
        assert (Thread.holdsLock(this.getLock()));
        this.doneWriting();
    }

    private void beginWriting() throws IOException {
        assert (Thread.holdsLock(this.getLock()));
        if (this.beginWritingNestLevel == 0) {
            sIndexReadersCache.removeIndexReader(this);
            sIndexWritersCache.beginWriting(this);
        }
        ++this.beginWritingNestLevel;
    }

    @Override
    void doWriterOpen() throws IOException {
        boolean useBatchIndexing;
        if (this.mIndexWriter != null) {
            return;
        }
        assert (Thread.holdsLock(this.getLock()));
        try {
            useBatchIndexing = this.mMbidx.useBatchedIndexing();
        }
        catch (ServiceException e) {
            throw new IOException("Caught IOException checking BatchedIndexing flag " + e);
        }
        LuceneConfigSettings.Config config = useBatchIndexing ? LuceneConfigSettings.batched : LuceneConfigSettings.nonBatched;
        try {
            this.mIndexWriter = new IndexWriter((Directory)this.mIdxDirectory, config.autocommit, this.mMbidx.getAnalyzer(), false, null);
            if (ZimbraLog.index_lucene.isDebugEnabled()) {
                this.mIndexWriter.setInfoStream(new PrintStream(new LoggingOutputStream(ZimbraLog.index_lucene, Log.Level.debug)));
            }
        }
        catch (IOException e1) {
            ZimbraLog.index_add.debug((Object)("Caught exception trying to open index: " + e1), e1);
            File indexDir = this.mIdxDirectory.getFile();
            if (this.indexDirIsEmpty(indexDir)) {
                this.mIndexWriter = new IndexWriter((Directory)this.mIdxDirectory, config.autocommit, this.mMbidx.getAnalyzer(), true, null);
                if (ZimbraLog.index_lucene.isDebugEnabled()) {
                    this.mIndexWriter.setInfoStream(new PrintStream(new LoggingOutputStream(ZimbraLog.index_lucene, Log.Level.debug)));
                }
                if (this.mIndexWriter == null) {
                    throw new IOException("Failed to open IndexWriter in directory " + indexDir.getAbsolutePath());
                }
            }
            this.mIndexWriter = null;
            IOException ioe = new IOException("Could not create index " + this.mIdxDirectory.toString() + " (directory already exists)");
            ioe.initCause(e1);
            throw ioe;
        }
        if (config.useSerialMergeScheduler) {
            this.mIndexWriter.setMergeScheduler(new SerialMergeScheduler());
        }
        this.mIndexWriter.setMaxBufferedDocs(config.maxBufferedDocs);
        this.mIndexWriter.setRAMBufferSizeMB((double)config.ramBufferSizeKB / 1024.0);
        this.mIndexWriter.setMergeFactor(config.mergeFactor);
        if (config.useDocScheduler) {
            LogDocMergePolicy policy = new LogDocMergePolicy();
            this.mIndexWriter.setMergePolicy(policy);
            policy.setUseCompoundDocStore(config.useCompoundFile);
            policy.setUseCompoundFile(config.useCompoundFile);
            policy.setMergeFactor(config.mergeFactor);
            policy.setMinMergeDocs((int)config.minMerge);
            if (config.maxMerge != Integer.MAX_VALUE) {
                policy.setMaxMergeDocs((int)config.maxMerge);
            }
        } else {
            LogByteSizeMergePolicy policy = new LogByteSizeMergePolicy();
            this.mIndexWriter.setMergePolicy(policy);
            policy.setUseCompoundDocStore(config.useCompoundFile);
            policy.setUseCompoundFile(config.useCompoundFile);
            policy.setMergeFactor(config.mergeFactor);
            policy.setMinMergeMB((double)config.minMerge / 1024.0);
            if (config.maxMerge != Integer.MAX_VALUE) {
                policy.setMaxMergeMB((double)config.maxMerge / 1024.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void doWriterClose() {
        block11: {
            boolean success;
            block12: {
                if (this.mIndexWriter == null) {
                    return;
                }
                if (ZimbraLog.index_add.isDebugEnabled()) {
                    ZimbraLog.index_add.debug("Closing IndexWriter " + this.mIndexWriter + " for " + this);
                }
                IndexWriter writer = this.mIndexWriter;
                this.mIndexWriter = null;
                success = false;
                try {
                    try {
                        writer.close();
                        success = true;
                    }
                    catch (IOException e) {
                        ZimbraLog.index_add.error((Object)("Caught Exception " + e + " in LuceneIndex.closeIndexWriter"), e);
                        Object var5_4 = null;
                        if (this.mNumUncommittedItems > 0) {
                            assert (this.mHighestUncomittedModContent.getChangeId() > 0);
                            this.mMbidx.indexingCompleted(this.mNumUncommittedItems, this.mHighestUncomittedModContent, success);
                        }
                        this.mNumUncommittedItems = 0;
                        this.mHighestUncomittedModContent = new SyncToken(0);
                        return;
                    }
                    Object var5_3 = null;
                    if (this.mNumUncommittedItems <= 0) break block11;
                    if ($assertionsDisabled || this.mHighestUncomittedModContent.getChangeId() > 0) break block12;
                    throw new AssertionError();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (this.mNumUncommittedItems > 0) {
                        assert (this.mHighestUncomittedModContent.getChangeId() > 0);
                        this.mMbidx.indexingCompleted(this.mNumUncommittedItems, this.mHighestUncomittedModContent, success);
                    }
                    this.mNumUncommittedItems = 0;
                    this.mHighestUncomittedModContent = new SyncToken(0);
                    throw throwable;
                }
            }
            this.mMbidx.indexingCompleted(this.mNumUncommittedItems, this.mHighestUncomittedModContent, success);
        }
        this.mNumUncommittedItems = 0;
        this.mHighestUncomittedModContent = new SyncToken(0);
    }

    private void updateLastWriteTime() {
        this.mLastWriteTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReaderClose(RefCountedIndexReader ref) {
        List<RefCountedIndexReader> list = this.mOpenReaders;
        synchronized (list) {
            this.mOpenReaders.remove(ref);
        }
    }

    @Override
    public IndexReader reopenReader(IndexReader reader) throws IOException {
        return reader.reopen();
    }

    static {
        System.setProperty("org.apache.lucene.FSDirectory.class", "com.zimbra.cs.index.Z23FSDirectory");
        MAX_TERMS_PER_QUERY = LC.zimbra_index_lucene_max_terms_per_query.intValue();
    }

    static interface TermEnumInterface {
        public void onTerm(Term var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TermEnumCallback
    implements TermEnumInterface {
        private Collection<BrowseTerm> mCollection;

        TermEnumCallback(Collection<BrowseTerm> collection) {
            this.mCollection = collection;
        }

        @Override
        public void onTerm(Term term, int docFreq) {
            String text = term.text();
            if (text.length() > 1) {
                this.mCollection.add(new BrowseTerm(text, docFreq));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DomainEnumCallback
    implements TermEnumInterface {
        private Collection<BrowseTerm> mCollection;

        DomainEnumCallback(Collection<BrowseTerm> collection) {
            this.mCollection = collection;
        }

        @Override
        public void onTerm(Term term, int docFreq) {
            String text = term.text();
            if (text.length() > 1 && text.charAt(0) == '@') {
                this.mCollection.add(new BrowseTerm(text.substring(1), docFreq));
            }
        }
    }

    static abstract class DocEnumInterface {
        DocEnumInterface() {
        }

        void maxDocNo(int num) {
        }

        abstract boolean onDocument(Document var1, boolean var2);
    }
}

