/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.util.Zimbra;

class LuceneConfigSettings {
    static final Config batched = new Config(true);
    static Config nonBatched = new Config(false);

    LuceneConfigSettings() {
    }

    static final class Config {
        final boolean useDocScheduler;
        final long minMerge;
        final long maxMerge;
        final int mergeFactor;
        final boolean useCompoundFile;
        final boolean useSerialMergeScheduler;
        final int maxBufferedDocs;
        final int ramBufferSizeKB;
        final boolean autocommit;
        final String prefix;

        private Config(boolean batchMode) {
            this.prefix = batchMode ? "zimbra_index_lucene_batch_" : "zimbra_index_lucene_nobatch_";
            this.useDocScheduler = this.getBool("use_doc_scheduler", true);
            this.minMerge = this.getLong("min_merge", 10L, 2L, Integer.MAX_VALUE);
            this.maxMerge = this.getLong("max_merge", 10L, 2L, Integer.MAX_VALUE);
            this.mergeFactor = this.getInt("merge_factor", 3, 2, 1000);
            this.useCompoundFile = this.getBool("use_compound_file", true);
            this.useSerialMergeScheduler = this.getBool("use_serial_merge_scheduler", true);
            this.maxBufferedDocs = this.getInt("max_buffered_docs", 100, 0, 100000);
            this.ramBufferSizeKB = this.getInt("ram_buffer_size_kb", 100, 0, 100000);
            this.autocommit = this.getBool("autocommit", false);
        }

        private String lookup(String key) {
            String value = LC.get(this.prefix + key);
            assert (value != null);
            if (value == null) {
                Zimbra.halt("Error loading LuceneConfigSettings, could not find \"" + this.prefix + key + "\" in LC.class.  This is a programming bug (mistyped name?)");
            }
            return value;
        }

        private int getInt(String key, int def, int min, int max) {
            String k = this.lookup(key);
            if (k != null) {
                try {
                    int toRet = Integer.parseInt(k);
                    if (toRet < min) {
                        ZimbraLog.index.warn("Invalid LocalConfig value (" + k + ") for \"" + this.prefix + key + "\" using default value of " + def);
                        return min;
                    }
                    if (toRet > max) {
                        ZimbraLog.index.warn("Invalid LocalConfig value (" + k + ") for \"" + this.prefix + key + "\" using default value of " + def);
                        return max;
                    }
                    return toRet;
                }
                catch (NumberFormatException e) {
                    ZimbraLog.index.warn("Invalid LocalConfig value (" + k + ") for \"" + this.prefix + key + "\" using default value of " + def);
                }
            }
            return def;
        }

        private long getLong(String key, long def, long min, long max) {
            String k = this.lookup(key);
            if (k != null) {
                try {
                    long toRet = Long.parseLong(k);
                    if (toRet < min) {
                        ZimbraLog.index.warn("Invalid LocalConfig value (" + k + ") for \"" + this.prefix + key + "\" using default value of " + def);
                        return min;
                    }
                    if (toRet > max) {
                        ZimbraLog.index.warn("Invalid LocalConfig value (" + k + ") for \"" + this.prefix + key + "\" using default value of " + def);
                        return max;
                    }
                    return toRet;
                }
                catch (NumberFormatException e) {
                    ZimbraLog.index.warn("Invalid LocalConfig value (" + k + ") for \"" + this.prefix + key + "\" using default value of " + def);
                }
            }
            return def;
        }

        private boolean getBool(String key, boolean def) {
            String value = this.lookup(key);
            if (value != null) {
                return Boolean.valueOf(value);
            }
            return def;
        }
    }
}

