/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.util.Log;
import java.io.IOException;
import java.io.OutputStream;

public class LoggingOutputStream
extends OutputStream {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final int DEFAULT_BUFFER_LENGTH = 2048;
    private static final int MAX_BUFFER_LENGTH = 16384;
    protected boolean mClosed = false;
    private Log mLog = null;
    private Log.Level mLevel = null;
    protected int bytesInBuf = 0;
    protected byte[] buf = new byte[2048];
    private int bufLength = 2048;

    LoggingOutputStream(Log log, Log.Level level) {
        this.mLog = log;
        this.mLevel = level;
    }

    public void close() {
        this.flush();
        this.mClosed = true;
    }

    public void write(int in) throws IOException {
        if (this.mClosed) {
            throw new IOException("Stream closed.");
        }
        if (in != 0) {
            if (this.bytesInBuf == this.bufLength) {
                if (this.bufLength * 2 >= 16384) {
                    this.flush();
                } else {
                    int newBufLength = 2 * this.bufLength;
                    byte[] newBuf = new byte[newBufLength];
                    System.arraycopy(this.buf, 0, newBuf, 0, this.bufLength);
                    this.buf = newBuf;
                    this.bufLength = newBufLength;
                }
            }
            this.buf[this.bytesInBuf] = (byte)in;
            ++this.bytesInBuf;
            if (in == 10) {
                this.flush();
            }
        }
    }

    public void flush() {
        if (this.bytesInBuf > 0) {
            if (this.bytesInBuf == 1 && this.buf[0] == 10 || this.bytesInBuf == 2 && this.buf[0] == 13 && this.buf[1] == 10) {
                this.bytesInBuf = 0;
            }
            byte[] toPrint = new byte[this.bytesInBuf];
            System.arraycopy(this.buf, 0, toPrint, 0, this.bytesInBuf);
            switch (this.mLevel) {
                case error: {
                    this.mLog.error(toPrint);
                    break;
                }
                case warn: {
                    this.mLog.warn(toPrint);
                    break;
                }
                case info: {
                    this.mLog.info(toPrint);
                    break;
                }
                default: {
                    this.mLog.debug(toPrint);
                }
            }
            this.bytesInBuf = 0;
        }
    }
}

