/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.mailbox.MailItem;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizedSortBy
extends SortBy {
    private Locale mLocale;

    LocalizedSortBy(SortBy.Type t, String str, SortBy.SortCriterion criterion, SortBy.SortDirection direction, Locale locale) {
        super(t, str, criterion, direction);
        this.mLocale = locale;
        System.out.println(this.mLocale);
    }

    public Comparator<ZimbraHit> getZimbraHitComparator() {
        Collator col = Collator.getInstance(this.mLocale);
        return new NameComparator(col);
    }

    public static class TestHit
    extends ZimbraHit {
        private String mName;
        private int mItemId;

        TestHit(String name, int id) {
            super(null, null, 0.0f);
            this.mName = name;
            this.mItemId = id;
        }

        int getConversationId() throws ServiceException {
            return 0;
        }

        long getDate() throws ServiceException {
            return 0L;
        }

        public int getItemId() throws ServiceException {
            return this.mItemId;
        }

        public MailItem getMailItem() throws ServiceException {
            return null;
        }

        String getName() throws ServiceException {
            return this.mName;
        }

        long getSize() throws ServiceException {
            return 0L;
        }

        String getSubject() throws ServiceException {
            return null;
        }

        boolean itemIsLoaded() throws ServiceException {
            return false;
        }

        void setItem(MailItem item) throws ServiceException {
        }

        public String toString() {
            return this.mName + "," + this.mItemId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NameComparator
    implements Comparator<ZimbraHit> {
        private Collator mCol;

        NameComparator(Collator col) {
            this.mCol = col;
        }

        @Override
        public int compare(ZimbraHit lhs, ZimbraHit rhs) {
            int toRet = 0;
            try {
                toRet = this.mCol.compare(lhs.getName(), rhs.getName());
                if (toRet == 0) {
                    toRet = lhs.getItemId() - rhs.getItemId();
                }
                if (LocalizedSortBy.this.isDescending()) {
                    toRet = -1 * toRet;
                }
            }
            catch (ServiceException e) {
                ZimbraLog.index.debug((Object)("Caught exception " + e + " trying to compare " + lhs + " to " + rhs), e);
                toRet = 0;
            }
            return toRet;
        }
    }
}

