/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.BufferingResultsGrouper;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import java.util.ArrayList;

class ItemPreloadingGrouper
extends BufferingResultsGrouper {
    private int mChunkSize;
    private OperationContext mOpContext;

    ItemPreloadingGrouper(ZimbraQueryResults results, int chunkSize, Mailbox mbox) {
        super(results);
        this.mChunkSize = chunkSize;
        this.mOpContext = mbox.getOperationContext();
        assert (this.mChunkSize > 0);
    }

    protected boolean bufferHits() throws ServiceException {
        if (this.mBufferedHit.size() > 0) {
            return true;
        }
        if (!this.mHits.hasNext()) {
            return false;
        }
        ArrayList<ZimbraHit> toLoad = new ArrayList<ZimbraHit>();
        ZimbraHit firstHit = this.mHits.peekNext();
        Mailbox mbx = firstHit.getMailbox();
        int numLoaded = 0;
        do {
            ZimbraHit nextHit = this.mHits.getNext();
            this.mBufferedHit.add(nextHit);
            if (nextHit.getMailbox() != mbx || mbx == null) continue;
            toLoad.add(nextHit);
        } while (++numLoaded < this.mChunkSize && this.mHits.hasNext());
        this.preload(mbx, toLoad);
        return true;
    }

    private void preload(Mailbox mbox, ArrayList hits) throws ServiceException {
        int[] unloadedIds = new int[hits.size()];
        int numToLoad = 0;
        for (int i = 0; i < hits.size(); ++i) {
            ZimbraHit cur = (ZimbraHit)hits.get(i);
            if (!cur.itemIsLoaded()) {
                ++numToLoad;
                unloadedIds[i] = cur.getItemId();
                continue;
            }
            unloadedIds[i] = -1;
        }
        if (numToLoad > 0) {
            MailItem[] items = mbox.getItemById(this.mOpContext, unloadedIds, (byte)-1);
            for (int i = 0; i < hits.size(); ++i) {
                if (items[i] == null) continue;
                ((ZimbraHit)hits.get(i)).setItem(items[i]);
            }
        }
    }
}

