/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.SetUtil;
import com.zimbra.cs.index.CombiningQueryOperation;
import com.zimbra.cs.index.DBQueryOperation;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.MessagePartHit;
import com.zimbra.cs.index.NoResultsQueryOperation;
import com.zimbra.cs.index.NoTermQueryOperation;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.QueryOperation;
import com.zimbra.cs.index.QueryTarget;
import com.zimbra.cs.index.QueryTargetSet;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.TextQueryOperation;
import com.zimbra.cs.index.UnionQueryOperation;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.Mailbox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntersectionQueryOperation
extends CombiningQueryOperation {
    boolean noHits = false;
    private static Log mLog = LogFactory.getLog(IntersectionQueryOperation.class);
    ArrayList<ZimbraHit> mBufferedNext = new ArrayList(1);
    private static final boolean ALWAYS_DISTRIBUTE_AND_OVER_OR = true;
    private HitGrouper[] mMessageGrouper = null;

    IntersectionQueryOperation() {
    }

    @Override
    public void resetIterator() throws ServiceException {
        if (mLog.isDebugEnabled()) {
            mLog.debug("Intersection.resetIterator()");
        }
        this.mBufferedNext.clear();
        for (int i = 0; i < this.mMessageGrouper.length; ++i) {
            this.mMessageGrouper[i].resetIterator();
        }
    }

    @Override
    public ZimbraHit getNext() throws ServiceException {
        if (this.noHits || !this.hasNext()) {
            return null;
        }
        return this.mBufferedNext.remove(0);
    }

    void bufferNextHits() throws ServiceException {
        if (this.mBufferedNext.size() == 0) {
            block0: while (true) {
                if (!this.mMessageGrouper[0].bufferNextHits()) {
                    return;
                }
                if (mLog.isDebugEnabled()) {
                    mLog.debug("\nMsgGrp0: " + this.mMessageGrouper[0].toString());
                }
                ZimbraHit curHit = this.mMessageGrouper[0].getGroupHit();
                int msgId = this.mMessageGrouper[0].getCurMsgId();
                for (int i = 1; i < this.mMessageGrouper.length; ++i) {
                    if (!this.mMessageGrouper[i].bufferNextHits(curHit)) continue block0;
                    if (!mLog.isDebugEnabled()) continue;
                    mLog.debug("MsgGrp" + i + ": " + this.mMessageGrouper[i].toString());
                }
                ArrayList<Integer> seenMsgs = new ArrayList<Integer>();
                do {
                    if (curHit != null && msgId > 0) {
                        for (int i = 0; i < this.mMessageGrouper.length; ++i) {
                            this.mMessageGrouper[i].setMsgId(msgId);
                            ZimbraHit hit = this.mMessageGrouper[i].getNextHit();
                            while (hit != null) {
                                if (!this.mBufferedNext.contains(hit)) {
                                    boolean ok = true;
                                    for (int j = 0; ok && j < this.mMessageGrouper.length; ++j) {
                                        if (j == i) continue;
                                        if (hit instanceof MessageHit) {
                                            if (this.mMessageGrouper[j].intersectWithBuffer((MessageHit)hit)) continue;
                                            ok = false;
                                            continue;
                                        }
                                        if (!(hit instanceof MessagePartHit) || this.mMessageGrouper[j].intersectWithBuffer((MessagePartHit)hit)) continue;
                                        ok = false;
                                    }
                                    if (ok) {
                                        this.mBufferedNext.add(hit);
                                    }
                                }
                                hit = this.mMessageGrouper[i].getNextHit();
                            }
                        }
                    }
                    seenMsgs.add(new Integer(msgId));
                } while ((msgId = this.mMessageGrouper[0].getNextMessageId(seenMsgs)) > 0);
                if (this.mBufferedNext.size() > 0) break;
            }
            for (int i = 0; i < this.mBufferedNext.size(); ++i) {
                ZimbraHit hit = this.mBufferedNext.get(i);
                if (!mLog.isDebugEnabled()) continue;
                mLog.debug("BUFFERED: " + hit.toString());
            }
        }
    }

    @Override
    public ZimbraHit peekNext() throws ServiceException {
        if (this.noHits) {
            return null;
        }
        this.bufferNextHits();
        if (this.mBufferedNext.size() > 0) {
            return this.mBufferedNext.get(0);
        }
        return null;
    }

    @Override
    public void doneWithSearchResults() throws ServiceException {
        for (int i = 0; i < this.mQueryOperations.size(); ++i) {
            QueryOperation op = (QueryOperation)this.mQueryOperations.get(i);
            op.doneWithSearchResults();
        }
    }

    @Override
    public ZimbraHit skipToHit(int hitNo) throws ServiceException {
        if (this.noHits) {
            return null;
        }
        return super.skipToHit(hitNo);
    }

    @Override
    boolean hasSpamTrashSetting() {
        boolean hasOne = false;
        Iterator iter = this.mQueryOperations.iterator();
        while (!hasOne && iter.hasNext()) {
            QueryOperation op = (QueryOperation)iter.next();
            hasOne = op.hasSpamTrashSetting();
        }
        return hasOne;
    }

    @Override
    void forceHasSpamTrashSetting() {
        assert (false);
        for (QueryOperation op : this.mQueryOperations) {
            op.forceHasSpamTrashSetting();
        }
    }

    @Override
    QueryTargetSet getQueryTargets() {
        QueryTargetSet toRet = new QueryTargetSet();
        Iterator qopIter = this.mQueryOperations.iterator();
        while (qopIter.hasNext()) {
            toRet = ((QueryOperation)qopIter.next()).getQueryTargets();
            while (qopIter.hasNext()) {
                QueryTargetSet curSet = ((QueryOperation)qopIter.next()).getQueryTargets();
                if (toRet.contains(QueryTarget.UNSPECIFIED)) {
                    if (curSet.contains(QueryTarget.UNSPECIFIED)) {
                        toRet = (QueryTargetSet)SetUtil.union(toRet, curSet);
                        continue;
                    }
                    toRet = curSet;
                    continue;
                }
                if (curSet.contains(QueryTarget.UNSPECIFIED)) continue;
                toRet = (QueryTargetSet)SetUtil.intersect(new QueryTargetSet(), toRet, curSet);
            }
        }
        return toRet;
    }

    @Override
    boolean hasNoResults() {
        return false;
    }

    @Override
    boolean hasAllResults() {
        return false;
    }

    @Override
    QueryOperation expandLocalRemotePart(Mailbox mbox) throws ServiceException {
        ArrayList<QueryOperation> newList = new ArrayList<QueryOperation>();
        for (QueryOperation op : this.mQueryOperations) {
            newList.add(op.expandLocalRemotePart(mbox));
        }
        this.mQueryOperations = newList;
        return this;
    }

    @Override
    QueryOperation ensureSpamTrashSetting(Mailbox mbox, boolean includeTrash, boolean includeSpam) throws ServiceException {
        if (!this.hasSpamTrashSetting()) {
            ArrayList<QueryOperation> newList = new ArrayList<QueryOperation>();
            for (QueryOperation op : this.mQueryOperations) {
                newList.add(op.ensureSpamTrashSetting(mbox, includeTrash, includeSpam));
            }
            this.mQueryOperations = newList;
        }
        return this;
    }

    void addQueryOp(QueryOperation op) {
        assert (op != null);
        this.mQueryOperations.add(op);
    }

    private void addQueryOps(List<QueryOperation> ops) {
        this.mQueryOperations.addAll(ops);
    }

    void pruneIncompatibleTargets(QueryTargetSet targets) {
        for (QueryOperation op : this.mQueryOperations) {
            if (op instanceof UnionQueryOperation) {
                ((UnionQueryOperation)op).pruneIncompatibleTargets(targets);
                continue;
            }
            if (op instanceof IntersectionQueryOperation) {
                assert (false);
                ((IntersectionQueryOperation)op).pruneIncompatibleTargets(targets);
                continue;
            }
            QueryTargetSet qts = op.getQueryTargets();
            assert (qts.size() == 1);
            assert (qts.contains(QueryTarget.UNSPECIFIED) || qts.isSubset(targets));
        }
    }

    @Override
    QueryOperation optimize(Mailbox mbox) throws ServiceException {
        block0: while (true) {
            Iterator iter = this.mQueryOperations.iterator();
            while (iter.hasNext()) {
                QueryOperation q = (QueryOperation)iter.next();
                QueryOperation newQ = q.optimize(mbox);
                if (newQ == q) continue;
                iter.remove();
                if (newQ == null) continue block0;
                this.addQueryOp(newQ);
                continue block0;
            }
            break;
        }
        if (this.mQueryOperations.size() == 0) {
            return new NoTermQueryOperation();
        }
        while (true) {
            block3: for (int i = 0; i < this.mQueryOperations.size(); ++i) {
                QueryOperation lhs = (QueryOperation)this.mQueryOperations.get(i);
                if (lhs instanceof IntersectionQueryOperation) {
                    this.combineOps(lhs, false);
                    this.mQueryOperations.remove(i);
                    continue;
                }
                for (int j = i + 1; j < this.mQueryOperations.size(); ++j) {
                    QueryOperation rhs = (QueryOperation)this.mQueryOperations.get(j);
                    QueryOperation joined = lhs.combineOps(rhs, false);
                    if (joined == null) continue;
                    this.mQueryOperations.remove(j);
                    this.mQueryOperations.remove(i);
                    this.addQueryOp(joined);
                    continue block3;
                }
            }
            break;
        }
        QueryTargetSet targets = this.getQueryTargets();
        if (targets.size() == 0) {
            mLog.debug("ELIMINATING " + this.toString() + " b/c of incompatible QueryTargets");
            return new NoResultsQueryOperation();
        }
        this.pruneIncompatibleTargets(targets);
        int distributeLhs = -1;
        for (int i = 0; i < this.mQueryOperations.size(); ++i) {
            QueryOperation lhs = (QueryOperation)this.mQueryOperations.get(i);
            if (!(lhs instanceof UnionQueryOperation) && lhs.getQueryTargets().size() <= 1) continue;
            distributeLhs = i;
            break;
        }
        if (distributeLhs >= 0) {
            UnionQueryOperation lhs = (UnionQueryOperation)this.mQueryOperations.remove(distributeLhs);
            assert (lhs instanceof UnionQueryOperation);
            UnionQueryOperation topOp = new UnionQueryOperation();
            for (QueryOperation lhsCur : lhs.mQueryOperations) {
                IntersectionQueryOperation newAnd = new IntersectionQueryOperation();
                topOp.add(newAnd);
                newAnd.addQueryOp(lhsCur);
                for (QueryOperation rhsCur : this.mQueryOperations) {
                    newAnd.addQueryOp((QueryOperation)rhsCur.clone());
                }
            }
            return topOp.optimize(mbox);
        }
        assert (this.getQueryTargets().countExplicitTargets() <= 1);
        TextQueryOperation lop = null;
        Iterator iter = this.mQueryOperations.iterator();
        while (iter.hasNext()) {
            QueryOperation op = (QueryOperation)iter.next();
            if (!(op instanceof TextQueryOperation)) continue;
            lop = (TextQueryOperation)op;
            iter.remove();
            break;
        }
        if (lop != null) {
            boolean foundIt = false;
            for (QueryOperation op : this.mQueryOperations) {
                if (!(op instanceof DBQueryOperation)) continue;
                ((DBQueryOperation)op).addTextOp(lop);
                foundIt = true;
            }
            if (!foundIt) {
                this.addQueryOp(lop);
            }
        }
        if (this.mQueryOperations.size() == 1) {
            return (QueryOperation)this.mQueryOperations.get(0);
        }
        return this;
    }

    @Override
    String toQueryString() {
        StringBuilder ret = new StringBuilder("(");
        boolean atFirst = true;
        for (QueryOperation op : this.mQueryOperations) {
            if (!atFirst) {
                ret.append(" AND ");
            }
            ret.append(op.toQueryString());
            atFirst = false;
        }
        ret.append(')');
        return ret.toString();
    }

    public String toString() {
        StringBuilder retval = new StringBuilder("INTERSECTION[");
        boolean atFirst = true;
        for (QueryOperation op : this.mQueryOperations) {
            if (atFirst) {
                atFirst = false;
            } else {
                retval.append(" AND ");
            }
            retval.append(op.toString());
        }
        retval.append("]");
        return retval.toString();
    }

    @Override
    public Object clone() {
        IntersectionQueryOperation toRet = (IntersectionQueryOperation)super.clone();
        assert (this.mMessageGrouper == null);
        toRet.mBufferedNext = new ArrayList(1);
        toRet.mQueryOperations = new ArrayList(this.mQueryOperations.size());
        for (QueryOperation q : this.mQueryOperations) {
            toRet.mQueryOperations.add((QueryOperation)q.clone());
        }
        return toRet;
    }

    @Override
    protected QueryOperation combineOps(QueryOperation other, boolean union) {
        if (!union && other instanceof IntersectionQueryOperation) {
            this.addQueryOps(((IntersectionQueryOperation)other).mQueryOperations);
            return this;
        }
        return null;
    }

    @Override
    protected void prepare(Mailbox mbx, ZimbraQueryResultsImpl res, MailboxIndex mbidx, SearchParams params, int chunkSize) throws ServiceException, IOException {
        chunkSize = (chunkSize + 1) * 3;
        this.mParams = params;
        this.mMessageGrouper = new HitGrouper[this.mQueryOperations.size()];
        this.setupResults(mbx, res);
        for (int i = 0; i < this.mQueryOperations.size(); ++i) {
            QueryOperation op = (QueryOperation)this.mQueryOperations.get(i);
            op.prepare(mbx, res, mbidx, params, chunkSize);
            this.mMessageGrouper[i] = new HitGrouper(op, res.getSortBy());
            if (op.hasNext()) continue;
            if (mLog.isDebugEnabled()) {
                mLog.debug("*Dropping out of intersect query since we got to 0 results on execution " + Integer.toString(i + 1) + " out of " + this.mQueryOperations.size());
            }
            for (int j = 0; j <= i; ++j) {
                ((QueryOperation)this.mQueryOperations.get(j)).doneWithSearchResults();
            }
            this.mQueryOperations.clear();
            this.mMessageGrouper = new HitGrouper[1];
            NoResultsQueryOperation nullOp = new NoResultsQueryOperation();
            this.addQueryOp(nullOp);
            this.mMessageGrouper[0] = new HitGrouper(nullOp, res.getSortBy());
            return;
        }
    }

    @Override
    public List<QueryInfo> getResultInfo() {
        ArrayList<QueryInfo> toRet = new ArrayList<QueryInfo>();
        for (QueryOperation op : this.mQueryOperations) {
            toRet.addAll(op.getResultInfo());
        }
        return toRet;
    }

    @Override
    public int estimateResultSize() throws ServiceException {
        if (this.mQueryOperations.size() == 0) {
            return 0;
        }
        int maxValue = Integer.MAX_VALUE;
        for (QueryOperation qop : this.mQueryOperations) {
            maxValue = Math.min(maxValue, qop.estimateResultSize()) / 2;
        }
        return maxValue;
    }

    @Override
    protected void depthFirstRecurse(QueryOperation.RecurseCallback cb) {
        for (int i = 0; i < this.mQueryOperations.size(); ++i) {
            QueryOperation op = (QueryOperation)this.mQueryOperations.get(i);
            op.depthFirstRecurse(cb);
        }
        cb.recurseCallback(this);
    }

    private static class HitGrouper {
        private QueryOperation mSubOp = null;
        private SortBy mSortOrder;
        private ArrayList<ZimbraHit> mBufferedHit = new ArrayList();
        private int mCurMsgId = -1;
        private ZimbraHit mGroupHit = null;
        private int mCurBufPos = 0;

        public String toString() {
            StringBuffer toRet = new StringBuffer(this.mSubOp.toString() + "\n\t");
            for (int i = 0; i < this.mBufferedHit.size(); ++i) {
                ZimbraHit hit = this.mBufferedHit.get(i);
                toRet.append(hit.toString()).append("\n\t");
            }
            return toRet.toString();
        }

        HitGrouper(QueryOperation subOperation, SortBy sortOrder) {
            this.mSubOp = subOperation;
            this.mSortOrder = sortOrder;
        }

        void resetIterator() throws ServiceException {
            this.mBufferedHit.clear();
            this.mSubOp.resetIterator();
            this.mCurMsgId = -1;
            this.mGroupHit = null;
            this.mCurBufPos = 0;
        }

        int getNextMessageId(ArrayList seenMsgs) throws ServiceException {
            for (int i = 1; i < this.mBufferedHit.size(); ++i) {
                Integer checkId = new Integer(this.mBufferedHit.get(i).getItemId());
                if (seenMsgs.contains(checkId)) continue;
                return checkId;
            }
            return -1;
        }

        boolean bufferNextHits() throws ServiceException {
            this.mBufferedHit.clear();
            if (!this.mSubOp.hasNext()) {
                return false;
            }
            this.mGroupHit = this.mSubOp.getNext();
            this.setMsgId(this.mGroupHit.getItemId());
            this.mBufferedHit.add(this.mGroupHit);
            while (this.mSubOp.hasNext()) {
                ZimbraHit hit = this.mSubOp.peekNext();
                if (hit.compareBySortField(this.mSortOrder, this.mGroupHit) == 0) {
                    this.mBufferedHit.add(hit);
                    ZimbraHit check = this.mSubOp.getNext();
                    assert (check == hit);
                    continue;
                }
                return !this.mBufferedHit.isEmpty();
            }
            return !this.mBufferedHit.isEmpty();
        }

        int getCurMsgId() {
            return this.mCurMsgId;
        }

        ZimbraHit getGroupHit() {
            return this.mGroupHit;
        }

        void setMsgId(int msgId) {
            this.mCurMsgId = msgId;
            this.mCurBufPos = 0;
        }

        ZimbraHit getNextHit() throws ServiceException {
            while (this.mCurBufPos < this.mBufferedHit.size()) {
                if (this.mBufferedHit.get(this.mCurBufPos).getItemId() == this.mCurMsgId) {
                    ++this.mCurBufPos;
                    return this.mBufferedHit.get(this.mCurBufPos - 1);
                }
                ++this.mCurBufPos;
            }
            return null;
        }

        boolean intersectWithBuffer(MessageHit hit) throws ServiceException {
            int hitMsgId = hit.getItemId();
            for (int i = 0; i < this.mBufferedHit.size(); ++i) {
                if (this.mBufferedHit.get(i).getItemId() != hitMsgId) continue;
                return true;
            }
            return false;
        }

        boolean intersectWithBuffer(MessagePartHit hit) throws ServiceException {
            int hitMsgId = hit.getItemId();
            for (int i = 0; i < this.mBufferedHit.size(); ++i) {
                ZimbraHit bufHit = this.mBufferedHit.get(i);
                if (bufHit.getItemId() != hitMsgId) continue;
                if (bufHit instanceof MessagePartHit) {
                    MessagePartHit mph = (MessagePartHit)bufHit;
                    if (mph != hit) continue;
                    return true;
                }
                return true;
            }
            return false;
        }

        boolean bufferNextHits(ZimbraHit curHit) throws ServiceException {
            this.mGroupHit = curHit;
            this.mBufferedHit.clear();
            if (!this.mSubOp.hasNext()) {
                return false;
            }
            ZimbraHit newStamp = null;
            while ((newStamp = this.mSubOp.peekNext()) != null) {
                int result = newStamp.compareBySortField(this.mSortOrder, this.mGroupHit);
                if (mLog.isDebugEnabled()) {
                    // empty if block
                }
                if (result == 0) {
                    this.mBufferedHit.add(newStamp);
                    ZimbraHit check = this.mSubOp.getNext();
                    assert (check == newStamp);
                    continue;
                }
                if (result < 0) {
                    this.mSubOp.getNext();
                    continue;
                }
                return this.mBufferedHit.size() > 0;
            }
            return this.mBufferedHit.size() > 0;
        }
    }
}

