/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ThreadPool;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.IIndexWritersCache;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;

class IndexWritersCache
implements IIndexWritersCache {
    private Set<IndexWriter> mOpenWriters = new LinkedHashSet<IndexWriter>();
    private Set<IndexWriter> mIdleWriters = new LinkedHashSet<IndexWriter>();
    private final long mSweeperTimeout = (long)LC.zimbra_index_sweep_frequency.intValueWithinRange(1, 3600) * 1000L;
    private final long mMaxIdleTime = 1000 * LC.zimbra_index_idle_flush_time.intValueWithinRange(1, 86400);
    private final int mMaxOpen = LC.zimbra_index_lru_size.intValueWithinRange(10, Integer.MAX_VALUE);
    private final int mFlushPoolSize = LC.zimbra_index_flush_pool_size.intValueWithinRange(1, 100);
    private int mNumFlushing = 0;
    private boolean mShutdown = false;
    private Thread mSweeperThread = null;
    private List<CountDownLatch> mWaitingForSlot = new ArrayList<CountDownLatch>();
    private ThreadPool mPool = new ThreadPool("IndexWriterFlush", this.mFlushPoolSize);
    private int mNumCacheHits = 0;
    private int mNumCacheOpens = 0;

    public IndexWritersCache() {
        Runnable sweeper = new Runnable(){

            public void run() {
                IndexWritersCache.this.doSweep(IndexWritersCache.this.mSweeperTimeout);
            }
        };
        this.mSweeperThread = new Thread(sweeper, "IndexWriterSweeper");
        this.mSweeperThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAllWriters() {
        ArrayList<IndexWriter> toFlush = new ArrayList<IndexWriter>();
        IndexWritersCache indexWritersCache = this;
        synchronized (indexWritersCache) {
            toFlush.addAll(this.mOpenWriters);
        }
        for (IndexWriter w : toFlush) {
            this.flush(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginWriting(IndexWriter w) throws IOException {
        assert (!Thread.holdsLock(this));
        boolean done = false;
        ZimbraPerf.COUNTER_IDX_WRT_OPENED.increment();
        do {
            WriterState curState;
            CountDownLatch l = null;
            IndexWritersCache indexWritersCache = this;
            synchronized (indexWritersCache) {
                curState = w.getState();
                switch (curState) {
                    case FLUSHING: {
                        l = w.getFlushWaiterLatch();
                        assert (!this.mIdleWriters.contains(w));
                        break;
                    }
                    case IDLE: {
                        assert (this.mIdleWriters.contains(w));
                        this.mIdleWriters.remove(w);
                        assert (!this.mIdleWriters.contains(w));
                        w.setState(WriterState.WRITING);
                        done = true;
                        ZimbraPerf.COUNTER_IDX_WRT_OPENED_CACHE_HIT.increment();
                        break;
                    }
                    case WRITING: {
                        assert (false);
                        done = true;
                        break;
                    }
                    case CLOSED: {
                        assert (!this.mIdleWriters.contains(w));
                        if (this.mOpenWriters.size() < this.mMaxOpen) {
                            done = true;
                            this.mOpenWriters.add(w);
                            w.setState(WriterState.WRITING);
                            break;
                        }
                        l = new CountDownLatch(1);
                        this.mWaitingForSlot.add(l);
                        this.notifyAll();
                    }
                }
            }
            if (!done) {
                try {
                    if (ZimbraLog.index.isDebugEnabled()) {
                        ZimbraLog.index.debug("Blocked in beginWriting for " + w + " because state was " + (Object)((Object)curState) + " NumFlushing=" + this.mNumFlushing);
                    }
                    l.await();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            ZimbraPerf.COUNTER_IDX_WRT.increment(this.mOpenWriters.size());
        } while (!done);
        try {
            w.doWriterOpen();
        }
        catch (IOException e) {
            this.openFailed(w);
            throw e;
        }
    }

    private synchronized void openFailed(IndexWriter w) {
        w.setState(WriterState.CLOSED);
        this.mIdleWriters.remove(w);
        this.mOpenWriters.remove(w);
        ZimbraPerf.COUNTER_IDX_WRT.increment(this.mOpenWriters.size());
        if (!this.mWaitingForSlot.isEmpty()) {
            CountDownLatch l = this.mWaitingForSlot.remove(0);
            l.countDown();
        }
        w.getFlushWaiterLatch().countDown();
        w.resetFlushWaiterLatch();
        this.notifyAll();
    }

    public synchronized void doneWriting(IndexWriter w) {
        assert (w.getState() == WriterState.WRITING);
        assert (!this.mIdleWriters.contains(w));
        assert (this.mOpenWriters.contains(w));
        w.setState(WriterState.IDLE);
        this.mIdleWriters.add(w);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        IndexWritersCache indexWritersCache = this;
        synchronized (indexWritersCache) {
            this.mShutdown = true;
            this.notifyAll();
            while (!this.mOpenWriters.isEmpty()) {
                this.notifyAll();
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            this.mSweeperThread.join();
            this.mPool.shutdown();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSweep(long sweepTime) {
        try {
            do {
                HashSet<IndexWriter> toFlush = new HashSet<IndexWriter>();
                long idleCutoff = System.currentTimeMillis() - this.mMaxIdleTime;
                IndexWritersCache indexWritersCache = this;
                synchronized (indexWritersCache) {
                    if (this.mShutdown && this.mOpenWriters.isEmpty()) {
                        return;
                    }
                    for (IndexWriter w : this.mIdleWriters) {
                        assert (w.getState() == WriterState.IDLE);
                        if (!this.mShutdown && w.getLastWriteTime() >= idleCutoff) continue;
                        toFlush.add(w);
                    }
                    int additionalNeeded = this.mWaitingForSlot.size() - (this.mNumFlushing + toFlush.size());
                    if (additionalNeeded > 0) {
                        for (IndexWriter w : this.mIdleWriters) {
                            assert (w.getState() == WriterState.IDLE);
                            if (additionalNeeded <= 0) break;
                            if (toFlush.contains(w)) continue;
                            --additionalNeeded;
                            toFlush.add(w);
                        }
                    }
                    if (toFlush.isEmpty()) {
                        try {
                            if (sweepTime > 0L) {
                                this.wait(sweepTime);
                            }
                        }
                        catch (InterruptedException e) {}
                    } else {
                        for (IndexWriter w : toFlush) {
                            assert (w.getState() == WriterState.IDLE);
                            ++this.mNumFlushing;
                            w.setState(WriterState.FLUSHING);
                            this.mIdleWriters.remove(w);
                        }
                    }
                }
                for (IndexWriter w : toFlush) {
                    AsyncFlush af = new AsyncFlush(w);
                    try {
                        this.mPool.execute(af);
                    }
                    catch (OutOfMemoryError e) {
                        Zimbra.halt("OutOfMemory in IndexWritersCache.doSweep", e);
                    }
                    catch (RejectedExecutionException e) {
                        ZimbraLog.index.debug("Sweeper hit interruptedException attempting to async flush " + w + ". Flushing synchronously.");
                        this.flushInternal(w);
                    }
                    catch (Throwable t) {
                        System.err.println("Error! " + t);
                        IndexWritersCache indexWritersCache2 = this;
                        synchronized (indexWritersCache2) {
                            --this.mNumFlushing;
                            w.setState(WriterState.IDLE);
                            w.getFlushWaiterLatch().countDown();
                            w.resetFlushWaiterLatch();
                            this.notifyAll();
                            this.mIdleWriters.add(w);
                        }
                    }
                }
            } while (sweepTime > 0L);
        }
        catch (OutOfMemoryError e) {
            Zimbra.halt("OutOfMemory in IndexWritersCache.doSweep", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(IndexWriter target) {
        IndexWritersCache indexWritersCache = this;
        synchronized (indexWritersCache) {
            while (target.getState() == WriterState.FLUSHING) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (target.getState() == WriterState.CLOSED) {
                return;
            }
            if (target.getState() == WriterState.WRITING) {
                this.doneWriting(target);
            }
            assert (target.getState() == WriterState.IDLE);
            ++this.mNumFlushing;
            target.setState(WriterState.FLUSHING);
            this.mIdleWriters.remove(target);
        }
        this.flushInternal(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInternal(IndexWriter target) {
        IndexWritersCache indexWritersCache;
        assert (!Thread.holdsLock(this));
        IndexWritersCache indexWritersCache2 = this;
        synchronized (indexWritersCache2) {
            assert (target.getState() == WriterState.FLUSHING);
        }
        try {
            target.doWriterClose();
            Object var5_4 = null;
            indexWritersCache = this;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IndexWritersCache indexWritersCache3 = this;
            synchronized (indexWritersCache3) {
                assert (target.getState() == WriterState.FLUSHING);
                assert (this.mOpenWriters.contains(target));
                assert (!this.mIdleWriters.contains(target));
                this.mOpenWriters.remove(target);
                ZimbraPerf.COUNTER_IDX_WRT.increment(this.mOpenWriters.size());
                target.setState(WriterState.CLOSED);
                --this.mNumFlushing;
                if (!this.mWaitingForSlot.isEmpty()) {
                    CountDownLatch l = this.mWaitingForSlot.remove(0);
                    l.countDown();
                }
                target.getFlushWaiterLatch().countDown();
                target.resetFlushWaiterLatch();
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (indexWritersCache) {
            assert (target.getState() == WriterState.FLUSHING);
            assert (this.mOpenWriters.contains(target));
            assert (!this.mIdleWriters.contains(target));
            this.mOpenWriters.remove(target);
            ZimbraPerf.COUNTER_IDX_WRT.increment(this.mOpenWriters.size());
            target.setState(WriterState.CLOSED);
            --this.mNumFlushing;
            if (!this.mWaitingForSlot.isEmpty()) {
                CountDownLatch l = this.mWaitingForSlot.remove(0);
                l.countDown();
            }
            target.getFlushWaiterLatch().countDown();
            target.resetFlushWaiterLatch();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int i;
        int cacheSize = 20;
        int numWriters = 200;
        int numThreads = 10;
        int sweepFrequencyS = 1;
        int idleFlushTimeS = 2000;
        int flushDeciPercent = 1;
        int writeDeciPercent = 999;
        ZimbraLog.toolSetupLog4j("WARN", "/tmp/iwc_test.txt");
        LC.zimbra_index_lru_size.setDefault(Integer.toString(cacheSize));
        LC.zimbra_index_sweep_frequency.setDefault(Integer.toString(sweepFrequencyS));
        LC.zimbra_index_idle_flush_time.setDefault(Integer.toString(idleFlushTimeS));
        IndexWritersCache cache = new IndexWritersCache();
        Random r = new Random(System.currentTimeMillis());
        ArrayList<TestWriter> writers = new ArrayList<TestWriter>();
        for (int i2 = 0; i2 < numWriters; ++i2) {
            TestWriter w = new TestWriter(r, cache);
            writers.add(w);
        }
        long start = System.currentTimeMillis();
        System.out.println("Beginning run w/ cache size = " + cacheSize + " numWriters=" + numWriters + " numThreads=" + numThreads);
        IndexWritersCache indexWritersCache = cache;
        synchronized (indexWritersCache) {
            cache.mNumCacheHits = 0;
            cache.mNumCacheOpens = 0;
        }
        TestThread[] t = new TestThread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            t[i] = new TestThread(cache, writers, Integer.MAX_VALUE, writeDeciPercent, flushDeciPercent);
        }
        for (i = 0; i < numThreads; ++i) {
            t[i].start();
        }
        boolean stop = false;
        while (!stop) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int lowestIter = Integer.MAX_VALUE;
            int highestIter = -1;
            for (TestThread tt : t) {
                int threadIter = tt.mCurrentIteration;
                lowestIter = Math.min(lowestIter, threadIter);
                highestIter = Math.max(highestIter, threadIter);
            }
            System.out.println("Lowest iter is " + lowestIter + " Highest=" + highestIter + " NumFlushing=" + cache.mNumFlushing);
        }
        for (int i3 = 0; i3 < numThreads; ++i3) {
            try {
                t[i3].join();
                continue;
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted: " + e);
                e.printStackTrace();
            }
        }
        cache.mShutdown = true;
        long end = System.currentTimeMillis();
        long total = end - start;
        System.out.println("Test Done w/ cache=" + cacheSize + " Took " + total + "ms");
        cache.shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestThread
    extends Thread {
        int mNumIters;
        Random mR;
        IIndexWritersCache mCache;
        List<TestWriter> mWriters;
        int mSleepTime;
        int mWritePct;
        int mFlushPct;
        volatile int mCurrentIteration;

        TestThread(IIndexWritersCache cache, List<TestWriter> writers, int numIters, int writePct, int flushPct) {
            this.mCache = cache;
            this.mWriters = writers;
            this.mWritePct = writePct;
            this.mFlushPct = flushPct;
            this.mNumIters = numIters;
            this.mR = new Random(System.currentTimeMillis() + this.getId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int i = 0; i < this.mNumIters; ++i) {
                this.mCurrentIteration = i;
                int dpct = this.mR.nextInt(1000);
                if (dpct <= this.mWritePct + this.mFlushPct) {
                    TestWriter w;
                    TestWriter testWriter = w = this.mWriters.get(this.mR.nextInt(this.mWriters.size()));
                    synchronized (testWriter) {
                        if (dpct > this.mFlushPct) {
                            try {
                                this.mCache.beginWriting(w);
                                try {
                                    Thread.sleep(5L);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                this.mCache.doneWriting(w);
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                }
                System.out.println("Sleeping...");
            }
        }
    }

    static class TestWriter
    extends IndexWriter {
        Random r;
        boolean opened = false;
        WriterState mState = WriterState.CLOSED;
        long mLastAccessTime = System.currentTimeMillis();
        IndexWritersCache mCache;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long randomLong(long max) {
            Random random = this.r;
            synchronized (random) {
                long l = this.r.nextLong();
                if (l < 0L) {
                    l = -1L * l;
                }
                return l % max;
            }
        }

        public void doWriterOpen() throws IOException {
            if (!this.opened) {
                try {
                    if ((double)this.r.nextFloat() > 0.9) {
                        throw new IOException("Foo");
                    }
                    this.opened = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void doWriterClose() {
            assert (this.opened);
            try {
                if ((double)this.r.nextFloat() > 0.999) {
                    throw new IllegalArgumentException("foo");
                }
                long length = this.randomLong(100L);
                if (length > 0L) {
                    Thread.sleep(length);
                }
                this.opened = false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public long getLastWriteTime() {
            return this.mLastAccessTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() {
            TestWriter testWriter = this;
            synchronized (testWriter) {
                try {
                    this.mCache.beginWriting(this);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                assert (this.opened);
                assert (this.opened);
                this.mCache.doneWriting(this);
                this.mLastAccessTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            TestWriter testWriter = this;
            synchronized (testWriter) {
                if (this.opened) {
                    // empty if block
                }
                this.mCache.flush(this);
            }
        }

        TestWriter(Random r, IndexWritersCache cache) {
            this.r = r;
            this.mCache = cache;
        }
    }

    class AsyncFlush
    implements Runnable {
        private IndexWriter mTarget;

        AsyncFlush(IndexWriter target) {
            this.mTarget = target;
        }

        public void run() {
            try {
                IndexWritersCache.this.flushInternal(this.mTarget);
            }
            catch (OutOfMemoryError e) {
                Zimbra.halt("OutOfMemory in IndexWritersCache.AsyncFlush", e);
            }
            catch (Throwable t) {
                ZimbraLog.index.warn((Object)"Caught exception in Async Index Flush: ", t);
            }
        }
    }

    static abstract class IndexWriter {
        private WriterState mState = WriterState.CLOSED;
        private CountDownLatch mFlushWaiterLatch = new CountDownLatch(1);

        IndexWriter() {
        }

        abstract void doWriterOpen() throws IOException;

        abstract void doWriterClose();

        abstract long getLastWriteTime();

        public WriterState getState() {
            return this.mState;
        }

        public void setState(WriterState state) {
            this.mState = state;
        }

        public CountDownLatch getFlushWaiterLatch() {
            return this.mFlushWaiterLatch;
        }

        public void resetFlushWaiterLatch() {
            this.mFlushWaiterLatch = new CountDownLatch(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WriterState {
        CLOSED,
        WRITING,
        IDLE,
        FLUSHING;

    }
}

