/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.ILuceneIndex;
import com.zimbra.cs.index.RefCountedIndexReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;

class IndexReadersCache
extends Thread {
    private static Log sLog = LogFactory.getLog(IndexReadersCache.class);
    private final int mMaxOpenReaders;
    private LinkedHashMap<ILuceneIndex, RefCountedIndexReader> mOpenIndexReaders;
    private boolean mShutdown;
    private long mSweepIntervalMS;
    private long mMaxReaderOpenTimeMS;
    private static boolean sUseReaderReopen = LC.zimbra_index_use_reader_reopen.booleanValue();

    IndexReadersCache(int maxOpenReaders, long maxReaderOpenTime, long sweepIntervalMS) {
        super("IndexReadersCache-Sweeper");
        if (maxReaderOpenTime < 0L) {
            maxReaderOpenTime = 0L;
        }
        if (sweepIntervalMS < 100L) {
            sweepIntervalMS = 100L;
        }
        this.mMaxReaderOpenTimeMS = maxReaderOpenTime;
        this.mMaxOpenReaders = maxOpenReaders;
        this.mOpenIndexReaders = new LinkedHashMap(this.mMaxOpenReaders);
        this.mShutdown = false;
        this.mSweepIntervalMS = sweepIntervalMS;
    }

    synchronized void signalShutdown() {
        this.mShutdown = true;
        this.notify();
    }

    synchronized void putIndexReader(ILuceneIndex idx, RefCountedIndexReader reader) {
        if (this.mMaxOpenReaders <= 0) {
            return;
        }
        int toRemove = this.mOpenIndexReaders.size() + 1 - this.mMaxOpenReaders;
        if (toRemove > 0) {
            Iterator<Map.Entry<ILuceneIndex, RefCountedIndexReader>> iter = this.mOpenIndexReaders.entrySet().iterator();
            while (toRemove > 0) {
                Map.Entry<ILuceneIndex, RefCountedIndexReader> entry = iter.next();
                entry.getValue().release();
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Releasing index reader for index: " + entry.getKey().toString() + " from cache (too many open)");
                }
                iter.remove();
                --toRemove;
            }
        }
        assert (toRemove <= 0);
        reader.addRef();
        this.mOpenIndexReaders.put(idx, reader);
    }

    synchronized void removeIndexReader(ILuceneIndex idx) {
        if (this.mMaxOpenReaders <= 0) {
            return;
        }
        RefCountedIndexReader reader = this.mOpenIndexReaders.get(idx);
        if (reader != null && !reader.requiresReopen()) {
            if (sUseReaderReopen && reader.markForReopen()) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug("IndexReader successfully marked for re-open: " + idx.toString());
                }
                return;
            }
            RefCountedIndexReader removed = (RefCountedIndexReader)this.mOpenIndexReaders.remove(idx);
            if (removed != null) {
                removed.release();
                if (sLog.isDebugEnabled()) {
                    sLog.debug("Closing index reader for index: " + idx.toString() + " (removed)");
                }
            }
        }
    }

    synchronized RefCountedIndexReader getIndexReader(ILuceneIndex idx) {
        RefCountedIndexReader toRet = this.mOpenIndexReaders.get(idx);
        if (toRet != null) {
            if (toRet.requiresReopen()) {
                try {
                    IndexReader oldReader = toRet.getReader();
                    IndexReader newReader = oldReader.reopen();
                    if (newReader != null && newReader != oldReader) {
                        oldReader.close();
                        if (sLog.isDebugEnabled()) {
                            sLog.debug("Reopened new indexreader instance: " + newReader);
                        }
                        toRet.reopened(newReader);
                    } else {
                        if (sLog.isDebugEnabled()) {
                            sLog.debug("Attempted reopen but reader was current: " + oldReader);
                        }
                        toRet.reopened(oldReader);
                    }
                }
                catch (IOException e) {
                    ZimbraLog.im.debug((Object)"Caught exception while attempting to reopen IndexReader", e);
                    toRet.release();
                    return null;
                }
            }
            toRet.addRef();
        }
        return toRet;
    }

    synchronized boolean containsKey(ILuceneIndex idx) {
        return this.mOpenIndexReaders.containsKey(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        IndexReadersCache indexReadersCache;
        if (this.mMaxOpenReaders <= 0) {
            sLog.info(this.getName() + " thread disabled (Max open IndexReaders set to 0)");
            return;
        }
        sLog.info(this.getName() + " thread starting");
        boolean shutdown = false;
        while (!shutdown) {
            indexReadersCache = this;
            synchronized (indexReadersCache) {
                long now;
                long until;
                long startTime = System.currentTimeMillis();
                if (!this.mShutdown && (until = startTime + this.mSweepIntervalMS) > (now = System.currentTimeMillis())) {
                    try {
                        this.wait(until - now);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!(shutdown = this.mShutdown)) {
                    now = System.currentTimeMillis();
                    long cutoff = now - this.mMaxReaderOpenTimeMS;
                    Iterator<Map.Entry<ILuceneIndex, RefCountedIndexReader>> iter = this.mOpenIndexReaders.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<ILuceneIndex, RefCountedIndexReader> entry = iter.next();
                        if (entry.getValue().getAccessTime() >= cutoff) continue;
                        if (sLog.isDebugEnabled()) {
                            sLog.debug("Releasing cached index reader for index: " + entry.getKey().toString() + " (timed out)");
                        }
                        entry.getValue().release();
                        iter.remove();
                    }
                }
            }
        }
        indexReadersCache = this;
        synchronized (indexReadersCache) {
            for (RefCountedIndexReader reader : this.mOpenIndexReaders.values()) {
                reader.release();
            }
            this.mOpenIndexReaders.clear();
        }
        sLog.info(this.getName() + " thread exiting");
    }
}

