/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.ExceptionToString;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.NetUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.index.ConversationHit;
import com.zimbra.cs.index.HitIdGrouper;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.MessagePartHit;
import com.zimbra.cs.index.MultiQueryResults;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.TestSearch;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQuery;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.tcpserver.ProtocolHandler;
import com.zimbra.cs.tcpserver.TcpServer;
import com.zimbra.cs.tcpserver.TcpServerInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class IndexEditor {
    static final int SEARCH_RETURN_CONVERSATIONS = 1;
    static final int SEARCH_RETURN_MESSAGES = 2;
    static final int SEARCH_RETURN_DOCUMENTS = 3;
    private static SortBy sortOrder = SortBy.DATE_DESCENDING;
    private BufferedReader inputReader = null;
    private PrintStream outputStream = null;
    private static Log mLog = LogFactory.getLog(IndexEditor.class);
    static IndexEditorTcpServer sTcpServer = null;
    static IndexEditorProtocolhandler sIndexEditorProtocolHandler;
    static int sPortNo;
    static IndexEditorTcpThread tcpServerThread;
    static Thread sThread;
    public static ArrayList inputs;
    private IndexEditorProtocolhandler mHandler;

    public void deleteIndex(long mailboxId) throws ServiceException {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mailboxId);
        MailboxIndex mi = mbox.getMailboxIndex();
        try {
            mi.deleteIndex();
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Caught IOException", e);
        }
    }

    public void reIndexAll() {
        MailboxManager mmgr;
        try {
            mmgr = MailboxManager.getInstance();
        }
        catch (ServiceException e) {
            ZimbraLog.index.error((Object)"could not retrieve mailbox manager; aborting reindex", e);
            return;
        }
        long[] ids = mmgr.getMailboxIds();
        for (int i = 0; i < ids.length; ++i) {
            mLog.info("Mailbox " + ids[i] + "\n");
            try {
                Mailbox mbx = mmgr.getMailboxById(ids[i]);
                mbx.reIndex(null, null, null, false);
                continue;
            }
            catch (ServiceException e) {
                mLog.info((Object)("Exception ReIndexing " + ids[i]), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reIndex(long mailboxId) {
        MailboxIndex midx = null;
        try {
            try {
                Mailbox mbx = MailboxManager.getInstance().getMailboxById(mailboxId);
                mbx.reIndex(null, null, null, false);
            }
            catch (Exception e) {
                this.outputStream.println("Re-index FAILED with " + ExceptionToString.ToString(e));
                Object var6_6 = null;
                if (midx != null) {
                    midx.flush();
                }
            }
            Object var6_5 = null;
            if (midx != null) {
                midx.flush();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (midx != null) {
                midx.flush();
            }
            throw throwable;
        }
    }

    public void checkIndex(long mailboxId, boolean repair) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doQuery(QueryRunner runner, boolean dump, int groupBy) throws MailServiceException, IOException, ParseException, ServiceException {
        while (true) {
            Object var17_15;
            this.outputStream.print("Query> ");
            String qstr = this.inputReader.readLine();
            if (qstr.equals("")) {
                return;
            }
            this.outputStream.println("\n\nTest 1: " + qstr);
            long startTime = System.currentTimeMillis();
            byte[] types = new byte[1];
            switch (groupBy) {
                case 1: {
                    types[0] = 4;
                    break;
                }
                case 2: {
                    types[0] = 5;
                    break;
                }
                default: {
                    types[0] = 0;
                }
            }
            ZimbraQueryResults res = runner.runQuery(qstr, types, sortOrder);
            try {
                long endTime = System.currentTimeMillis();
                boolean numMessages = false;
                int HITS_PER_PAGE = 20;
                int totalShown = 0;
                res.resetIterator();
                ZimbraHit hit = res.getNext();
                while (hit != null) {
                    for (int i = 0; hit != null && i < HITS_PER_PAGE; ++i) {
                        this.displayHit(hit, groupBy);
                        ++totalShown;
                        hit = res.getNext();
                    }
                    if (hit == null) continue;
                    this.outputStream.print("more (y/n) ? ");
                    String line = this.inputReader.readLine();
                    if (line.length() != 0 && line.charAt(0) != 'n') continue;
                    break;
                }
                this.outputStream.println("Query ran in " + (endTime - startTime) + " ms");
                this.outputStream.println("Displayed a total of " + totalShown + " Hits");
                var17_15 = null;
            }
            catch (Throwable throwable) {
                var17_15 = null;
                res.doneWithSearchResults();
                throw throwable;
            }
            res.doneWithSearchResults();
        }
    }

    public void displayHit(ZimbraHit hit, int groupBy) {
        this.outputStream.print("HIT: ");
        if (groupBy == 1) {
            ConversationHit ch = (ConversationHit)hit;
            this.outputStream.println(ch.toString() + " \"  (" + ch.getNumMessageHits() + ")");
            Collection<MessageHit> mhs = ch.getMessageHits();
            for (MessageHit mh : mhs) {
                this.outputStream.println("\t" + mh.toString());
            }
        } else if (hit instanceof MessageHit) {
            MessageHit mh = (MessageHit)hit;
            this.outputStream.println(mh.toString());
        } else if (hit instanceof MessagePartHit) {
            MessagePartHit mph = (MessagePartHit)hit;
            this.outputStream.println(mph.toString());
        } else {
            this.outputStream.println(hit.toString());
        }
    }

    public void dumpFields(long mailboxId) throws IOException, ServiceException {
    }

    public boolean confirm(String confirmString) {
        this.outputStream.println(confirmString);
        this.outputStream.print("Type YES to confirm: ");
        try {
            String s = this.inputReader.readLine();
            if (s.equals("YES")) {
                return true;
            }
        }
        catch (Exception e) {
            this.outputStream.print("Caught exception: " + ExceptionToString.ToString(e));
        }
        return false;
    }

    public static String Format(String s, int len) {
        StringBuffer toRet = new StringBuffer(len + 1);
        int curOff = 0;
        if (s.length() < len) {
            for (curOff = 0; curOff < len - s.length(); ++curOff) {
                toRet.append(" ");
            }
        }
        int sOff = 0;
        while (curOff < len) {
            toRet.append(s.charAt(sOff));
            ++sOff;
            ++curOff;
        }
        toRet.append("  ");
        return toRet.toString();
    }

    public void dumpDocument(Document d, boolean isDeleted) {
        String part;
        Field f;
        if (isDeleted) {
            this.outputStream.print("DELETED ");
        }
        String subj = (f = d.getField("subject")) != null ? f.stringValue() : "MISSING_SUBJECT";
        f = d.getField("l.mbox_blob_id");
        String blobId = f != null ? f.stringValue() : "MISSING";
        String dateStr = d.get("l.date");
        if (dateStr == null) {
            dateStr = "";
        } else {
            Date dt = DateField.stringToDate(dateStr);
            dateStr = dt.toString() + " (" + dt.getTime() + ")";
        }
        String sizeStr = d.get("l.size");
        if (sizeStr == null) {
            sizeStr = "";
        }
        if ((part = d.get("l.partname")) == null) {
            part = "NO_PART";
        }
        this.outputStream.println(IndexEditor.Format(blobId, 10) + IndexEditor.Format(dateStr, 45) + IndexEditor.Format(part, 10) + IndexEditor.Format(sizeStr, 10) + "\"" + subj + "\"");
        Field content = d.getField("l.content");
        if (content != null) {
            this.outputStream.println("\t" + content.toString());
        }
    }

    public void dumpAll(long mailboxId) throws IOException, ServiceException {
    }

    public void dumpDocumentByMailItemId(long mailboxId, int mailItemId) throws ServiceException, IOException {
    }

    private static int NumDigits(String s) {
        int ret = 0;
        char[] array = s.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (!Character.isDigit(array[i])) continue;
            ++ret;
        }
        return ret;
    }

    public void dumpTerms(long mailboxId) throws IOException, ServiceException {
    }

    public void getTerms(long mailboxId, String field, int minNum, int maxNum, Collection ret) throws IOException, ServiceException {
    }

    public void spanTest(long mailboxId) throws IOException, ServiceException {
    }

    public static void StartTcpEditor() throws ServiceException {
        ServerSocket serverSocket = NetUtil.getTcpServerSocket(null, sPortNo);
        sTcpServer = new IndexEditorTcpServer("IndexEditorTcpServer", 3, 5, serverSocket);
        sIndexEditorProtocolHandler = new IndexEditorProtocolhandler(sTcpServer);
        sTcpServer.addActiveHandler(sIndexEditorProtocolHandler);
        sThread = new Thread((Runnable)new IndexEditorTcpThread(), "IndexEditor-TcpServer");
        sThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void EndTcpEditor() {
        for (Object cur : inputs) {
            try {
                if (cur instanceof InputStream) {
                    ((InputStream)cur).close();
                    continue;
                }
                ((OutputStream)cur).close();
            }
            catch (IOException e) {
                mLog.error("Caught " + ExceptionToString.ToString(e));
            }
        }
        if (sTcpServer != null) {
            try {
                sTcpServer.removeActiveHandler(sIndexEditorProtocolHandler);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                sTcpServer.shutdown(0);
                sTcpServer = null;
                throw throwable;
            }
            sTcpServer.shutdown(0);
            sTcpServer = null;
            {
            }
        }
    }

    public void run(InputStream input, OutputStream output) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        PrintStream printer = new PrintStream(output, true);
        this.run(reader, printer);
    }

    public void run() {
        this.run(new BufferedReader(new InputStreamReader(System.in)), System.out);
    }

    public void run(BufferedReader _inputReader, PrintStream _outputStream) {
        this.inputReader = _inputReader;
        this.outputStream = _outputStream;
        String mailboxIdStr = null;
        long mailboxId = 0L;
        boolean quit = false;
        while (!quit) {
            try {
                SingleQueryRunner runner;
                this.outputStream.print("> ");
                String command = null;
                try {
                    command = this.inputReader.readLine();
                }
                catch (IOException e) {
                    quit = true;
                    continue;
                }
                if (command == null || command.equals("exit") || command.equals("quit")) {
                    quit = true;
                    continue;
                }
                if (command.equals("?")) {
                    this.help();
                    continue;
                }
                if (command.equals("re-index")) {
                    this.reIndex(mailboxId);
                    continue;
                }
                if (command.equals("re-index-all")) {
                    this.reIndexAll();
                    continue;
                }
                if (command.equals("re-index-msg")) {
                    this.outputStream.print("MSGID> THIS_FUNCTION_CURRENTLY_UNIMPLEMENTED");
                    continue;
                }
                if (command.equals("sort da")) {
                    sortOrder = SortBy.DATE_ASCENDING;
                    this.outputStream.println("---->Search order = DATE_ASCENDING");
                    continue;
                }
                if (command.equals("sort dd")) {
                    sortOrder = SortBy.DATE_DESCENDING;
                    this.outputStream.println("---->Search order = DATE_DESCENDING");
                    continue;
                }
                if (command.equals("sort sa")) {
                    sortOrder = SortBy.SUBJ_ASCENDING;
                    this.outputStream.println("---->Search order = SUBJ_ASCENDING");
                    continue;
                }
                if (command.equals("sort sd")) {
                    sortOrder = SortBy.SUBJ_DESCENDING;
                    this.outputStream.println("---->Search order = SUBJ_DESCENDING");
                    continue;
                }
                if (command.equals("sort na")) {
                    sortOrder = SortBy.NAME_ASCENDING;
                    this.outputStream.println("---->Search order = NAME_ASCENDING");
                    continue;
                }
                if (command.equals("sort nd")) {
                    sortOrder = SortBy.NAME_DESCENDING;
                    this.outputStream.println("---->Search order = NAME_DESCENDING");
                    continue;
                }
                if (command.equals("sort za")) {
                    sortOrder = SortBy.SIZE_ASCENDING;
                    this.outputStream.println("---->Search order = SIZE_ASCENDING");
                    continue;
                }
                if (command.equals("sort zd")) {
                    sortOrder = SortBy.SIZE_DESCENDING;
                    this.outputStream.println("---->Search order = SIZE_DESCENDING");
                    continue;
                }
                if (command.equals("q") || command.equals("query")) {
                    runner = new SingleQueryRunner(mailboxId);
                    this.doQuery(runner, false, 2);
                    continue;
                }
                if (command.equals("qd") || command.equals("querydump")) {
                    runner = new SingleQueryRunner(mailboxId);
                    this.doQuery(runner, true, 3);
                    continue;
                }
                if (command.equals("qc") || command.equals("queryconv")) {
                    runner = new SingleQueryRunner(mailboxId);
                    this.doQuery(runner, true, 1);
                    continue;
                }
                if (command.equals("qp") || command.equals("queryconv")) {
                    runner = new SingleQueryRunner(mailboxId);
                    this.doQuery(runner, true, 3);
                    continue;
                }
                if (command.equals("mq")) {
                    ArrayList<Long> ids = new ArrayList<Long>();
                    do {
                        this.outputStream.print("Enter Mailbox ID (blank when done): ");
                        mailboxIdStr = this.inputReader.readLine();
                        if (mailboxIdStr.equals("")) continue;
                        long id = this.getMailboxIdFromString(mailboxIdStr);
                        this.outputStream.println("\tAdded mailbox ID " + id);
                        ids.add(new Long(id));
                    } while (!mailboxIdStr.equals(""));
                    MultiQueryRunner runner2 = new MultiQueryRunner(ids);
                    this.doQuery(runner2, false, 1);
                    continue;
                }
                if (command.equals("mbox")) {
                    this.outputStream.print("Enter New Mailbox ID: ");
                    mailboxIdStr = this.inputReader.readLine();
                    mailboxId = this.getMailboxIdFromString(mailboxIdStr);
                    this.outputStream.println("\tMailboxID set to " + mailboxId);
                    continue;
                }
                if (command.equals("fields")) {
                    this.dumpFields(mailboxId);
                    continue;
                }
                if (command.equals("terms")) {
                    this.dumpTerms(mailboxId);
                    continue;
                }
                if (command.equals("s")) {
                    this.spanTest(mailboxId);
                    continue;
                }
                if (command.equals("delete_index")) {
                    if (!this.confirm("Are you sure you want to delete the index for mailbox " + mailboxId + "?")) continue;
                    this.deleteIndex(mailboxId);
                    continue;
                }
                if (command.equals("dumpmi")) {
                    this.outputStream.print("Enter Mail-Item-ID:");
                    String midStr = this.inputReader.readLine();
                    if (midStr.equals("")) continue;
                    int id = Integer.parseInt(midStr);
                    this.dumpDocumentByMailItemId(mailboxId, id);
                    continue;
                }
                if (command.equals("dumpall")) {
                    this.dumpAll(mailboxId);
                    continue;
                }
                if (command.equals("unit")) {
                    TestSearch.runTests();
                    continue;
                }
                if (command.equals("verify")) {
                    this.checkIndex(mailboxId, false);
                    continue;
                }
                if (command.equals("repair")) {
                    this.checkIndex(mailboxId, true);
                    continue;
                }
                if (command.equals("size")) {
                    this.getSize(mailboxId);
                    continue;
                }
                if (command.equals("loglevel")) {
                    this.logLevel();
                    continue;
                }
                if (command.equals("snoop")) {
                    if (this.mHandler == null) {
                        this.outputStream.println("Log Snooping only available in remote mode");
                        continue;
                    }
                    if (this.mHandler.enableLogging()) {
                        this.outputStream.println("Log Snooping ENABLED");
                        continue;
                    }
                    this.outputStream.println("Log Snooping already active.");
                    continue;
                }
                if (!command.equals("nosnoop")) continue;
                if (this.mHandler == null) {
                    this.outputStream.println("Log Snooping only available in remote mode");
                    continue;
                }
                if (this.mHandler.disableLogging()) {
                    this.outputStream.println("Log Snooping DISABLED");
                    continue;
                }
                this.outputStream.println("Log Snooping not active.");
            }
            catch (Exception e) {
                this.outputStream.println("Caught Exception " + ExceptionToString.ToString(e));
            }
        }
    }

    long getMailboxIdFromString(String str) throws ServiceException {
        if (str != null && !str.equals("")) {
            if (str.indexOf(64) >= 0) {
                Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, str);
                Mailbox mbx = MailboxManager.getInstance().getMailboxByAccount(acct);
                return mbx.getId();
            }
            return Long.parseLong(str);
        }
        return 0L;
    }

    public void logLevel() {
        String logLevel = null;
        try {
            this.outputStream.print("Enter logging level> ");
            logLevel = this.inputReader.readLine();
        }
        catch (Exception e) {
            this.outputStream.print("Caught exception: " + e.toString());
        }
        Logger root = Logger.getRootLogger();
        if (logLevel != null && !logLevel.equals("")) {
            Level newLevel = null;
            if (logLevel.equalsIgnoreCase("ALL")) {
                newLevel = Level.ALL;
            } else if (logLevel.equalsIgnoreCase("DEBUG")) {
                newLevel = Level.DEBUG;
            } else if (logLevel.equalsIgnoreCase("ERROR")) {
                newLevel = Level.ERROR;
            } else if (logLevel.equalsIgnoreCase("FATAL")) {
                newLevel = Level.FATAL;
            } else if (logLevel.equalsIgnoreCase("INFO")) {
                newLevel = Level.INFO;
            } else if (logLevel.equalsIgnoreCase("OFF")) {
                newLevel = Level.OFF;
            } else if (logLevel.equalsIgnoreCase("WARN")) {
                newLevel = Level.WARN;
            }
            if (newLevel == null) {
                this.outputStream.println("Unknown level - must be ALL/DEBUG/ERROR/FATAL/INFO/OFF/WARN");
                return;
            }
            root.setLevel(newLevel);
        }
        Level cur = root.getLevel();
        this.outputStream.println("Current level is: " + cur);
    }

    public IndexEditor(IndexEditorProtocolhandler handler) {
        this.mHandler = handler;
    }

    public IndexEditor() {
        this.mHandler = null;
    }

    public static void main(String[] args) {
        CliUtil.toolSetup("DEBUG");
        MailboxIndex.startup();
        IndexEditor editor = new IndexEditor();
        editor.run();
        MailboxIndex.shutdown();
    }

    void getSize(long mailboxId) throws ServiceException {
        Mailbox mbx = MailboxManager.getInstance().getMailboxById(mailboxId);
        long size = mbx.getSize();
        this.outputStream.println("Mailbox " + mailboxId + " has size " + size + " (" + size / 1024L + "kb)");
    }

    void help() {
        this.outputStream.println("\nHELP (updated)");
        this.outputStream.println("----");
        this.outputStream.println("exit-- exit this program");
        this.outputStream.println("re-index -- re-index mailbox from message store");
        this.outputStream.println("re-index-all -- re-index ALL MAILBOXES (!) in the message store");
        this.outputStream.println("re-index-msg -- re-index mailbox from message store");
        this.outputStream.println("sort na|nd|sa|sd|da|dd -- set sort order (name asc/desc, subj asc/desc or date asc/desc)");
        this.outputStream.println("query -- run a query group_by_message");
        this.outputStream.println("queryconv -- run a query group_by_conv");
        this.outputStream.println("mbox -- change mailbox");
        this.outputStream.println("fields -- dump all known fields");
        this.outputStream.println("terms -- dump all known terms for a field");
        this.outputStream.println("delete_index -- deletes the index");
        this.outputStream.println("dumpmi -- dump document by mail_item");
        this.outputStream.println("dumpall -- dump all documents");
        this.outputStream.println("unit -- run unit tests");
        this.outputStream.println("hack -- hacked test code to make a copy of index");
        this.outputStream.println("size -- Return the (uncompressed) size of this mailbox");
        this.outputStream.println("verify -- Verify that all messages in this mailbox are indexed");
        this.outputStream.println("loglevel -- Change the default global logging level (affects all appenders!)");
        this.outputStream.println("snoop -- copy log4j root logger to local output (snoop logs)");
        this.outputStream.println("nosnoop -- stop copying log4j logger");
    }

    static {
        sPortNo = 7035;
        inputs = new ArrayList();
    }

    private static class IndexEditorProtocolhandler
    extends ProtocolHandler {
        private InputStream mInputStream;
        private OutputStream mOutputStream;
        private IndexEditor mEditor = null;
        private String logLayoutPattern = "%d %-5p [%t] [%x] %c{1} - %m%n";
        private WriterAppender mAppender;

        public IndexEditorProtocolhandler(TcpServer server) {
            super(server);
        }

        protected boolean setupConnection(Socket connection) throws IOException {
            this.mInputStream = new TcpServerInputStream(connection.getInputStream());
            this.mOutputStream = new BufferedOutputStream(connection.getOutputStream());
            inputs.add(this.mInputStream);
            inputs.add(this.mOutputStream);
            return true;
        }

        protected boolean authenticate() throws IOException {
            return true;
        }

        public boolean enableLogging() {
            if (this.mAppender == null) {
                PatternLayout layout = new PatternLayout(this.logLayoutPattern);
                this.mAppender = new WriterAppender((Layout)layout, this.mOutputStream);
                Logger root = Logger.getRootLogger();
                root.addAppender((Appender)this.mAppender);
                return true;
            }
            return false;
        }

        public boolean disableLogging() {
            if (this.mAppender != null) {
                Logger root = Logger.getRootLogger();
                root.removeAppender((Appender)this.mAppender);
                this.mAppender = null;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean processCommand() throws Exception {
            this.mAppender = null;
            try {
                this.mEditor = new IndexEditor(this);
                this.mEditor.run(this.mInputStream, this.mOutputStream);
                Object var2_1 = null;
                this.disableLogging();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.disableLogging();
                throw throwable;
            }
            return false;
        }

        protected void dropConnection() {
            if (this.mInputStream != null) {
                try {
                    this.mInputStream.close();
                }
                catch (IOException e) {
                    mLog.warn("While closing output stream, Caught " + ExceptionToString.ToString(e));
                }
                this.mInputStream = null;
            }
            if (this.mOutputStream != null) {
                try {
                    this.mOutputStream.close();
                }
                catch (IOException e) {
                    mLog.warn("While closing output stream, Caught " + ExceptionToString.ToString(e));
                }
                this.mOutputStream = null;
            }
        }

        protected void notifyIdleConnection() {
        }
    }

    private static class IndexEditorTcpServer
    extends TcpServer {
        IndexEditorTcpServer(String name, int numThreads, int threadPriority, ServerSocket serverSocket) {
            super(name, numThreads, threadPriority, serverSocket);
        }

        protected ProtocolHandler newProtocolHandler() {
            return new IndexEditorProtocolhandler(this);
        }

        public int getConfigMaxIdleMilliSeconds() {
            return 0;
        }
    }

    private static class IndexEditorTcpThread
    implements Runnable {
        private IndexEditorTcpThread() {
        }

        public void run() {
            sTcpServer.run();
        }
    }

    public static class TwoTerms
    implements Comparable {
        public int mCount;
        public String s1;
        public String s2;

        public int compareTo(Object o) {
            TwoTerms other = (TwoTerms)o;
            if (other.mCount == this.mCount) {
                if (other.s1.equals(this.s1)) {
                    return -other.s2.compareTo(this.s2);
                }
                return -other.s1.compareTo(this.s1);
            }
            return -(other.mCount - this.mCount);
        }
    }

    public class MultiQueryRunner
    implements QueryRunner {
        long[] mMailboxId;

        MultiQueryRunner(long[] mailboxId) throws ServiceException {
            this.mMailboxId = new long[mailboxId.length];
            for (int i = 0; i < mailboxId.length; ++i) {
                this.mMailboxId[i] = mailboxId[i];
            }
        }

        MultiQueryRunner(ArrayList mailboxId) throws ServiceException {
            this.mMailboxId = new long[mailboxId.size()];
            for (int i = 0; i < mailboxId.size(); ++i) {
                this.mMailboxId[i] = (Long)mailboxId.get(i);
            }
        }

        public ZimbraQueryResults runQuery(String qstr, byte[] types, SortBy sortBy) throws IOException, MailServiceException, ParseException, ServiceException {
            ZimbraQueryResults[] res = new ZimbraQueryResults[this.mMailboxId.length];
            for (int i = 0; i < this.mMailboxId.length; ++i) {
                Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.mMailboxId[i]);
                SearchParams params = new SearchParams();
                params.setQueryStr(qstr);
                params.setTypes(types);
                params.setSortBy(sortBy);
                params.setOffset(0);
                params.setLimit(100);
                params.setPrefetch(true);
                params.setMode(Mailbox.SearchResultMode.NORMAL);
                ZimbraQuery zq = new ZimbraQuery(null, SoapProtocol.Soap12, mbox, params);
                res[i] = zq.execute();
            }
            return HitIdGrouper.Create(new MultiQueryResults(res, sortBy), sortBy);
        }
    }

    public class SingleQueryRunner
    implements QueryRunner {
        long mMailboxId;

        SingleQueryRunner(long mailboxId) throws ServiceException {
            this.mMailboxId = mailboxId;
        }

        public ZimbraQueryResults runQuery(String qstr, byte[] types, SortBy sortBy) throws IOException, MailServiceException, ParseException, ServiceException {
            Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.mMailboxId);
            SearchParams params = new SearchParams();
            params.setQueryStr(qstr);
            params.setTypes(types);
            params.setSortBy(sortBy);
            params.setOffset(0);
            params.setLimit(100);
            params.setPrefetch(true);
            params.setMode(Mailbox.SearchResultMode.NORMAL);
            ZimbraQuery zq = new ZimbraQuery(null, SoapProtocol.Soap12, mbox, params);
            return zq.execute();
        }
    }

    public static interface QueryRunner {
        public ZimbraQueryResults runQuery(String var1, byte[] var2, SortBy var3) throws IOException, ParseException, MailServiceException, ServiceException;
    }
}

