/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.BufferingResultsGrouper;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import java.util.Collections;

public class HitIdGrouper
extends BufferingResultsGrouper {
    private SortBy mSortOrder;

    public static ZimbraQueryResults Create(ZimbraQueryResults hits, SortBy sortOrder) {
        if (sortOrder == SortBy.NONE) {
            return hits;
        }
        return new HitIdGrouper(hits, sortOrder);
    }

    private HitIdGrouper(ZimbraQueryResults hits, SortBy sortOrder) {
        super(hits);
        this.mSortOrder = sortOrder;
    }

    public boolean hasNext() throws ServiceException {
        return this.mBufferedHit.size() > 0 || this.mHits.hasNext();
    }

    protected boolean bufferHits() throws ServiceException {
        if (this.mBufferedHit.size() > 0) {
            return true;
        }
        if (!this.mHits.hasNext()) {
            return false;
        }
        ZimbraHit curGroupHit = this.mHits.getNext();
        this.mBufferedHit.add(curGroupHit);
        while (this.mHits.hasNext() && curGroupHit.compareBySortField(this.mSortOrder, this.mHits.peekNext()) == 0) {
            if (ZimbraLog.index_search.isDebugEnabled()) {
                ZimbraLog.index_search.debug("HitIdGrouper buffering " + this.mHits.peekNext());
            }
            this.mBufferedHit.add(this.mHits.getNext());
        }
        Collections.sort(this.mBufferedHit, ZimbraHit.getSortAndIdComparator(this.mSortOrder));
        return true;
    }
}

