/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

public class Fragment {
    private static final int MAX_FRAGMENT_LENGTH = 150;
    private static final String CALENDAR_SEPARATOR = "*~*~*~*~*~*~*~*~*~*";
    private static final String STOPWORD_REPLY_1 = "--Original Message--";
    private static final String STOPWORD_REPLY_2 = "-- Original Message --";
    private static final String STOPWORD_REPLY_3 = "________________________________";
    private static final String STOPWORD_REPLY_4 = "--Original Invite--";
    private static final String STOPWORD_FORWARD_1 = "--Forwarded Message--";
    private static final String STOPWORD_FORWARD_2 = "-- Forwarded Message --";

    private static boolean isHeader(String text, boolean allowSpaces) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ':') {
                return i != 0;
            }
            if (c == '\r' || c == '\n') {
                return false;
            }
            if (allowSpaces || !Character.isWhitespace(c)) continue;
            return false;
        }
        return false;
    }

    private static String skipFragmentHeader(String fragment, boolean calendar) {
        String backup = fragment;
        String checkpoint = fragment;
        int returnIndex = -1;
        while (fragment.length() > 0) {
            char first = fragment.charAt(0);
            fragment = fragment.trim();
            if (first == '\r' || first == '\n') {
                checkpoint = fragment;
            }
            returnIndex = fragment.indexOf(10);
            if (!Fragment.isHeader(fragment, calendar)) {
                String line;
                if (!calendar) break;
                String string = line = returnIndex == -1 ? fragment : fragment.substring(0, returnIndex).trim();
                if (!line.equals(CALENDAR_SEPARATOR)) break;
                checkpoint = returnIndex == -1 ? "" : fragment.substring(returnIndex + 1).trim();
                break;
            }
            if (returnIndex == -1) {
                checkpoint = "";
                break;
            }
            fragment = fragment.substring(returnIndex + 1);
        }
        return checkpoint.length() > 0 ? checkpoint : backup;
    }

    private static String skipQuotedText(String fragment, boolean twoLineHeader) {
        String backup = fragment;
        int returnIndex = -1;
        int headerLines = twoLineHeader ? 2 : 1;
        for (int i = 0; i < headerLines && !fragment.startsWith(">") && !fragment.startsWith("|") && (returnIndex = fragment.indexOf(10, returnIndex + 1)) != -1; ++i) {
            String firstLine = fragment.substring(0, returnIndex).trim();
            if (!firstLine.endsWith(":")) continue;
            if (!(fragment = fragment.substring(returnIndex + 1).trim()).startsWith("[") || (returnIndex = fragment.indexOf(10)) == -1 || !fragment.substring(0, returnIndex).trim().endsWith("]")) break;
            fragment = fragment.substring(returnIndex + 1).trim();
            break;
        }
        if (fragment.startsWith(">")) {
            while ((fragment = (returnIndex = fragment.indexOf(10)) == -1 ? "" : fragment.substring(returnIndex + 1).trim()).startsWith(">")) {
            }
        } else if (fragment.startsWith("|")) {
            while ((fragment = (returnIndex = fragment.indexOf(10)) == -1 ? "" : fragment.substring(returnIndex + 1).trim()).startsWith("|")) {
            }
        } else if (fragment != backup) {
            fragment = backup;
        }
        return fragment;
    }

    private static String compressLine(String line) {
        StringBuffer sb = new StringBuffer();
        char last = ' ';
        char lastButOne = '\u0000';
        for (int i = 0; i < line.length() && sb.length() <= 155; ++i) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c)) {
                c = ' ';
            }
            if (c == ' ' && last == c || c < ' ' || c == '\ufffe' || c == '\uffff' || c > '\ud7ff' && c < '\ue000' || c == '\ufffc' || (c == '=' || c == '-') && last == c && lastButOne == c) continue;
            lastButOne = last;
            last = c;
            sb.append(last);
        }
        return sb.toString().trim();
    }

    public static String getFragment(String content, boolean hasCalendar) {
        Source item = Source.MESSAGE;
        if (hasCalendar) {
            item = Source.APPOINTMENT;
        }
        return Fragment.getFragment(content, item);
    }

    public static String getFragment(String content, Source item) {
        String result;
        String remainder;
        String backup = remainder = content.trim();
        StringBuffer fragment = new StringBuffer();
        if (item == Source.NOTEBOOK) {
            result = content;
        } else {
            if (item == Source.APPOINTMENT) {
                remainder = Fragment.skipFragmentHeader(remainder, true);
            }
            remainder = Fragment.skipQuotedText(remainder, true);
            boolean elided = false;
            boolean mainMessage = true;
            while (fragment.length() <= 150) {
                String trimmed;
                int returnIndex;
                if (remainder.startsWith(">") || remainder.startsWith("|")) {
                    if (mainMessage) {
                        remainder = Fragment.skipQuotedText(remainder, false);
                        elided = true;
                    } else {
                        remainder = remainder.substring(1).trim();
                    }
                }
                if (remainder.equals("") || (returnIndex = remainder.indexOf(10)) == 3 && remainder.startsWith("-- ") || returnIndex == 4 && remainder.startsWith("-- \r")) break;
                String line = (returnIndex == -1 ? remainder : remainder.substring(0, returnIndex)).trim();
                if (mainMessage && line.endsWith(":") && returnIndex != -1 && (trimmed = Fragment.skipQuotedText(remainder, false)) != remainder) {
                    remainder = trimmed;
                    elided = true;
                    continue;
                }
                if ((line = Fragment.compressLine(line)).equalsIgnoreCase(STOPWORD_REPLY_1) || line.equalsIgnoreCase(STOPWORD_REPLY_2) || line.equalsIgnoreCase(STOPWORD_REPLY_3) || line.equalsIgnoreCase(STOPWORD_REPLY_4) || line.equalsIgnoreCase(STOPWORD_FORWARD_1) || line.equalsIgnoreCase(STOPWORD_FORWARD_2)) {
                    if (fragment.length() != 0 || returnIndex == -1) break;
                    fragment.append(line);
                    remainder = Fragment.skipFragmentHeader(remainder.substring(returnIndex).trim(), false);
                    mainMessage = false;
                    elided = false;
                    continue;
                }
                if (fragment.length() != 0) {
                    if (elided) {
                        fragment.append(" ...");
                    }
                    fragment.append(' ');
                }
                fragment.append(line);
                remainder = returnIndex == -1 ? "" : remainder.substring(returnIndex).trim();
                elided = false;
            }
            result = fragment.toString();
        }
        if (result.equals("")) {
            result = Fragment.compressLine(backup);
        }
        boolean isTruncated = result.length() > 150;
        result = result.substring(0, isTruncated ? 150 : result.length());
        if (isTruncated) {
            int wspIndex = Math.max(result.lastIndexOf(10), result.lastIndexOf(32));
            if ((wspIndex = Math.max(wspIndex, result.lastIndexOf(9))) != -1) {
                result = result.substring(0, wspIndex).trim();
            }
            if (!result.endsWith(" ...")) {
                result = result.concat(" ...");
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Source {
        MESSAGE,
        APPOINTMENT,
        NOTEBOOK;

    }
}

