/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.ConversationHit;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.TaskHit;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.MailItem;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredQueryResults
implements ZimbraQueryResults {
    ZimbraQueryResults mResults;
    private boolean mFilterTagDeleted = false;
    private Set<TaskHit.Status> mAllowedTaskStatuses = null;

    FilteredQueryResults(ZimbraQueryResults other) {
        this.mResults = other;
    }

    void setFilterTagDeleted(boolean truthiness) {
        this.mFilterTagDeleted = truthiness;
    }

    void setAllowedTaskStatuses(Set<TaskHit.Status> allowed) {
        this.mAllowedTaskStatuses = allowed;
    }

    @Override
    public void doneWithSearchResults() throws ServiceException {
        this.mResults.doneWithSearchResults();
    }

    @Override
    public int estimateResultSize() throws ServiceException {
        return this.mResults.estimateResultSize();
    }

    @Override
    public ZimbraHit getFirstHit() throws ServiceException {
        this.resetIterator();
        return this.getNext();
    }

    @Override
    public List<QueryInfo> getResultInfo() {
        return this.mResults.getResultInfo();
    }

    @Override
    public SortBy getSortBy() {
        return this.mResults.getSortBy();
    }

    @Override
    public void resetIterator() throws ServiceException {
        this.mResults.resetIterator();
    }

    @Override
    public ZimbraHit skipToHit(int hitNo) throws ServiceException {
        this.resetIterator();
        for (int i = 0; i < hitNo; ++i) {
            if (!this.hasNext()) {
                return null;
            }
            this.getNext();
        }
        return this.getNext();
    }

    @Override
    public ZimbraHit getNext() throws ServiceException {
        ZimbraHit toRet = this.peekNext();
        if (toRet != null) {
            this.mResults.getNext();
        }
        return toRet;
    }

    @Override
    public boolean hasNext() throws ServiceException {
        return this.peekNext() != null;
    }

    private boolean shouldFilter(ZimbraHit hit) throws ServiceException {
        if (this.mAllowedTaskStatuses != null && hit instanceof TaskHit && !this.mAllowedTaskStatuses.contains((Object)((TaskHit)hit).getStatus())) {
            return true;
        }
        if (this.mFilterTagDeleted && hit.isLocal()) {
            MailItem item = hit.getMailItem();
            if (item == null) {
                System.out.println("NULL!");
            }
            if ((item.getFlagBitmask() & Flag.BITMASK_DELETED) != 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ZimbraHit peekNext() throws ServiceException {
        ZimbraHit cur = this.mResults.peekNext();
        while (cur != null) {
            boolean filterThisHit = false;
            if (cur instanceof ConversationHit) {
                MessageHit mh;
                ConversationHit ch = (ConversationHit)cur;
                Iterator<MessageHit> i$ = ch.getMessageHits().iterator();
                while (i$.hasNext() && (filterThisHit = this.shouldFilter(mh = i$.next()))) {
                }
            } else {
                filterThisHit = this.shouldFilter(cur);
            }
            if (!filterThisHit) {
                return cur;
            }
            this.mResults.getNext();
            cur = this.mResults.peekNext();
        }
        return null;
    }
}

