/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;

public class DocumentHit
extends ZimbraHit {
    protected Document mDocument;
    protected int mMessageId;
    protected org.apache.lucene.document.Document mDoc;

    protected DocumentHit(ZimbraQueryResultsImpl results, Mailbox mbx, float score, int mailItemId, MailItem.UnderlyingData underlyingData, org.apache.lucene.document.Document d) throws ServiceException {
        this(results, mbx, score, mailItemId, underlyingData);
        this.mDoc = d;
    }

    protected DocumentHit(ZimbraQueryResultsImpl results, Mailbox mbx, float score, int mailItemId, MailItem.UnderlyingData underlyingData) throws ServiceException {
        this(results, mbx, score);
        this.mMessageId = mailItemId;
        if (underlyingData != null) {
            MailItem item = mbx.getItemFromUnderlyingData(underlyingData);
            assert (item instanceof Document);
            this.mDocument = (Document)item;
        }
    }

    protected DocumentHit(ZimbraQueryResultsImpl results, Mailbox mbx, float score) {
        super(results, mbx, score);
    }

    public long getDate() {
        return this.mDocument.getDate();
    }

    public long getSize() {
        return this.mDocument.getSize();
    }

    public int getConversationId() {
        return 0;
    }

    public int getItemId() {
        return this.mMessageId;
    }

    public byte getItemType() {
        return this.mDocument.getType();
    }

    void setItem(MailItem item) {
        if (item instanceof Document) {
            this.mDocument = (Document)item;
        }
    }

    boolean itemIsLoaded() {
        return this.mDocument != null;
    }

    public String getSubject() {
        return this.mDocument.getName();
    }

    public String getName() {
        return this.mDocument.getName();
    }

    public MailItem getMailItem() {
        return this.getDocument();
    }

    public Document getDocument() {
        return this.mDocument;
    }

    public int getVersion() {
        String verStr;
        if (this.mDoc != null && (verStr = this.mDoc.get("l.version")) != null) {
            return Integer.parseInt(verStr);
        }
        return this.mDocument.getVersion();
    }
}

