/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.db.DbSearchConstraints;
import com.zimbra.cs.db.DbSearchConstraintsNode;
import com.zimbra.cs.index.DbAndNode;
import com.zimbra.cs.index.IConstraints;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbOrNode
implements IConstraints {
    protected List<IConstraints> mSubNodes = new ArrayList<IConstraints>();

    DbOrNode() {
    }

    @Override
    public DbSearchConstraintsNode.NodeType getNodeType() {
        return DbSearchConstraintsNode.NodeType.OR;
    }

    @Override
    public Iterable<? extends DbSearchConstraintsNode> getSubNodes() {
        return this.mSubNodes;
    }

    @Override
    public DbSearchConstraints getSearchConstraints() {
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DbOrNode toRet = (DbOrNode)super.clone();
        toRet.mSubNodes = new ArrayList<IConstraints>();
        for (IConstraints node : this.mSubNodes) {
            toRet.mSubNodes.add((IConstraints)node.clone());
        }
        return toRet;
    }

    @Override
    public IConstraints andIConstraints(IConstraints other) {
        if (other.getNodeType() == DbSearchConstraintsNode.NodeType.AND) {
            return other.andIConstraints(this);
        }
        IConstraints top = new DbAndNode();
        top = top.andIConstraints(this);
        top = top.andIConstraints(other);
        return top;
    }

    @Override
    public IConstraints orIConstraints(IConstraints other) {
        if (other.getNodeType() == DbSearchConstraintsNode.NodeType.OR) {
            for (IConstraints n : ((DbOrNode)other).mSubNodes) {
                this.mSubNodes.add(n);
            }
        } else {
            this.mSubNodes.add(other);
        }
        return this;
    }

    @Override
    public void ensureSpamTrashSetting(Mailbox mbox, List<Folder> excludeFolders) throws ServiceException {
        for (IConstraints n : this.mSubNodes) {
            n.ensureSpamTrashSetting(mbox, excludeFolders);
        }
    }

    @Override
    public boolean hasSpamTrashSetting() {
        for (IConstraints n : this.mSubNodes) {
            if (n.hasSpamTrashSetting()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forceHasSpamTrashSetting() {
        for (IConstraints n : this.mSubNodes) {
            if (n.hasSpamTrashSetting()) continue;
            n.forceHasSpamTrashSetting();
        }
    }

    @Override
    public boolean hasNoResults() {
        for (IConstraints n : this.mSubNodes) {
            if (n.hasNoResults()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean tryDbFirst(Mailbox mbox) {
        return false;
    }

    @Override
    public void setTypes(Set<Byte> types) {
        for (IConstraints n : this.mSubNodes) {
            n.setTypes(types);
        }
    }

    @Override
    public String toQueryString() {
        StringBuilder ret = new StringBuilder("(");
        boolean atFirst = true;
        for (IConstraints n : this.mSubNodes) {
            if (!atFirst) {
                ret.append(" OR ");
            }
            ret.append(n.toQueryString());
            atFirst = false;
        }
        ret.append(')');
        return ret.toString();
    }

    public String toString() {
        StringBuilder toRet = new StringBuilder("OR(");
        for (IConstraints n : this.mSubNodes) {
            toRet.append(n.toString()).append(' ');
        }
        return toRet.append(')').toString();
    }
}

