/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.DbSearchConstraints;
import com.zimbra.cs.db.DbSearchConstraintsNode;
import com.zimbra.cs.index.DbOrNode;
import com.zimbra.cs.index.IConstraints;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.service.util.ItemId;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbLeafNode
extends DbSearchConstraints
implements IConstraints {
    protected boolean mHasSpamTrashSetting = false;

    DbLeafNode() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DbLeafNode toRet = (DbLeafNode)super.clone();
        assert (toRet.folders != this.folders);
        return toRet;
    }

    @Override
    public void ensureSpamTrashSetting(Mailbox mbox, List<Folder> trashSpamFolders) {
        if (!this.mHasSpamTrashSetting) {
            for (Folder f : trashSpamFolders) {
                this.excludeFolders.add(f);
            }
            this.mHasSpamTrashSetting = true;
        }
    }

    @Override
    public IConstraints andIConstraints(IConstraints other) {
        switch (other.getNodeType()) {
            case AND: {
                return other.andIConstraints(this);
            }
            case OR: {
                return other.andIConstraints(this);
            }
            case LEAF: {
                if (other.hasSpamTrashSetting()) {
                    this.forceHasSpamTrashSetting();
                }
                if (other.hasNoResults()) {
                    this.noResults = true;
                }
                this.andConstraints((DbLeafNode)other);
                return this;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public IConstraints orIConstraints(IConstraints other) {
        if (other.getNodeType() == DbSearchConstraintsNode.NodeType.OR) {
            return other.orIConstraints(this);
        }
        IConstraints top = new DbOrNode();
        top = top.orIConstraints(this);
        top = top.orIConstraints(other);
        return top;
    }

    @Override
    public boolean hasSpamTrashSetting() {
        return this.mHasSpamTrashSetting;
    }

    @Override
    public void forceHasSpamTrashSetting() {
        this.mHasSpamTrashSetting = true;
    }

    @Override
    public boolean hasNoResults() {
        return this.noResults;
    }

    @Override
    public boolean tryDbFirst(Mailbox mbox) throws ServiceException {
        return this.convId != 0 || this.tags != null && this.tags.contains(mbox.getFlagById(-10));
    }

    @Override
    public void setTypes(Set<Byte> _types) {
        this.types = _types;
    }

    @Override
    public String toQueryString() {
        if (this.noResults) {
            return "-is:anywhere";
        }
        return this.toString();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    void addItemIdClause(Integer itemId, boolean truth) {
        if (truth) {
            if (!(this.itemIds.contains(itemId) || this.prohibitedItemIds != null && this.prohibitedItemIds.contains(itemId))) {
                this.itemIds.add(itemId);
            }
        } else if (!this.prohibitedItemIds.contains(itemId)) {
            if (this.itemIds != null && this.itemIds.contains(itemId)) {
                this.itemIds.remove(itemId);
            }
            this.prohibitedItemIds.add(itemId);
        }
    }

    void addRemoteItemIdClause(ItemId itemId, boolean truth) {
        if (truth) {
            if (!(this.remoteItemIds.contains(itemId) || this.prohibitedRemoteItemIds != null && this.prohibitedRemoteItemIds.contains(itemId))) {
                this.remoteItemIds.add(itemId);
            }
        } else if (!this.prohibitedRemoteItemIds.contains(itemId)) {
            if (this.remoteItemIds != null && this.remoteItemIds.contains(itemId)) {
                this.remoteItemIds.remove(itemId);
            }
            this.prohibitedRemoteItemIds.add(itemId);
        }
    }

    void addDateClause(long lowest, boolean lowestEqual, long highest, boolean highestEqual, boolean truth) {
        DbSearchConstraints.NumericRange intv = new DbSearchConstraints.NumericRange();
        intv.lowest = lowest;
        intv.lowestEqual = lowestEqual;
        intv.highest = highest;
        intv.highestEqual = highestEqual;
        intv.negated = !truth;
        this.dates.add(intv);
    }

    void addCalStartDateClause(long lowest, boolean lowestEqual, long highest, boolean highestEqual, boolean truth) {
        DbSearchConstraints.NumericRange intv = new DbSearchConstraints.NumericRange();
        intv.lowest = lowest;
        intv.lowestEqual = lowestEqual;
        intv.highest = highest;
        intv.highestEqual = highestEqual;
        intv.negated = !truth;
        this.calStartDates.add(intv);
    }

    void addCalEndDateClause(long lowest, boolean lowestEqual, long highest, boolean highestEqual, boolean truth) {
        DbSearchConstraints.NumericRange intv = new DbSearchConstraints.NumericRange();
        intv.lowest = lowest;
        intv.lowestEqual = lowestEqual;
        intv.highest = highest;
        intv.highestEqual = highestEqual;
        intv.negated = !truth;
        this.calEndDates.add(intv);
    }

    void addModSeqClause(long lowest, boolean lowestEqual, long highest, boolean highestEqual, boolean truth) {
        DbSearchConstraints.NumericRange intv = new DbSearchConstraints.NumericRange();
        intv.lowest = lowest;
        intv.lowestEqual = lowestEqual;
        intv.highest = highest;
        intv.highestEqual = highestEqual;
        intv.negated = !truth;
        this.modified.add(intv);
    }

    void addConvCountClause(long lowest, boolean lowestEqual, long highest, boolean highestEqual, boolean truth) {
        DbSearchConstraints.NumericRange intv = new DbSearchConstraints.NumericRange();
        intv.lowest = lowest;
        intv.lowestEqual = lowestEqual;
        intv.highest = highest;
        intv.highestEqual = highestEqual;
        intv.negated = !truth;
        this.convCounts.add(intv);
    }

    void addSizeClause(long lowestSize, long highestSize, boolean truth) {
        DbSearchConstraints.NumericRange intv = new DbSearchConstraints.NumericRange();
        intv.lowest = lowestSize;
        intv.highest = highestSize;
        intv.negated = !truth;
        this.sizes.add(intv);
    }

    void addSubjectRelClause(String lowest, boolean lowestEqual, String highest, boolean highestEqual, boolean truth) {
        DbSearchConstraints.StringRange intv = new DbSearchConstraints.StringRange();
        intv.lowest = lowest;
        intv.lowestEqual = lowestEqual;
        intv.highest = highest;
        intv.highestEqual = highestEqual;
        intv.negated = !truth;
        this.subjectRanges.add(intv);
    }

    void addSenderRelClause(String lowest, boolean lowestEqual, String highest, boolean highestEqual, boolean truth) {
        DbSearchConstraints.StringRange intv = new DbSearchConstraints.StringRange();
        intv.lowest = lowest;
        intv.lowestEqual = lowestEqual;
        intv.highest = highest;
        intv.highestEqual = highestEqual;
        intv.negated = !truth;
        this.senderRanges.add(intv);
    }

    void addConvId(int cid, boolean truth) {
        if (truth) {
            if (this.prohibitedConvIds.contains(cid)) {
                this.noResults = true;
            }
            if (this.convId == 0) {
                this.convId = cid;
            } else {
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    ZimbraLog.index_search.debug("Query requested two conflicting convIDs, this is now a no-results-query");
                }
                this.convId = Integer.MAX_VALUE;
                this.noResults = true;
            }
        } else {
            if (this.convId == cid) {
                this.noResults = true;
            }
            this.prohibitedConvIds.add(cid);
        }
    }

    void addRemoteConvId(ItemId cid, boolean truth) {
        if (truth) {
            if (this.prohibitedRemoteConvIds.contains(cid)) {
                this.noResults = true;
            }
            if (this.remoteConvId == null) {
                this.remoteConvId = cid;
            } else {
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    ZimbraLog.index_search.debug("Query requested two conflicting Remote convIDs, this is now a no-results-query");
                }
                this.remoteConvId = new ItemId(cid.getAccountId(), Integer.MAX_VALUE);
                this.noResults = true;
            }
        } else {
            if (this.remoteConvId.equals(cid)) {
                this.noResults = true;
            }
            this.prohibitedRemoteConvIds.add(cid);
        }
    }

    void addInRemoteFolderClause(ItemId id, String subfolderPath, boolean includeSubfolders, boolean truth) {
        if (truth) {
            if (this.remoteFolders.size() > 0 && !this.remoteFolders.contains(id) || this.excludeRemoteFolders.contains(id)) {
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    ZimbraLog.index_search.debug("AND of conflicting remote folders, no-results-query");
                }
                this.noResults = true;
            }
            this.remoteFolders.clear();
            this.remoteFolders.add(new DbSearchConstraints.RemoteFolderDescriptor(id, subfolderPath, includeSubfolders));
            this.forceHasSpamTrashSetting();
        } else {
            if (this.remoteFolders.contains(id)) {
                this.remoteFolders.remove(id);
                if (this.remoteFolders.size() == 0) {
                    if (ZimbraLog.index_search.isDebugEnabled()) {
                        ZimbraLog.index_search.debug("AND of conflicting remote folders, no-results-query");
                    }
                    this.noResults = true;
                }
            }
            this.excludeRemoteFolders.add(new DbSearchConstraints.RemoteFolderDescriptor(id, subfolderPath, includeSubfolders));
        }
    }

    void addInClause(Folder folder, boolean truth) {
        if (truth) {
            if (this.folders.size() > 0 && !this.folders.contains(folder) || this.excludeFolders.contains(folder)) {
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    ZimbraLog.index_search.debug("AND of conflicting folders, no-results-query");
                }
                this.noResults = true;
            }
            this.folders.clear();
            this.folders.add(folder);
            this.forceHasSpamTrashSetting();
        } else {
            if (this.folders.contains(folder)) {
                this.folders.remove(folder);
                if (this.folders.size() == 0) {
                    if (ZimbraLog.index_search.isDebugEnabled()) {
                        ZimbraLog.index_search.debug("AND of conflicting folders, no-results-query");
                    }
                    this.noResults = true;
                }
            }
            this.excludeFolders.add(folder);
            int fid = folder.getId();
            if (fid == 3 || fid == 4) {
                this.forceHasSpamTrashSetting();
            }
        }
    }

    void addAnyFolderClause(boolean truth) {
        this.forceHasSpamTrashSetting();
        if (!truth) {
            if (ZimbraLog.index_search.isDebugEnabled()) {
                ZimbraLog.index_search.debug("addAnyFolderClause(FALSE) called -- changing to no-results-query.");
            }
            this.noResults = true;
        }
    }

    void addTagClause(Tag tag, boolean truth) {
        if (ZimbraLog.index_search.isDebugEnabled()) {
            ZimbraLog.index_search.debug("AddTagClause(" + tag + "," + truth + ")");
        }
        if (truth) {
            if (this.excludeTags != null && this.excludeTags.contains(tag)) {
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    ZimbraLog.index_search.debug("TAG and NOT TAG = no results");
                }
                this.noResults = true;
            }
            if (this.tags == null) {
                this.tags = new HashSet();
            }
            this.tags.add(tag);
        } else {
            if (this.tags != null && this.tags.contains(tag)) {
                if (ZimbraLog.index_search.isDebugEnabled()) {
                    ZimbraLog.index_search.debug("TAG and NOT TAG = no results");
                }
                this.noResults = true;
            }
            if (this.excludeTags == null) {
                this.excludeTags = new HashSet();
            }
            this.excludeTags.add(tag);
        }
    }
}

