/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.db.DbSearchConstraints;
import com.zimbra.cs.db.DbSearchConstraintsNode;
import com.zimbra.cs.index.DbLeafNode;
import com.zimbra.cs.index.DbOrNode;
import com.zimbra.cs.index.IConstraints;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbAndNode
implements IConstraints {
    protected List<IConstraints> mSubNodes = new ArrayList<IConstraints>();

    DbAndNode() {
    }

    @Override
    public DbSearchConstraintsNode.NodeType getNodeType() {
        return DbSearchConstraintsNode.NodeType.AND;
    }

    @Override
    public Iterable<? extends DbSearchConstraintsNode> getSubNodes() {
        return this.mSubNodes;
    }

    @Override
    public DbSearchConstraints getSearchConstraints() {
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DbAndNode toRet = (DbAndNode)super.clone();
        toRet.mSubNodes = new ArrayList<IConstraints>();
        for (IConstraints node : this.mSubNodes) {
            toRet.mSubNodes.add((IConstraints)node.clone());
        }
        return toRet;
    }

    DbLeafNode getLeafChild() {
        for (IConstraints n : this.mSubNodes) {
            if (n.getNodeType() != DbSearchConstraintsNode.NodeType.LEAF) continue;
            return (DbLeafNode)n;
        }
        DbLeafNode c = new DbLeafNode();
        this.mSubNodes.add(c);
        return c;
    }

    @Override
    public IConstraints andIConstraints(IConstraints other) {
        switch (other.getNodeType()) {
            case LEAF: {
                DbLeafNode otherLeaf = (DbLeafNode)other;
                IConstraints ret = this.getLeafChild().andIConstraints(otherLeaf);
                assert (this.mSubNodes.contains(ret));
                break;
            }
            case AND: {
                for (IConstraints n : ((DbAndNode)other).mSubNodes) {
                    if (n.getNodeType() == DbSearchConstraintsNode.NodeType.LEAF) {
                        IConstraints c = this.getLeafChild().andIConstraints((DbLeafNode)n);
                        assert (c == this);
                        continue;
                    }
                    this.mSubNodes.add(n);
                }
                break;
            }
            case OR: {
                this.mSubNodes.add(other);
            }
        }
        return this;
    }

    @Override
    public IConstraints orIConstraints(IConstraints other) {
        if (other.getNodeType() == DbSearchConstraintsNode.NodeType.OR) {
            return other.orIConstraints(other);
        }
        IConstraints top = new DbOrNode();
        top = top.orIConstraints(this);
        top = top.orIConstraints(other);
        return top;
    }

    @Override
    public void ensureSpamTrashSetting(Mailbox mbox, List<Folder> excludeFolders) throws ServiceException {
        DbLeafNode c = this.getLeafChild();
        c.ensureSpamTrashSetting(mbox, excludeFolders);
    }

    @Override
    public boolean hasSpamTrashSetting() {
        for (IConstraints n : this.mSubNodes) {
            if (!n.hasSpamTrashSetting()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forceHasSpamTrashSetting() {
        for (IConstraints n : this.mSubNodes) {
            if (n.hasSpamTrashSetting()) continue;
            n.forceHasSpamTrashSetting();
        }
    }

    @Override
    public boolean hasNoResults() {
        for (IConstraints n : this.mSubNodes) {
            if (!n.hasNoResults()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryDbFirst(Mailbox mbox) {
        return false;
    }

    @Override
    public void setTypes(Set<Byte> types) {
        for (IConstraints n : this.mSubNodes) {
            n.setTypes(types);
        }
    }

    @Override
    public String toQueryString() {
        StringBuilder ret = new StringBuilder("(");
        boolean atFirst = true;
        for (IConstraints n : this.mSubNodes) {
            if (!atFirst) {
                ret.append(" AND ");
            }
            ret.append(n.toQueryString());
            atFirst = false;
        }
        ret.append(')');
        return ret.toString();
    }

    public String toString() {
        StringBuilder toRet = new StringBuilder("AND(");
        for (IConstraints n : this.mSubNodes) {
            toRet.append(n.toString()).append(' ');
        }
        return toRet.append(')').toString();
    }
}

