/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbSearch;
import com.zimbra.cs.index.DbAndNode;
import com.zimbra.cs.index.DbLeafNode;
import com.zimbra.cs.index.IConstraints;
import com.zimbra.cs.index.MailboxIndex;
import com.zimbra.cs.index.NoResultsQueryOperation;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.QueryOperation;
import com.zimbra.cs.index.QueryTarget;
import com.zimbra.cs.index.QueryTargetSet;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.TextQueryOperation;
import com.zimbra.cs.index.UnionQueryOperation;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.SearchFolder;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.service.util.ItemId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBQueryOperation
extends QueryOperation {
    protected int mSizeEstimate = -1;
    protected int mCountDbResults = -1;
    protected IConstraints mConstraints = new DbLeafNode();
    protected int mCurHitsOffset = 0;
    protected int mOffset = 0;
    protected boolean mAllResultsQuery = true;
    protected boolean mIncludeIsLocalFolders = false;
    protected boolean mIncludeIsRemoteFolders = false;
    protected List<DbSearch.SearchResult> mDBHits;
    protected List<ZimbraHit> mNextHits = new ArrayList<ZimbraHit>();
    protected Iterator<DbSearch.SearchResult> mDBHitsIter;
    protected boolean atStart = true;
    protected int mHitsPerChunk = 100;
    protected static final int MAX_HITS_PER_CHUNK = 2000;
    protected boolean mEndOfHits = false;
    protected HashSet<Byte> mTypes = new HashSet();
    protected HashSet<Byte> mExcludeTypes = new HashSet();
    protected TextQueryOperation mLuceneOp = null;
    protected TextQueryOperation.TextResultsChunk mLuceneChunk = null;
    protected QueryTarget mQueryTarget = QueryTarget.UNSPECIFIED;
    private DbSearch.SearchResult.ExtraData mExtra = null;
    private QueryExecuteMode mExecuteMode = null;
    private LRUHashMap<ZimbraHit> mSeenHits = new LRUHashMap(2048, 100);
    List<QueryInfo> mQueryInfo = new ArrayList<QueryInfo>();

    protected DBQueryOperation() {
    }

    static DBQueryOperation Create() {
        return new DBQueryOperation();
    }

    static List<Folder> getTrashFolders(Mailbox mbox) throws ServiceException {
        return mbox.getFolderById(null, 3).getSubfolderHierarchy();
    }

    @Override
    QueryOperation expandLocalRemotePart(Mailbox mbox) throws ServiceException {
        if (this.mConstraints instanceof DbLeafNode) {
            boolean added = false;
            if (this.mIncludeIsLocalFolders) {
                this.mIncludeIsLocalFolders = false;
                DbLeafNode leaf = (DbLeafNode)this.mConstraints;
                for (Folder f : mbox.getFolderById(null, 11).getSubfolderHierarchy()) {
                    if (f instanceof Mountpoint || f instanceof SearchFolder) continue;
                    leaf.folders.add(f);
                    added = true;
                }
                if (!added) {
                    return new NoResultsQueryOperation();
                }
                return this;
            }
            if (this.mIncludeIsRemoteFolders) {
                UnionQueryOperation toRet = new UnionQueryOperation();
                this.mIncludeIsRemoteFolders = false;
                for (Folder f : mbox.getFolderById(null, 11).getSubfolderHierarchy()) {
                    Mountpoint mpt;
                    if (!(f instanceof Mountpoint) || (mpt = (Mountpoint)f).isLocal()) continue;
                    DBQueryOperation db = new DBQueryOperation();
                    db.addInRemoteFolderClause(mpt.getTarget(), "", true, true);
                    toRet.add(db);
                    added = true;
                }
                if (!added) {
                    return new NoResultsQueryOperation();
                }
                return toRet;
            }
            return this;
        }
        throw new IllegalStateException("expandLocalRemotePart must be called before optimize() is called");
    }

    @Override
    QueryOperation ensureSpamTrashSetting(Mailbox mbox, boolean includeTrash, boolean includeSpam) throws ServiceException {
        if (!this.hasSpamTrashSetting()) {
            ArrayList<Folder> exclude = new ArrayList<Folder>();
            if (!includeSpam) {
                Folder spam = mbox.getFolderById(null, 4);
                exclude.add(spam);
            }
            if (!includeTrash) {
                List<Folder> trashFolders = DBQueryOperation.getTrashFolders(mbox);
                for (Folder cur : trashFolders) {
                    exclude.add(cur);
                }
            }
            this.mConstraints.ensureSpamTrashSetting(mbox, exclude);
        }
        return this;
    }

    @Override
    boolean hasSpamTrashSetting() {
        if (this.mLuceneOp != null && this.mLuceneOp.hasSpamTrashSetting()) {
            return true;
        }
        if (this.mIncludeIsRemoteFolders) {
            return true;
        }
        return this.mConstraints.hasSpamTrashSetting();
    }

    @Override
    void forceHasSpamTrashSetting() {
        this.mConstraints.forceHasSpamTrashSetting();
    }

    @Override
    boolean hasNoResults() {
        return this.mConstraints.hasNoResults();
    }

    @Override
    boolean hasAllResults() {
        return this.mAllResultsQuery;
    }

    @Override
    QueryTargetSet getQueryTargets() {
        QueryTargetSet toRet = new QueryTargetSet(1);
        toRet.add(this.mQueryTarget);
        return toRet;
    }

    DbLeafNode topLevelAndedConstraint() {
        switch (this.mConstraints.getNodeType()) {
            case LEAF: {
                return (DbLeafNode)this.mConstraints;
            }
            case AND: {
                DbAndNode and = (DbAndNode)this.mConstraints;
                return and.getLeafChild();
            }
            case OR: {
                DbAndNode top = new DbAndNode();
                this.mConstraints = top.andIConstraints(this.mConstraints);
                return ((DbAndNode)this.mConstraints).getLeafChild();
            }
        }
        assert (false);
        return null;
    }

    void addTextOp(TextQueryOperation op) {
        assert (this.mLuceneOp == null);
        this.mAllResultsQuery = false;
        this.mLuceneOp = op;
    }

    void addItemIdClause(Mailbox mbox, ItemId itemId, boolean truth) {
        this.mAllResultsQuery = false;
        if (itemId.belongsTo(mbox)) {
            this.topLevelAndedConstraint().addItemIdClause(itemId.getId(), truth);
        } else {
            this.topLevelAndedConstraint().addRemoteItemIdClause(itemId, truth);
        }
    }

    void addDateClause(long lowestDate, boolean lowestEq, long highestDate, boolean highestEq, boolean truth) {
        this.mAllResultsQuery = false;
        this.topLevelAndedConstraint().addDateClause(lowestDate, lowestEq, highestDate, highestEq, truth);
    }

    void addCalStartDateClause(long lowestDate, boolean lowestEq, long highestDate, boolean highestEq, boolean truth) {
        this.mAllResultsQuery = false;
        this.topLevelAndedConstraint().addCalStartDateClause(lowestDate, lowestEq, highestDate, highestEq, truth);
    }

    void addCalEndDateClause(long lowestDate, boolean lowestEq, long highestDate, boolean highestEq, boolean truth) {
        this.mAllResultsQuery = false;
        this.topLevelAndedConstraint().addCalEndDateClause(lowestDate, lowestEq, highestDate, highestEq, truth);
    }

    void addConvCountClause(long lowest, boolean lowestEq, long highest, boolean highestEq, boolean truth) {
        this.mAllResultsQuery = false;
        this.topLevelAndedConstraint().addConvCountClause(lowest, lowestEq, highest, highestEq, truth);
    }

    void addModSeqClause(long lowest, boolean lowestEq, long highest, boolean highestEq, boolean truth) {
        this.mAllResultsQuery = false;
        this.topLevelAndedConstraint().addModSeqClause(lowest, lowestEq, highest, highestEq, truth);
    }

    void addSizeClause(long lowestSize, long highestSize, boolean truth) {
        this.mAllResultsQuery = false;
        this.topLevelAndedConstraint().addSizeClause(lowestSize, highestSize, truth);
    }

    void addRelativeSubject(String lowestSubj, boolean lowerEqual, String highestSubj, boolean higherEqual, boolean truth) {
        this.mAllResultsQuery = false;
        this.topLevelAndedConstraint().addSubjectRelClause(lowestSubj, lowerEqual, highestSubj, higherEqual, truth);
    }

    void addRelativeSender(String lowestSubj, boolean lowerEqual, String highestSubj, boolean higherEqual, boolean truth) {
        this.mAllResultsQuery = false;
        this.topLevelAndedConstraint().addSenderRelClause(lowestSubj, lowerEqual, highestSubj, higherEqual, truth);
    }

    void addConvId(Mailbox mbox, ItemId convId, boolean truth) {
        this.mAllResultsQuery = false;
        if (convId.belongsTo(mbox)) {
            if (!this.mQueryTarget.isCompatibleLocal()) {
                throw new IllegalArgumentException("Cannot addConvId w/ local target b/c DBQueryOperation already has a remote target");
            }
            this.mQueryTarget = QueryTarget.LOCAL;
            this.topLevelAndedConstraint().addConvId(convId.getId(), truth);
        } else {
            if (this.mQueryTarget != QueryTarget.UNSPECIFIED && !this.mQueryTarget.toString().equals(convId.getAccountId())) {
                throw new IllegalArgumentException("Cannot addConvId w/ remote target b/c DBQueryOperation already has an incompatible remote target");
            }
            this.mQueryTarget = new QueryTarget(convId.getAccountId());
            this.topLevelAndedConstraint().addRemoteConvId(convId, truth);
        }
    }

    void addIsLocalClause() {
        if (!this.mQueryTarget.isCompatibleLocal()) {
            throw new IllegalArgumentException("Cannot addIsLocalFolderClause b/c DBQueryOperation already has a remote target");
        }
        this.mQueryTarget = QueryTarget.LOCAL;
        this.mAllResultsQuery = false;
        this.mIncludeIsLocalFolders = true;
    }

    void addIsRemoteClause() {
        if (this.mQueryTarget == QueryTarget.LOCAL) {
            throw new IllegalArgumentException("Cannot addIsRemoteFolderClause b/c DBQueryOperation already has a local target");
        }
        if (this.mQueryTarget != QueryTarget.IS_REMOTE && this.mQueryTarget != QueryTarget.UNSPECIFIED) {
            throw new IllegalArgumentException("Cannot addIsRemoteFolderClause b/c DBQueryOperation already has a remote target: " + this.mQueryTarget);
        }
        this.mQueryTarget = QueryTarget.IS_REMOTE;
        this.mAllResultsQuery = false;
        this.mIncludeIsRemoteFolders = true;
    }

    void addInRemoteFolderClause(ItemId remoteFolderId, String subfolderPath, boolean includeSubfolders, boolean truth) {
        this.mAllResultsQuery = false;
        if (this.mQueryTarget != QueryTarget.UNSPECIFIED && !this.mQueryTarget.toString().equals(remoteFolderId.getAccountId())) {
            throw new IllegalArgumentException("Cannot addInClause b/c DBQueryOperation already has an incompatible remote target");
        }
        this.mQueryTarget = new QueryTarget(remoteFolderId.getAccountId());
        this.topLevelAndedConstraint().addInRemoteFolderClause(remoteFolderId, subfolderPath, includeSubfolders, truth);
    }

    void addInClause(Folder folder, boolean truth) {
        this.mAllResultsQuery = false;
        assert (!(folder instanceof Mountpoint) || ((Mountpoint)folder).isLocal());
        if (truth) {
            if (!this.mQueryTarget.isCompatibleLocal()) {
                throw new IllegalArgumentException("Cannot addInClause w/ local target b/c DBQueryOperation already has a remote target");
            }
            this.mQueryTarget = QueryTarget.LOCAL;
        }
        this.topLevelAndedConstraint().addInClause(folder, truth);
    }

    void addAnyFolderClause(boolean truth) {
        this.topLevelAndedConstraint().addAnyFolderClause(truth);
        if (!truth) {
            this.mAllResultsQuery = false;
        }
    }

    void addTagClause(Tag tag, boolean truth) {
        this.mAllResultsQuery = false;
        this.topLevelAndedConstraint().addTagClause(tag, truth);
    }

    void addTypeClause(byte type, boolean truth) {
        this.mAllResultsQuery = false;
        if (truth) {
            if (!this.mTypes.contains(type)) {
                this.mTypes.add(type);
            }
        } else if (!this.mExcludeTypes.contains(type)) {
            this.mExcludeTypes.add(type);
        }
    }

    @Override
    public void doneWithSearchResults() throws ServiceException {
        if (this.mLuceneOp != null) {
            this.mLuceneOp.doneWithSearchResults();
        }
    }

    @Override
    public void resetIterator() {
        if (this.mLuceneOp != null) {
            this.mLuceneOp.resetDocNum();
        }
        this.mNextHits.clear();
        this.mSeenHits.clear();
        if (!this.atStart) {
            this.mOffset = 0;
            this.mDBHitsIter = null;
            this.mCurHitsOffset = 0;
            this.mEndOfHits = false;
            this.atStart = true;
        } else if (this.mDBHits != null) {
            this.mDBHitsIter = this.mDBHits.iterator();
        }
    }

    @Override
    public ZimbraHit peekNext() throws ServiceException {
        ZimbraHit toRet = null;
        if (this.mNextHits.size() > 0) {
            toRet = this.mNextHits.get(0);
        } else {
            while (toRet == null) {
                if (!(this.mDBHitsIter != null && this.mDBHitsIter.hasNext() || this.mEndOfHits)) {
                    if (this.mExtra == null) {
                        this.mExtra = DbSearch.SearchResult.ExtraData.NONE;
                        switch (this.getResultsSet().getSearchMode()) {
                            case NORMAL: {
                                if (this.isTopLevelQueryOp()) {
                                    this.mExtra = DbSearch.SearchResult.ExtraData.MAIL_ITEM;
                                    break;
                                }
                                this.mExtra = DbSearch.SearchResult.ExtraData.NONE;
                                break;
                            }
                            case IMAP: {
                                this.mExtra = DbSearch.SearchResult.ExtraData.IMAP_MSG;
                                break;
                            }
                            case IDS: {
                                this.mExtra = DbSearch.SearchResult.ExtraData.NONE;
                                break;
                            }
                            case MODSEQ: {
                                this.mExtra = DbSearch.SearchResult.ExtraData.MODSEQ;
                                break;
                            }
                            case PARENT: {
                                this.mExtra = DbSearch.SearchResult.ExtraData.PARENT;
                            }
                        }
                    }
                    if (this.mExecuteMode == null) {
                        if (this.hasNoResults() || !this.prepareSearchConstraints()) {
                            this.mExecuteMode = QueryExecuteMode.NO_RESULTS;
                        } else if (this.mLuceneOp == null) {
                            this.mExecuteMode = QueryExecuteMode.NO_LUCENE;
                        } else if (this.shouldExecuteDbFirst()) {
                            this.mLuceneOp.clearFilterClause();
                            this.mExecuteMode = QueryExecuteMode.DB_FIRST;
                        } else {
                            this.mExecuteMode = QueryExecuteMode.LUCENE_FIRST;
                        }
                    }
                    this.getNextChunk();
                }
                if (this.mDBHitsIter != null && this.mDBHitsIter.hasNext()) {
                    DbSearch.SearchResult sr = this.mDBHitsIter.next();
                    List<Document> docs = null;
                    float score = 1.0f;
                    if (this.mLuceneChunk != null) {
                        TextQueryOperation.TextResultsChunk.ScoredLuceneHit sh = this.mLuceneChunk.getScoredHit(sr.indexId);
                        if (sh != null) {
                            docs = sh.mDocs;
                            score = sh.mScore;
                        } else {
                            ZimbraLog.index_search.info("Missing ScoredLuceneHit for sr.indexId=" + sr.indexId + " sr.id=" + sr.id + " type=" + sr.type + " part hits may be list");
                            docs = null;
                            score = 1.0f;
                        }
                    }
                    if (docs == null || !ZimbraQueryResultsImpl.shouldAddDuplicateHits(sr.type)) {
                        ZimbraHit toAdd = this.getResultsSet().getZimbraHit(this.getMailbox(), score, sr, null, this.mExtra);
                        if (toAdd != null && !this.mSeenHits.containsKey(toAdd)) {
                            this.mSeenHits.put(toAdd, toAdd);
                            this.mNextHits.add(toAdd);
                        }
                    } else {
                        for (Document doc : docs) {
                            ZimbraHit toAdd = this.getResultsSet().getZimbraHit(this.getMailbox(), score, sr, doc, this.mExtra);
                            if (toAdd == null || this.mSeenHits.containsKey(toAdd)) continue;
                            this.mSeenHits.put(toAdd, toAdd);
                            this.mNextHits.add(toAdd);
                        }
                    }
                    if (this.mNextHits.size() <= 0) continue;
                    toRet = this.mNextHits.get(0);
                    continue;
                }
                return null;
            }
        }
        return toRet;
    }

    @Override
    public ZimbraHit getNext() throws ServiceException {
        this.atStart = false;
        if (this.mNextHits.size() == 0) {
            this.peekNext();
        }
        if (this.mNextHits.size() == 0) {
            return null;
        }
        ZimbraHit toRet = this.mNextHits.remove(0);
        return toRet;
    }

    private byte[] convertTypesToDbQueryTypes(byte[] types) {
        int numUsed = 0;
        byte[] tmp = new byte[2 * types.length];
        block13: for (int i = 0; i < types.length; ++i) {
            if (types[i] == 0) {
                types = null;
                break;
            }
            switch (types[i]) {
                case 0: {
                    return null;
                }
                case 1: 
                case 2: 
                case 3: {
                    tmp[numUsed++] = -1;
                    continue block13;
                }
                case 4: {
                    tmp[numUsed++] = 5;
                    tmp[numUsed++] = 16;
                    continue block13;
                }
                case 5: {
                    tmp[numUsed++] = 5;
                    tmp[numUsed++] = 16;
                    continue block13;
                }
                case 6: {
                    tmp[numUsed++] = 6;
                    continue block13;
                }
                case 11: {
                    tmp[numUsed++] = 11;
                    continue block13;
                }
                case 15: {
                    tmp[numUsed++] = 15;
                    continue block13;
                }
                case 8: {
                    tmp[numUsed++] = 8;
                    continue block13;
                }
                case 9: {
                    tmp[numUsed++] = 9;
                    continue block13;
                }
                case 10: {
                    tmp[numUsed++] = 10;
                    continue block13;
                }
                case 14: {
                    tmp[numUsed++] = 14;
                }
            }
        }
        byte[] toRet = new byte[numUsed];
        System.arraycopy(tmp, 0, toRet, 0, numUsed);
        return toRet;
    }

    private Set<Byte> getDbQueryTypes() {
        byte[] defTypes = this.convertTypesToDbQueryTypes(this.getResultsSet().getTypes());
        HashSet<Byte> toRet = new HashSet<Byte>();
        byte[] arr$ = defTypes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Byte b = arr$[i$];
            toRet.add(b);
        }
        if (this.mTypes.size() > 0) {
            for (Byte b : this.mTypes) {
                if (toRet.contains(b)) continue;
                toRet.add(b);
            }
        }
        return toRet;
    }

    private boolean prepareSearchConstraints() {
        Set<Byte> types = this.getDbQueryTypes();
        if (types.size() == 0) {
            ZimbraLog.index_search.debug("NO RESULTS -- no known types requested");
            return false;
        }
        this.mConstraints.setTypes(types);
        return true;
    }

    private SortBy getSortOrder() {
        return this.getResultsSet().getSortBy();
    }

    private boolean shouldExecuteDbFirst() throws ServiceException {
        if (this.getResultsSet().getSortBy() == SortBy.SCORE_DESCENDING) {
            return false;
        }
        DbLeafNode toplevel = this.topLevelAndedConstraint();
        if (toplevel.convId > 0 || toplevel.itemIds.size() > 0) {
            return true;
        }
        if (this.mLuceneOp != null && this.mLuceneOp.shouldExecuteDbFirst()) {
            return true;
        }
        return this.mConstraints.tryDbFirst(this.getMailbox());
    }

    private void noLuceneGetNextChunk(DbPool.Connection conn, Mailbox mbox, SortBy sort) throws ServiceException {
        if (this.mParams.getEstimateSize() && this.mSizeEstimate == -1) {
            this.mSizeEstimate = DbSearch.countResults(conn, this.mConstraints, mbox);
        }
        DbSearch.search(this.mDBHits, conn, this.mConstraints, mbox, sort, this.mCurHitsOffset, this.mHitsPerChunk, this.mExtra);
        if (this.mDBHits.size() < this.mHitsPerChunk) {
            this.mEndOfHits = true;
        }
        this.mHitsPerChunk *= 2;
        if (this.mHitsPerChunk > 2000) {
            this.mHitsPerChunk = 2000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbFirstGetNextChunk(DbPool.Connection conn, Mailbox mbox, SortBy sort) throws ServiceException {
        long overallStart = 0L;
        if (ZimbraLog.index_search.isDebugEnabled()) {
            ZimbraLog.index_search.debug("Fetching a DB-FIRST chunk");
            overallStart = System.currentTimeMillis();
        }
        do {
            Object var17_18;
            ArrayList<DbSearch.SearchResult> dbRes = new ArrayList<DbSearch.SearchResult>();
            if (this.mParams.getEstimateSize() && this.mSizeEstimate == -1) {
                this.mSizeEstimate = DbSearch.countResults(conn, this.mConstraints, mbox);
            }
            DbSearch.search(dbRes, conn, this.mConstraints, mbox, sort, this.mOffset, 2000, this.mExtra);
            if (dbRes.size() < 2000) {
                this.mEndOfHits = true;
            }
            if (dbRes.size() <= 0) continue;
            this.mOffset += dbRes.size();
            try {
                HashMap<String, LinkedList<DbSearch.SearchResult>> mailItemToResultsMap = new HashMap<String, LinkedList<DbSearch.SearchResult>>();
                for (DbSearch.SearchResult res : dbRes) {
                    LinkedList<DbSearch.SearchResult> l = (LinkedList<DbSearch.SearchResult>)mailItemToResultsMap.get(res.indexId);
                    if (l == null) {
                        l = new LinkedList<DbSearch.SearchResult>();
                        mailItemToResultsMap.put(res.indexId, l);
                    }
                    l.add(res);
                    this.mLuceneOp.addFilterClause(new Term("l.mbox_blob_id", res.indexId));
                }
                boolean hasMore = true;
                boolean printedQuery = false;
                while (hasMore) {
                    this.mLuceneChunk = this.mLuceneOp.getNextResultsChunk(2000);
                    Set<String> indexIds = this.mLuceneChunk.getIndexIds();
                    if (indexIds.size() < 2000) {
                        hasMore = false;
                    }
                    for (String indexId : indexIds) {
                        List l = (List)mailItemToResultsMap.get(indexId);
                        if (l == null) {
                            if (ZimbraLog.index_search.isDebugEnabled() && !printedQuery) {
                                ZimbraLog.index_search.debug("DBQueryOperation.dbFirstGetNextChunk: LuceneQuery is \"" + this.mLuceneOp.getCurrentQuery().toString() + "\"");
                                printedQuery = true;
                            }
                            ZimbraLog.index_search.warn("DBQueryOperation.dbFirstGetNextChunk: Lucene returned item ID " + indexId + " but wasn't in resultMap");
                            throw ServiceException.FAILURE("Inconsistent DB/Index query results: Text Index returned item ID " + indexId + " but wasn't in resultMap", null);
                        }
                        for (DbSearch.SearchResult sr : l) {
                            this.mDBHits.add(sr);
                        }
                    }
                }
                var17_18 = null;
                this.mLuceneOp.clearFilterClause();
            }
            catch (Throwable throwable) {
                var17_18 = null;
                this.mLuceneOp.clearFilterClause();
                throw throwable;
            }
        } while (this.mDBHits.size() == 0 && !this.mEndOfHits);
        if (ZimbraLog.index_search.isDebugEnabled()) {
            long overallTime = System.currentTimeMillis() - overallStart;
            ZimbraLog.index_search.debug("Done fetching DB-FIRST chunk (took " + overallTime + "ms)");
        }
    }

    private void luceneFirstGetNextChunk(DbPool.Connection conn, Mailbox mbox, SortBy sort) throws ServiceException {
        long overallStart = 0L;
        if (ZimbraLog.index_search.isDebugEnabled()) {
            ZimbraLog.index_search.debug("Fetching a LUCENE-FIRST chunk");
            overallStart = System.currentTimeMillis();
        }
        do {
            long luceneStart = 0L;
            if (ZimbraLog.index_search.isDebugEnabled()) {
                luceneStart = System.currentTimeMillis();
            }
            this.mLuceneChunk = this.mLuceneOp.getNextResultsChunk(Math.max(Db.getINClauseBatchSize(), this.mHitsPerChunk));
            DbLeafNode sc = this.topLevelAndedConstraint();
            if (this.mParams.getEstimateSize() && this.mSizeEstimate == -1) {
                sc.indexIds = new HashSet();
                int dbResultCount = DbSearch.countResults(conn, this.mConstraints, mbox);
                int numTextHits = this.mLuceneOp.countHits();
                if (ZimbraLog.index.isDebugEnabled()) {
                    ZimbraLog.index.debug("LUCENE=" + numTextHits + "  DB=" + dbResultCount);
                }
                this.mSizeEstimate = Math.min(dbResultCount, numTextHits);
            }
            sc.indexIds = this.mLuceneChunk.getIndexIds();
            if (ZimbraLog.index_search.isDebugEnabled()) {
                long luceneTime = System.currentTimeMillis() - luceneStart;
                ZimbraLog.index_search.debug("Fetched Lucene Chunk of " + sc.indexIds.size() + " hits in " + luceneTime + "ms");
            }
            this.mHitsPerChunk *= 2;
            if (this.mHitsPerChunk > 2000) {
                this.mHitsPerChunk = 2000;
            }
            if (sc.indexIds.size() == 0) {
                this.mEndOfHits = true;
                continue;
            }
            long dbStart = System.currentTimeMillis();
            DbSearch.search(this.mDBHits, conn, this.mConstraints, mbox, sort, -1, -1, this.mExtra);
            if (ZimbraLog.index_search.isDebugEnabled()) {
                long dbTime = System.currentTimeMillis() - dbStart;
                ZimbraLog.index_search.debug("Fetched DB-second chunk in " + dbTime + "ms");
            }
            if (this.getSortBy() != SortBy.SCORE_DESCENDING) continue;
            Object[] scHits = new ScoredDBHit[this.mDBHits.size()];
            int offset = 0;
            for (DbSearch.SearchResult sr : this.mDBHits) {
                TextQueryOperation.TextResultsChunk.ScoredLuceneHit lucScore = this.mLuceneChunk.getScoredHit(sr.indexId);
                scHits[offset++] = new ScoredDBHit(sr, lucScore.mScore);
            }
            Arrays.sort(scHits);
            this.mDBHits = new ArrayList<DbSearch.SearchResult>(scHits.length);
            for (Object sdbHit : scHits) {
                this.mDBHits.add(((ScoredDBHit)sdbHit).mSr);
            }
        } while (this.mDBHits.size() == 0 && !this.mEndOfHits);
        if (ZimbraLog.index_search.isDebugEnabled()) {
            long overallTime = System.currentTimeMillis() - overallStart;
            ZimbraLog.index_search.debug("Done fetching LUCENE-FIRST chunk (took " + overallTime + "ms)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNextChunk() throws ServiceException {
        assert (!this.mEndOfHits);
        assert (this.mDBHitsIter == null || !this.mDBHitsIter.hasNext());
        if (this.mExecuteMode == QueryExecuteMode.NO_RESULTS) {
            if (ZimbraLog.index_search.isDebugEnabled()) {
                ZimbraLog.index_search.debug(" Returned **NO DB RESULTS (no-results-query-optimization)**");
            }
            this.mDBHitsIter = null;
            this.mEndOfHits = true;
        } else {
            Mailbox mbox = this.getMailbox();
            SortBy sort = this.getSortOrder();
            this.mDBHits = new ArrayList<DbSearch.SearchResult>();
            Object object = DbMailItem.getSynchronizer(mbox);
            synchronized (object) {
                DbPool.Connection conn = null;
                try {
                    conn = DbPool.getConnection(mbox);
                    switch (this.mExecuteMode) {
                        case NO_RESULTS: {
                            assert (false);
                            break;
                        }
                        case NO_LUCENE: {
                            this.noLuceneGetNextChunk(conn, mbox, sort);
                            break;
                        }
                        case DB_FIRST: {
                            this.dbFirstGetNextChunk(conn, mbox, sort);
                            break;
                        }
                        case LUCENE_FIRST: {
                            this.luceneFirstGetNextChunk(conn, mbox, sort);
                        }
                    }
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    DbPool.quietClose(conn);
                    throw throwable;
                }
                DbPool.quietClose(conn);
            }
            if (this.mDBHits.size() == 0) {
                this.mDBHitsIter = null;
                this.mDBHits = null;
                this.mEndOfHits = true;
            } else {
                this.mCurHitsOffset += this.mDBHits.size();
                this.mDBHitsIter = this.mDBHits.iterator();
            }
        }
    }

    @Override
    protected void prepare(Mailbox mbx, ZimbraQueryResultsImpl res, MailboxIndex mbidx, SearchParams params, int chunkSize) throws ServiceException, IOException {
        this.mParams = params;
        if (chunkSize > 2000) {
            chunkSize = 2000;
        }
        this.mHitsPerChunk = chunkSize;
        this.setupResults(mbx, res);
        if (this.mLuceneOp != null) {
            this.mHitsPerChunk *= 2;
            this.mLuceneOp.setDBOperation(this);
            this.mLuceneOp.prepare(mbx, res, mbidx, this.mParams, this.mHitsPerChunk);
        }
    }

    @Override
    QueryOperation optimize(Mailbox mbox) {
        return this;
    }

    @Override
    String toQueryString() {
        StringBuilder ret = new StringBuilder("(");
        if (this.mLuceneOp != null) {
            ret.append(this.mLuceneOp.toQueryString()).append(" AND ");
        }
        ret.append(this.mConstraints.toQueryString());
        ret.append(')');
        return ret.toString();
    }

    public String toString() {
        boolean atFirst = true;
        StringBuilder retVal = new StringBuilder("<");
        if (this.mLuceneOp != null) {
            retVal.append(this.mLuceneOp.toString());
            atFirst = false;
        }
        if (!atFirst) {
            retVal.append(" AND ");
        }
        retVal.append("DB(");
        if (this.mAllResultsQuery) {
            retVal.append("ANYWHERE");
        } else if (this.hasNoResults()) {
            retVal.append("--- NO RESULT ---");
        } else {
            if (this.mIncludeIsLocalFolders) {
                retVal.append("IS:LOCAL ");
            } else if (this.mIncludeIsRemoteFolders) {
                retVal.append("IS:REMOTE ");
            }
            retVal.append(this.mConstraints.toString());
        }
        retVal.append(")");
        retVal.append('>');
        return retVal.toString();
    }

    private DBQueryOperation cloneInternal() {
        try {
            DBQueryOperation toRet = (DBQueryOperation)super.clone();
            assert (this.mDBHits == null);
            assert (this.mDBHitsIter == null);
            assert (this.mLuceneChunk == null);
            toRet.mConstraints = (IConstraints)this.mConstraints.clone();
            toRet.mTypes = new HashSet();
            toRet.mTypes.addAll(this.mTypes);
            toRet.mExcludeTypes = new HashSet();
            toRet.mExcludeTypes.addAll(this.mExcludeTypes);
            toRet.mNextHits = new ArrayList<ZimbraHit>();
            return toRet;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    @Override
    public Object clone() {
        try {
            DBQueryOperation toRet = this.cloneInternal();
            if (this.mLuceneOp != null) {
                toRet.mLuceneOp = (TextQueryOperation)this.mLuceneOp.clone(this);
            }
            return toRet;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    protected Object clone(TextQueryOperation caller) {
        DBQueryOperation toRet = this.cloneInternal();
        toRet.mLuceneOp = caller;
        return toRet;
    }

    @Override
    protected QueryOperation combineOps(QueryOperation other, boolean union) {
        if (union) {
            if (this.hasNoResults()) {
                return other;
            }
            if (other.hasNoResults()) {
                return this;
            }
            if (other instanceof DBQueryOperation) {
                DBQueryOperation dbOther = (DBQueryOperation)other;
                if (this.mQueryTarget != null && dbOther.mQueryTarget != null && !this.mQueryTarget.equals(dbOther.mQueryTarget)) {
                    return null;
                }
                if (this.mAllResultsQuery) {
                    return this;
                }
                dbOther = (DBQueryOperation)other;
                if (dbOther.mAllResultsQuery) {
                    return dbOther;
                }
                if (this.mLuceneOp != null || dbOther.mLuceneOp != null) {
                    return null;
                }
                if (this.mQueryTarget == null) {
                    this.mQueryTarget = dbOther.mQueryTarget;
                }
                this.mConstraints = this.mConstraints.orIConstraints(dbOther.mConstraints);
                return this;
            }
            return null;
        }
        if (this.mAllResultsQuery) {
            assert (this.mLuceneOp == null);
            if (this.hasSpamTrashSetting()) {
                other.forceHasSpamTrashSetting();
            }
            return other;
        }
        DBQueryOperation dbOther = null;
        if (!(other instanceof DBQueryOperation)) {
            return null;
        }
        dbOther = (DBQueryOperation)other;
        if (dbOther.mAllResultsQuery) {
            if (dbOther.hasSpamTrashSetting()) {
                this.forceHasSpamTrashSetting();
            }
            return this;
        }
        if (this.mQueryTarget != QueryTarget.UNSPECIFIED && dbOther.mQueryTarget != QueryTarget.UNSPECIFIED && !this.mQueryTarget.equals(dbOther.mQueryTarget)) {
            ZimbraLog.index_search.debug("ANDing two DBOps with different targets -- this is a no results query!");
            return new NoResultsQueryOperation();
        }
        if (this.mQueryTarget == QueryTarget.UNSPECIFIED) {
            this.mQueryTarget = dbOther.mQueryTarget;
        }
        if (this.mLuceneOp != null) {
            if (dbOther.mLuceneOp != null) {
                this.mLuceneOp.combineOps(dbOther.mLuceneOp, false);
            }
        } else {
            this.mLuceneOp = dbOther.mLuceneOp;
        }
        this.mAllResultsQuery = this.mAllResultsQuery && dbOther.mAllResultsQuery;
        this.mConstraints = this.mConstraints.andIConstraints(dbOther.mConstraints);
        return this;
    }

    @Override
    public List<QueryInfo> getResultInfo() {
        ArrayList<QueryInfo> toRet = new ArrayList<QueryInfo>();
        toRet.addAll(this.mQueryInfo);
        if (this.mLuceneOp != null) {
            toRet.addAll(this.mLuceneOp.getQueryInfo());
        }
        return toRet;
    }

    @Override
    public int estimateResultSize() {
        return this.mSizeEstimate;
    }

    @Override
    protected void depthFirstRecurse(QueryOperation.RecurseCallback cb) {
        if (this.mLuceneOp != null) {
            this.mLuceneOp.depthFirstRecurseInternal(cb);
        }
        cb.recurseCallback(this);
    }

    protected int getDbHitCount(DbPool.Connection conn, Mailbox mbox) throws ServiceException {
        if (this.mCountDbResults == -1) {
            this.mCountDbResults = DbSearch.countResults(conn, this.mConstraints, mbox);
        }
        return this.mCountDbResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getDbHitCount() throws ServiceException {
        if (this.mCountDbResults == -1) {
            Mailbox mbox = this.getMailbox();
            Object object = DbMailItem.getSynchronizer(mbox);
            synchronized (object) {
                DbPool.Connection conn = null;
                try {
                    conn = DbPool.getConnection(mbox);
                    this.mCountDbResults = this.getDbHitCount(conn, mbox);
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    DbPool.quietClose(conn);
                    throw throwable;
                }
                DbPool.quietClose(conn);
            }
        }
        return this.mCountDbResults;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LRUHashMap<T>
    extends LinkedHashMap<T, T> {
        private final int mMaxSize;

        LRUHashMap(int maxSize) {
            super(maxSize, 0.75f, true);
            this.mMaxSize = maxSize;
        }

        LRUHashMap(int maxSize, int tableSize) {
            super(tableSize, 0.75f, true);
            this.mMaxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<T, T> eldest) {
            return this.size() > this.mMaxSize;
        }
    }

    private static class ScoredDBHit
    implements Comparable {
        public DbSearch.SearchResult mSr;
        public float mScore;

        ScoredDBHit(DbSearch.SearchResult sr, float score) {
            this.mSr = sr;
            this.mScore = score;
        }

        long scoreAsLong() {
            return (long)(this.mScore * 10000.0f);
        }

        public int compareTo(Object o) {
            long os;
            ScoredDBHit other = (ScoredDBHit)o;
            long mys = this.scoreAsLong();
            if (mys == (os = other.scoreAsLong())) {
                return this.mSr.id - other.mSr.id;
            }
            long l = os - mys;
            if (l > 0L) {
                return 1;
            }
            if (l < 0L) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            return o == this || this.compareTo(o) == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum QueryExecuteMode {
        NO_RESULTS,
        NO_LUCENE,
        DB_FIRST,
        LUCENE_FIRST;

    }
}

