/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConversationHit
extends ZimbraHit {
    private Conversation mConversation = null;
    private Map<Long, MessageHit> mMessageHits = new LinkedHashMap<Long, MessageHit>();
    private MessageHit mLastMessageHitAdded = null;
    private int mConversationId = 0;

    protected ConversationHit(ZimbraQueryResultsImpl results, Mailbox mbx, int conversationId, float score) {
        super(results, mbx, score);
        this.mConversationId = conversationId;
    }

    @Override
    public int getConversationId() {
        return this.getId();
    }

    public void addMessageHit(MessageHit mh) {
        this.mLastMessageHitAdded = mh;
        this.mMessageHits.put(new Long(mh.getItemId()), mh);
    }

    public Collection<MessageHit> getMessageHits() {
        return this.mMessageHits.values();
    }

    public int getNumMessageHits() {
        return this.getMessageHits().size();
    }

    public int getNumMessages() throws ServiceException {
        return this.getConversation().getMessageCount();
    }

    public MessageHit getMessageHit(Long mailboxBlobId) {
        return this.mMessageHits.get(mailboxBlobId);
    }

    public MessageHit getFirstMessageHit() {
        Iterator<MessageHit> iter = this.getMessageHits().iterator();
        return iter.hasNext() ? iter.next() : null;
    }

    @Override
    public int getItemId() {
        return this.mConversationId;
    }

    public byte getItemType() {
        return 4;
    }

    @Override
    void setItem(MailItem item) {
        this.mConversation = (Conversation)item;
    }

    @Override
    boolean itemIsLoaded() {
        return this.mConversation != null;
    }

    public int getId() {
        return this.mConversationId;
    }

    @Override
    public String toString() {
        return super.toString() + " C" + Long.toString(this.getId());
    }

    @Override
    public String getSubject() throws ServiceException {
        if (this.mCachedSubj == null) {
            this.mCachedSubj = this.mLastMessageHitAdded.getSubject();
        }
        return this.mCachedSubj;
    }

    @Override
    public String getName() {
        return "CONV_HAS_NO_NAME";
    }

    public long getHitDate() throws ServiceException {
        MessageHit mh = this.getFirstMessageHit();
        return mh == null ? 0L : mh.getDate();
    }

    @Override
    public long getSize() throws ServiceException {
        return this.getConversation().getSize();
    }

    @Override
    public long getDate() throws ServiceException {
        if (this.mCachedDate == -1L) {
            this.mCachedDate = this.getHitDate();
            if (this.mCachedDate == 0L) {
                this.mCachedDate = this.getConversation().getDate();
            }
        }
        return this.mCachedDate;
    }

    @Override
    public MailItem getMailItem() throws ServiceException {
        return this.getConversation();
    }

    public Conversation getConversation() throws ServiceException {
        if (this.mConversation == null) {
            this.mConversation = this.getMailbox().getConversationById(null, this.mConversationId);
        }
        return this.mConversation;
    }
}

