/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.ConversationHit;
import com.zimbra.cs.index.MessageHit;
import com.zimbra.cs.index.MessagePartHit;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.Mailbox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConvQueryResults
extends ZimbraQueryResultsImpl {
    ZimbraQueryResults mResults;
    private ZimbraHit mNextHit = null;
    private int mNextHitNo = 0;
    private ArrayList<ZimbraHit> mCachedResults = new ArrayList();
    HashMap<Integer, ConversationHit> mSeenConversations = new HashMap();

    ConvQueryResults(ZimbraQueryResults results, byte[] types, SortBy searchOrder, Mailbox.SearchResultMode mode) {
        super(types, searchOrder, mode);
        this.mResults = results;
    }

    private ZimbraHit internalGetNextHit() throws ServiceException {
        while (this.mResults.hasNext()) {
            ZimbraHit opNext = this.mResults.getNext();
            ConversationHit curHit = null;
            if (!(opNext instanceof MessageHit || opNext instanceof MessagePartHit || opNext instanceof ConversationHit)) {
                return opNext;
            }
            Integer convId = new Integer(opNext.getConversationId());
            curHit = this.mSeenConversations.get(convId);
            if (curHit != null) continue;
            if (opNext instanceof ConversationHit) {
                curHit = (ConversationHit)opNext;
            } else if (opNext instanceof MessageHit) {
                curHit = ((MessageHit)opNext).getConversationResult();
            } else if (opNext instanceof MessagePartHit) {
                curHit = ((MessagePartHit)opNext).getMessageResult().getConversationResult();
            } else {
                return opNext;
            }
            this.mSeenConversations.put(convId, curHit);
            while (this.mResults.hasNext()) {
                ZimbraHit nextHit = this.mResults.peekNext();
                if (!(nextHit instanceof MessageHit || nextHit instanceof MessagePartHit || nextHit instanceof ConversationHit)) {
                    return curHit;
                }
                if (nextHit.getConversationId() != convId.intValue()) {
                    return curHit;
                }
                this.mResults.getNext();
                if (nextHit instanceof MessageHit) {
                    curHit.addMessageHit((MessageHit)nextHit);
                    continue;
                }
                if (!(nextHit instanceof MessagePartHit)) continue;
                curHit.addMessageHit(((MessagePartHit)nextHit).getMessageResult());
            }
            return curHit;
        }
        return null;
    }

    private boolean bufferNextHit() throws ServiceException {
        if (this.mNextHit == null) {
            this.mNextHit = this.internalGetNextHit();
        }
        return this.mNextHit != null;
    }

    @Override
    public ZimbraHit peekNext() throws ServiceException {
        this.bufferNextHit();
        return this.mNextHit;
    }

    @Override
    public void resetIterator() throws ServiceException {
        this.mSeenConversations.clear();
        this.mResults.resetIterator();
        this.mNextHitNo = 0;
        this.mCachedResults.clear();
        this.mNextHit = null;
    }

    @Override
    public ZimbraHit getNext() throws ServiceException {
        ZimbraHit retVal = null;
        if (this.mCachedResults.size() > this.mNextHitNo) {
            retVal = this.mCachedResults.get(this.mNextHitNo);
        } else if (this.bufferNextHit()) {
            retVal = this.mNextHit;
            this.mCachedResults.add(this.mNextHitNo, this.mNextHit);
            this.mNextHit = null;
        }
        if (retVal != null) {
            ++this.mNextHitNo;
        }
        return retVal;
    }

    @Override
    public void doneWithSearchResults() throws ServiceException {
        this.mResults.doneWithSearchResults();
    }

    @Override
    public ZimbraHit skipToHit(int hitNo) throws ServiceException {
        if (hitNo == 0) {
            this.resetIterator();
            return this.getNext();
        }
        ZimbraHit retVal = null;
        this.mNextHitNo = hitNo < this.mCachedResults.size() ? hitNo : this.mCachedResults.size();
        while (this.mNextHitNo <= hitNo && (retVal = this.getNext()) != null) {
        }
        return retVal;
    }

    @Override
    public List<QueryInfo> getResultInfo() {
        return this.mResults.getResultInfo();
    }

    @Override
    public int estimateResultSize() throws ServiceException {
        return (int)((double)this.mResults.estimateResultSize() / 1.5);
    }
}

