/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import org.apache.lucene.document.Document;

public final class ContactHit
extends ZimbraHit {
    private Contact mContact = null;
    private int mItemId;

    public ContactHit(ZimbraQueryResultsImpl results, Mailbox mbx, int itemId, Document d, float score, MailItem.UnderlyingData ud) throws ServiceException {
        super(results, mbx, score);
        this.mItemId = itemId;
        if (ud != null) {
            this.mContact = (Contact)mbx.getItemFromUnderlyingData(ud);
        }
    }

    public long getDate() throws ServiceException {
        if (this.mCachedDate == -1L) {
            this.mCachedDate = this.getContact().getDate();
        }
        return this.mCachedDate;
    }

    public MailItem getMailItem() throws ServiceException {
        return this.getContact();
    }

    public Contact getContact() throws ServiceException {
        if (this.mContact == null) {
            this.mContact = this.getMailbox().getContactById(null, this.getItemId());
        }
        return this.mContact;
    }

    public long getSize() throws ServiceException {
        return this.getContact().getSize();
    }

    public int getConversationId() {
        return 0;
    }

    public int getItemId() {
        return this.mItemId;
    }

    public byte getItemType() {
        return 6;
    }

    void setItem(MailItem item) {
        this.mContact = (Contact)item;
    }

    boolean itemIsLoaded() {
        return this.mContact != null;
    }

    public String getSubject() throws ServiceException {
        if (this.mCachedSubj == null) {
            this.mCachedSubj = this.getContact().getSubject();
        }
        return this.mCachedSubj;
    }

    public String getName() throws ServiceException {
        if (this.mCachedName == null) {
            this.mCachedName = this.getContact().getFileAsString();
        }
        return this.mCachedName;
    }

    public String toString() {
        int convId = this.getConversationId();
        String msgStr = "";
        String contactStr = "";
        try {
            msgStr = Integer.toString(this.getItemId());
            contactStr = this.getContact().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "CT: " + super.toString() + " C" + convId + " M" + msgStr + " " + contactStr;
    }
}

