/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResultsImpl;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import org.apache.lucene.document.Document;

public class CalendarItemHit
extends ZimbraHit {
    protected int mId;
    protected CalendarItem mCalItem;
    private byte mType = (byte)-1;

    public CalendarItemHit(ZimbraQueryResultsImpl results, Mailbox mbx, int mailItemId, Document d, float score, MailItem.UnderlyingData ud) throws ServiceException {
        super(results, mbx, score);
        this.mId = mailItemId;
        if (ud != null) {
            this.mCalItem = (CalendarItem)mbx.getItemFromUnderlyingData(ud);
            this.mType = ud.type;
        }
    }

    public CalendarItemHit(ZimbraQueryResultsImpl results, Mailbox mbx, int id, float score, MailItem.UnderlyingData ud) throws ServiceException {
        super(results, mbx, score);
        this.mId = id;
        if (ud != null) {
            this.mCalItem = (CalendarItem)mbx.getItemFromUnderlyingData(ud);
            this.mType = ud.type;
        }
    }

    public CalendarItemHit(ZimbraQueryResultsImpl results, Mailbox mbx, int id, Document d, float score, CalendarItem calItem, byte type) throws ServiceException {
        super(results, mbx, score);
        this.mId = id;
        this.mCalItem = calItem;
        this.mType = type;
    }

    public MailItem getMailItem() throws ServiceException {
        return this.getCalendarItem();
    }

    public CalendarItem getCalendarItem() throws ServiceException {
        if (this.mCalItem == null) {
            this.mCalItem = this.getMailbox().getCalendarItemById(null, this.mId);
        }
        return this.mCalItem;
    }

    public long getDate() throws ServiceException {
        return this.getCalendarItem().getDate();
    }

    public long getSize() throws ServiceException {
        return this.getCalendarItem().getSize();
    }

    public int getConversationId() {
        assert (false);
        return 0;
    }

    public int getItemId() {
        return this.mId;
    }

    public byte getItemType() {
        return this.mType;
    }

    void setItem(MailItem item) {
        this.mCalItem = (CalendarItem)item;
        this.mType = this.mCalItem != null ? this.mCalItem.getType() : (byte)-1;
    }

    boolean itemIsLoaded() {
        return this.mId == 0 || this.mCalItem != null;
    }

    public String getSubject() throws ServiceException {
        return this.getCalendarItem().getSubject();
    }

    public String getName() throws ServiceException {
        return this.getCalendarItem().getSubject();
    }

    public String toString() {
        String name = "";
        String subject = "";
        try {
            name = this.getName();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            subject = this.getSubject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "CalendarItem: " + super.toString() + " " + name + " " + subject;
    }
}

