/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.index;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.index.QueryInfo;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BufferingResultsGrouper
implements ZimbraQueryResults {
    protected ZimbraQueryResults mHits;
    protected List<ZimbraHit> mBufferedHit = new LinkedList<ZimbraHit>();
    protected boolean atStart = true;

    protected abstract boolean bufferHits() throws ServiceException;

    @Override
    public SortBy getSortBy() {
        return this.mHits.getSortBy();
    }

    public BufferingResultsGrouper(ZimbraQueryResults hits) {
        this.mHits = hits;
    }

    @Override
    public void resetIterator() throws ServiceException {
        if (!this.atStart) {
            this.mBufferedHit.clear();
            this.mHits.resetIterator();
            this.atStart = true;
        }
    }

    @Override
    public boolean hasNext() throws ServiceException {
        return this.bufferHits();
    }

    @Override
    public ZimbraHit getFirstHit() throws ServiceException {
        this.resetIterator();
        return this.getNext();
    }

    @Override
    public ZimbraHit peekNext() throws ServiceException {
        if (this.bufferHits()) {
            return this.mBufferedHit.get(0);
        }
        return null;
    }

    @Override
    public ZimbraHit skipToHit(int hitNo) throws ServiceException {
        this.resetIterator();
        for (int i = 0; i < hitNo; ++i) {
            if (!this.hasNext()) {
                return null;
            }
            this.getNext();
        }
        return this.getNext();
    }

    @Override
    public ZimbraHit getNext() throws ServiceException {
        this.atStart = false;
        if (this.bufferHits()) {
            return this.mBufferedHit.remove(0);
        }
        return null;
    }

    @Override
    public void doneWithSearchResults() throws ServiceException {
        this.mHits.doneWithSearchResults();
    }

    @Override
    public List<QueryInfo> getResultInfo() {
        return this.mHits.getResultInfo();
    }

    @Override
    public int estimateResultSize() throws ServiceException {
        return this.mHits.estimateResultSize();
    }
}

