/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.imap.ImapHandler;
import com.zimbra.cs.imap.ImapParseException;
import com.zimbra.cs.imap.ImapRequest;
import com.zimbra.cs.imap.Literal;
import com.zimbra.cs.tcpserver.TcpServerInputStream;
import java.io.IOException;

public class TcpImapRequest
extends ImapRequest {
    private TcpServerInputStream mStream;
    private long mLiteral = -1L;
    private boolean mUnlogged;

    TcpImapRequest(String line, ImapHandler handler) {
        super(handler);
        this.addPart(line);
    }

    TcpImapRequest(TcpServerInputStream tsis, ImapHandler handler) {
        super(handler);
        this.mStream = tsis;
    }

    void continuation() throws IOException, ImapParseException {
        int openBrace;
        String line;
        if (this.mLiteral >= 0L) {
            this.continueLiteral();
        }
        String logline = line = this.mStream.readLine();
        if (line == null) {
            throw new ImapTerminatedException();
        }
        this.incrementSize(line.length());
        this.addPart(line);
        if (this.mParts.size() == 1 && !this.isMaxRequestSizeExceeded()) {
            this.mUnlogged = this.isLogin();
            if (this.mUnlogged) {
                logline = line.substring(0, line.indexOf(32) + 7) + "...";
            }
        }
        if (ZimbraLog.imap.isDebugEnabled()) {
            ZimbraLog.imap.debug("C: " + logline);
        }
        if (line.endsWith("+}") && this.extensionEnabled("LITERAL+") && (openBrace = line.lastIndexOf(123, line.length() - 3)) >= 0) {
            long size;
            try {
                size = Long.parseLong(line.substring(openBrace + 1, line.length() - 2));
            }
            catch (NumberFormatException nfe) {
                size = -1L;
            }
            if (size >= 0L) {
                if (!this.isAppend()) {
                    this.incrementSize(size);
                }
                this.mLiteral = size;
                this.continuation();
            } else {
                if (this.mTag == null && this.mIndex == 0 && this.mOffset == 0) {
                    this.mTag = this.readTag();
                    this.rewind();
                }
                throw new ImapParseException(this.mTag, "malformed nonblocking literal");
            }
        }
    }

    private void continueLiteral() throws IOException, ImapParseException {
        if (this.isMaxRequestSizeExceeded()) {
            long skipped = this.mStream.skip(this.mLiteral);
            if (this.mLiteral > 0L && skipped == 0L) {
                throw new ImapTerminatedException();
            }
            this.mLiteral -= skipped;
        } else {
            Literal literal;
            ImapRequest.Part part = (ImapRequest.Part)this.mParts.get(this.mParts.size() - 1);
            if (part.isLiteral()) {
                literal = part.getLiteral();
            } else {
                literal = Literal.newInstance((int)this.mLiteral, this.isAppend());
                this.addPart(literal);
            }
            int read = literal.copy(this.mStream);
            if (read == -1) {
                throw new ImapTerminatedException();
            }
            if (!this.mUnlogged && ZimbraLog.imap.isDebugEnabled()) {
                ZimbraLog.imap.debug("C: {" + read + "}");
            }
            this.mLiteral -= (long)read;
        }
        if (this.mLiteral > 0L) {
            throw new ImapContinuationException(false);
        }
        this.mLiteral = -1L;
    }

    private Literal getCurrentBuffer() throws ImapParseException {
        return ((ImapRequest.Part)this.mParts.get(this.mIndex)).getLiteral();
    }

    protected Literal readLiteral() throws IOException, ImapParseException {
        boolean lastPart;
        boolean blocking = true;
        this.skipChar('{');
        long length = Long.parseLong(this.readNumber());
        if (this.peekChar() == 43 && this.extensionEnabled("LITERAL+")) {
            this.skipChar('+');
            blocking = false;
        }
        this.skipChar('}');
        if (this.getCurrentLine().length() != this.mOffset) {
            throw new ImapParseException(this.mTag, "extra characters after literal declaration");
        }
        boolean bl = lastPart = this.mIndex == this.mParts.size() - 1;
        if (lastPart || this.mIndex == this.mParts.size() - 2 && this.mLiteral != -1L) {
            if (this.mLiteral == -1L) {
                if (!this.isAppend()) {
                    this.incrementSize(length);
                }
                this.mLiteral = length;
            }
            if (!blocking && (long)this.mStream.available() >= this.mLiteral) {
                this.continuation();
            } else {
                throw new ImapContinuationException(blocking && lastPart);
            }
        }
        ++this.mIndex;
        Literal result = this.getCurrentBuffer();
        ++this.mIndex;
        this.mOffset = 0;
        return result;
    }

    final class ImapContinuationException
    extends ImapParseException {
        private static final long serialVersionUID = 7925400980773927177L;
        boolean sendContinuation;

        ImapContinuationException(boolean send) {
            this.sendContinuation = send;
        }
    }

    final class ImapTerminatedException
    extends ImapParseException {
        private static final long serialVersionUID = 6105950126307803418L;

        ImapTerminatedException() {
        }
    }
}

