/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.util.NetUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.imap.ImapFolder;
import com.zimbra.cs.imap.ImapHandler;
import com.zimbra.cs.imap.ImapParseException;
import com.zimbra.cs.imap.ImapServer;
import com.zimbra.cs.imap.TcpImapRequest;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.tcpserver.TcpServerInputStream;
import com.zimbra.cs.util.Config;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class TcpImapHandler
extends ImapHandler {
    private TcpServerInputStream mInputStream;
    private String mRemoteAddress;
    private TcpImapRequest mRequest;

    TcpImapHandler(ImapServer server) {
        super(server);
    }

    protected boolean setupConnection(Socket connection) throws IOException {
        connection.setSoTimeout(this.mConfig.getUnauthMaxIdleSeconds() * 1000);
        this.mRemoteAddress = connection.getInetAddress().getHostAddress();
        this.INFO("connected");
        this.mInputStream = new TcpServerInputStream(connection.getInputStream());
        this.mOutputStream = new BufferedOutputStream(connection.getOutputStream());
        if (!Config.userServicesEnabled()) {
            ZimbraLog.imap.debug("dropping connection because user services are disabled");
            this.dropConnection();
            return false;
        }
        this.sendUntagged(this.mConfig.getBanner(), true);
        return true;
    }

    protected boolean authenticate() {
        return true;
    }

    protected void setIdle(boolean idle) {
        super.setIdle(idle);
        ImapFolder i4selected = this.mSelectedFolder;
        if (i4selected != null) {
            i4selected.updateAccessTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processCommand() throws IOException {
        boolean bl;
        block14: {
            boolean bl2;
            block13: {
                if (this.mInputStream == null) {
                    return false;
                }
                this.setUpLogContext(this.mRemoteAddress);
                if (this.mRequest == null) {
                    this.mRequest = new TcpImapRequest(this.mInputStream, (ImapHandler)this);
                }
                try {
                    try {
                        this.mRequest.continuation();
                        if (this.mRequest.isMaxRequestSizeExceeded()) {
                            this.setIdle(false);
                            throw new ImapParseException(this.mRequest.getTag(), "maximum request size exceeded", false);
                        }
                        long start = ZimbraPerf.STOPWATCH_IMAP.start();
                        if (!this.checkAccountStatus()) {
                            bl2 = false;
                            Object var6_7 = null;
                            break block13;
                        }
                        boolean keepGoing = this.mAuthenticator != null && !this.mAuthenticator.isComplete() ? this.continueAuthentication(this.mRequest) : this.executeRequest(this.mRequest);
                        this.setIdle(false);
                        ZimbraPerf.STOPWATCH_IMAP.stop(start);
                        if (this.mLastCommand != null) {
                            ZimbraPerf.IMAP_TRACKER.addStat(this.mLastCommand.toUpperCase(), start);
                        }
                        this.clearRequest();
                        bl = keepGoing;
                        break block14;
                    }
                    catch (TcpImapRequest.ImapContinuationException ice) {
                        this.mRequest.rewind();
                        if (ice.sendContinuation) {
                            this.sendContinuation("send literal data");
                        }
                        boolean bl3 = true;
                        Object var6_9 = null;
                        ZimbraLog.clearContext();
                        return bl3;
                    }
                    catch (TcpImapRequest.ImapTerminatedException ite) {
                        boolean bl4 = false;
                        Object var6_10 = null;
                        ZimbraLog.clearContext();
                        return bl4;
                    }
                    catch (ImapParseException ipe) {
                        this.clearRequest();
                        this.handleParseException(ipe);
                        boolean bl5 = true;
                        Object var6_11 = null;
                        ZimbraLog.clearContext();
                        return bl5;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    ZimbraLog.clearContext();
                    throw throwable;
                }
            }
            ZimbraLog.clearContext();
            return bl2;
        }
        Object var6_8 = null;
        ZimbraLog.clearContext();
        return bl;
    }

    private void clearRequest() {
        if (this.mRequest != null) {
            this.mRequest.cleanup();
            this.mRequest = null;
        }
    }

    boolean doSTARTTLS(String tag) throws IOException {
        if (!this.checkState(tag, ImapHandler.State.NOT_AUTHENTICATED)) {
            return true;
        }
        if (this.mStartedTLS) {
            this.sendNO(tag, "TLS already started");
            return true;
        }
        this.sendOK(tag, "Begin TLS negotiation now");
        SSLSocketFactory fac = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket tlsconn = (SSLSocket)fac.createSocket(this.mConnection, this.mConnection.getInetAddress().getHostName(), this.mConnection.getPort(), true);
        NetUtil.setSSLEnabledCipherSuites(tlsconn, this.mConfig.getSSLExcludeCiphers());
        tlsconn.setUseClientMode(false);
        tlsconn.startHandshake();
        ZimbraLog.imap.debug("suite: " + tlsconn.getSession().getCipherSuite());
        this.mInputStream = new TcpServerInputStream(tlsconn.getInputStream());
        this.mOutputStream = new BufferedOutputStream(tlsconn.getOutputStream());
        this.mStartedTLS = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dropConnection(boolean sendBanner) {
        this.clearRequest();
        try {
            this.unsetSelectedFolder(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        new Thread(){

            public void run() {
                if (TcpImapHandler.this.mOutputStream == null) {
                    return;
                }
                try {
                    1.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                OutputStream os = TcpImapHandler.this.mOutputStream;
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }.start();
        ZimbraLog.addIpToContext(this.mRemoteAddress);
        try {
            block11: {
                try {
                    OutputStream os = this.mOutputStream;
                    if (os != null) {
                        if (sendBanner && !this.mGoodbyeSent) {
                            this.sendBYE();
                        }
                        os.close();
                        this.mOutputStream = null;
                    }
                    if (this.mInputStream != null) {
                        this.mInputStream.close();
                        this.mInputStream = null;
                    }
                    if (this.mAuthenticator == null) break block11;
                    this.mAuthenticator.dispose();
                    this.mAuthenticator = null;
                }
                catch (IOException e) {
                    if (ZimbraLog.imap.isDebugEnabled()) {
                        ZimbraLog.imap.info((Object)"I/O error while closing connection", e);
                    } else {
                        ZimbraLog.imap.info("I/O error while closing connection: " + e);
                    }
                    Object var4_6 = null;
                    ZimbraLog.clearContext();
                    return;
                }
            }
            Object var4_5 = null;
            ZimbraLog.clearContext();
            return;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            ZimbraLog.clearContext();
            throw throwable;
        }
    }

    protected void notifyIdleConnection() {
        ZimbraLog.imap.debug("dropping connection for inactivity");
        this.dropConnection();
    }

    protected void completeAuthentication() throws IOException {
        this.mAuthenticator.sendSuccess();
        if (this.mAuthenticator.isEncryptionEnabled()) {
            this.mInputStream = new TcpServerInputStream(this.mAuthenticator.unwrap(this.mConnection.getInputStream()));
            this.mOutputStream = this.mAuthenticator.wrap(this.mConnection.getOutputStream());
        }
    }

    protected void enableInactivityTimer() throws SocketException {
        this.mConnection.setSoTimeout(this.mConfig.getMaxIdleSeconds() * 1000);
    }

    protected void flushOutput() throws IOException {
        this.mOutputStream.flush();
    }

    void sendLine(String line, boolean flush) throws IOException {
        OutputStream os = this.mOutputStream;
        if (os == null) {
            return;
        }
        os.write(line.getBytes());
        os.write(LINE_SEPARATOR_BYTES);
        if (flush) {
            os.flush();
        }
    }

    void INFO(String message, Throwable e) {
        if (ZimbraLog.imap.isInfoEnabled()) {
            ZimbraLog.imap.info(this.withClientInfo(message), e);
        }
    }

    void INFO(String message) {
        if (ZimbraLog.imap.isInfoEnabled()) {
            ZimbraLog.imap.info(this.withClientInfo(message));
        }
    }

    private StringBuilder withClientInfo(String message) {
        int length = 64;
        if (message != null) {
            length += message.length();
        }
        return new StringBuilder(length).append("[").append(this.mRemoteAddress).append("] ").append(message);
    }
}

