/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.imap.ImapConfig;
import com.zimbra.cs.imap.MinaImapDecoder;
import com.zimbra.cs.imap.MinaImapHandler;
import com.zimbra.cs.mina.MinaCodecFactory;
import com.zimbra.cs.mina.MinaHandler;
import com.zimbra.cs.mina.MinaServer;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ExecutorService;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;

public class MinaImapServer
extends MinaServer {
    public static boolean isEnabled() {
        return Boolean.getBoolean("ZimbraNioImapEnabled") || LC.nio_imap_enabled.booleanValue();
    }

    MinaImapServer(ImapConfig config, ExecutorService pool) throws IOException, ServiceException {
        super(config, pool);
    }

    public MinaHandler createHandler(IoSession session) {
        return new MinaImapHandler(this, session);
    }

    protected ProtocolCodecFactory getProtocolCodecFactory() {
        return new MinaCodecFactory(this){

            public ProtocolDecoder getDecoder() {
                return new MinaImapDecoder(MinaImapServer.this.getStats());
            }
        };
    }

    public Log getLog() {
        return ZimbraLog.imap;
    }

    public void registerMinaStatsMBean(String name) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this.getStats(), new ObjectName(name));
        }
        catch (Exception e) {
            ZimbraLog.imap.warn((Object)"Unable to register MinaStats mbean", e);
        }
    }
}

