/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.cs.imap.ImapParseException;
import com.zimbra.cs.imap.ImapRequest;
import com.zimbra.cs.imap.Literal;
import com.zimbra.cs.imap.LiteralInfo;
import com.zimbra.cs.imap.MinaImapHandler;
import com.zimbra.cs.mina.MinaHandler;
import java.io.IOException;

public class MinaImapRequest
extends ImapRequest {
    private Literal literal;
    private int literalCount;
    private boolean complete;

    public MinaImapRequest(MinaHandler handler) {
        super((MinaImapHandler)handler);
    }

    public boolean parse(Object obj) throws IOException {
        try {
            if (this.literal != null) {
                this.parseLiteral((byte[])obj);
            } else {
                this.parseCommand((String)obj);
            }
            return this.complete;
        }
        catch (ImapParseException e) {
            this.cleanup();
            this.mHandler.handleParseException(e);
            throw new IllegalArgumentException("Bad request line", e);
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    private void parseLiteral(byte[] b) throws IOException, ImapParseException {
        assert (b.length <= this.literalCount);
        this.literalCount = this.isMaxRequestSizeExceeded() ? (this.literalCount -= Math.min(this.literalCount, b.length)) : (this.literalCount -= this.literal.put(b, 0, b.length));
        if (this.literalCount <= 0) {
            assert (this.literal.remaining() == 0);
            if (!this.isMaxRequestSizeExceeded()) {
                this.addPart(this.literal);
            }
            this.literal = null;
        }
    }

    private void parseCommand(String line) throws IOException, ImapParseException {
        LiteralInfo li;
        this.incrementSize(line.length());
        this.addPart(line);
        try {
            li = LiteralInfo.parse(line);
        }
        catch (IllegalArgumentException e) {
            throw new ImapParseException(this.getTag(), "bad literal format");
        }
        if (li != null) {
            this.literalCount = li.getCount();
            if (!this.isAppend()) {
                this.incrementSize(this.literalCount);
            }
            if (!this.isMaxRequestSizeExceeded()) {
                this.literal = Literal.newInstance(this.literalCount, this.isAppend());
            }
            if (li.isBlocking()) {
                this.sendContinuation();
            }
        } else {
            this.complete = true;
        }
    }

    private void sendContinuation() throws IOException, ImapParseException {
        if (this.isMaxRequestSizeExceeded()) {
            throw new ImapParseException(this.getTag(), "maximum request size exceeded", false);
        }
        this.mHandler.sendContinuation("send literal data");
    }

    public Literal readLiteral() throws ImapParseException {
        this.skipChar('{');
        if (this.mIndex + 1 >= this.mParts.size()) {
            throw new ImapParseException(this.mTag, "no next literal");
        }
        ImapRequest.Part part = (ImapRequest.Part)this.mParts.get(this.mIndex + 1);
        this.mIndex += 2;
        this.mOffset = 0;
        return part.getLiteral();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ImapRequest.Part part : this.mParts) {
            sb.append(part);
            if (!part.isString()) continue;
            sb.append("\r\n");
        }
        return sb.toString();
    }
}

