/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.imap.ImapFolder;
import com.zimbra.cs.imap.ImapHandler;
import com.zimbra.cs.imap.ImapParseException;
import com.zimbra.cs.imap.MinaImapRequest;
import com.zimbra.cs.imap.MinaImapServer;
import com.zimbra.cs.mina.MinaHandler;
import com.zimbra.cs.mina.MinaIoSessionOutputStream;
import com.zimbra.cs.mina.MinaOutputStream;
import com.zimbra.cs.mina.MinaServer;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.util.Config;
import java.io.IOException;
import java.net.Socket;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;

class MinaImapHandler
extends ImapHandler
implements MinaHandler {
    private MinaImapServer mServer;
    private IoSession mSession;
    private MinaImapRequest mRequest;
    private static final long WRITE_TIMEOUT = LC.nio_imap_write_timeout.longValue() * 1000L;
    private static final int MAX_SESSIONS = LC.nio_imap_max_sessions.intValue();

    MinaImapHandler(MinaImapServer server, IoSession session) {
        super(server);
        this.mServer = server;
        this.mSession = session;
        this.mOutputStream = new MinaIoSessionOutputStream(this.mSession, LC.nio_imap_max_chunk_size.intValue()).setHighWatermark(LC.nio_imap_write_queue_high_watermark.intValue()).setLowWatermark(LC.nio_imap_write_queue_low_watermark.intValue()).setTimeout(WRITE_TIMEOUT);
        this.mSession.setIdleTime(IdleStatus.BOTH_IDLE, this.mConfig.getUnauthMaxIdleSeconds());
    }

    boolean doSTARTTLS(String tag) throws IOException {
        if (!this.checkState(tag, ImapHandler.State.NOT_AUTHENTICATED)) {
            return true;
        }
        if (this.mStartedTLS) {
            this.sendNO(tag, "TLS already started");
            return true;
        }
        MinaServer.startTLS(this.mSession, this.mConfig);
        this.sendOK(tag, "begin TLS negotiation now");
        this.mStartedTLS = true;
        return true;
    }

    public void connectionOpened() throws IOException {
        if (!Config.userServicesEnabled()) {
            ZimbraLog.imap.debug("Dropping connection (user services are disabled)");
            this.dropConnection();
        } else if (this.mServer.getStats().getActiveSessions() >= (long)MAX_SESSIONS) {
            ZimbraLog.imap.debug("Dropping connection (max sessions exceeded)");
            this.sendBYE("Server too busy");
            this.dropConnection();
        } else {
            this.sendUntagged(this.mConfig.getBanner(), true);
        }
    }

    protected boolean processCommand() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void messageReceived(Object msg) throws IOException {
        if (this.mRequest == null) {
            this.mRequest = new MinaImapRequest(this);
        }
        if (!this.mRequest.parse(msg)) return;
        this.setUpLogContext(this.mSession.getRemoteAddress().toString());
        try {
            block5: {
                try {
                    if (this.processRequest(this.mRequest)) break block5;
                    this.dropConnection();
                }
                catch (ImapParseException e) {
                    this.handleParseException(e);
                    Object var4_3 = null;
                    ZimbraLog.clearContext();
                    if (this.mRequest == null) return;
                    this.mRequest.cleanup();
                    this.mRequest = null;
                    return;
                }
            }
            Object var4_2 = null;
            ZimbraLog.clearContext();
            if (this.mRequest == null) return;
            this.mRequest.cleanup();
            this.mRequest = null;
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ZimbraLog.clearContext();
            if (this.mRequest == null) throw throwable;
            this.mRequest.cleanup();
            this.mRequest = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processRequest(MinaImapRequest req) throws IOException, ImapParseException {
        Throwable throwable2;
        boolean bl;
        long start;
        block10: {
            block9: {
                if (req.isMaxRequestSizeExceeded()) {
                    throw new ImapParseException(req.getTag(), "maximum request size exceeded", false);
                }
                ImapFolder i4selected = this.mSelectedFolder;
                if (i4selected != null) {
                    i4selected.updateAccessTime();
                }
                start = ZimbraPerf.STOPWATCH_IMAP.start();
                if (this.checkAccountStatus()) break block9;
                boolean bl2 = false;
                Object var8_8 = null;
                ZimbraPerf.STOPWATCH_IMAP.stop(start);
                if (this.mLastCommand == null) return bl2;
                ZimbraPerf.IMAP_TRACKER.addStat(this.mLastCommand.toUpperCase(), start);
                return bl2;
            }
            if (this.mAuthenticator == null || this.mAuthenticator.isComplete()) break block10;
            boolean bl3 = this.continueAuthentication(req);
            Object var8_9 = null;
            ZimbraPerf.STOPWATCH_IMAP.stop(start);
            if (this.mLastCommand == null) return bl3;
            ZimbraPerf.IMAP_TRACKER.addStat(this.mLastCommand.toUpperCase(), start);
            return bl3;
        }
        try {
            bl = this.executeRequest(req);
        }
        catch (ImapParseException e) {
            try {
                this.handleParseException(e);
                boolean bl4 = true;
                Object var8_11 = null;
                ZimbraPerf.STOPWATCH_IMAP.stop(start);
                if (this.mLastCommand == null) return bl4;
                ZimbraPerf.IMAP_TRACKER.addStat(this.mLastCommand.toUpperCase(), start);
                return bl4;
            }
            catch (Throwable throwable2) {
                Object var8_12 = null;
                ZimbraPerf.STOPWATCH_IMAP.stop(start);
                if (this.mLastCommand == null) throw throwable2;
                ZimbraPerf.IMAP_TRACKER.addStat(this.mLastCommand.toUpperCase(), start);
            }
        }
        Object var8_10 = null;
        ZimbraPerf.STOPWATCH_IMAP.stop(start);
        if (this.mLastCommand == null) return bl;
        ZimbraPerf.IMAP_TRACKER.addStat(this.mLastCommand.toUpperCase(), start);
        return bl;
        throw throwable2;
    }

    protected void dropConnection(boolean sendBanner) {
        this.dropConnection(sendBanner, WRITE_TIMEOUT);
    }

    private void dropConnection(boolean sendBanner, long timeout) {
        try {
            this.unsetSelectedFolder(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!this.mSession.isConnected()) {
            return;
        }
        ZimbraLog.imap.debug("dropConnection: sendBanner = %s\n", sendBanner);
        this.cleanup();
        if (sendBanner && !this.mGoodbyeSent) {
            this.sendBYE();
        }
        MinaOutputStream out = (MinaOutputStream)this.mOutputStream;
        if (timeout >= 0L && out != null && !out.join(timeout)) {
            ZimbraLog.imap.warn("Force closing session because write timed out: " + this.mSession);
        }
        this.mSession.close();
    }

    public void dropConnection(long timeout) {
        this.dropConnection(true, timeout);
    }

    public void connectionClosed() {
        this.cleanup();
        this.mSession.close();
    }

    private void cleanup() {
        if (this.mRequest != null) {
            this.mRequest.cleanup();
            this.mRequest = null;
        }
        try {
            this.unsetSelectedFolder(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void connectionIdle() {
        this.notifyIdleConnection();
    }

    protected boolean setupConnection(Socket connection) {
        throw new UnsupportedOperationException();
    }

    protected boolean authenticate() {
        throw new UnsupportedOperationException();
    }

    protected void notifyIdleConnection() {
        ZimbraLog.imap.debug("dropping connection for inactivity");
        this.dropConnection();
    }

    protected void enableInactivityTimer() {
        this.mSession.setIdleTime(IdleStatus.BOTH_IDLE, 1800);
    }

    protected void completeAuthentication() throws IOException {
        if (this.mAuthenticator.isEncryptionEnabled()) {
            MinaServer.addSaslFilter(this.mSession, this.mAuthenticator.getSaslServer());
        }
        this.mAuthenticator.sendSuccess();
    }

    protected void flushOutput() throws IOException {
        this.mOutputStream.flush();
    }

    void sendLine(String line, boolean flush) throws IOException {
        MinaOutputStream out = (MinaOutputStream)this.mOutputStream;
        if (out != null) {
            out.write(line);
            out.write("\r\n");
            if (flush) {
                out.flush();
            }
        }
    }
}

