/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.localconfig.LC;
import com.zimbra.cs.imap.LiteralInfo;
import com.zimbra.cs.mina.LineBuffer;
import com.zimbra.cs.mina.MinaStats;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class MinaImapDecoder
extends ProtocolDecoderAdapter {
    private final MinaStats stats;
    private final LineBuffer buf = new LineBuffer();
    private int count = -1;
    private static final int MAX_BYTES = LC.nio_imap_max_chunk_size.intValue();

    MinaImapDecoder(MinaStats stats) {
        this.stats = stats;
    }

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) {
        java.nio.ByteBuffer bb = in.buf();
        while (bb.hasRemaining()) {
            if (this.count >= 0) {
                int len = Math.min(Math.min(bb.remaining(), this.count), MAX_BYTES);
                byte[] b = new byte[len];
                bb.get(b);
                out.write((Object)b);
                if (this.stats != null) {
                    this.stats.receivedBytes.addAndGet(len);
                }
                this.count -= len;
                if (this.count != 0) continue;
                this.count = -1;
                continue;
            }
            if (!this.buf.parse(bb)) continue;
            String line = this.buf.getLine();
            out.write((Object)line);
            if (this.stats != null) {
                this.stats.receivedBytes.addAndGet(this.buf.size());
            }
            this.buf.reset();
            try {
                LiteralInfo li = LiteralInfo.parse(line);
                if (li == null) continue;
                this.count = li.count;
            }
            catch (IllegalArgumentException e) {}
        }
    }
}

