/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

public class LiteralInfo {
    int count;
    boolean blocking;

    public static LiteralInfo parse(String line) {
        int i;
        if (line.endsWith("}") && (i = line.lastIndexOf(123)) >= 0) {
            LiteralInfo li = new LiteralInfo();
            String s = line.substring(i + 1, line.length() - 1);
            if (s.endsWith("+")) {
                s = s.substring(0, s.length() - 1);
            } else {
                li.blocking = true;
            }
            li.count = LiteralInfo.parseCount(s);
            if (li.count < 0) {
                throw new IllegalArgumentException("bad literal format");
            }
            return li;
        }
        return null;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    private static int parseCount(String s) {
        int n = 0;
        for (int i = 0; i < s.length(); ++i) {
            int d = Character.digit(s.charAt(i), 10);
            if (d == -1) {
                return -1;
            }
            if ((n = n * 10 + d) >= 0) continue;
            return -1;
        }
        return n;
    }
}

