/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.BlobBuilder;
import com.zimbra.cs.store.file.FileBlobStore;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

abstract class Literal {
    Literal() {
    }

    public static Literal newInstance(int size) throws IOException {
        return Literal.newInstance(size, false);
    }

    public static Literal newInstance(int size, boolean useBlob) throws IOException {
        return useBlob ? new BlobLiteral(size) : new ByteBufferLiteral(size);
    }

    public abstract int size();

    public abstract int remaining();

    public abstract int copy(InputStream var1) throws IOException;

    public abstract int put(byte[] var1, int var2, int var3) throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract byte[] getBytes() throws IOException;

    public abstract Blob getBlob() throws IOException, ServiceException;

    public abstract void cleanup();

    public int put(ByteBuffer bb) throws IOException {
        assert (bb.hasArray());
        int len = this.put(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        bb.position(bb.position() + len);
        return len;
    }

    protected void checkComplete() {
        if (this.remaining() > 0) {
            throw new IllegalStateException("Incomplete literal");
        }
    }

    private static IOException error(String msg, Throwable cause) {
        IOException e = new IOException(msg);
        e.initCause(cause);
        return e;
    }

    private static class BlobLiteral
    extends Literal {
        private BlobBuilder builder;

        BlobLiteral(int size) throws IOException {
            try {
                this.builder = FileBlobStore.getInstance().getBlobBuilder();
                this.builder.setSizeHint(size).init();
            }
            catch (ServiceException e) {
                throw Literal.error("Unable to initialize BlobBuilder", e);
            }
        }

        public int size() {
            return (int)this.builder.getSizeHint();
        }

        public int remaining() {
            return this.size() - (int)this.builder.getTotalBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getBytes() throws IOException {
            byte[] byArray;
            DataInputStream is = new DataInputStream(this.getInputStream());
            try {
                byte[] b = new byte[this.size()];
                is.readFully(b);
                assert (is.read() == -1);
                byArray = b;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
            ByteUtil.closeStream(is);
            return byArray;
        }

        public InputStream getInputStream() throws IOException {
            return this.getBlob().getInputStream();
        }

        public int put(byte[] b, int off, int len) throws IOException {
            if (len > this.remaining()) {
                len = this.remaining();
            }
            if (len > 0) {
                this.builder.append(b, off, len);
            }
            return len;
        }

        public int copy(InputStream is) throws IOException {
            int count = 0;
            if (this.remaining() > 0) {
                byte[] b = new byte[8192];
                do {
                    int len;
                    if ((len = is.read(b, 0, Math.min(b.length, this.remaining()))) < 0) {
                        throw new EOFException("Unexpected end of stream");
                    }
                    count += this.put(b, 0, len);
                } while (this.remaining() > 0 && is.available() > 0);
            }
            return count;
        }

        public Blob getBlob() throws IOException {
            this.checkComplete();
            try {
                return this.builder.finish();
            }
            catch (ServiceException e) {
                throw Literal.error("Unable to finalize BlobBuilder", e);
            }
        }

        public void cleanup() {
            if (this.builder != null) {
                this.builder.dispose();
                this.builder = null;
            }
        }
    }

    private static class ByteBufferLiteral
    extends Literal {
        private ByteBuffer buf;
        private Blob blob;

        ByteBufferLiteral(int size) {
            this.buf = ByteBuffer.allocate(size);
        }

        public int size() {
            return this.buf.capacity();
        }

        public int remaining() {
            return this.buf.capacity() - this.buf.position();
        }

        public byte[] getBytes() {
            this.checkComplete();
            return this.buf.array();
        }

        public InputStream getInputStream() {
            this.checkComplete();
            return new ByteArrayInputStream(this.buf.array());
        }

        public int copy(InputStream is) throws IOException {
            int count = is.read(this.buf.array(), this.buf.position(), this.remaining());
            if (count > 0) {
                this.buf.position(this.buf.position() + count);
            }
            return count;
        }

        public int put(byte[] b, int off, int len) {
            if (len > this.remaining()) {
                len = this.remaining();
            }
            this.buf.put(b, off, len);
            return len;
        }

        public Blob getBlob() throws IOException, ServiceException {
            return FileBlobStore.getInstance().storeIncoming(this.getInputStream(), this.size(), null);
        }

        public void cleanup() {
            this.buf = null;
            if (this.blob != null) {
                FileBlobStore.getInstance().quietDelete(this.blob);
                this.blob = null;
            }
        }
    }
}

