/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.imap.ImapCredentials;
import com.zimbra.cs.imap.ImapFolder;
import com.zimbra.cs.imap.ImapHandler;
import com.zimbra.cs.imap.ImapMessage;
import com.zimbra.cs.imap.ImapParseException;
import com.zimbra.cs.imap.ImapPartSpecifier;
import com.zimbra.cs.imap.ImapPath;
import com.zimbra.cs.imap.ImapRequest;
import com.zimbra.cs.imap.Literal;
import com.zimbra.cs.imap.TcpImapHandler;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.util.JMSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.mail.MessagingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImapURL {
    private String mURL;
    private String mUsername;
    private String mHostname;
    private short mPort;
    private ImapPath mPath;
    private int mUid;
    private ImapPartSpecifier mPart;

    ImapURL(String tag, ImapHandler handler, String url) throws ImapParseException {
        if (url == null || url.length() == 0) {
            throw new ImapUrlException(tag, url, "blank/null IMAP URL");
        }
        this.parse(tag, handler.getCredentials(), url);
        this.mURL = url;
        if (this.mPath == null || this.mPath.asZimbraPath().length() == 0) {
            if (handler.getState() != ImapHandler.State.SELECTED) {
                throw new ImapUrlException(tag, url, "IMAP URL must specify folder if session not SELECTED");
            }
            this.mPath = handler.getSelectedFolder().getPath();
        }
        if (this.mUsername == null || this.mUsername.length() == 0) {
            if (handler.getState() == ImapHandler.State.NOT_AUTHENTICATED) {
                throw new ImapUrlException(tag, url, "IMAP URL must specify user if session not AUTHENTICATED");
            }
            this.mUsername = handler.getCredentials().getUsername();
            if (this.mPath != null && this.mPath.getOwner() != null) {
                try {
                    Account owner = this.mPath.getOwnerAccount();
                    if (owner != null) {
                        this.mUsername = owner.getName();
                    }
                }
                catch (ServiceException e) {
                    throw new ImapUrlException(tag, url, "could not look up user: " + this.mPath.getOwner());
                }
            }
        }
        if (this.mHostname == null || this.mHostname.length() == 0) {
            try {
                Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, this.mUsername);
                if (acct == null) {
                    throw new ImapUrlException(tag, url, "unknown user: " + this.mUsername);
                }
                this.mHostname = acct.getAttr("zimbraMailHost");
            }
            catch (ServiceException e) {
                throw new ImapUrlException(tag, url, "could not look up user: " + this.mUsername);
            }
        }
    }

    String getURL() {
        return this.mURL;
    }

    private void parse(String tag, ImapCredentials creds, String url) throws ImapParseException {
        String section;
        String lcurl = url.toLowerCase();
        int pos = 0;
        if (url.length() > 7 && lcurl.startsWith("imap://")) {
            int colon;
            int slash = url.indexOf(47, pos += 7);
            int ampersand = url.indexOf(64, pos);
            if (slash == -1 || slash == pos) {
                throw new ImapUrlException(tag, url, "malformed IMAP URL");
            }
            if (ampersand != -1 && ampersand < slash) {
                int semicolon = url.indexOf(59, pos);
                this.mUsername = this.urlDecode(url.substring(pos, semicolon != -1 && semicolon < ampersand ? semicolon : ampersand));
                pos = ampersand + 1;
            }
            if ((colon = url.indexOf(58, pos)) != -1 && colon < slash) {
                try {
                    this.mPort = Short.parseShort(url.substring(colon + 1, slash));
                }
                catch (NumberFormatException nfe) {
                    throw new ImapUrlException(tag, url, "invalid port: " + url.substring(colon + 1, slash));
                }
            }
            this.mHostname = url.substring(pos, colon != -1 && colon < slash ? colon : slash);
            pos = slash + 1;
        } else if (url.charAt(0) != '/') {
            throw new ImapUrlException(tag, url, "relative IMAP URLs must begin with '/'");
        }
        int iuid = lcurl.indexOf("/;uid=", pos);
        int uvv = lcurl.indexOf(";uidvalidity=", pos);
        if (iuid == -1) {
            throw new ImapUrlException(tag, url, "only \"imessagepart\"-type IMAP URLs supported");
        }
        this.mPath = new ImapPath(this.urlDecode(url.substring(pos, uvv != -1 && uvv < iuid ? uvv : iuid)), creds);
        pos = iuid + 6;
        int isection = lcurl.indexOf("/;section=", pos);
        String uid = url.substring(pos, isection != -1 ? isection : url.length());
        try {
            this.mUid = Integer.parseInt(uid);
        }
        catch (NumberFormatException nfe) {
            throw new ImapUrlException(tag, url, "invalid uid in IMAP URL: " + uid);
        }
        if (isection != -1 && (section = this.urlDecode(url.substring(isection + 10))).length() > 0) {
            try {
                ParserImapRequest req = new ParserImapRequest(tag, section);
                this.mPart = req.readPartSpecifier(false, false);
                if (!req.eof()) {
                    throw new ImapUrlException(tag, url, "extra chars at end of IMAP URL SECTION");
                }
            }
            catch (ImapParseException ipe) {
                throw new ImapUrlException(tag, url, ipe.getMessage());
            }
            catch (IOException ioe) {
                throw new ImapUrlException(tag, url, ioe.getMessage());
            }
        }
    }

    private String urlDecode(String raw) {
        try {
            return URLDecoder.decode(raw, "utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            return raw;
        }
    }

    public byte[] getContent(ImapHandler handler, ImapCredentials creds, String tag) throws ImapParseException {
        Pair<Long, InputStream> content = this.getContentAsStream(handler, creds, tag);
        try {
            return ByteUtil.getContent(content.getSecond(), (int)Math.min(content.getFirst(), Integer.MAX_VALUE));
        }
        catch (IOException e) {
            ZimbraLog.imap.info((Object)"error reading content from IMAP URL", e);
            throw new ImapUrlException(tag, this.mURL, "error fetching IMAP URL content");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Long, InputStream> getContentAsStream(ImapHandler handler, ImapCredentials creds, String tag) throws ImapParseException {
        ImapHandler.State state = handler.getState();
        if (state == ImapHandler.State.NOT_AUTHENTICATED) {
            throw new ImapUrlException(tag, this.mURL, "must be in AUTHENTICATED state");
        }
        try {
            Mime.FixedMimeMessage mm;
            ImapFolder i4folder;
            Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, this.mUsername);
            if (acct == null) {
                throw new ImapUrlException(tag, this.mURL, "cannot find user: " + this.mUsername);
            }
            OperationContext octxt = creds.getContext().setSession(handler.getSelectedFolder());
            Pair<Long, InputStream> content = null;
            if (state == ImapHandler.State.SELECTED && (i4folder = handler.getSelectedFolder()) != null && acct.getId().equals(i4folder.getTargetAccountId()) && this.mPath.isEquivalent(i4folder.getPath())) {
                ImapMessage i4msg = i4folder.getByImapId(this.mUid);
                if (i4msg == null || i4msg.isExpunged()) {
                    throw new ImapUrlException(tag, this.mURL, "no such message");
                }
                MailItem item = i4folder.getMailbox().getItemById(octxt, i4msg.msgId, i4msg.getType());
                content = ImapMessage.getContent(item);
            }
            if (content == null && this.mPath.onLocalServer()) {
                Mailbox mbox = (Mailbox)this.mPath.getOwnerMailbox();
                MailItem item = mbox.getItemByImapId(octxt, this.mUid, this.mPath.asItemId().getId());
                if (!ImapMessage.SUPPORTED_TYPES.contains(item.getType())) {
                    throw new ImapUrlException(tag, this.mURL, "no such message");
                }
                content = ImapMessage.getContent(item);
            }
            if (content == null) {
                Account authacct = Provisioning.getInstance().get(Provisioning.AccountBy.id, creds.getAccountId());
                AuthToken auth = AuthProvider.getAuthToken(authacct, System.currentTimeMillis() + 60000L);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("imap_id", Integer.toString(this.mUid));
                UserServlet.HttpInputStream is = UserServlet.getRemoteContentAsStream(auth, acct, this.mPath.asResolvedPath(), params);
                content = new Pair<Long, UserServlet.HttpInputStream>(Long.valueOf(is.getContentLength()), is);
            }
            if (this.mPart == null) {
                return content;
            }
            try {
                mm = new Mime.FixedMimeMessage(JMSession.getSession(), (InputStream)content.getSecond());
                Object var13_17 = null;
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                ((InputStream)content.getSecond()).close();
                throw throwable;
            }
            ((InputStream)content.getSecond()).close();
            Pair<Long, InputStream> part = this.mPart.getContent((Object)mm);
            if (part == null) {
                throw new ImapUrlException(tag, this.mURL, "no such part");
            }
            return part;
        }
        catch (MailServiceException.NoSuchItemException e) {
            ZimbraLog.imap.info((Object)"no such message", e);
        }
        catch (ServiceException e) {
            ZimbraLog.imap.info((Object)"can't fetch content from IMAP URL", e);
        }
        catch (MessagingException e) {
            ZimbraLog.imap.info((Object)"can't fetch content from IMAP URL", e);
        }
        catch (IOException e) {
            ZimbraLog.imap.info((Object)"error reading content from IMAP URL", e);
        }
        catch (ImapPartSpecifier.BinaryDecodingException e) {
            ZimbraLog.imap.info((Object)"can't fetch content from IMAP URL", e);
        }
        throw new ImapUrlException(tag, this.mURL, "error fetching IMAP URL content");
    }

    public String toString() {
        try {
            return "imap://" + URLEncoder.encode(this.mUsername, "utf-8") + '@' + this.mHostname + (this.mPort > 0 ? ":" + this.mPort : "") + '/' + URLEncoder.encode(this.mPath.asImapPath(), "utf-8") + "/;UID=" + this.mUid + (this.mPart != null ? "/;SECTION=" + URLEncoder.encode(this.mPart.getSectionSpec(), "utf-8") : "");
        }
        catch (UnsupportedEncodingException e) {
            return "imap://" + this.mUsername + '@' + this.mHostname + (this.mPort > 0 ? ":" + this.mPort : "") + '/' + this.mPath + "/;UID=" + this.mUid + (this.mPart != null ? "/;SECTION=" + this.mPart.getSectionSpec() : "");
        }
    }

    public static void main(String[] args) throws ImapParseException, ServiceException, IOException {
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, "user1@macbeth.liquidsys.com");
        TcpImapHandler handler = new TcpImapHandler(null);
        ImapCredentials creds = new ImapCredentials(acct, ImapCredentials.EnabledHack.NONE);
        handler.setSelectedFolder(new ImapFolder(new ImapPath("trash", creds), 0, handler, creds));
        System.out.println(new ImapURL("tag", handler, "/Drafts;UIDVALIDITY=385759045/;UID=20/;section=HEADER"));
        System.out.println(new ImapURL("tag", handler, "/;UID=20/;section=1.mime"));
        System.out.println(new ImapURL("tag", handler, "/INBOX;UIDVALIDITY=785799047/;UID=113330/;section=1.5.9"));
        System.out.println(new ImapURL("tag", handler, "imap://minbari.org:7143/\\\"gray-council\\\";UIDVALIDITY=385759045/;UID=20"));
        System.out.println(new ImapURL("tag", handler, "imap://bester;auth=gssapi@psicorp.org/~peter/%E6%97%A5%E6%9C%AC%E8%AA%9E/%E5%8F%B0%E5%8C%97/;UID=11916"));
        System.out.println(new ImapURL("tag", handler, "imap://;AUTH=*@minbari.org/gray-council/;uid=20/;section="));
        System.out.println(new ImapUrlException((String)"tag", (String)"\"\\\"", (String)"msg").mCode);
    }

    private static class ParserImapRequest
    extends ImapRequest {
        public ParserImapRequest(String tag, String section) {
            super(null);
            this.mTag = tag;
            this.addPart(section);
        }

        private Literal getNextBuffer() throws ImapParseException {
            if (this.mIndex + 1 >= this.mParts.size()) {
                throw new ImapParseException(this.mTag, "no next literal");
            }
            Literal literal = ((ImapRequest.Part)this.mParts.get(this.mIndex + 1)).getLiteral();
            this.mIndex += 2;
            this.mOffset = 0;
            return literal;
        }

        Literal readLiteral() throws ImapParseException {
            return this.getNextBuffer();
        }
    }

    private static class ImapUrlException
    extends ImapParseException {
        private static final long serialVersionUID = 174398702563521440L;

        ImapUrlException(String tag, String url, String message) {
            super(tag, "BADURL \"" + url.replace("\\", "\\\\").replace("\"", "\\\"") + '\"', "APPEND failed: " + message, false);
        }
    }
}

