/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.service.ServiceException;

public class ImapServiceException
extends ServiceException {
    private static final long serialVersionUID = -8493068960356614305L;
    public static final String CANT_DELETE_SYSTEM_FOLDER = "imap.CANNOT_DELETE_SYSTEM_FOLDER";
    public static final String CANT_RENAME_INBOX = "imap.CANNOT_RENAME_INBOX";
    public static final String FOLDER_NOT_VISIBLE = "imap.FOLDER_NOT_VISIBLE";
    public static final String FOLDER_NOT_WRITABLE = "imap.FOLDER_NOT_WRITABLE";
    public static final String FOLDER_NAME = "folderName";

    private ImapServiceException(String message, String code, boolean isReceiversFault, ServiceException.Argument ... args) {
        super(message, code, isReceiversFault, args);
    }

    public static ImapServiceException CANNOT_DELETE_SYSTEM_FOLDER(String folderName) {
        return new ImapServiceException("cannot delete system folder: ", CANT_DELETE_SYSTEM_FOLDER, false, new ServiceException.Argument(FOLDER_NAME, folderName, ServiceException.Argument.Type.STR));
    }

    public static ImapServiceException CANT_RENAME_INBOX() {
        return new ImapServiceException("Rename of INBOX not supported", CANT_RENAME_INBOX, false, new ServiceException.Argument[0]);
    }

    public static ImapServiceException FOLDER_NOT_VISIBLE(String folderName) {
        return new ImapServiceException("folder not visible: ", FOLDER_NOT_VISIBLE, false, new ServiceException.Argument(FOLDER_NAME, folderName, ServiceException.Argument.Type.STR));
    }

    public static ImapServiceException FOLDER_NOT_WRITABLE(String folderName) {
        return new ImapServiceException("folder is READ-ONLY: ", FOLDER_NOT_WRITABLE, false, new ServiceException.Argument(FOLDER_NAME, folderName, ServiceException.Argument.Type.STR));
    }
}

