/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.stats.RealtimeStatsCallback;
import com.zimbra.common.util.NetUtil;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.imap.ImapConfig;
import com.zimbra.cs.imap.MinaImapServer;
import com.zimbra.cs.imap.TcpImapHandler;
import com.zimbra.cs.mina.MinaThreadFactory;
import com.zimbra.cs.server.Server;
import com.zimbra.cs.stats.ZimbraPerf;
import com.zimbra.cs.tcpserver.ProtocolHandler;
import com.zimbra.cs.tcpserver.TcpServer;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapServer
extends TcpServer
implements RealtimeStatsCallback {
    private static Server sImapServer;
    private static Server sImapSSLServer;
    private static final String HANDLER_THREAD_NAME = "ImapHandler";
    private static ExecutorService sHandlerThreadPool;

    private ImapServer(ImapConfig config) throws ServiceException {
        super(config.isSSLEnabled() ? "ImapSSLServer" : "ImapServer", config);
        ZimbraPerf.addStatsCallback(this);
    }

    @Override
    protected ProtocolHandler newProtocolHandler() {
        return new TcpImapHandler(this);
    }

    public static void bindServerSocket(String addr, int port, boolean ssl) throws IOException {
        NetUtil.bindServerSocket(addr, port, ssl, MinaImapServer.isEnabled(), null);
    }

    public static synchronized void startupImapServer() throws ServiceException {
        if (sImapServer == null) {
            sImapServer = ImapServer.startServer(false);
        }
    }

    public static synchronized void startupImapSSLServer() throws ServiceException {
        if (sImapSSLServer == null) {
            sImapSSLServer = ImapServer.startServer(true);
        }
    }

    private static Server startServer(boolean ssl) throws ServiceException {
        Server server;
        ImapConfig config = new ImapConfig(Provisioning.getInstance(), ssl);
        if (MinaImapServer.isEnabled()) {
            if (sHandlerThreadPool == null) {
                sHandlerThreadPool = ImapServer.newHandlerThreadPool(config);
            }
            try {
                server = new MinaImapServer(config, sHandlerThreadPool);
            }
            catch (IOException e) {
                Zimbra.halt("failed to start MinaImapServer", e);
                return null;
            }
        } else {
            server = new ImapServer(config);
        }
        try {
            server.start();
        }
        catch (IOException e) {
            Zimbra.halt("failed to start ImapSSLServer", e);
            return null;
        }
        return server;
    }

    private static ThreadPoolExecutor newHandlerThreadPool(ImapConfig config) {
        return new ThreadPoolExecutor(Math.min(config.getNumThreads(), LC.nio_imap_min_threads.intValue()), config.getNumThreads(), (long)LC.nio_imap_thread_keep_alive_time.intValue(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new MinaThreadFactory(HANDLER_THREAD_NAME));
    }

    public static synchronized void shutdownImapServers() {
        if (sImapServer != null) {
            sImapServer.shutdown(10);
            sImapServer = null;
        }
        if (sImapSSLServer != null) {
            sImapSSLServer.shutdown(10);
            sImapSSLServer = null;
        }
    }

    @Override
    public Map<String, Object> getStatData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String statName = this.getConfig().isSSLEnabled() ? "imap_ssl_conn" : "imap_conn";
        data.put(statName, this.numActiveHandlers());
        return data;
    }
}

