/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.cs.imap.ImapFlagCache;
import com.zimbra.cs.imap.ImapFolder;
import com.zimbra.cs.imap.ImapMessage;
import com.zimbra.cs.imap.ImapParseException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ImapSearch {
    ImapSearch() {
    }

    abstract boolean canBeRunLocally();

    abstract String toZimbraSearch(ImapFolder var1) throws ImapParseException;

    abstract ImapMessage.ImapMessageSet evaluate(ImapFolder var1) throws ImapParseException;

    boolean requiresMODSEQ() {
        return false;
    }

    static boolean isAllMessages(ImapFolder i4folder, Set<ImapMessage> i4set) {
        int size = i4set.size() - (i4set.contains(null) ? 1 : 0);
        return size == i4folder.getSize();
    }

    static String sequenceAsSearchTerm(ImapFolder i4folder, TreeSet<ImapMessage> i4set, boolean abbreviateAll) {
        i4set.remove(null);
        if (i4set.isEmpty()) {
            return "item:none";
        }
        if (abbreviateAll && ImapSearch.isAllMessages(i4folder, i4set)) {
            return "item:all";
        }
        StringBuilder sb = new StringBuilder("item:{");
        for (ImapMessage i4msg : i4set) {
            sb.append(sb.length() == 6 ? "" : ",").append(i4msg.msgId);
        }
        return sb.append('}').toString();
    }

    static String stringAsSearchTerm(String content) {
        return ImapSearch.stringAsSearchTerm(content, true);
    }

    static String stringAsSearchTerm(String content, boolean wildcard) {
        content = content.replace('*', ' ').replace('\"', ' ');
        if (wildcard && (content.length() == 0 || !Character.isWhitespace(content.charAt(content.length() - 1)))) {
            content = content + '*';
        }
        return '\"' + content + '\"';
    }

    static class HeaderSearch
    extends ImapSearch {
        private Header mHeader;
        private String mValue;
        private boolean mPrefixSearch = true;

        HeaderSearch(Header header, String value) {
            while (value.startsWith("<") || value.startsWith(">") || value.startsWith("=")) {
                value = value.substring(1);
            }
            if (header == Header.MSGID && value.endsWith(">")) {
                value = value.substring(0, value.length() - 1);
                this.mPrefixSearch = false;
            }
            this.mValue = value;
            this.mHeader = header;
        }

        boolean canBeRunLocally() {
            return false;
        }

        String toZimbraSearch(ImapFolder i4folder) {
            String value = HeaderSearch.stringAsSearchTerm(this.mValue, this.mPrefixSearch);
            if ((this.mHeader == Header.FROM || this.mHeader == Header.TO || this.mHeader == Header.CC) && this.mValue.indexOf(64) == -1) {
                value = value + " or " + HeaderSearch.stringAsSearchTerm('@' + this.mValue);
            }
            return this.mHeader + ":(" + value + ")";
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) {
            throw new UnsupportedOperationException("evaluate of " + this.toZimbraSearch(i4folder));
        }

        static class Header {
            static final Header SUBJECT = new Header("subject", "subject");
            static final Header FROM = new Header("from", "from");
            static final Header TO = new Header("to", "to");
            static final Header CC = new Header("cc", "cc");
            static final Header BCC = new Header("bcc", "#bcc");
            static final Header MSGID = new Header("message-id", "msgid");
            private static final Header[] SPECIAL_HEADERS = new Header[]{SUBJECT, FROM, TO, CC, BCC, MSGID};
            private final String mField;
            private final String mKey;

            private Header(String fieldName, String searchKey) {
                this.mField = fieldName;
                this.mKey = searchKey;
            }

            static Header parse(String field) {
                field = field.toLowerCase();
                for (Header syshdr : SPECIAL_HEADERS) {
                    if (!field.equals(syshdr.mField)) continue;
                    return syshdr;
                }
                String key = field.replaceAll("[ \t\":()]", "");
                while (key.startsWith("-")) {
                    key = key.substring(1);
                }
                if (key.equals("")) {
                    key = "*";
                }
                return new Header(field, '#' + key);
            }

            public String toString() {
                return this.mKey;
            }
        }
    }

    static class ContentSearch
    extends ImapSearch {
        private String mValue;

        ContentSearch(String value) {
            this.mValue = value;
        }

        boolean canBeRunLocally() {
            return this.mValue.trim().equals("");
        }

        String toZimbraSearch(ImapFolder i4folder) {
            return ContentSearch.stringAsSearchTerm(this.mValue);
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) {
            if (this.canBeRunLocally()) {
                return i4folder.getAllMessages();
            }
            throw new UnsupportedOperationException("evaluate of " + this.toZimbraSearch(i4folder));
        }
    }

    static class SizeSearch
    extends ImapSearch {
        private Relation mRelation;
        private long mSize;

        SizeSearch(Relation relation, long size) {
            this.mSize = size;
            this.mRelation = relation;
        }

        boolean canBeRunLocally() {
            return false;
        }

        String toZimbraSearch(ImapFolder i4folder) {
            return (Object)((Object)this.mRelation) + ":" + this.mSize;
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) {
            throw new UnsupportedOperationException("evaluate of " + this.toZimbraSearch(i4folder));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Relation {
            larger,
            smaller;

        }
    }

    static class ModifiedSearch
    extends ImapSearch {
        private int mChangedSince;

        ModifiedSearch(int changeId) {
            this.mChangedSince = changeId;
        }

        boolean requiresMODSEQ() {
            return true;
        }

        boolean canBeRunLocally() {
            return false;
        }

        String toZimbraSearch(ImapFolder i4folder) {
            ImapFlagCache i4cache = i4folder.getTagset();
            StringBuilder query = new StringBuilder("(modseq:>").append(this.mChangedSince);
            if (i4cache.getMaximumModseq() > this.mChangedSince) {
                for (ImapFlagCache.ImapFlag i4flag : i4cache) {
                    if (i4flag.mModseq <= this.mChangedSince) continue;
                    query.append(" or tag:").append(i4flag.mName);
                }
            }
            return query.append(')').toString();
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) {
            throw new UnsupportedOperationException("evaluate of " + this.toZimbraSearch(i4folder));
        }
    }

    static class RelativeDateSearch
    extends ImapSearch {
        private DateSearch.Relation mRelation;
        private int mOffset;

        RelativeDateSearch(DateSearch.Relation relation, int offset) {
            this.mOffset = offset;
            this.mRelation = relation;
        }

        boolean canBeRunLocally() {
            return false;
        }

        String toZimbraSearch(ImapFolder i4folder) {
            return this.mRelation.toString() + (System.currentTimeMillis() - (long)this.mOffset * 1000L);
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) {
            throw new UnsupportedOperationException("evaluate of " + this.toZimbraSearch(i4folder));
        }
    }

    static class DateSearch
    extends ImapSearch {
        private Relation mRelation;
        private Date mDate;
        private long mTimestamp;

        DateSearch(Relation relation, Date date) {
            this.mDate = date;
            this.mTimestamp = date.getTime();
            this.mRelation = relation;
        }

        boolean canBeRunLocally() {
            return this.mTimestamp < 0L || this.mTimestamp > System.currentTimeMillis() + 96422400000L;
        }

        String toZimbraSearch(ImapFolder i4folder) {
            if (this.mTimestamp < 0L) {
                return this.mRelation == Relation.after ? "item:all" : "item:none";
            }
            if (this.mTimestamp > System.currentTimeMillis() + 96422400000L) {
                return this.mRelation == Relation.before ? "item:all" : "item:none";
            }
            return (Object)((Object)this.mRelation) + DateFormat.getDateInstance(3).format(this.mDate);
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) {
            if (this.mTimestamp < 0L) {
                return this.mRelation == Relation.after ? i4folder.getAllMessages() : new ImapMessage.ImapMessageSet();
            }
            if (this.mTimestamp > System.currentTimeMillis() + 96422400000L) {
                return this.mRelation == Relation.before ? i4folder.getAllMessages() : new ImapMessage.ImapMessageSet();
            }
            throw new UnsupportedOperationException("evaluate of " + this.toZimbraSearch(i4folder));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Relation {
            before("before:"),
            after("date:>="),
            date("date:");

            String query;

            private Relation(String rep) {
                this.query = rep;
            }

            public String toString() {
                return this.query;
            }
        }
    }

    static class FlagSearch
    extends ImapSearch {
        private String mFlagName;

        FlagSearch(String flagName) {
            this.mFlagName = flagName;
        }

        boolean canBeRunLocally() {
            return true;
        }

        String toZimbraSearch(ImapFolder i4folder) {
            String suffix;
            ImapFlagCache.ImapFlag i4flag = i4folder.getFlagByName(this.mFlagName);
            if (i4flag == null) {
                return "item:none";
            }
            String prefix = i4flag.mPositive ? "" : "(-";
            String string = suffix = i4flag.mPositive ? "" : ")";
            if (i4flag.mPermanent) {
                return prefix + "tag:" + i4flag.mName + suffix;
            }
            return prefix + FlagSearch.sequenceAsSearchTerm(i4folder, i4folder.getFlaggedMessages(i4flag), true) + suffix;
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) {
            ImapFlagCache.ImapFlag i4flag = i4folder.getFlagByName(this.mFlagName);
            if (i4flag == null) {
                return new ImapMessage.ImapMessageSet();
            }
            if (i4flag.mPositive) {
                return i4folder.getFlaggedMessages(i4flag);
            }
            ImapMessage.ImapMessageSet matched = i4folder.getAllMessages();
            matched.removeAll(i4folder.getFlaggedMessages(i4flag));
            return matched;
        }
    }

    static class SequenceSearch
    extends ImapSearch {
        private String mTag;
        private String mSubSequence;
        private boolean mIsUidSearch;

        SequenceSearch(String tag, String subSequence, boolean byUID) {
            this.mTag = tag;
            this.mSubSequence = subSequence;
            this.mIsUidSearch = byUID;
        }

        boolean canBeRunLocally() {
            return true;
        }

        String toZimbraSearch(ImapFolder i4folder) throws ImapParseException {
            return SequenceSearch.sequenceAsSearchTerm(i4folder, this.evaluate(i4folder), true);
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) throws ImapParseException {
            return i4folder.getSubsequence(this.mTag, this.mSubSequence, this.mIsUidSearch, true);
        }
    }

    static class NoneSearch
    extends ImapSearch {
        NoneSearch() {
        }

        boolean canBeRunLocally() {
            return true;
        }

        String toZimbraSearch(ImapFolder i4folder) {
            return "item:none";
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) {
            return new ImapMessage.ImapMessageSet();
        }
    }

    static class AllSearch
    extends ImapSearch {
        AllSearch() {
        }

        boolean canBeRunLocally() {
            return true;
        }

        String toZimbraSearch(ImapFolder i4folder) {
            return "item:all";
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) {
            return i4folder.getAllMessages();
        }
    }

    static class NotOperation
    extends LogicalOperation {
        NotOperation() {
        }

        NotOperation(ImapSearch child) {
            this.addChild(child);
        }

        String toZimbraSearch(ImapFolder i4folder) throws ImapParseException {
            return '-' + ((ImapSearch)this.mChildren.get(0)).toZimbraSearch(i4folder);
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) throws ImapParseException {
            ImapMessage.ImapMessageSet matches = i4folder.getAllMessages();
            matches.removeAll(((ImapSearch)this.mChildren.get(0)).evaluate(i4folder));
            return matches;
        }
    }

    static class OrOperation
    extends LogicalOperation {
        OrOperation(ImapSearch ... children) {
            for (ImapSearch i4search : children) {
                this.addChild(i4search);
            }
        }

        String toZimbraSearch(ImapFolder i4folder) throws ImapParseException {
            StringBuilder search = new StringBuilder("(");
            for (ImapSearch i4search : this.mChildren) {
                search.append(search.length() == 1 ? "(" : " or (").append(i4search.toZimbraSearch(i4folder)).append(')');
            }
            return search.append(')').toString();
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) throws ImapParseException {
            ImapMessage.ImapMessageSet matched = null;
            for (ImapSearch i4search : this.mChildren) {
                if (matched == null) {
                    matched = i4search.evaluate(i4folder);
                } else {
                    matched.addAll(i4search.evaluate(i4folder));
                }
                if (!OrOperation.isAllMessages(i4folder, matched)) continue;
                break;
            }
            return matched;
        }
    }

    static class AndOperation
    extends LogicalOperation {
        AndOperation(ImapSearch ... children) {
            for (ImapSearch i4search : children) {
                this.addChild(i4search);
            }
        }

        String toZimbraSearch(ImapFolder i4folder) throws ImapParseException {
            StringBuilder search = new StringBuilder("(");
            for (ImapSearch i4search : this.mChildren) {
                search.append(search.length() == 1 ? "" : " ").append(i4search.toZimbraSearch(i4folder));
            }
            return search.append(')').toString();
        }

        ImapMessage.ImapMessageSet evaluate(ImapFolder i4folder) throws ImapParseException {
            ImapMessage.ImapMessageSet matched = null;
            for (ImapSearch i4search : this.mChildren) {
                if (matched == null) {
                    matched = i4search.evaluate(i4folder);
                } else {
                    matched.retainAll(i4search.evaluate(i4folder));
                }
                if (!matched.isEmpty()) continue;
                break;
            }
            return matched;
        }
    }

    static abstract class LogicalOperation
    extends ImapSearch {
        List<ImapSearch> mChildren = new ArrayList<ImapSearch>();

        LogicalOperation() {
        }

        LogicalOperation addChild(ImapSearch i4search) {
            this.mChildren.add(i4search);
            return this;
        }

        boolean canBeRunLocally() {
            for (ImapSearch i4search : this.mChildren) {
                if (i4search.canBeRunLocally()) continue;
                return false;
            }
            return true;
        }

        boolean requiresMODSEQ() {
            for (ImapSearch i4search : this.mChildren) {
                if (!i4search.requiresMODSEQ()) continue;
                return true;
            }
            return false;
        }
    }
}

