/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.imap.ImapHandler;
import com.zimbra.cs.imap.ImapParseException;
import com.zimbra.cs.imap.ImapPartSpecifier;
import com.zimbra.cs.imap.ImapPath;
import com.zimbra.cs.imap.ImapSearch;
import com.zimbra.cs.imap.Literal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ImapRequest {
    private static final boolean[] TAG_CHARS;
    private static final boolean[] ATOM_CHARS;
    private static final boolean[] ASTRING_CHARS;
    private static final boolean[] PATTERN_CHARS;
    private static final boolean[] FETCH_CHARS;
    private static final boolean[] NUMBER_CHARS;
    private static final boolean[] SEQUENCE_CHARS;
    private static final boolean[] BASE64_CHARS;
    private static final boolean[] SEARCH_CHARS;
    final ImapHandler mHandler;
    String mTag;
    List<Part> mParts = new ArrayList<Part>();
    int mIndex;
    int mOffset;
    private long mSize;
    private boolean mMaxRequestSizeExceeded;
    private boolean mIsAppend;
    private boolean mIsLogin;
    static final boolean NONZERO = false;
    static final boolean ZERO_OK = true;
    private static final int LAST_PUNCT = 0;
    private static final int LAST_DIGIT = 1;
    private static final int LAST_STAR = 2;
    private static Set<String> SYSTEM_FLAGS;
    private static final Map<String, Integer> MONTH_NUMBER;
    private static final Map<String, String> NEGATED_SEARCH;
    private static final boolean SINGLE_CLAUSE = true;
    private static final boolean MULTIPLE_CLAUSES = false;
    private static final String SUBCLAUSE = "";

    ImapRequest(ImapHandler handler) {
        this.mHandler = handler;
    }

    ImapRequest rewind() {
        this.mOffset = 0;
        this.mIndex = 0;
        return this;
    }

    void incrementSize(long increment) {
        this.mSize += increment;
        if (this.mSize > (long)this.getMaxRequestSize()) {
            this.mMaxRequestSizeExceeded = true;
        }
    }

    long getSize() {
        return this.mSize;
    }

    int getMaxRequestSize() {
        return this.mHandler.getConfig().getMaxRequestSize();
    }

    void addPart(Literal literal) {
        this.addPart(new LiteralPart(literal));
    }

    void addPart(String line) {
        if (this.mParts.isEmpty()) {
            String cmd = this.getCommand(line);
            if ("APPEND".equalsIgnoreCase(cmd)) {
                this.mIsAppend = true;
            } else if ("LOGIN".equalsIgnoreCase(cmd)) {
                this.mIsLogin = true;
            }
        }
        this.addPart(new StringPart(line));
    }

    private void addPart(Part part) {
        if (!this.isMaxRequestSizeExceeded() || this.mParts.isEmpty()) {
            this.mParts.add(part);
        }
    }

    void cleanup() {
        for (Part part : this.mParts) {
            part.cleanup();
        }
        this.mParts.clear();
    }

    protected boolean isAppend() {
        return this.mIsAppend;
    }

    protected boolean isLogin() {
        return this.mIsLogin;
    }

    protected String getCommand(String requestLine) {
        int j;
        int i = requestLine.indexOf(32) + 1;
        if (i > 0 && (j = requestLine.indexOf(32, i)) > 0) {
            return requestLine.substring(i, j);
        }
        return null;
    }

    String getCurrentLine() throws ImapParseException {
        return this.mParts.get(this.mIndex).getString();
    }

    boolean isMaxRequestSizeExceeded() {
        return this.mMaxRequestSizeExceeded;
    }

    byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Part part : this.mParts) {
            byte[] content = part.getBytes();
            baos.write(content, 0, content.length);
            if (!part.isString()) continue;
            baos.write(ImapHandler.LINE_SEPARATOR_BYTES, 0, 2);
        }
        return baos.toByteArray();
    }

    String getTag() {
        if (this.mTag == null && this.mIndex == 0 && this.mOffset == 0 && this.mParts.size() > 0) {
            try {
                this.readTag();
            }
            catch (ImapParseException imapParseException) {
                // empty catch block
            }
            this.mIndex = 0;
            this.mOffset = 0;
        }
        return this.mTag;
    }

    boolean extensionEnabled(String extension) {
        return this.mHandler == null || this.mHandler.extensionEnabled(extension);
    }

    void setTag(String tag) {
        this.mTag = tag;
    }

    String readContent(boolean[] acceptable) throws ImapParseException {
        return this.readContent(acceptable, false);
    }

    String readContent(boolean[] acceptable, boolean emptyOK) throws ImapParseException {
        char c;
        int i;
        String content = this.getCurrentLine();
        for (i = this.mOffset; i < content.length() && (c = content.charAt(i)) <= '\u007f' && acceptable[c]; ++i) {
        }
        if (i == this.mOffset && !emptyOK) {
            throw new ImapParseException(this.mTag, "zero-length content");
        }
        String result = content.substring(this.mOffset, i);
        this.mOffset += result.length();
        return result;
    }

    boolean eof() {
        return this.mIndex >= this.mParts.size() || this.mOffset >= this.mParts.get(this.mIndex).size();
    }

    int peekChar() throws ImapParseException {
        if (this.mIndex >= this.mParts.size()) {
            return -1;
        }
        String str = this.mParts.get(this.mIndex).getString();
        return this.mOffset < str.length() ? (int)str.charAt(this.mOffset) : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String peekATOM() {
        int index = this.mIndex;
        int offset = this.mOffset;
        try {
            String string = this.readATOM();
            Object var6_5 = null;
            this.mIndex = index;
            this.mOffset = offset;
            return string;
        }
        catch (ImapParseException ipe) {
            try {
                String string = null;
                Object var6_6 = null;
                this.mIndex = index;
                this.mOffset = offset;
                return string;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.mIndex = index;
                this.mOffset = offset;
                throw throwable;
            }
        }
    }

    void skipSpace() throws ImapParseException {
        this.skipChar(' ');
    }

    void skipChar(char c) throws ImapParseException {
        String str = this.mParts.get(this.mIndex).getString();
        if (this.mOffset >= str.length()) {
            throw new ImapParseException(this.mTag, "unexpected end of line; expected '" + c + "'");
        }
        char got = str.charAt(this.mOffset);
        if (got == c) {
            ++this.mOffset;
        } else {
            throw new ImapParseException(this.mTag, "wrong character; expected '" + c + "' but got '" + got + "'");
        }
    }

    void skipNIL() throws ImapParseException {
        this.skipAtom("NIL");
    }

    void skipAtom(String atom) throws ImapParseException {
        if (!this.readATOM().equals(atom)) {
            throw new ImapParseException(this.mTag, "did not find expected " + atom);
        }
    }

    String readAtom() throws ImapParseException {
        return this.readContent(ATOM_CHARS);
    }

    String readATOM() throws ImapParseException {
        return this.readContent(ATOM_CHARS).toUpperCase();
    }

    String readQuoted() throws ImapParseException {
        String content = this.getCurrentLine();
        StringBuffer result = null;
        this.skipChar('\"');
        int backslash = this.mOffset - 1;
        boolean escaped = false;
        for (int i = this.mOffset; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c > '\u007f' || c == '\u0000' || c == '\r' || c == '\n' || escaped && c != '\\' && c != '\"') {
                throw new ImapParseException(this.mTag, "illegal character '" + c + "' in quoted string");
            }
            if (!escaped && c == '\\') {
                if (result == null) {
                    result = new StringBuffer();
                }
                result.append(content.substring(backslash + 1, i));
                backslash = i;
                escaped = true;
                continue;
            }
            if (!escaped && c == '\"') {
                this.mOffset = i + 1;
                String range = content.substring(backslash + 1, i);
                return result == null ? range : result.append(range).toString();
            }
            escaped = false;
        }
        throw new ImapParseException(this.mTag, "unexpected end of line in quoted string");
    }

    abstract Literal readLiteral() throws IOException, ImapParseException;

    private String readLiteral(String charset) throws IOException, ImapParseException {
        try {
            return new String(this.readLiteral().getBytes(), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new ImapParseException(this.mTag, "BADCHARSET", "could not convert string to charset \"" + charset + '\"', true);
        }
    }

    Literal readLiteral8() throws IOException, ImapParseException {
        if (this.peekChar() == 126 && this.extensionEnabled("BINARY")) {
            this.skipChar('~');
        }
        return this.readLiteral();
    }

    String readAstring() throws IOException, ImapParseException {
        return this.readAstring(null);
    }

    String readAstring(String charset) throws IOException, ImapParseException {
        return this.readAstring(charset, ASTRING_CHARS);
    }

    private String readAstring(String charset, boolean[] acceptable) throws IOException, ImapParseException {
        int c = this.peekChar();
        if (c == -1) {
            throw new ImapParseException(this.mTag, "unexpected end of line");
        }
        if (c == 123) {
            return this.readLiteral(charset != null ? charset : "utf-8");
        }
        if (c != 34) {
            return this.readContent(acceptable);
        }
        return this.readQuoted();
    }

    private String readAquoted() throws ImapParseException {
        int c = this.peekChar();
        if (c == -1) {
            throw new ImapParseException(this.mTag, "unexpected end of line");
        }
        if (c != 34) {
            return this.readContent(ASTRING_CHARS);
        }
        return this.readQuoted();
    }

    private String readString(String charset) throws IOException, ImapParseException {
        int c = this.peekChar();
        if (c == -1) {
            throw new ImapParseException(this.mTag, "unexpected end of line");
        }
        if (c == 123) {
            return this.readLiteral(charset != null ? charset : "utf-8");
        }
        return this.readQuoted();
    }

    private String readNstring(String charset) throws IOException, ImapParseException {
        int c = this.peekChar();
        if (c == -1) {
            throw new ImapParseException(this.mTag, "unexpected end of line");
        }
        if (c == 123) {
            return this.readLiteral(charset != null ? charset : "utf-8");
        }
        if (c != 34) {
            this.skipNIL();
            return null;
        }
        return this.readQuoted();
    }

    String readTag() throws ImapParseException {
        this.mTag = this.readContent(TAG_CHARS);
        return this.mTag;
    }

    String readNumber() throws ImapParseException {
        return this.readNumber(true);
    }

    String readNumber(boolean zeroOK) throws ImapParseException {
        String number = this.readContent(NUMBER_CHARS);
        if (number.startsWith("0") && (!zeroOK || number.length() > 1)) {
            throw new ImapParseException(this.mTag, "invalid number: " + number);
        }
        return number;
    }

    int parseInteger(String number) throws ImapParseException {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException nfe) {
            throw new ImapParseException(this.mTag, "number out of range: " + number);
        }
    }

    long parseLong(String number) throws ImapParseException {
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException nfe) {
            throw new ImapParseException(this.mTag, "number out of range: " + number);
        }
    }

    byte[] readBase64(boolean skipEquals) throws ImapParseException {
        if (skipEquals && this.peekChar() == 61) {
            this.skipChar('=');
            return null;
        }
        String encoded = this.readContent(BASE64_CHARS, true);
        int padding = (4 - encoded.length() % 4) % 4;
        if (padding == 3) {
            throw new ImapParseException(this.mTag, "invalid base64-encoded content");
        }
        while (padding-- > 0) {
            this.skipChar('=');
            encoded = encoded + "=";
        }
        try {
            return new Base64().decode(encoded.getBytes("us-ascii"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ImapParseException(this.mTag, "invalid base64-encoded content");
        }
    }

    String readSequence(boolean specialsOK) throws ImapParseException {
        return this.validateSequence(this.readContent(SEQUENCE_CHARS), specialsOK);
    }

    String readSequence() throws ImapParseException {
        return this.validateSequence(this.readContent(SEQUENCE_CHARS), true);
    }

    private String validateSequence(String value, boolean specialsOK) throws ImapParseException {
        if (value.equals("$") && specialsOK && this.extensionEnabled("X-DRAFT-I05-SEARCHRES")) {
            return value;
        }
        int last = 0;
        boolean colon = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c > '\u007f' || c == '$' || !SEQUENCE_CHARS[c] || c == '*' && !specialsOK) {
                throw new ImapParseException(this.mTag, "illegal character '" + c + "' in sequence");
            }
            if (c == '*') {
                if (last == 1) {
                    throw new ImapParseException(this.mTag, "malformed sequence");
                }
                last = 2;
                continue;
            }
            if (c == ',') {
                if (last == 0) {
                    throw new ImapParseException(this.mTag, "malformed sequence");
                }
                last = 0;
                colon = false;
                continue;
            }
            if (c == ':') {
                if (colon || last == 0) {
                    throw new ImapParseException(this.mTag, "malformed sequence");
                }
                last = 0;
                colon = true;
                continue;
            }
            if (last == 2 || c == '0' && last == 0) {
                throw new ImapParseException(this.mTag, "malformed sequence");
            }
            last = 1;
        }
        if (last == 0) {
            throw new ImapParseException(this.mTag, "malformed sequence");
        }
        return value;
    }

    String readFolder() throws IOException, ImapParseException {
        return this.readFolder(false);
    }

    String readFolderPattern() throws IOException, ImapParseException {
        return this.readFolder(true);
    }

    private String readFolder(boolean isPattern) throws IOException, ImapParseException {
        String raw = this.readAstring(null, isPattern ? PATTERN_CHARS : ASTRING_CHARS);
        if (raw == null || raw.indexOf("&") == -1) {
            return raw;
        }
        try {
            return ImapPath.FOLDER_ENCODING_CHARSET.decode(ByteBuffer.wrap(raw.getBytes("US-ASCII"))).toString();
        }
        catch (Exception e) {
            ZimbraLog.imap.debug((Object)("ignoring error while decoding folder name: " + raw), e);
            return raw;
        }
    }

    List<String> readFlags() throws ImapParseException {
        boolean parens;
        ArrayList<String> tags = new ArrayList<String>();
        String content = this.getCurrentLine();
        boolean bl = parens = this.peekChar() == 40;
        if (parens) {
            this.skipChar('(');
        } else if (this.mOffset == content.length()) {
            throw new ImapParseException(this.mTag, "missing flag list");
        }
        if (!parens || this.peekChar() != 41) {
            while (this.mOffset < content.length()) {
                if (!tags.isEmpty()) {
                    this.skipSpace();
                }
                if (this.peekChar() == 92) {
                    this.skipChar('\\');
                    String name = this.readAtom();
                    if (!SYSTEM_FLAGS.contains(name.toUpperCase())) {
                        throw new ImapParseException(this.mTag, "invalid flag: \\" + name);
                    }
                    tags.add('\\' + name);
                } else {
                    tags.add(this.readAtom());
                }
                if (!parens || this.peekChar() != 41) continue;
            }
        }
        if (parens) {
            this.skipChar(')');
        }
        return tags;
    }

    private Date readDate() throws ImapParseException {
        return this.readDate(false, false);
    }

    Date readDate(boolean datetime, boolean checkRange) throws ImapParseException {
        String dateStr = this.peekChar() == 34 ? this.readQuoted() : this.readAtom();
        if (dateStr.length() < (datetime ? 26 : 10)) {
            throw new ImapParseException(this.mTag, "invalid date format");
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        int pos = 0;
        if (datetime && dateStr.charAt(0) == ' ') {
            ++pos;
        }
        int count = 2 - pos - (datetime || dateStr.charAt(1) != '-' ? 0 : 1);
        this.validateDigits(dateStr, pos, count, cal, 5);
        this.validateChar(dateStr, pos += count, '-');
        this.validateMonth(dateStr, ++pos, cal);
        this.validateChar(dateStr, pos += 3, '-');
        this.validateDigits(dateStr, ++pos, 4, cal, 1);
        pos += 4;
        if (datetime) {
            this.validateChar(dateStr, pos, ' ');
            this.validateDigits(dateStr, ++pos, 2, cal, 10);
            this.validateChar(dateStr, pos += 2, ':');
            this.validateDigits(dateStr, ++pos, 2, cal, 12);
            this.validateChar(dateStr, pos += 2, ':');
            this.validateDigits(dateStr, ++pos, 2, cal, 13);
            this.validateChar(dateStr, pos += 2, ' ');
            boolean zonesign = dateStr.charAt(++pos) == '+';
            this.validateChar(dateStr, pos, zonesign ? (char)'+' : '-');
            int zonehrs = this.validateDigits(dateStr, ++pos, 2, cal, -1);
            int zonemins = this.validateDigits(dateStr, pos += 2, 2, cal, -1);
            pos += 2;
            cal.set(15, (zonesign ? 1 : -1) * (60 * zonehrs + zonemins) * 60000);
            cal.set(16, 0);
        }
        if (pos != dateStr.length()) {
            throw new ImapParseException(this.mTag, "excess characters at end of date string");
        }
        Date date = cal.getTime();
        if (checkRange && date.getTime() < 0L) {
            throw new ImapParseException(this.mTag, "date out of range");
        }
        return date;
    }

    private int validateDigits(String str, int pos, int count, Calendar cal, int field) throws ImapParseException {
        if (str.length() < pos + count) {
            throw new ImapParseException(this.mTag, "unexpected end of date string");
        }
        int value = 0;
        for (int i = 0; i < count; ++i) {
            char c = str.charAt(pos + i);
            if (c < '0' || c > '9') {
                throw new ImapParseException(this.mTag, "invalid digit in date string");
            }
            value = value * 10 + (c - 48);
        }
        if (field >= 0) {
            cal.set(field, value);
        }
        return value;
    }

    private void validateChar(String str, int pos, char c) throws ImapParseException {
        if (str.length() < pos + 1) {
            throw new ImapParseException(this.mTag, "unexpected end of date string");
        }
        if (str.charAt(pos) != c) {
            throw new ImapParseException(this.mTag, "unexpected character in date string");
        }
    }

    private void validateMonth(String str, int pos, Calendar cal) throws ImapParseException {
        Integer month = MONTH_NUMBER.get(str.substring(pos, pos + 3).toUpperCase());
        if (month == null) {
            throw new ImapParseException(this.mTag, "invalid month string");
        }
        cal.set(2, month);
    }

    Map<String, String> readParameters(boolean nil) throws IOException, ImapParseException {
        if (this.peekChar() != 40) {
            if (!nil) {
                throw new ImapParseException(this.mTag, "did not find expected '('");
            }
            this.skipNIL();
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        this.skipChar('(');
        while (true) {
            String name = this.readString("utf-8");
            this.skipSpace();
            params.put(name, this.readNstring("utf-8"));
            if (this.peekChar() == 41) break;
            this.skipSpace();
        }
        this.skipChar(')');
        return params;
    }

    int readFetch(List<ImapPartSpecifier> parts) throws IOException, ImapParseException {
        boolean list = this.peekChar() == 40;
        int attributes = 0;
        if (list) {
            this.skipChar('(');
        }
        do {
            String item = this.readContent(FETCH_CHARS).toUpperCase();
            if (!list && item.equals("ALL")) {
                attributes = 60;
            } else if (!list && item.equals("FULL")) {
                attributes = 61;
            } else if (!list && item.equals("FAST")) {
                attributes = 56;
            } else if (item.equals("BODY") && this.peekChar() != 91) {
                attributes |= 1;
            } else if (item.equals("BODYSTRUCTURE")) {
                attributes |= 2;
            } else if (item.equals("ENVELOPE")) {
                attributes |= 4;
            } else if (item.equals("FLAGS")) {
                attributes |= 8;
            } else if (item.equals("INTERNALDATE")) {
                attributes |= 0x10;
            } else if (item.equals("UID")) {
                attributes |= 0x80;
            } else if (item.equals("MODSEQ") && this.extensionEnabled("CONDSTORE")) {
                attributes |= 0x100;
            } else if (item.equals("RFC822.SIZE")) {
                attributes |= 0x20;
            } else if (item.equals("RFC822.HEADER")) {
                parts.add(new ImapPartSpecifier(item, SUBCLAUSE, "HEADER"));
            } else if (item.equals("RFC822")) {
                attributes |= 0x1000;
                parts.add(new ImapPartSpecifier(item, SUBCLAUSE, SUBCLAUSE));
            } else if (item.equals("RFC822.TEXT")) {
                attributes |= 0x1000;
                parts.add(new ImapPartSpecifier(item, SUBCLAUSE, "TEXT"));
            } else if (item.equals("BINARY.SIZE") && this.extensionEnabled("BINARY")) {
                String sectionPart = SUBCLAUSE;
                this.skipChar('[');
                while (this.peekChar() != 93) {
                    if (!sectionPart.equals(SUBCLAUSE)) {
                        sectionPart = sectionPart + ".";
                        this.skipChar('.');
                    }
                    sectionPart = sectionPart + this.readNumber(false);
                }
                this.skipChar(']');
                if (sectionPart.equals(SUBCLAUSE)) {
                    attributes |= 0x40;
                } else {
                    parts.add(new ImapPartSpecifier(item, sectionPart, SUBCLAUSE));
                }
            } else if (item.equals("BODY") || item.equals("BODY.PEEK") || (item.equals("BINARY") || item.equals("BINARY.PEEK")) && this.extensionEnabled("BINARY")) {
                if (!item.endsWith(".PEEK")) {
                    attributes |= 0x1000;
                }
                boolean binary = item.startsWith("BINARY");
                this.skipChar('[');
                ImapPartSpecifier pspec = this.readPartSpecifier(binary, true);
                this.skipChar(']');
                if (this.peekChar() == 60) {
                    try {
                        this.skipChar('<');
                        int partialStart = Integer.parseInt(this.readNumber());
                        this.skipChar('.');
                        int partialCount = Integer.parseInt(this.readNumber(false));
                        this.skipChar('>');
                        pspec.setPartial(partialStart, partialCount);
                    }
                    catch (NumberFormatException e) {
                        throw new ImapParseException(this.mTag, "invalid partial fetch specifier");
                    }
                }
                parts.add(pspec);
            } else {
                throw new ImapParseException(this.mTag, "unknown FETCH attribute \"" + item + '\"');
            }
            if (!list || this.peekChar() == 41) continue;
            this.skipSpace();
        } while (list && this.peekChar() != 41);
        if (list) {
            this.skipChar(')');
        }
        return attributes;
    }

    ImapPartSpecifier readPartSpecifier(boolean binary, boolean literals) throws ImapParseException, IOException {
        String sectionPart = SUBCLAUSE;
        String sectionText = SUBCLAUSE;
        ArrayList<String> headers = null;
        boolean done = false;
        while (Character.isDigit((char)this.peekChar())) {
            sectionPart = sectionPart + (sectionPart.equals(SUBCLAUSE) ? SUBCLAUSE : ".") + this.readNumber(false);
            done = this.peekChar() != 46;
            if (done) continue;
            this.skipChar('.');
        }
        if (!done && this.peekChar() != 93) {
            if (binary) {
                throw new ImapParseException(this.mTag, "section-text not permitted for BINARY");
            }
            sectionText = this.readATOM();
            if (sectionText.equals("HEADER.FIELDS") || sectionText.equals("HEADER.FIELDS.NOT")) {
                headers = new ArrayList<String>();
                this.skipSpace();
                this.skipChar('(');
                while (this.peekChar() != 41) {
                    if (!headers.isEmpty()) {
                        this.skipSpace();
                    }
                    headers.add((literals ? this.readAstring() : this.readAquoted()).toUpperCase());
                }
                if (headers.isEmpty()) {
                    throw new ImapParseException(this.mTag, "header-list may not be empty");
                }
                this.skipChar(')');
            } else if (sectionText.equals("MIME")) {
                if (sectionPart.equals(SUBCLAUSE)) {
                    throw new ImapParseException(this.mTag, "\"MIME\" is not a valid section-spec");
                }
            } else if (!sectionText.equals("HEADER") && !sectionText.equals("TEXT")) {
                throw new ImapParseException(this.mTag, "unknown section-text \"" + sectionText + '\"');
            }
        }
        ImapPartSpecifier pspec = new ImapPartSpecifier(binary ? "BINARY" : "BODY", sectionPart, sectionText);
        pspec.setHeaders(headers);
        return pspec;
    }

    private ImapSearch readSearchClause(String charset, boolean single, ImapSearch.LogicalOperation parent) throws IOException, ImapParseException {
        boolean first = true;
        int nots = 0;
        do {
            ImapSearch child;
            int c;
            if (!first) {
                this.skipSpace();
            }
            String key = (c = this.peekChar()) == 40 ? SUBCLAUSE : this.readContent(SEARCH_CHARS).toUpperCase();
            ImapSearch.LogicalOperation target = parent;
            if (key.equals("NOT")) {
                ++nots;
                first = false;
                continue;
            }
            if (nots % 2 != 0) {
                if (NEGATED_SEARCH.containsKey(key)) {
                    key = NEGATED_SEARCH.get(key);
                } else {
                    target = new ImapSearch.NotOperation();
                    parent.addChild(target);
                }
            }
            nots = 0;
            if (key.equals("ALL")) {
                child = new ImapSearch.AllSearch();
            } else if (key.equals("ANSWERED")) {
                child = new ImapSearch.FlagSearch("\\Answered");
            } else if (key.equals("DELETED")) {
                child = new ImapSearch.FlagSearch("\\Deleted");
            } else if (key.equals("DRAFT")) {
                child = new ImapSearch.FlagSearch("\\Draft");
            } else if (key.equals("FLAGGED")) {
                child = new ImapSearch.FlagSearch("\\Flagged");
            } else if (key.equals("RECENT")) {
                child = new ImapSearch.FlagSearch("\\Recent");
            } else if (key.equals("NEW")) {
                child = new ImapSearch.AndOperation(new ImapSearch.FlagSearch("\\Recent"), new ImapSearch.NotOperation(new ImapSearch.FlagSearch("\\Seen")));
            } else if (key.equals("OLD")) {
                child = new ImapSearch.NotOperation(new ImapSearch.FlagSearch("\\Recent"));
            } else if (key.equals("SEEN")) {
                child = new ImapSearch.FlagSearch("\\Seen");
            } else if (key.equals("UNANSWERED")) {
                child = new ImapSearch.NotOperation(new ImapSearch.FlagSearch("\\Answered"));
            } else if (key.equals("UNDELETED")) {
                child = new ImapSearch.NotOperation(new ImapSearch.FlagSearch("\\Deleted"));
            } else if (key.equals("UNDRAFT")) {
                child = new ImapSearch.NotOperation(new ImapSearch.FlagSearch("\\Draft"));
            } else if (key.equals("UNFLAGGED")) {
                child = new ImapSearch.NotOperation(new ImapSearch.FlagSearch("\\Flagged"));
            } else if (key.equals("UNSEEN")) {
                child = new ImapSearch.NotOperation(new ImapSearch.FlagSearch("\\Seen"));
            } else if (key.equals("BCC")) {
                this.skipSpace();
                child = new ImapSearch.HeaderSearch(ImapSearch.HeaderSearch.Header.BCC, this.readAstring(charset));
            } else if (key.equals("BEFORE")) {
                this.skipSpace();
                child = new ImapSearch.DateSearch(ImapSearch.DateSearch.Relation.before, this.readDate());
            } else if (key.equals("BODY")) {
                this.skipSpace();
                child = new ImapSearch.ContentSearch(this.readAstring(charset));
            } else if (key.equals("CC")) {
                this.skipSpace();
                child = new ImapSearch.HeaderSearch(ImapSearch.HeaderSearch.Header.CC, this.readAstring(charset));
            } else if (key.equals("FROM")) {
                this.skipSpace();
                child = new ImapSearch.HeaderSearch(ImapSearch.HeaderSearch.Header.FROM, this.readAstring(charset));
            } else if (key.equals("HEADER")) {
                this.skipSpace();
                ImapSearch.HeaderSearch.Header relation = ImapSearch.HeaderSearch.Header.parse(this.readAstring());
                this.skipSpace();
                child = new ImapSearch.HeaderSearch(relation, this.readAstring(charset));
            } else if (key.equals("KEYWORD")) {
                this.skipSpace();
                child = new ImapSearch.FlagSearch(this.readAtom());
            } else if (key.equals("LARGER")) {
                this.skipSpace();
                child = new ImapSearch.SizeSearch(ImapSearch.SizeSearch.Relation.larger, this.parseLong(this.readNumber()));
            } else if (key.equals("MODSEQ") && this.extensionEnabled("CONDSTORE")) {
                this.skipSpace();
                if (this.peekChar() == 34) {
                    this.readFolder();
                    this.skipSpace();
                    this.readATOM();
                    this.skipSpace();
                }
                child = new ImapSearch.ModifiedSearch(this.parseInteger(this.readNumber(true)));
            } else if (key.equals("ON")) {
                this.skipSpace();
                child = new ImapSearch.DateSearch(ImapSearch.DateSearch.Relation.date, this.readDate());
            } else if (key.equals("OLDER") && this.extensionEnabled("WITHIN")) {
                this.skipSpace();
                child = new ImapSearch.RelativeDateSearch(ImapSearch.DateSearch.Relation.before, this.parseInteger(this.readNumber()));
            } else if (key.equals("SENTBEFORE")) {
                this.skipSpace();
                child = new ImapSearch.DateSearch(ImapSearch.DateSearch.Relation.before, this.readDate());
            } else if (key.equals("SENTON")) {
                this.skipSpace();
                child = new ImapSearch.DateSearch(ImapSearch.DateSearch.Relation.date, this.readDate());
            } else if (key.equals("SENTSINCE")) {
                this.skipSpace();
                child = new ImapSearch.DateSearch(ImapSearch.DateSearch.Relation.after, this.readDate());
            } else if (key.equals("SINCE")) {
                this.skipSpace();
                child = new ImapSearch.DateSearch(ImapSearch.DateSearch.Relation.after, this.readDate());
            } else if (key.equals("SMALLER")) {
                this.skipSpace();
                child = new ImapSearch.SizeSearch(ImapSearch.SizeSearch.Relation.smaller, this.parseLong(this.readNumber()));
            } else if (key.equals("SUBJECT")) {
                this.skipSpace();
                child = new ImapSearch.HeaderSearch(ImapSearch.HeaderSearch.Header.SUBJECT, this.readAstring(charset));
            } else if (key.equals("TEXT")) {
                this.skipSpace();
                child = new ImapSearch.ContentSearch(this.readAstring(charset));
            } else if (key.equals("TO")) {
                this.skipSpace();
                child = new ImapSearch.HeaderSearch(ImapSearch.HeaderSearch.Header.TO, this.readAstring(charset));
            } else if (key.equals("UID")) {
                this.skipSpace();
                child = new ImapSearch.SequenceSearch(this.mTag, this.readSequence(), true);
            } else if (key.equals("UNKEYWORD")) {
                this.skipSpace();
                child = new ImapSearch.NotOperation(new ImapSearch.FlagSearch(this.readAtom()));
            } else if (key.equals("YOUNGER") && this.extensionEnabled("WITHIN")) {
                this.skipSpace();
                child = new ImapSearch.RelativeDateSearch(ImapSearch.DateSearch.Relation.after, this.parseInteger(this.readNumber()));
            } else if (key.equals(SUBCLAUSE)) {
                this.skipChar('(');
                child = this.readSearchClause(charset, false, new ImapSearch.AndOperation(new ImapSearch[0]));
                this.skipChar(')');
            } else if (Character.isDigit(key.charAt(0)) || key.charAt(0) == '*' || key.charAt(0) == '$') {
                child = new ImapSearch.SequenceSearch(this.mTag, this.validateSequence(key, true), false);
            } else if (key.equals("OR")) {
                this.skipSpace();
                child = this.readSearchClause(charset, true, new ImapSearch.OrOperation(new ImapSearch[0]));
                this.skipSpace();
                this.readSearchClause(charset, true, (ImapSearch.LogicalOperation)child);
            } else {
                throw new ImapParseException(this.mTag, "unknown search tag: " + key);
            }
            target.addChild(child);
            first = false;
        } while (this.peekChar() != -1 && this.peekChar() != 41 && (nots > 0 || !single));
        if (nots > 0) {
            throw new ImapParseException(this.mTag, "missing search-key after NOT");
        }
        return parent;
    }

    ImapSearch readSearch(String charset) throws IOException, ImapParseException {
        return this.readSearchClause(charset, false, new ImapSearch.AndOperation(new ImapSearch[0]));
    }

    String readCharset() throws IOException, ImapParseException {
        String charset = this.readAstring();
        try {
            if (Charset.isSupported(charset)) {
                return charset;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ImapParseException(this.mTag, "BADCHARSET", "unknown charset: " + charset.replace('\r', ' ').replace('\n', ' '), true);
    }

    static {
        int i;
        TAG_CHARS = new boolean[128];
        ATOM_CHARS = new boolean[128];
        ASTRING_CHARS = new boolean[128];
        PATTERN_CHARS = new boolean[128];
        FETCH_CHARS = new boolean[128];
        NUMBER_CHARS = new boolean[128];
        SEQUENCE_CHARS = new boolean[128];
        BASE64_CHARS = new boolean[128];
        SEARCH_CHARS = new boolean[128];
        for (i = 33; i < 127; ++i) {
            if (i == 40 || i == 41 || i == 123 || i == 37 || i == 42 || i == 34 || i == 92) continue;
            ImapRequest.TAG_CHARS[i] = true;
            ImapRequest.ATOM_CHARS[i] = true;
            ImapRequest.ASTRING_CHARS[i] = true;
            ImapRequest.PATTERN_CHARS[i] = true;
            ImapRequest.FETCH_CHARS[i] = true;
            ImapRequest.SEARCH_CHARS[i] = true;
        }
        ImapRequest.ATOM_CHARS[93] = false;
        ImapRequest.TAG_CHARS[43] = false;
        ImapRequest.PATTERN_CHARS[42] = true;
        ImapRequest.PATTERN_CHARS[37] = true;
        ImapRequest.FETCH_CHARS[91] = false;
        ImapRequest.SEARCH_CHARS[42] = true;
        for (i = 97; i <= 122; ++i) {
            ImapRequest.BASE64_CHARS[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            ImapRequest.BASE64_CHARS[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            ImapRequest.SEQUENCE_CHARS[i] = true;
            ImapRequest.NUMBER_CHARS[i] = true;
            ImapRequest.BASE64_CHARS[i] = true;
        }
        ImapRequest.SEQUENCE_CHARS[36] = true;
        ImapRequest.SEQUENCE_CHARS[44] = true;
        ImapRequest.SEQUENCE_CHARS[58] = true;
        ImapRequest.SEQUENCE_CHARS[42] = true;
        ImapRequest.BASE64_CHARS[47] = true;
        ImapRequest.BASE64_CHARS[43] = true;
        SYSTEM_FLAGS = new HashSet<String>(Arrays.asList("ANSWERED", "FLAGGED", "DELETED", "SEEN", "DRAFT"));
        MONTH_NUMBER = new HashMap<String, Integer>(16);
        String[] names = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
        for (int i2 = 0; i2 < names.length; ++i2) {
            MONTH_NUMBER.put(names[i2], i2);
        }
        NEGATED_SEARCH = new HashMap<String, String>();
        NEGATED_SEARCH.put("ANSWERED", "UNANSWERED");
        NEGATED_SEARCH.put("DELETED", "UNDELETED");
        NEGATED_SEARCH.put("DRAFT", "UNDRAFT");
        NEGATED_SEARCH.put("FLAGGED", "UNFLAGGED");
        NEGATED_SEARCH.put("KEYWORD", "UNKEYWORD");
        NEGATED_SEARCH.put("RECENT", "OLD");
        NEGATED_SEARCH.put("OLD", "RECENT");
        NEGATED_SEARCH.put("SEEN", "UNSEEN");
        NEGATED_SEARCH.put("UNANSWERED", "ANSWERED");
        NEGATED_SEARCH.put("UNDELETED", "DELETED");
        NEGATED_SEARCH.put("UNDRAFT", "DRAFT");
        NEGATED_SEARCH.put("UNFLAGGED", "FLAGGED");
        NEGATED_SEARCH.put("UNKEYWORD", "KEYWORD");
        NEGATED_SEARCH.put("UNSEEN", "SEEN");
    }

    private class LiteralPart
    extends Part {
        private Literal lit;

        LiteralPart(Literal l) {
            this.lit = l;
        }

        int size() {
            return this.lit.size();
        }

        byte[] getBytes() throws IOException {
            return this.lit.getBytes();
        }

        boolean isLiteral() {
            return true;
        }

        Literal getLiteral() {
            return this.lit;
        }

        void cleanup() {
            this.lit.cleanup();
        }

        public String getString() throws ImapParseException {
            throw new ImapParseException(ImapRequest.this.mTag, "not inside string");
        }

        public String toString() {
            try {
                return new String(this.lit.getBytes(), "US-ASCII");
            }
            catch (IOException e) {
                return "???";
            }
        }
    }

    private class StringPart
    extends Part {
        private String str;

        StringPart(String s) {
            this.str = s;
        }

        int size() {
            return this.str.length();
        }

        byte[] getBytes() {
            return this.str.getBytes();
        }

        boolean isString() {
            return true;
        }

        String getString() {
            return this.str;
        }

        public String toString() {
            return this.str;
        }

        Literal getLiteral() throws ImapParseException {
            throw new ImapParseException(ImapRequest.this.mTag, "not inside literal");
        }
    }

    protected abstract class Part {
        protected Part() {
        }

        abstract int size();

        abstract byte[] getBytes() throws IOException;

        boolean isString() {
            return false;
        }

        boolean isLiteral() {
            return false;
        }

        abstract String getString() throws ImapParseException;

        abstract Literal getLiteral() throws ImapParseException;

        void cleanup() {
        }
    }
}

