/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.imap.ImapHandler;
import com.zimbra.cs.imap.ImapPath;
import com.zimbra.cs.imap.ImapRequest;
import com.zimbra.cs.mailclient.MailConfig;
import com.zimbra.cs.mailclient.MailInputStream;
import com.zimbra.cs.mailclient.MailOutputStream;
import com.zimbra.cs.mailclient.auth.Authenticator;
import com.zimbra.cs.mailclient.auth.AuthenticatorFactory;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.service.AuthProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;

class ImapProxy {
    private static final AuthenticatorFactory sAuthenticatorFactory = new AuthenticatorFactory();
    private final ImapHandler mHandler;
    private final ImapPath mPath;
    private ImapConnection mConnection;
    private Thread mIdleThread;
    private static final HashSet<String> UNSTRUCTURED_CODES;

    ImapProxy(ImapHandler handler, ImapPath path) throws ServiceException {
        this.mHandler = handler;
        this.mPath = path;
        Account acct = handler.getCredentials().getAccount();
        Server server = Provisioning.getInstance().getServer(path.getOwnerAccount());
        String host = server.getAttr("zimbraServiceHostname");
        if (acct == null) {
            throw ServiceException.PROXY_ERROR(new Exception("no such authenticated user"), path.asImapPath());
        }
        ImapConfig config = new ImapConfig();
        config.setAuthenticationId(acct.getName());
        config.setMechanism("X-ZIMBRA");
        config.setAuthenticatorFactory(sAuthenticatorFactory);
        config.setReadTimeout(LC.javamail_imap_timeout.intValue());
        config.setConnectTimeout(config.getReadTimeout());
        config.setHost(host);
        if (server.getBooleanAttr("zimbraImapServerEnabled", true)) {
            config.setPort(server.getIntAttr("zimbraImapBindPort", 143));
        } else if (server.getBooleanAttr("zimbraImapSSLServerEnabled", true)) {
            config.setPort(server.getIntAttr("zimbraImapSSLBindPort", 993));
            config.setSecurity(MailConfig.Security.SSL);
        } else {
            throw ServiceException.PROXY_ERROR(new Exception("no open IMAP port for server " + host), path.asImapPath());
        }
        ZimbraLog.imap.info("opening proxy connection (user=" + acct.getName() + ", host=" + host + ", path=" + path.getReferent().asImapPath() + ')');
        ImapConnection conn = this.mConnection = new ImapConnection(config);
        try {
            conn.connect();
            conn.authenticate(AuthProvider.getAuthToken(acct).getEncoded());
        }
        catch (Exception e) {
            this.dropConnection();
            throw ServiceException.PROXY_ERROR(e, null);
        }
    }

    ImapPath getPath() {
        return this.mPath;
    }

    void dropConnection() {
        ImapConnection conn = this.mConnection;
        this.mConnection = null;
        if (conn == null) {
            return;
        }
        ZimbraLog.imap.info("closing proxy connection");
        conn.close();
    }

    boolean select(String tag, byte params, ImapHandler.QResyncInfo qri) throws IOException, ServiceException {
        String command = (params & 1) == 0 ? "SELECT" : "EXAMINE";
        StringBuilder select = new StringBuilder(100);
        select.append(tag).append(' ').append(command).append(' ');
        select.append(this.mPath.getReferent().asUtf7String());
        if ((params & 2) != 0) {
            select.append(" (");
            if (qri == null) {
                select.append("CONDSTORE");
            } else {
                select.append("QRESYNC (").append(qri.uvv).append(' ').append(qri.modseq);
                if (qri.knownUIDs != null) {
                    select.append(' ').append(qri.knownUIDs);
                }
                if (qri.seqMilestones != null) {
                    select.append(" (").append(qri.seqMilestones).append(' ').append(qri.uidMilestones).append(')');
                }
                select.append(')');
            }
            select.append(')');
        }
        return this.proxyCommand(tag, select.append("\r\n").toString().getBytes(), true, false);
    }

    boolean idle(final ImapRequest req, boolean begin) throws IOException {
        if (!begin) {
            ImapHandler handler = this.mHandler;
            if (handler == null) {
                throw new IOException("proxy connection already closed");
            }
            Thread idle = this.mIdleThread;
            if (idle == null) {
                throw new IOException("bad proxy state: no IDLE thread active when attempting DONE");
            }
            this.writeRequest(req.toByteArray());
            this.mIdleThread = null;
            try {
                idle.join(5000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (idle.isAlive()) {
                handler.dropConnection(false);
            }
        } else {
            final ImapHandler handler = this.mHandler;
            final ImapConnection conn = this.mConnection;
            if (conn == null) {
                throw new IOException("proxy connection already closed");
            }
            ImapConfig config = conn.getImapConfig();
            final int oldTimeout = config != null ? config.getReadTimeout() : LC.javamail_imap_timeout.intValue();
            this.mIdleThread = new Thread(){

                public void run() {
                    boolean success = false;
                    try {
                        conn.setReadTimeout(1800);
                        boolean ok = ImapProxy.this.proxyCommand(req.getTag(), req.toByteArray(), true, true);
                        conn.setReadTimeout(oldTimeout);
                        success = ok;
                    }
                    catch (IOException e) {
                        ZimbraLog.imap.warn((Object)"error encountered during IDLE; dropping connection", e);
                    }
                    if (!success) {
                        handler.dropConnection();
                    }
                }
            };
            this.mIdleThread.setName("Imap-Idle-Proxy-" + Thread.currentThread().getName());
            this.mIdleThread.start();
        }
        return true;
    }

    boolean proxy(ImapRequest req) throws IOException {
        this.proxyCommand(req.getTag(), req.toByteArray(), true, false);
        return true;
    }

    boolean proxy(String tag, String command) throws IOException {
        this.proxyCommand(tag, (tag + ' ' + command + "\r\n").getBytes(), true, false);
        return true;
    }

    void fetchNotifications() throws IOException {
        String tag = this.mConnection == null ? "1" : this.mConnection.newTag();
        this.proxyCommand(tag, (tag + " NOOP\r\n").getBytes(), false, false);
    }

    private ImapConnection writeRequest(byte[] payload) throws IOException {
        ImapConnection conn = this.mConnection;
        if (conn == null) {
            throw new IOException("proxy connection already closed");
        }
        MailOutputStream remote = conn.getOutputStream();
        if (remote == null) {
            this.dropConnection();
            throw new IOException("proxy connection already closed");
        }
        remote.write(payload);
        ((OutputStream)remote).flush();
        return conn;
    }

    boolean proxyCommand(String tag, byte[] payload, boolean includeTaggedResponse, boolean isIdle) throws IOException {
        int first;
        ImapConnection conn = this.writeRequest(payload);
        MailInputStream min = conn.getInputStream();
        OutputStream out = this.mHandler.mOutputStream;
        if (out == null) {
            this.dropConnection();
            throw new IOException("proxy connection already closed");
        }
        boolean success = false;
        while ((first = min.peek()) != -1) {
            int c;
            boolean tagged = first != 42 && first != 43;
            boolean structured = first == 42;
            boolean proxy = !(first == 43 && !isIdle || tagged && !includeTaggedResponse);
            ByteArrayOutputStream line = proxy ? new ByteArrayOutputStream() : null;
            StringBuilder debug = proxy && ZimbraLog.imap.isDebugEnabled() ? new StringBuilder("  S: ") : null;
            StringBuilder condition = new StringBuilder(10);
            boolean quoted = false;
            boolean escaped = false;
            boolean space1 = false;
            boolean space2 = false;
            int literal = -1;
            while ((c = min.read()) != -1) {
                if (!space2) {
                    if (c == 32 && !space1) {
                        space1 = true;
                    } else if (c == 32) {
                        space2 = true;
                        String code = condition.toString().toUpperCase();
                        if (tagged) {
                            success = code.equals("OK") || isIdle && code.equals("BAD");
                        }
                        structured &= !UNSTRUCTURED_CODES.contains(code);
                    } else if (space1) {
                        condition.append((char)c);
                    }
                }
                if (structured) {
                    if (escaped) {
                        escaped = false;
                    } else if (quoted && c == 92) {
                        escaped = true;
                    } else if (c == 34) {
                        quoted = !quoted;
                    } else if (!quoted && c == 123) {
                        literal = 0;
                    } else if (literal != -1 && c >= 48 && c <= 57) {
                        literal = literal * 10 + (c - 48);
                    }
                }
                if (!quoted && c == 13 && min.peek() == 10) {
                    int read;
                    byte[] buffer;
                    min.read();
                    if (proxy) {
                        out.write(line.toByteArray());
                        out.write(ImapHandler.LINE_SEPARATOR_BYTES);
                        line.reset();
                        if (isIdle) {
                            out.flush();
                        }
                    }
                    if (literal == -1) break;
                    byte[] byArray = buffer = literal == 0 ? null : new byte[Math.min(literal, 8196)];
                    while (literal > 0 && (read = min.read(buffer)) != -1) {
                        if (proxy) {
                            out.write(buffer, 0, read);
                        }
                        literal -= read;
                    }
                    literal = -1;
                    if (!isIdle) continue;
                    out.flush();
                    continue;
                }
                if (!proxy) continue;
                line.write(c);
                if (debug == null) continue;
                debug.append((char)c);
            }
            if (debug != null) {
                ZimbraLog.imap.debug(debug.toString());
            }
            if (!tagged) continue;
            break;
        }
        out.flush();
        return success;
    }

    static {
        sAuthenticatorFactory.register("X-ZIMBRA", ZimbraClientAuthenticator.class);
        UNSTRUCTURED_CODES = new HashSet<String>(Arrays.asList("OK", "NO", "BAD", "PREAUTH", "BYE"));
    }

    public static final class ZimbraClientAuthenticator
    extends Authenticator {
        private String username;
        private String authtoken;
        private boolean complete;

        public void init(MailConfig config, String password) {
            this.username = config.getAuthenticationId();
            this.authtoken = password;
        }

        public String getMechanism() {
            return "X-ZIMBRA";
        }

        public boolean isComplete() {
            return this.complete;
        }

        public boolean hasInitialResponse() {
            return true;
        }

        public byte[] getInitialResponse() {
            return this.evaluateChallenge(null);
        }

        public byte[] evaluateChallenge(byte[] challenge) {
            this.complete = true;
            String response = this.username + '\u0000' + this.username + '\u0000' + this.authtoken;
            try {
                return response.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException uee) {
                return response.getBytes();
            }
        }
    }
}

