/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.imap.ImapCredentials;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.SearchFolder;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZMountpoint;
import com.zimbra.cs.zclient.ZSearchFolder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapPath
implements Comparable<ImapPath> {
    static Charset FOLDER_ENCODING_CHARSET;
    static final String NAMESPACE_PREFIX = "/home/";
    private ImapCredentials mCredentials;
    private String mOwner;
    private String mPath;
    private Object mMailbox;
    private Object mFolder;
    private ItemId mItemId;
    private Scope mScope = Scope.CONTENT;
    private ImapPath mReferent;

    ImapPath(String imapPath, ImapCredentials creds) {
        this(imapPath, creds, Scope.CONTENT);
    }

    ImapPath(String imapPath, ImapCredentials creds, Scope scope) {
        this.mCredentials = creds;
        this.mPath = imapPath;
        this.mScope = scope;
        if (imapPath.toLowerCase().startsWith(NAMESPACE_PREFIX) && !(imapPath = imapPath.substring(NAMESPACE_PREFIX.length())).equals("") && !imapPath.startsWith("/")) {
            int slash = imapPath.indexOf(47);
            this.mOwner = (slash == -1 ? imapPath : imapPath.substring(0, slash)).toLowerCase();
            String string = this.mPath = slash == -1 ? "" : imapPath.substring(slash);
        }
        while (this.mPath.startsWith("/")) {
            this.mPath = this.mPath.substring(1);
        }
        while (this.mPath.endsWith("/")) {
            this.mPath = this.mPath.substring(0, this.mPath.length() - 1);
        }
        String lcname = this.mPath.toLowerCase();
        if (creds != null && creds.isHackEnabled(ImapCredentials.EnabledHack.WM5) && lcname.startsWith("sent items") && (lcname.length() == 10 || lcname.charAt(10) == '/')) {
            this.mPath = "Sent" + this.mPath.substring(10);
        }
    }

    ImapPath(String owner, String zimbraPath, ImapCredentials creds) {
        this.mCredentials = creds;
        this.mOwner = owner == null ? null : owner.toLowerCase();
        this.mPath = zimbraPath.startsWith("/") ? zimbraPath.substring(1) : zimbraPath;
    }

    ImapPath(ImapPath other) {
        this.mCredentials = other.mCredentials;
        this.mOwner = other.mOwner;
        this.mPath = other.mPath;
        this.mMailbox = other.mMailbox;
        this.mFolder = other.mFolder;
        this.mItemId = other.mItemId;
    }

    ImapPath(String owner, Folder folder, ImapCredentials creds) {
        this(owner, folder.getPath(), creds);
        this.mMailbox = folder.getMailbox();
        this.mFolder = folder;
        this.mItemId = new ItemId(folder);
    }

    ImapPath(String owner, Folder folder, ImapPath mountpoint) throws ServiceException {
        this(mountpoint);
        this.mReferent = new ImapPath(owner, folder, this.mCredentials);
        new ImapPath(owner, folder, this.mCredentials).mScope = Scope.REFERENCE;
        int start = mountpoint.getReferent().mPath.length() + 1;
        this.mPath = mountpoint.mPath + "/" + this.mReferent.mPath.substring(start == 1 ? 0 : start);
    }

    ImapPath(String owner, ZFolder zfolder, ImapCredentials creds) throws ServiceException {
        this(owner, zfolder.getPath(), creds);
        this.mMailbox = zfolder.getMailbox();
        this.mFolder = zfolder;
        this.mItemId = new ItemId(zfolder.getId(), creds == null ? null : creds.getAccountId());
    }

    ImapPath(String owner, ZFolder zfolder, ImapPath mountpoint) throws ServiceException {
        this(mountpoint);
        this.mReferent = new ImapPath(owner, zfolder, this.mCredentials);
        new ImapPath(owner, zfolder, this.mCredentials).mScope = Scope.REFERENCE;
        int start = mountpoint.getReferent().mPath.length() + 1;
        this.mPath = mountpoint.mPath + "/" + this.mReferent.mPath.substring(start == 1 ? 0 : start);
    }

    public boolean isEquivalent(ImapPath other) {
        if (!this.mPath.equalsIgnoreCase(other.mPath)) {
            return false;
        }
        if (this.mOwner == other.mOwner || this.mOwner != null && this.mOwner.equalsIgnoreCase(other.mOwner)) {
            return true;
        }
        try {
            Account acct = this.getOwnerAccount();
            Account otheracct = other.getOwnerAccount();
            return acct == null || otheracct == null ? false : acct.getId().equalsIgnoreCase(otheracct.getId());
        }
        catch (ServiceException e) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImapPath)) {
            return super.equals(obj);
        }
        return this.asImapPath().equalsIgnoreCase(((ImapPath)obj).asImapPath());
    }

    @Override
    public int compareTo(ImapPath o) {
        return this.asImapPath().compareToIgnoreCase(o.asImapPath());
    }

    public int hashCode() {
        return (this.mOwner == null ? 0 : this.mOwner.toUpperCase().hashCode()) ^ this.mPath.toUpperCase().hashCode() ^ (this.mCredentials == null ? 0 : this.mCredentials.hashCode());
    }

    ImapPath canonicalize() throws ServiceException {
        this.getFolder();
        String path = this.mFolder instanceof Folder ? ((Folder)this.mFolder).getPath() : ((ZFolder)this.mFolder).getPath();
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int excess = this.mPath.length() - path.length();
        this.mPath = this.mReferent == this || excess == 0 ? path : path + "/" + this.mReferent.canonicalize().mPath.substring(this.mReferent.mPath.length() - excess + 1);
        return this;
    }

    String getOwner() {
        return this.mOwner;
    }

    ImapCredentials getCredentials() {
        return this.mCredentials;
    }

    boolean belongsTo(Mailbox mbox) throws ServiceException {
        return this.belongsTo(mbox.getAccountId());
    }

    boolean belongsTo(ImapCredentials creds) throws ServiceException {
        return this.belongsTo(creds.getAccountId());
    }

    boolean belongsTo(String accountId) throws ServiceException {
        String ownerId = this.getOwnerAccountId();
        return ownerId != null && ownerId.equalsIgnoreCase(accountId);
    }

    String getOwnerAccountId() throws ServiceException {
        if (this.useReferent()) {
            return this.getReferent().getOwnerAccountId();
        }
        if (this.mMailbox instanceof Mailbox) {
            return ((Mailbox)this.mMailbox).getAccountId();
        }
        if (this.mOwner == null && this.mCredentials != null) {
            return this.mCredentials.getAccountId();
        }
        if (this.mOwner == null) {
            return null;
        }
        Account acct = this.getOwnerAccount();
        return acct == null ? null : acct.getId();
    }

    Account getOwnerAccount() throws ServiceException {
        if (this.useReferent()) {
            return this.getReferent().getOwnerAccount();
        }
        if (this.mMailbox instanceof Mailbox) {
            return ((Mailbox)this.mMailbox).getAccount();
        }
        if (this.mOwner != null) {
            return Provisioning.getInstance().get(Provisioning.AccountBy.name, this.mOwner);
        }
        if (this.mCredentials != null) {
            return Provisioning.getInstance().get(Provisioning.AccountBy.id, this.mCredentials.getAccountId());
        }
        return null;
    }

    boolean onLocalServer() throws ServiceException {
        Account acct = this.getOwnerAccount();
        return acct != null && Provisioning.onLocalServer(acct);
    }

    Object getOwnerMailbox() throws ServiceException {
        return this.getOwnerMailbox(true);
    }

    Object getOwnerMailbox(boolean traverse) throws ServiceException {
        if (this.useReferent()) {
            return this.mReferent.getOwnerMailbox();
        }
        if (this.mMailbox == null) {
            Account target = this.getOwnerAccount();
            this.mMailbox = target == null ? null : (Provisioning.onLocalServer(target) ? MailboxManager.getInstance().getMailboxByAccount(target) : (this.mCredentials == null ? null : this.getOwnerZMailbox()));
        }
        return this.mMailbox;
    }

    ZMailbox getOwnerZMailbox() throws ServiceException {
        if (this.useReferent()) {
            return this.getReferent().getOwnerZMailbox();
        }
        if (this.mMailbox instanceof ZMailbox) {
            return (ZMailbox)this.mMailbox;
        }
        if (this.mCredentials == null) {
            return null;
        }
        Account target = this.getOwnerAccount();
        if (target == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(this.getOwner());
        }
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, this.mCredentials.getAccountId());
        if (acct == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(this.mCredentials.getUsername());
        }
        try {
            ZMailbox.Options options = new ZMailbox.Options(AuthProvider.getAuthToken(acct).getEncoded(), AccountUtil.getSoapUri(target));
            options.setTargetAccount(target.getName());
            options.setNoSession(true);
            return ZMailbox.getMailbox(options);
        }
        catch (AuthTokenException ate) {
            throw ServiceException.FAILURE("error generating auth token", ate);
        }
    }

    private OperationContext getContext() throws ServiceException {
        return this.mCredentials == null ? null : this.mCredentials.getContext();
    }

    Object getFolder() throws ServiceException {
        if (this.useReferent()) {
            return this.getReferent().getFolder();
        }
        if (this.mFolder == null) {
            Object mboxobj = this.getOwnerMailbox();
            if (mboxobj instanceof Mailbox) {
                Folder folder = ((Mailbox)mboxobj).getFolderByPath(this.getContext(), this.asZimbraPath());
                this.mFolder = folder;
                this.mItemId = new ItemId(folder);
            } else if (mboxobj instanceof ZMailbox) {
                ZFolder zfolder = ((ZMailbox)mboxobj).getFolderByPath(this.asZimbraPath());
                this.mFolder = zfolder;
                if (zfolder == null) {
                    throw MailServiceException.NO_SUCH_FOLDER(this.asImapPath());
                }
                this.mItemId = new ItemId(zfolder.getId(), this.mCredentials == null ? null : this.mCredentials.getAccountId());
            } else {
                throw AccountServiceException.NO_SUCH_ACCOUNT(this.getOwner());
            }
        }
        return this.mFolder;
    }

    private boolean useReferent() throws ServiceException {
        ItemId iidBase;
        if (this.getReferent() == this) {
            return false;
        }
        if (this.mScope == Scope.CONTENT) {
            return true;
        }
        assert (this.mScope == Scope.NAME);
        assert (this.mFolder != null);
        assert (this.mReferent != null);
        if (this.mFolder instanceof Mountpoint) {
            iidBase = ((Mountpoint)this.mFolder).getTarget();
        } else if (this.mFolder instanceof ZMountpoint) {
            iidBase = new ItemId(((ZMountpoint)this.mFolder).getCanonicalRemoteId(), (String)null);
        } else {
            return false;
        }
        return !iidBase.equals(this.mReferent.mItemId);
    }

    ImapPath getReferent() throws ServiceException {
        block26: {
            String owner;
            ItemId iidRemote;
            if (this.mReferent != null) {
                return this.mReferent;
            }
            this.mReferent = this;
            if (this.mScope == Scope.REFERENCE || this.mScope == Scope.UNPARSED || !this.belongsTo(this.mCredentials)) {
                return this.mReferent;
            }
            String subpathRemote = null;
            Object mboxobj = this.getOwnerMailbox();
            if (mboxobj instanceof Mailbox) {
                try {
                    if (this.mFolder == null) {
                        Pair<Folder, String> resolved = ((Mailbox)mboxobj).getFolderByPathLongestMatch(this.getContext(), 1, this.asZimbraPath());
                        subpathRemote = resolved.getSecond();
                        boolean isMountpoint = resolved.getFirst() instanceof Mountpoint;
                        if (isMountpoint || resolved.getSecond() == null) {
                            this.mFolder = resolved.getFirst();
                            this.mItemId = new ItemId(resolved.getFirst());
                        }
                        if (!isMountpoint || this.mFolder == null) {
                            return this.mReferent;
                        }
                    } else if (!(this.mFolder instanceof Mountpoint)) {
                        return this.mReferent;
                    }
                    iidRemote = ((Mountpoint)this.mFolder).getTarget();
                }
                catch (ServiceException e) {
                    return this.mReferent;
                }
            } else {
                iidRemote = null;
                subpathRemote = null;
            }
            if (this.belongsTo(iidRemote.getAccountId())) {
                return this.mReferent;
            }
            Account target = Provisioning.getInstance().get(Provisioning.AccountBy.id, iidRemote.getAccountId());
            if (target == null) {
                return this.mReferent;
            }
            String string = owner = this.mCredentials != null && this.mCredentials.getAccountId().equalsIgnoreCase(target.getId()) ? null : target.getName();
            if (Provisioning.onLocalServer(target)) {
                try {
                    Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(target);
                    Folder folder = mbox.getFolderById(this.getContext(), iidRemote.getId());
                    if (subpathRemote == null) {
                        this.mReferent = new ImapPath(owner, folder, this.mCredentials);
                        break block26;
                    }
                    this.mReferent = new ImapPath(owner, folder.getPath() + (folder.getPath().equals("/") ? "" : "/") + subpathRemote, this.mCredentials);
                    new ImapPath(owner, folder.getPath() + (folder.getPath().equals("/") ? "" : "/") + subpathRemote, this.mCredentials).mMailbox = mbox;
                }
                catch (ServiceException e) {}
            } else {
                Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, this.mCredentials.getAccountId());
                if (acct == null) {
                    return this.mReferent;
                }
                try {
                    ZMailbox.Options options = new ZMailbox.Options(AuthProvider.getAuthToken(acct).getEncoded(), AccountUtil.getSoapUri(target));
                    options.setTargetAccount(target.getName());
                    options.setNoSession(true);
                    ZMailbox zmbx = ZMailbox.getMailbox(options);
                    ZFolder zfolder = zmbx.getFolderById(iidRemote.toString(this.mCredentials.getAccountId()));
                    if (zfolder == null) {
                        return this.mReferent;
                    }
                    if (subpathRemote == null) {
                        this.mReferent = new ImapPath(owner, zfolder, this.mCredentials);
                    } else {
                        this.mReferent = new ImapPath(owner, zfolder.getPath() + (zfolder.getPath().equals("/") ? "" : "/") + subpathRemote, this.mCredentials);
                        new ImapPath(owner, zfolder.getPath() + (zfolder.getPath().equals("/") ? "" : "/") + subpathRemote, this.mCredentials).mMailbox = zmbx;
                    }
                }
                catch (AuthTokenException ate) {
                    throw ServiceException.FAILURE("error generating auth token", ate);
                }
                catch (ServiceException e) {
                    // empty catch block
                }
            }
        }
        if (this.mReferent != this) {
            this.mReferent.mScope = Scope.REFERENCE;
        }
        return this.mReferent;
    }

    short getFolderRights() throws ServiceException {
        if (this.getFolder() instanceof Folder) {
            Folder folder = (Folder)this.getFolder();
            return folder.getMailbox().getEffectivePermissions(this.getContext(), folder.getId(), folder.getType());
        }
        ZFolder zfolder = (ZFolder)this.getFolder();
        String rights = zfolder.getEffectivePerms();
        return rights == null ? (short)-1 : (short)ACL.stringToRights(rights);
    }

    boolean isCreatable() {
        String path = this.mPath.toLowerCase();
        return !path.matches("\\s*notebook\\s*(/.*)?") && !path.matches("\\s*contacts\\s*(/.*)?") && !path.matches("\\s*calendar\\s*(/.*)?");
    }

    boolean isWritable() throws ServiceException {
        return this.isWritable((short)8) || this.isWritable((short)4) || this.isWritable((short)2);
    }

    boolean isWritable(short rights) throws ServiceException {
        ZFolder zfolder;
        Folder folder;
        if (!this.isSelectable()) {
            return false;
        }
        if (this.mFolder instanceof Folder ? (folder = (Folder)this.mFolder) instanceof SearchFolder || folder.getDefaultView() == 6 : (zfolder = (ZFolder)this.mFolder) instanceof ZSearchFolder || zfolder.getDefaultView() == ZFolder.View.contact) {
            return false;
        }
        if (rights == 0) {
            return true;
        }
        return (this.getFolderRights() & rights) == rights;
    }

    boolean isSelectable() throws ServiceException {
        if (!this.isVisible()) {
            return false;
        }
        if (this.mFolder instanceof Folder) {
            Folder folder = (Folder)this.mFolder;
            if (folder.getId() == 1) {
                return false;
            }
            if (folder.isTagged(-8)) {
                return false;
            }
        } else {
            ZFolder zfolder = (ZFolder)this.mFolder;
            if (new ItemId(zfolder.getId(), (String)null).getId() == 1) {
                return false;
            }
            if (zfolder.isIMAPDeleted()) {
                return false;
            }
        }
        return this.mReferent == this ? true : this.mReferent.isSelectable();
    }

    boolean isVisible() throws ServiceException {
        String lcname;
        if (this.mCredentials != null && this.mCredentials.isHackEnabled(ImapCredentials.EnabledHack.WM5) && (lcname = this.mPath.toLowerCase()).startsWith("sent items") && (lcname.length() == 10 || lcname.charAt(10) == '/')) {
            return false;
        }
        try {
            this.getFolder();
        }
        catch (ServiceException e) {
            if ("service.PERM_DENIED".equals(e.getCode())) {
                return false;
            }
            throw e;
        }
        if (this.mOwner != null && this.belongsTo(this.mCredentials)) {
            return false;
        }
        if (this.mFolder instanceof Folder) {
            Folder folder = (Folder)this.mFolder;
            if (folder.isHidden()) {
                return false;
            }
            if (folder.getId() == 1 && this.mScope != Scope.REFERENCE) {
                return false;
            }
            byte view = folder.getDefaultView();
            if (view == 11 || view == 15 || view == 14 || view == 8) {
                return false;
            }
            if (this.mReferent != this && folder.inTrash() && !((Mountpoint)folder).getTarget().equals(this.mReferent.asItemId())) {
                return false;
            }
            if (folder instanceof Mountpoint && this.mReferent == this && this.mScope != Scope.UNPARSED) {
                return false;
            }
            if (folder instanceof SearchFolder) {
                return ((SearchFolder)folder).isImapVisible();
            }
        } else {
            ZFolder zfolder = (ZFolder)this.mFolder;
            if (this.asItemId().getId() == 1 && this.mScope != Scope.REFERENCE) {
                return false;
            }
            ZFolder.View view = zfolder.getDefaultView();
            if (view == ZFolder.View.appointment || view == ZFolder.View.task || view == ZFolder.View.wiki || view == ZFolder.View.document) {
                return false;
            }
            if (zfolder instanceof ZSearchFolder || zfolder instanceof ZMountpoint) {
                return false;
            }
        }
        return this.mReferent == this ? true : this.mReferent.isVisible();
    }

    String asZimbraPath() {
        return this.mPath;
    }

    String asResolvedPath() throws ServiceException {
        return this.getReferent().mPath;
    }

    ItemId asItemId() throws ServiceException {
        if (this.useReferent()) {
            return this.getReferent().mItemId;
        }
        if (this.mItemId == null) {
            this.getFolder();
        }
        return this.mItemId;
    }

    public String toString() {
        return this.asImapPath();
    }

    String asImapPath() {
        String path = this.mPath;
        String lcpath = path.toLowerCase();
        if (lcpath.startsWith("inbox") && (lcpath.length() == 5 || lcpath.charAt(5) == '/')) {
            path = "INBOX" + path.substring(5);
        } else if (this.mCredentials != null && this.mCredentials.isHackEnabled(ImapCredentials.EnabledHack.WM5) && lcpath.startsWith("sent") && (lcpath.length() == 4 || lcpath.charAt(4) == '/')) {
            path = "Sent Items" + path.substring(4);
        }
        if (this.mOwner != null && !this.mOwner.equals("")) {
            path = NAMESPACE_PREFIX + this.mOwner + (path.equals("") ? "" : "/") + path;
        }
        return path;
    }

    String asUtf7String() {
        ByteBuffer bb = FOLDER_ENCODING_CHARSET.encode(this.asImapPath());
        byte[] content = new byte[bb.limit() + 2];
        content[0] = 34;
        System.arraycopy(bb.array(), 0, content, 1, content.length - 2);
        content[content.length - 1] = 34;
        return new String(content).replaceAll("\\\\", "\\\\\\\\");
    }

    static {
        try {
            FOLDER_ENCODING_CHARSET = Charset.forName("imap-utf-7");
        }
        catch (Exception e) {
            ZimbraLog.imap.error((Object)"could not load imap-utf-7 charset (perhaps zimbra-charset.jar is not in the jetty endorsed directory)", e);
            FOLDER_ENCODING_CHARSET = Charset.forName("utf-8");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Scope {
        UNPARSED,
        NAME,
        CONTENT,
        REFERENCE;

    }
}

