/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.QPDecoderStream;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.imap.ImapHandler;
import com.zimbra.cs.imap.ImapMessage;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mime.Mime;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImapPartSpecifier {
    static final int MAX_PINNED_BINARY_CONTENT = 100000;
    private String mCommand;
    private String mPart;
    private String mModifier;
    private int mOctetStart = -1;
    private int mOctetEnd = -1;
    private List<String> mHeaders;
    private static final String[] NO_HEADERS = new String[0];

    ImapPartSpecifier(String cmd, String part, String modifier) {
        this.mCommand = cmd;
        this.mPart = part;
        this.mModifier = modifier;
    }

    ImapPartSpecifier(String cmd, String part, String modifier, int start, int count) {
        this.mCommand = cmd;
        this.mPart = part;
        this.mModifier = modifier;
        this.setPartial(start, count);
    }

    void setPartial(int start, int count) {
        if (start >= 0 && count >= 0) {
            this.mOctetStart = start;
            this.mOctetEnd = start + count;
        }
    }

    boolean isEntireMessage() {
        return this.mPart.equals("") && this.mModifier.equals("");
    }

    ImapPartSpecifier setHeaders(List<String> headers) {
        this.mHeaders = headers;
        return this;
    }

    private String[] getHeaders() {
        if (this.mHeaders == null || this.mHeaders.isEmpty()) {
            return NO_HEADERS;
        }
        String[] headers = new String[this.mHeaders.size()];
        for (int i = 0; i < this.mHeaders.size(); ++i) {
            headers[i] = this.mHeaders.get(i);
        }
        return headers;
    }

    public String toString() {
        StringBuilder response = new StringBuilder(this.mCommand);
        if (this.mCommand.equals("BODY") || this.mCommand.equals("BINARY") || this.mCommand.equals("BINARY.SIZE")) {
            response.append('[').append(this.getSectionSpec()).append(']');
            if (this.mOctetStart != -1) {
                response.append('<').append(this.mOctetStart).append('>');
            }
        }
        return response.toString();
    }

    String getSectionSpec() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mPart).append(this.mPart.equals("") || this.mModifier.equals("") ? "" : ".").append(this.mModifier);
        if (this.mHeaders != null) {
            boolean first = true;
            sb.append(" (");
            for (String header : this.mHeaders) {
                sb.append(first ? "" : " ").append(header.toUpperCase());
                first = false;
            }
            sb.append(')');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(PrintStream ps, OutputStream os, Object obj) throws IOException, BinaryDecodingException, ServiceException {
        Pair<Long, InputStream> contents = this.getContent(obj);
        InputStream is = contents == null ? null : contents.getSecond();
        long length = contents == null ? -1L : contents.getFirst();
        ps.print(this);
        ps.write(32);
        try {
            if (is == null) {
                ps.print("NIL");
            } else if (this.mCommand.equals("BINARY.SIZE")) {
                ps.print(length >= 0L ? length : NULCheck.getLength(is));
            } else {
                boolean binary = false;
                if (this.mCommand.startsWith("BINARY")) {
                    NULCheck nul = NULCheck.hasNULs(is, length);
                    if (length < 0L) {
                        length = nul.length;
                    }
                    is = nul.content == null ? this.getContent(obj).getSecond() : new ByteArrayInputStream(nul.content);
                    binary = nul.hasNULs;
                }
                ps.print(binary ? "~{" : "{");
                ps.print(length);
                ps.write(125);
                if (os != null) {
                    os.write(ImapHandler.LINE_SEPARATOR_BYTES);
                    long written = ByteUtil.copy(is, false, os, false);
                    assert (written == length);
                }
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
    }

    Pair<Long, InputStream> getContent(Object obj) throws IOException, BinaryDecodingException, ServiceException {
        Pair<Long, InputStream> contents;
        if (obj instanceof MimeMessage) {
            contents = this.getContent((MimeMessage)obj);
        } else if (obj instanceof MailItem) {
            if (!this.isEntireMessage()) {
                throw ServiceException.FAILURE("called writeMessage on non-toplevel part", null);
            }
            contents = ImapMessage.getContent((MailItem)obj);
        } else {
            throw ServiceException.FAILURE("called write() with unexpected argument: " + (obj == null ? "null" : obj.getClass().getSimpleName()), null);
        }
        if (this.mOctetStart >= 0 && contents != null) {
            InputStream is = contents.getSecond();
            long statedLength = contents.getFirst();
            long realLength = Math.max(0L, Math.min(statedLength < 0L ? Integer.MAX_VALUE : statedLength, (long)this.mOctetEnd) - (long)this.mOctetStart);
            try {
                int start = this.mOctetStart;
                if (is instanceof BASE64DecoderStream || is instanceof QPDecoderStream) {
                    ByteUtil.skip(is, start);
                    start = 0;
                }
                is = ByteUtil.SegmentInputStream.create(is, start, (long)start + realLength);
            }
            catch (IOException ioe) {
                ByteUtil.closeStream(is);
                throw ioe;
            }
            contents = new Pair<Long, InputStream>(statedLength < 0L ? -1L : realLength, is);
        }
        return contents;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pair<Long, InputStream> getContent(MimeMessage msg) throws BinaryDecodingException {
        long length = -1L;
        InputStream is = null;
        try {
            MimePart mp = Mime.getMimePart((MimePart)msg, this.mPart);
            if (mp == null) {
                return null;
            }
            if ((this.mModifier.equals("TEXT") || this.mModifier.startsWith("HEADER")) && !(mp instanceof MimeMessage)) {
                MimeMessage content = Mime.getMessageContent(mp);
                if (!(content instanceof MimeMessage)) {
                    return null;
                }
                mp = content;
            }
            if (this.mModifier.equals("")) {
                if (mp instanceof MimeBodyPart) {
                    if (!this.mCommand.startsWith("BINARY")) {
                        is = ((MimeBodyPart)mp).getRawInputStream();
                        length = Math.max(0, mp.getSize());
                        return new Pair<Long, InputStream>(length, is);
                    }
                    try {
                        is = ((MimeBodyPart)mp).getInputStream();
                        return new Pair<Long, InputStream>(length, is);
                    }
                    catch (IOException ioe) {
                        throw new BinaryDecodingException();
                    }
                }
                if (!(mp instanceof MimeMessage)) {
                    ZimbraLog.imap.debug("getting content of part; not MimeBodyPart: " + this);
                    return ImapMessage.EMPTY_CONTENT;
                }
                if (!this.mCommand.startsWith("BINARY")) {
                    is = ((MimeMessage)mp).getRawInputStream();
                    length = Math.max(0, mp.getSize());
                    return new Pair<Long, InputStream>(length, is);
                }
                try {
                    is = ((MimeMessage)mp).getInputStream();
                    return new Pair<Long, InputStream>(length, is);
                }
                catch (IOException ioe) {
                    throw new BinaryDecodingException();
                }
            }
            if (this.mModifier.startsWith("HEADER")) {
                MimeMessage mm = (MimeMessage)mp;
                Enumeration headers = this.mModifier.equals("HEADER") ? mm.getAllHeaderLines() : (this.mModifier.equals("HEADER.FIELDS") ? mm.getMatchingHeaderLines(this.getHeaders()) : mm.getNonMatchingHeaderLines(this.getHeaders()));
                StringBuilder result = new StringBuilder();
                while (true) {
                    if (!headers.hasMoreElements()) {
                        byte[] content = result.append(ImapHandler.LINE_SEPARATOR).toString().getBytes();
                        is = new ByteArrayInputStream(content);
                        length = content.length;
                        return new Pair<Long, InputStream>(length, is);
                    }
                    result.append(headers.nextElement()).append(ImapHandler.LINE_SEPARATOR);
                }
            }
            if (!this.mModifier.equals("MIME")) {
                if (!this.mModifier.equals("TEXT")) return null;
                is = ((MimeMessage)mp).getRawInputStream();
                length = Math.max(0, mp.getSize());
                return new Pair<Long, InputStream>(length, is);
            }
            Enumeration mime = mp.getAllHeaderLines();
            StringBuilder result = new StringBuilder();
            while (true) {
                if (!mime.hasMoreElements()) {
                    byte[] content = result.append(ImapHandler.LINE_SEPARATOR).toString().getBytes();
                    is = new ByteArrayInputStream(content);
                    length = content.length;
                    return new Pair<Long, InputStream>(length, is);
                }
                result.append(mime.nextElement()).append(ImapHandler.LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            ByteUtil.closeStream(is);
            return null;
        }
        catch (MessagingException e) {
            ByteUtil.closeStream(is);
            return null;
        }
    }

    private static class NULCheck {
        long length;
        byte[] content;
        boolean hasNULs;

        private NULCheck() {
        }

        static long getLength(InputStream is) throws BinaryDecodingException {
            return NULCheck.scan((InputStream)is, (long)-1L, (boolean)false).length;
        }

        static NULCheck hasNULs(InputStream is, long length) throws BinaryDecodingException {
            return NULCheck.scan(is, length, true);
        }

        private static NULCheck scan(InputStream is, long length, boolean checkNULs) throws BinaryDecodingException {
            NULCheck nul = new NULCheck();
            long totalSize = 0L;
            ByteArrayOutputStream baos = null;
            if (checkNULs && length <= 100000L) {
                baos = new ByteArrayOutputStream(length < 0L ? 50000 : (int)length);
            }
            byte[] buffer = new byte[8192];
            try {
                try {
                    int bytesRead;
                    while ((bytesRead = is.read(buffer)) >= 0) {
                        if (checkNULs && !nul.hasNULs) {
                            for (int i = 0; i < bytesRead; ++i) {
                                if (buffer[i] != 0) continue;
                                nul.hasNULs = true;
                                break;
                            }
                        }
                        if (length < 0L && (totalSize += (long)bytesRead) > 100000L && baos != null) {
                            baos = null;
                        }
                        if (baos != null) {
                            baos.write(buffer, 0, bytesRead);
                            continue;
                        }
                        if (!nul.hasNULs || length <= 0L) continue;
                    }
                }
                catch (IOException ioe) {
                    throw new BinaryDecodingException();
                }
                {
                    break;
                }
                Object var12_10 = null;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
            ByteUtil.closeStream(is);
            if (baos != null) {
                nul.content = baos.toByteArray();
            }
            if (length < 0L) {
                nul.length = totalSize;
            }
            return nul;
        }
    }

    static class BinaryDecodingException
    extends Exception {
        private static final long serialVersionUID = 8158363540973909369L;

        BinaryDecodingException() {
        }
    }
}

