/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.mime.ContentDisposition;
import com.zimbra.common.mime.ContentType;
import com.zimbra.common.mime.MimeCompoundHeader;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.imap.ImapFlagCache;
import com.zimbra.cs.imap.ImapFolder;
import com.zimbra.cs.imap.ImapHandler;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mime.MPartInfo;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.service.formatter.VCard;
import com.zimbra.cs.util.JMSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.BCodec;
import org.apache.commons.codec.net.QCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapMessage
implements Comparable<ImapMessage> {
    public static final List<Byte> SUPPORTED_TYPES = Arrays.asList((byte)5, (byte)16, (byte)6);
    static final short FLAG_RECENT = 1;
    static final short FLAG_SPAM = 2;
    static final short FLAG_NONSPAM = 4;
    static final short FLAG_JUNKRECORDED = 8;
    static final short FLAG_IS_CONTACT = 16;
    static final short FLAG_ADDED = 256;
    static final short FLAG_EXPUNGED = 512;
    static final int IMAP_FLAGS = Flag.BITMASK_UNREAD | Flag.BITMASK_FLAGGED | Flag.BITMASK_DELETED | Flag.BITMASK_DRAFT | Flag.BITMASK_REPLIED | Flag.BITMASK_FORWARDED | Flag.BITMASK_NOTIFIED;
    static final short MUTABLE_SESSION_FLAGS = 14;
    static final short SESSION_FLAGS = 799;
    int sequence;
    int msgId;
    int imapUid;
    int flags;
    long tags;
    short sflags;
    private static final DateFormat GMT_DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z (z)", Locale.US);
    static final Pair<Long, InputStream> EMPTY_CONTENT;
    private static final String NO_FLAGS = "FLAGS ()";
    private static final byte[] NIL;

    public ImapMessage(int id, byte type, int imapId, int flag, long tag) {
        this.msgId = id;
        this.imapUid = imapId;
        this.flags = flag;
        this.tags = tag;
        this.sflags = (short)(type == 6 ? 16 : 0);
    }

    public ImapMessage(MailItem item) {
        this(item.getId(), item.getType(), item.getImapUid(), item.getFlagBitmask(), item.getTagBitmask());
    }

    byte getType() {
        return (this.sflags & 0x10) == 0 ? (byte)5 : 6;
    }

    long getSize(MailItem item) throws ServiceException {
        if (item instanceof Message) {
            return item.getSize();
        }
        return ImapMessage.getContent(item).getFirst();
    }

    boolean isExpunged() {
        return (this.sflags & 0x200) != 0;
    }

    boolean isAdded() {
        return (this.sflags & 0x100) != 0;
    }

    void setExpunged(boolean expunged) {
        this.sflags = (short)(expunged ? this.sflags | 0x200 : this.sflags & 0xFFFFFDFF);
    }

    void setAdded(boolean added) {
        this.sflags = (short)(added ? this.sflags | 0x100 : this.sflags & 0xFFFFFEFF);
    }

    @Override
    public int compareTo(ImapMessage i4msg) {
        if (this.imapUid == i4msg.imapUid) {
            return 0;
        }
        return this.imapUid < i4msg.imapUid ? -1 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Pair<Long, InputStream> getContent(MailItem item) throws ServiceException {
        if (item instanceof Message) {
            return new Pair<Long, InputStream>(item.getSize(), item.getContentStream());
        }
        if (item instanceof Contact) {
            try {
                VCard vcard = VCard.formatContact((Contact)item);
                QCodec qcodec = new QCodec();
                qcodec.setEncodeBlanks(true);
                StringBuilder header = new StringBuilder();
                header.append("Subject: ").append(qcodec.encode(vcard.fn, "utf-8")).append(ImapHandler.LINE_SEPARATOR);
                DateFormat dateFormat = GMT_DATE_FORMAT;
                synchronized (dateFormat) {
                    header.append("Date: ").append(GMT_DATE_FORMAT.format(new Date(item.getDate()))).append(ImapHandler.LINE_SEPARATOR);
                }
                header.append("Content-Type: text/x-vcard; charset=\"utf-8\"").append(ImapHandler.LINE_SEPARATOR);
                header.append("Content-Transfer-Encoding: 8bit").append(ImapHandler.LINE_SEPARATOR);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(header.toString().getBytes("us-ascii"));
                baos.write(ImapHandler.LINE_SEPARATOR_BYTES);
                baos.write(vcard.formatted.getBytes("utf-8"));
                return new Pair<Long, InputStream>(Long.valueOf(baos.size()), new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (Exception e) {
                throw ServiceException.FAILURE("problems serializing contact " + item.getId(), e);
            }
        }
        return EMPTY_CONTENT;
    }

    static MimeMessage getMimeMessage(MailItem item) throws ServiceException {
        Mime.FixedMimeMessage fixedMimeMessage;
        if (item instanceof Message) {
            return ((Message)item).getMimeMessage(false);
        }
        InputStream is = ImapMessage.getContent(item).getSecond();
        try {
            fixedMimeMessage = new Mime.FixedMimeMessage(JMSession.getSession(), is);
            Object var4_4 = null;
        }
        catch (MessagingException e) {
            try {
                throw ServiceException.FAILURE("error creating MimeMessage for " + MailItem.getNameForType(item.getType()) + ' ' + item.getId(), e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                ByteUtil.closeStream(is);
                throw throwable;
            }
        }
        ByteUtil.closeStream(is);
        return fixedMimeMessage;
    }

    int getModseq(MailItem item, ImapFlagCache i4cache) {
        return Math.max(item.getModifiedSequence(), this.getFlagModseq(i4cache));
    }

    int getFlagModseq(ImapFlagCache i4cache) {
        int modseq = 0;
        long tagBuffer = this.tags;
        for (int i = 0; tagBuffer != 0L && i < 64; ++i) {
            long mask = 1L << i;
            if ((tagBuffer & mask) == 0L) continue;
            ImapFlagCache.ImapFlag i4flag = i4cache.getByMask(mask);
            if (i4flag != null) {
                modseq = Math.max(modseq, i4flag.mModseq);
            }
            tagBuffer &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return modseq;
    }

    void setPermanentFlags(int f, long t, int changeId, ImapFolder parent) {
        if (t == this.tags && (f & IMAP_FLAGS) == (this.flags & IMAP_FLAGS)) {
            return;
        }
        this.flags = f & IMAP_FLAGS | this.flags & ~IMAP_FLAGS;
        this.tags = t;
        if (parent != null) {
            parent.dirtyMessage(this, changeId);
        }
    }

    void setSessionFlags(short s, ImapFolder parent) {
        if ((s & 0xE) == (this.sflags & 0xE)) {
            return;
        }
        this.sflags = (short)(s & 0xE | this.sflags & 0xFFFFFFF1);
        if (parent != null) {
            parent.dirtyMessage(this, -1);
        }
    }

    String getFlags(ImapFolder i4folder) {
        if ((this.flags & IMAP_FLAGS) == Flag.BITMASK_UNREAD && this.tags == 0L && this.sflags == 0) {
            return NO_FLAGS;
        }
        StringBuilder result = new StringBuilder("FLAGS (");
        int empty = result.length();
        if ((this.flags & Flag.BITMASK_DELETED) != 0) {
            result.append(result.length() == empty ? "" : " ").append("\\Deleted");
        }
        if ((this.flags & Flag.BITMASK_DRAFT) != 0) {
            result.append(result.length() == empty ? "" : " ").append("\\Draft");
        }
        if ((this.flags & Flag.BITMASK_FLAGGED) != 0) {
            result.append(result.length() == empty ? "" : " ").append("\\Flagged");
        }
        if ((this.flags & Flag.BITMASK_REPLIED) != 0) {
            result.append(result.length() == empty ? "" : " ").append("\\Answered");
        }
        if ((this.flags & Flag.BITMASK_NOTIFIED) != 0) {
            result.append(result.length() == empty ? "" : " ").append("$MDNSent");
        }
        if ((this.flags & Flag.BITMASK_FORWARDED) != 0) {
            result.append(result.length() == empty ? "" : " ").append("$Forwarded Forwarded");
        }
        if ((this.flags & Flag.BITMASK_UNREAD) == 0) {
            result.append(result.length() == empty ? "" : " ").append("\\Seen");
        }
        if ((this.sflags & 1) != 0) {
            result.append(result.length() == empty ? "" : " ").append("\\Recent");
        }
        if ((this.sflags & 2) != 0) {
            result.append(result.length() == empty ? "" : " ").append("$Junk Junk");
        }
        if ((this.sflags & 4) != 0) {
            result.append(result.length() == empty ? "" : " ").append("$NotJunk NotJunk NonJunk");
        }
        if ((this.sflags & 8) != 0) {
            result.append(result.length() == empty ? "" : " ").append("JunkRecorded");
        }
        long tagBuffer = this.tags;
        for (int i = 0; tagBuffer != 0L && i < 64; ++i) {
            ImapFlagCache.ImapFlag other;
            long mask = 1L << i;
            if ((tagBuffer & mask) == 0L) continue;
            ImapFlagCache.ImapFlag i4flag = i4folder.getTagByMask(mask);
            if (i4flag != null && ((other = i4folder.getFlagByName(i4flag.mImapName)) == null || other == i4flag)) {
                result.append(result.length() == empty ? "" : " ").append(i4flag);
            }
            tagBuffer &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return result.append(')').toString();
    }

    private static void nstring(PrintStream ps, String value) {
        if (value == null) {
            ps.write(NIL, 0, 3);
        } else {
            ImapMessage.astring(ps, value, false);
        }
    }

    private static void astring(PrintStream ps, String value) {
        if (value == null) {
            ps.print("\"\"");
        } else {
            ImapMessage.astring(ps, value, false);
        }
    }

    private static void aSTRING(PrintStream ps, String value) {
        if (value == null) {
            ps.print("\"\"");
        } else {
            ImapMessage.astring(ps, value, true);
        }
    }

    private static void astring(PrintStream ps, String value, boolean upcase) {
        String content;
        int i;
        boolean literal = false;
        StringBuilder nonulls = null;
        int lastNull = -1;
        int length = value.length();
        for (i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '\u0000') {
                if (nonulls == null) {
                    nonulls = new StringBuilder();
                }
                nonulls.append(value.substring(lastNull + 1, i));
                lastNull = i;
                continue;
            }
            if (c != '\"' && c != '\\' && c < '\u007f' && c >= ' ') continue;
            literal = true;
        }
        String string = content = nonulls == null ? value : nonulls.append(value.substring(lastNull + 1, i)).toString();
        if (upcase) {
            content = content.toUpperCase();
        }
        if (!literal) {
            ps.write(34);
            ps.print(content);
            ps.write(34);
        } else {
            try {
                byte[] bytes = content.getBytes("utf-8");
                ps.write(123);
                ps.print(bytes.length);
                ps.write(125);
                ps.write(ImapHandler.LINE_SEPARATOR_BYTES, 0, 2);
                ps.write(bytes, 0, bytes.length);
            }
            catch (UnsupportedEncodingException uee) {
                ps.write(NIL, 0, 3);
            }
        }
    }

    private static void nstring2047(PrintStream ps, String value) {
        if (value == null) {
            ps.write(NIL, 0, 3);
            return;
        }
        boolean encoded = false;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c != '\"' && c != '\\' && c < '\u007f' && c >= ' ') continue;
            encoded = true;
        }
        if (!encoded) {
            ps.write(34);
            ps.print(value);
            ps.write(34);
        } else {
            try {
                ps.write(34);
                ps.print(new BCodec().encode(value, "utf-8"));
                ps.write(34);
            }
            catch (EncoderException ee) {
                ps.write(NIL, 0, 3);
            }
        }
    }

    private static void address(PrintStream ps, InternetAddress addr) {
        int colon;
        String address = addr.getAddress().trim();
        String route = null;
        if (address.startsWith("@") && (colon = address.indexOf(58)) != -1) {
            route = address.substring(0, colon);
            address = address.substring(colon + 1);
        }
        String[] parts = address.split("@", 2);
        ps.write(40);
        ImapMessage.nstring2047(ps, addr.getPersonal());
        ps.write(32);
        ImapMessage.nstring(ps, route);
        ps.write(32);
        ImapMessage.nstring(ps, parts[0]);
        ps.write(32);
        ImapMessage.nstring(ps, parts.length > 1 ? parts[1] : null);
        ps.write(41);
    }

    private static void naddresses(PrintStream ps, InternetAddress[] addrs) {
        int count = 0;
        if (addrs != null && addrs.length > 0) {
            for (InternetAddress addr : addrs) {
                if (addr.isGroup()) {
                    try {
                        String serialized = addr.getAddress();
                        int colon = serialized.indexOf(58);
                        String name = colon == -1 ? serialized : serialized.substring(0, colon);
                        InternetAddress[] members = addr.getGroup(false);
                        if (count++ == 0) {
                            ps.write(40);
                        }
                        ps.print("(NIL NIL ");
                        ImapMessage.nstring(ps, name);
                        ps.print(" NIL)");
                        if (members != null) {
                            for (InternetAddress member : members) {
                                ImapMessage.address(ps, member);
                            }
                        }
                        ps.print("(NIL NIL NIL NIL)");
                    }
                    catch (ParseException e) {}
                    continue;
                }
                if (addr.getAddress() == null) continue;
                if (count++ == 0) {
                    ps.write(40);
                }
                ImapMessage.address(ps, addr);
            }
        }
        if (count == 0) {
            ps.write(NIL, 0, 3);
        } else {
            ps.write(41);
        }
    }

    private static void nlist(PrintStream ps, String[] list) {
        if (list == null || list.length == 0) {
            ps.print("NIL");
        } else if (list.length == 1) {
            ImapMessage.astring(ps, list[0]);
        } else {
            ps.write(40);
            for (int i = 0; i < list.length; ++i) {
                if (i != 0) {
                    ps.write(32);
                }
                ImapMessage.astring(ps, list[i]);
            }
            ps.write(41);
        }
    }

    private static void nparams(PrintStream ps, MimeCompoundHeader header) {
        boolean first = true;
        Iterator<Map.Entry<String, String>> it = header.getParameterIterator();
        while (it.hasNext()) {
            Map.Entry<String, String> param = it.next();
            ps.print(first ? (char)'(' : ' ');
            ImapMessage.aSTRING(ps, param.getKey());
            ps.write(32);
            ImapMessage.nstring2047(ps, param.getValue());
            first = false;
        }
        ps.print(first ? "NIL" : ")");
    }

    private static void ndisposition(PrintStream ps, String disposition) {
        if (disposition == null) {
            ps.print("NIL");
        } else {
            ContentDisposition cdisp = new ContentDisposition(disposition);
            ps.write(40);
            ImapMessage.astring(ps, cdisp.getValue());
            ps.write(32);
            ImapMessage.nparams(ps, cdisp);
            ps.write(41);
        }
    }

    static void serializeEnvelope(PrintStream ps, MimeMessage mm) throws MessagingException {
        InternetAddress[] from = Mime.parseAddressHeader(mm, "From", false);
        InternetAddress[] sender = Mime.parseAddressHeader(mm, "Sender", false);
        InternetAddress[] replyTo = Mime.parseAddressHeader(mm, "Reply-To", false);
        ps.write(40);
        ImapMessage.nstring(ps, mm.getHeader("Date", ","));
        ps.write(32);
        ImapMessage.nstring2047(ps, Mime.getSubject(mm));
        ps.write(32);
        ImapMessage.naddresses(ps, from);
        ps.write(32);
        ImapMessage.naddresses(ps, sender.length == 0 ? from : sender);
        ps.write(32);
        ImapMessage.naddresses(ps, replyTo.length == 0 ? from : replyTo);
        ps.write(32);
        ImapMessage.naddresses(ps, Mime.parseAddressHeader(mm, "To", false));
        ps.write(32);
        ImapMessage.naddresses(ps, Mime.parseAddressHeader(mm, "CC", false));
        ps.write(32);
        ImapMessage.naddresses(ps, Mime.parseAddressHeader(mm, "BCC", false));
        ps.write(32);
        ImapMessage.nstring(ps, mm.getHeader("In-Reply-To", " "));
        ps.write(32);
        ImapMessage.nstring(ps, mm.getMessageID());
        ps.write(41);
    }

    private static String nATOM(String value) {
        return value == null ? "NIL" : '\"' + value.toUpperCase() + '\"';
    }

    static void serializeStructure(PrintStream ps, MimeMessage root, boolean extensions) throws IOException, MessagingException {
        LinkedList<LinkedList<MPartInfo>> queue = new LinkedList<LinkedList<MPartInfo>>();
        LinkedList level = new LinkedList();
        level.add(Mime.getParts(root).get(0));
        queue.add(level);
        boolean pop = false;
        while (!queue.isEmpty()) {
            level = (LinkedList)queue.getLast();
            if (level.isEmpty()) {
                queue.removeLast();
                pop = true;
                continue;
            }
            MPartInfo mpart = (MPartInfo)level.getFirst();
            MimePart mp = mpart.getMimePart();
            boolean hasChildren = mpart.getChildren() != null && !mpart.getChildren().isEmpty();
            ContentType ctype = new ContentType(mp.getHeader("Content-Type", null)).setValue(mpart.getContentType());
            String primary = ImapMessage.nATOM(ctype.getPrimaryType());
            String subtype = ImapMessage.nATOM(ctype.getSubType());
            if (!pop) {
                ps.write(40);
            }
            if (primary.equals("\"MULTIPART\"")) {
                if (!pop) {
                    if (!hasChildren) {
                        ps.print("NIL");
                    } else {
                        queue.addLast(new LinkedList<MPartInfo>(mpart.getChildren()));
                        continue;
                    }
                }
                ps.write(32);
                ps.print(subtype);
                if (extensions) {
                    ps.write(32);
                    ImapMessage.nparams(ps, ctype);
                    ps.write(32);
                    ImapMessage.ndisposition(ps, mp.getHeader("Content-Disposition", null));
                    ps.write(32);
                    ImapMessage.nlist(ps, mp.getContentLanguage());
                    ps.write(32);
                    ImapMessage.nstring(ps, mp.getHeader("Content-Location", null));
                }
            } else {
                boolean rfc822;
                if (!pop) {
                    String cte = mp.getEncoding();
                    cte = cte == null || cte.trim().equals("") ? "7bit" : cte;
                    ImapMessage.aSTRING(ps, ctype.getPrimaryType());
                    ps.write(32);
                    ImapMessage.aSTRING(ps, ctype.getSubType());
                    ps.write(32);
                    ImapMessage.nparams(ps, ctype);
                    ps.write(32);
                    ImapMessage.nstring(ps, mp.getContentID());
                    ps.write(32);
                    ImapMessage.nstring2047(ps, mp.getDescription());
                    ps.write(32);
                    ImapMessage.aSTRING(ps, cte);
                    ps.write(32);
                    ps.print(Math.max(mp.getSize(), 0));
                }
                boolean bl = rfc822 = primary.equals("\"MESSAGE\"") && subtype.equals("\"RFC822\"");
                if (rfc822) {
                    if (!pop) {
                        if (!hasChildren) {
                            ps.print(" NIL NIL");
                        } else {
                            MimeMessage mm = (MimeMessage)mpart.getChildren().get(0).getMimePart();
                            ps.write(32);
                            ImapMessage.serializeEnvelope(ps, mm);
                            ps.write(32);
                            queue.addLast(new LinkedList<MPartInfo>(mpart.getChildren()));
                            continue;
                        }
                    }
                    ps.write(32);
                    ps.print(ImapMessage.getLineCount(mp));
                } else if (primary.equals("\"TEXT\"")) {
                    ps.write(32);
                    ps.print(ImapMessage.getLineCount(mp));
                }
                if (extensions) {
                    ps.write(32);
                    ImapMessage.nstring(ps, mp.getContentMD5());
                    ps.write(32);
                    ImapMessage.ndisposition(ps, mp.getHeader("Content-Disposition", null));
                    ps.write(32);
                    ImapMessage.nlist(ps, mp.getContentLanguage());
                    ps.write(32);
                    ImapMessage.nstring(ps, mp.getHeader("Content-Location", null));
                }
            }
            ps.write(41);
            level.removeFirst();
            pop = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getLineCount(MimePart mp) {
        int n;
        InputStream is;
        block11: {
            int n2;
            block10: {
                is = null;
                try {
                    try {
                        int c;
                        if (mp instanceof MimeBodyPart) {
                            is = ((MimeBodyPart)mp).getRawInputStream();
                        } else {
                            if (!(mp instanceof MimeMessage)) {
                                n2 = 0;
                                Object var7_6 = null;
                                break block10;
                            }
                            is = ((MimeMessage)mp).getRawInputStream();
                        }
                        int lines = 0;
                        boolean complete = false;
                        while ((c = is.read()) != -1) {
                            complete = c == 10;
                            if (!complete) continue;
                            ++lines;
                        }
                        n = complete ? lines : lines + 1;
                        break block11;
                    }
                    catch (MessagingException e) {
                        int n3 = 0;
                        Object var7_8 = null;
                        ByteUtil.closeStream(is);
                        return n3;
                    }
                    catch (IOException e) {
                        int n4 = 0;
                        Object var7_9 = null;
                        ByteUtil.closeStream(is);
                        return n4;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    ByteUtil.closeStream(is);
                    throw throwable;
                }
            }
            ByteUtil.closeStream(is);
            return n2;
        }
        Object var7_7 = null;
        ByteUtil.closeStream(is);
        return n;
    }

    public static void main(String[] args) {
        String[] samples;
        PrintStream ps = new PrintStream(System.out);
        ps.print(ImapHandler.LINE_SEPARATOR_BYTES);
        for (String s : samples = new String[]{null, "test", "\u0442", "ha\nnd", "\"dog\"", "ca\"t", "\u0000fr\u0000og\u0000"}) {
            ImapMessage.nstring2047(ps, s);
            ps.write(32);
            ImapMessage.nstring(ps, s);
            ps.write(32);
            ImapMessage.astring(ps, s);
            ps.write(32);
            ImapMessage.aSTRING(ps, s);
            ps.write(10);
        }
    }

    static {
        GMT_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        EMPTY_CONTENT = new Pair<Long, ByteArrayInputStream>(0L, new ByteArrayInputStream(new byte[0]));
        NIL = new byte[]{78, 73, 76};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SequenceComparator
    implements Comparator<ImapMessage> {
        SequenceComparator() {
        }

        @Override
        public int compare(ImapMessage o1, ImapMessage o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.sequence < o2.sequence ? -1 : (o1.sequence == o2.sequence ? 0 : 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImapMessageSet
    extends TreeSet<ImapMessage> {
        private static final long serialVersionUID = 4831178352505203361L;

        ImapMessageSet() {
            super(new SequenceComparator());
        }

        ImapMessageSet(Collection<ImapMessage> msgs) {
            this();
            this.addAll(msgs);
        }
    }
}

