/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ArrayUtil;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.MailTarget;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.imap.AppendMessage;
import com.zimbra.cs.imap.ImapAuthenticatorUser;
import com.zimbra.cs.imap.ImapConfig;
import com.zimbra.cs.imap.ImapCredentials;
import com.zimbra.cs.imap.ImapFlagCache;
import com.zimbra.cs.imap.ImapFolder;
import com.zimbra.cs.imap.ImapMessage;
import com.zimbra.cs.imap.ImapParseException;
import com.zimbra.cs.imap.ImapPartSpecifier;
import com.zimbra.cs.imap.ImapPath;
import com.zimbra.cs.imap.ImapProxy;
import com.zimbra.cs.imap.ImapRequest;
import com.zimbra.cs.imap.ImapSearch;
import com.zimbra.cs.imap.ImapServer;
import com.zimbra.cs.imap.ImapServiceException;
import com.zimbra.cs.imap.MinaImapServer;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.index.queryparser.ParseException;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.SearchFolder;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.WellKnownTimeZones;
import com.zimbra.cs.security.sasl.Authenticator;
import com.zimbra.cs.security.sasl.PlainAuthenticator;
import com.zimbra.cs.service.mail.FolderAction;
import com.zimbra.cs.service.mail.ItemActionHelper;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.tcpserver.ProtocolHandler;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZGrant;
import com.zimbra.cs.zclient.ZMailbox;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ImapHandler
extends ProtocolHandler {
    private static final long MAXIMUM_IDLE_PROCESSING_MILLIS = 15000L;
    private static final String ID_PARAMS = "\"NAME\" \"Zimbra\" \"VERSION\" \"" + BuildInfo.VERSION + "\" \"RELEASE\" \"" + BuildInfo.RELEASE + "\"";
    static final char[] LINE_SEPARATOR = new char[]{'\r', '\n'};
    static final byte[] LINE_SEPARATOR_BYTES = new byte[]{13, 10};
    protected ImapConfig mConfig;
    protected OutputStream mOutputStream;
    protected Authenticator mAuthenticator;
    protected ImapCredentials mCredentials;
    protected boolean mStartedTLS;
    protected String mLastCommand;
    private ImapProxy mProxy;
    protected ImapFolder mSelectedFolder;
    private String mIdleTag;
    private String mOrigRemoteAddress;
    private String mUserAgent;
    protected boolean mGoodbyeSent;
    private Set<ImapExtension> mActiveExtensions;
    static final boolean STOP_PROCESSING = false;
    static final boolean CONTINUE_PROCESSING = true;
    private static final Set<String> SUPPORTED_EXTENSIONS = new LinkedHashSet<String>(Arrays.asList("ACL", "BINARY", "CATENATE", "CHILDREN", "CONDSTORE", "ENABLE", "ESEARCH", "ESORT", "I18NLEVEL=1", "ID", "IDLE", "LIST-EXTENDED", "LITERAL+", "LOGIN-REFERRALS", "MULTIAPPEND", "NAMESPACE", "QRESYNC", "QUOTA", "RIGHTS=ektx", "SASL-IR", "SEARCHRES", "SORT", "THREAD=ORDEREDSUBJECT", "UIDPLUS", "UNSELECT", "WITHIN", "X-DRAFT-I00-LIST-STATUS"));
    private static final byte SELECT_SUBSCRIBED = 1;
    private static final byte SELECT_REMOTE = 2;
    private static final byte SELECT_RECURSIVE = 4;
    private static final byte RETURN_SUBSCRIBED = 1;
    private static final byte RETURN_CHILDREN = 2;
    private static final boolean[] REGEXP_ESCAPED = new boolean[128];
    static final int STATUS_MESSAGES = 1;
    static final int STATUS_RECENT = 2;
    static final int STATUS_UIDNEXT = 4;
    static final int STATUS_UIDVALIDITY = 8;
    static final int STATUS_UNSEEN = 16;
    static final int STATUS_HIGHESTMODSEQ = 32;
    static final boolean IDLE_START = true;
    static final boolean IDLE_STOP = false;
    private static final String IMAP_READ_RIGHTS = "lr";
    private static final String IMAP_WRITE_RIGHTS = "sw";
    private static final String IMAP_INSERT_RIGHTS = "ick";
    private static final String IMAP_DELETE_RIGHTS = "xted";
    private static final String IMAP_ADMIN_RIGHTS = "a";
    private short SUBFOLDER_RIGHTS = (short)5;
    private static final String IMAP_CONCATENATED_RIGHTS = "lrswickxteda";
    private static final String IMAP_DELIMITED_RIGHTS = "lr sw ick xted a";
    private final int SUGGESTED_DELETE_BATCH_SIZE = 30;
    private static final int RETURN_MIN = 1;
    private static final int RETURN_MAX = 2;
    private static final int RETURN_ALL = 4;
    private static final int RETURN_COUNT = 8;
    private static final int RETURN_SAVE = 16;
    private static final int LARGEST_FOLDER_BATCH = 600;
    public static final byte[] ITEM_TYPES;
    static final int FETCH_BODY = 1;
    static final int FETCH_BODYSTRUCTURE = 2;
    static final int FETCH_ENVELOPE = 4;
    static final int FETCH_FLAGS = 8;
    static final int FETCH_INTERNALDATE = 16;
    static final int FETCH_RFC822_SIZE = 32;
    static final int FETCH_BINARY_SIZE = 64;
    static final int FETCH_UID = 128;
    static final int FETCH_MODSEQ = 256;
    static final int FETCH_VANISHED = 512;
    static final int FETCH_MARK_READ = 4096;
    private static final int FETCH_FROM_CACHE = 136;
    private static final int FETCH_FROM_MIME = 7;
    static final int FETCH_FAST = 56;
    static final int FETCH_ALL = 60;
    static final int FETCH_FULL = 61;
    private final int SUGGESTED_BATCH_SIZE = 100;
    private final int SUGGESTED_COPY_BATCH_SIZE = 50;

    ImapHandler(MinaImapServer server) {
        super(null);
        this.mConfig = (ImapConfig)server.getConfig();
        this.mStartedTLS = this.mConfig.isSSLEnabled();
    }

    ImapHandler(ImapServer server) {
        super(server);
        this.mConfig = (ImapConfig)server.getConfig();
        this.mStartedTLS = this.mConfig.isSSLEnabled();
    }

    ImapCredentials getCredentials() {
        return this.mCredentials;
    }

    public boolean isSSLEnabled() {
        return this.mStartedTLS;
    }

    public ImapConfig getConfig() {
        return this.mConfig;
    }

    protected String getOrigRemoteIpAddr() {
        return this.mOrigRemoteAddress;
    }

    protected void setOrigRemoteIpAddr(String ip) {
        this.mOrigRemoteAddress = ip;
    }

    protected String getUserAgent() {
        return this.mUserAgent;
    }

    protected void setUserAgent(String ua) {
        this.mUserAgent = ua;
    }

    protected void setUpLogContext(String remoteAddress) {
        ZimbraLog.clearContext();
        ImapFolder i4selected = this.mSelectedFolder;
        Mailbox mbox = i4selected == null ? null : i4selected.getMailbox();
        String origRemoteIp = this.getOrigRemoteIpAddr();
        if (this.mCredentials != null) {
            ZimbraLog.addAccountNameToContext(this.mCredentials.getUsername());
        }
        if (mbox != null) {
            ZimbraLog.addMboxToContext(mbox.getId());
        }
        if (origRemoteIp != null) {
            ZimbraLog.addOrigIpToContext(origRemoteIp);
        }
        ZimbraLog.addIpToContext(remoteAddress);
    }

    protected void handleParseException(ImapParseException e) throws IOException {
        String message = (e.mCode == null ? "" : '[' + e.mCode + "] ") + e.getMessage();
        if (e.mTag == null) {
            this.sendUntagged("BAD " + message, true);
        } else if (e.mNO) {
            this.sendNO(e.mTag, message);
        } else {
            this.sendBAD(e.mTag, message);
        }
    }

    void checkEOF(String tag, ImapRequest req) throws ImapParseException {
        if (!req.eof()) {
            throw new ImapParseException(tag, "excess characters at end of command");
        }
    }

    boolean continueAuthentication(ImapRequest req) throws IOException {
        String tag = ImapHandler.getTag(this.mAuthenticator);
        try {
            req.setTag(tag);
            if (req.peekChar() == 42) {
                req.skipChar('*');
                if (req.eof()) {
                    this.sendBAD(tag, "AUTHENTICATE aborted");
                } else {
                    this.sendBAD(tag, "AUTHENTICATE failed; invalid base64 input");
                }
                this.mAuthenticator = null;
                return true;
            }
            byte[] response = req.readBase64(false);
            this.checkEOF(tag, req);
            return this.continueAuthentication(response);
        }
        catch (ImapParseException ipe) {
            this.sendBAD(tag, ipe.getMessage());
            this.mAuthenticator = null;
            return true;
        }
    }

    private boolean continueAuthentication(byte[] response) throws IOException {
        this.mAuthenticator.handle(response);
        if (this.mAuthenticator.isComplete()) {
            if (this.mAuthenticator.isAuthenticated()) {
                this.completeAuthentication();
                this.enableInactivityTimer();
                return true;
            }
            boolean canContinue = ImapHandler.canContinue(this.mAuthenticator);
            this.mAuthenticator = null;
            return canContinue;
        }
        return true;
    }

    boolean isIdle() {
        return this.mIdleTag != null;
    }

    private static String getTag(Authenticator auth) {
        return ((ImapAuthenticatorUser)auth.getAuthenticatorUser()).getTag();
    }

    private static boolean canContinue(Authenticator auth) {
        return ((ImapAuthenticatorUser)auth.getAuthenticatorUser()).canContinue();
    }

    boolean checkAccountStatus() {
        if (this.mCredentials == null) {
            return true;
        }
        try {
            Account account = this.mCredentials.getAccount();
            if (account == null || !this.isAccountStatusActive(account)) {
                ZimbraLog.imap.warn("account missing or not active; dropping connection");
                return false;
            }
        }
        catch (ServiceException e) {
            ZimbraLog.imap.warn((Object)"error checking account status; dropping connection", e);
            return false;
        }
        ImapFolder i4selected = this.mSelectedFolder;
        if (i4selected == null) {
            return true;
        }
        String id = i4selected.getTargetAccountId();
        if (this.mCredentials.getAccountId().equalsIgnoreCase(id)) {
            return true;
        }
        try {
            Account account = Provisioning.getInstance().get(Provisioning.AccountBy.id, id);
            if (account == null || !this.isAccountStatusActive(account)) {
                ZimbraLog.imap.warn("target account missing or not active; dropping connection");
                return false;
            }
        }
        catch (ServiceException e) {
            ZimbraLog.imap.warn((Object)"error checking target account status; dropping connection", e);
            return false;
        }
        return true;
    }

    private boolean isAccountStatusActive(Account account) {
        return account.getAccountStatus(Provisioning.getInstance()).equals("active");
    }

    boolean executeRequest(ImapRequest req) throws IOException, ImapParseException {
        boolean isProxied;
        boolean bl = isProxied = this.mProxy != null;
        if (this.isIdle()) {
            boolean clean = false;
            try {
                clean = req.readATOM().equals("DONE") && req.eof();
            }
            catch (ImapParseException ipe) {
                // empty catch block
            }
            return this.doIDLE(null, false, clean, req);
        }
        String tag = req.readTag();
        boolean byUID = false;
        req.skipSpace();
        String command = this.mLastCommand = req.readATOM();
        block22: do {
            switch (command.charAt(0)) {
                case 'A': {
                    if (command.equals("AUTHENTICATE")) {
                        req.skipSpace();
                        String mechanism = req.readATOM();
                        byte[] response = null;
                        if (req.peekChar() == 32 && this.extensionEnabled("SASL-IR")) {
                            req.skipSpace();
                            response = req.readBase64(true);
                        }
                        this.checkEOF(tag, req);
                        return this.doAUTHENTICATE(tag, mechanism, response);
                    }
                    if (!command.equals("APPEND")) break;
                    ArrayList<AppendMessage> appends = new ArrayList<AppendMessage>(1);
                    req.skipSpace();
                    ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                    do {
                        req.skipSpace();
                        appends.add(AppendMessage.parse(this, tag, req));
                    } while (!req.eof() && this.extensionEnabled("MULTIAPPEND"));
                    this.checkEOF(tag, req);
                    return this.doAPPEND(tag, path, appends);
                }
                case 'C': {
                    if (command.equals("CAPABILITY")) {
                        this.checkEOF(tag, req);
                        return this.doCAPABILITY(tag);
                    }
                    if (command.equals("COPY")) {
                        req.skipSpace();
                        String sequence = req.readSequence();
                        req.skipSpace();
                        ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                        this.checkEOF(tag, req);
                        return isProxied ? this.mProxy.proxy(req) : this.doCOPY(tag, sequence, path, byUID);
                    }
                    if (command.equals("CLOSE")) {
                        this.checkEOF(tag, req);
                        return this.doCLOSE(tag);
                    }
                    if (command.equals("CREATE")) {
                        req.skipSpace();
                        ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                        this.checkEOF(tag, req);
                        return this.doCREATE(tag, path);
                    }
                    if (!command.equals("CHECK")) break;
                    this.checkEOF(tag, req);
                    return this.doCHECK(tag);
                }
                case 'D': {
                    if (command.equals("DELETE")) {
                        req.skipSpace();
                        ImapPath path = new ImapPath(req.readFolder(), this.mCredentials, ImapPath.Scope.NAME);
                        this.checkEOF(tag, req);
                        return this.doDELETE(tag, path);
                    }
                    if (!command.equals("DELETEACL") || !this.extensionEnabled("ACL")) continue block22;
                    req.skipSpace();
                    ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                    req.skipSpace();
                    String principal = req.readAstring();
                    this.checkEOF(tag, req);
                    return this.doDELETEACL(tag, path, principal);
                }
                case 'E': {
                    if (command.equals("EXPUNGE")) {
                        String sequence = null;
                        if (byUID) {
                            req.skipSpace();
                            sequence = req.readSequence();
                        }
                        this.checkEOF(tag, req);
                        return isProxied ? this.mProxy.proxy(req) : this.doEXPUNGE(tag, byUID, sequence);
                    }
                    if (command.equals("EXAMINE")) {
                        byte params = 0;
                        QResyncInfo qri = null;
                        req.skipSpace();
                        ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                        if (req.peekChar() == 32) {
                            req.skipSpace();
                            req.skipChar('(');
                            while (req.peekChar() != 41) {
                                String param;
                                if (params != 0) {
                                    req.skipSpace();
                                }
                                if ((param = req.readATOM()).equals("CONDSTORE") && this.extensionEnabled("CONDSTORE")) {
                                    params = (byte)(params | 2);
                                    continue;
                                }
                                if (param.equals("QRESYNC") && this.sessionActivated(ImapExtension.QRESYNC)) {
                                    params = (byte)(params | 2);
                                    qri = new QResyncInfo();
                                    req.skipSpace();
                                    req.skipChar('(');
                                    qri.uvv = req.parseInteger(req.readNumber());
                                    req.skipSpace();
                                    qri.modseq = req.parseInteger(req.readNumber());
                                    if (req.peekChar() == 32) {
                                        req.skipSpace();
                                        if (req.peekChar() != 40) {
                                            qri.knownUIDs = req.readSequence(false);
                                        }
                                        if (qri.knownUIDs == null || req.peekChar() == 32) {
                                            if (qri.knownUIDs != null) {
                                                req.skipSpace();
                                            }
                                            req.skipChar('(');
                                            qri.seqMilestones = req.readSequence(false);
                                            req.skipSpace();
                                            qri.uidMilestones = req.readSequence(false);
                                            req.skipChar(')');
                                        }
                                    }
                                    req.skipChar(')');
                                    continue;
                                }
                                throw new ImapParseException(tag, "unknown EXAMINE parameter \"" + param + '\"');
                            }
                            req.skipChar(')');
                        }
                        this.checkEOF(tag, req);
                        return this.doEXAMINE(tag, path, params, qri);
                    }
                    if (!command.equals("ENABLE") || !this.extensionEnabled("ENABLE")) continue block22;
                    ArrayList<String> extensions = new ArrayList<String>();
                    do {
                        req.skipSpace();
                        extensions.add(req.readATOM());
                    } while (!req.eof());
                    this.checkEOF(tag, req);
                    return this.doENABLE(tag, extensions);
                }
                case 'F': {
                    if (!command.equals("FETCH")) break;
                    ArrayList<ImapPartSpecifier> parts = new ArrayList<ImapPartSpecifier>();
                    int modseq = -1;
                    req.skipSpace();
                    String sequence = req.readSequence();
                    req.skipSpace();
                    int attributes = req.readFetch(parts);
                    if (req.peekChar() == 32) {
                        boolean first = true;
                        req.skipSpace();
                        req.skipChar('(');
                        while (req.peekChar() != 41) {
                            String modifier;
                            if (!first) {
                                req.skipSpace();
                            }
                            if ((modifier = req.readATOM()).equals("CHANGEDSINCE") && this.extensionEnabled("CONDSTORE")) {
                                req.skipSpace();
                                modseq = req.parseInteger(req.readNumber(true));
                            } else if (modifier.equals("VANISHED") && byUID && this.sessionActivated(ImapExtension.QRESYNC)) {
                                attributes |= 0x200;
                            } else {
                                throw new ImapParseException(tag, "bad FETCH modifier: " + modifier);
                            }
                            first = false;
                        }
                        req.skipChar(')');
                    }
                    this.checkEOF(tag, req);
                    return isProxied ? this.mProxy.proxy(req) : this.doFETCH(tag, sequence, attributes, parts, byUID, modseq);
                }
                case 'G': {
                    if (command.equals("GETQUOTA") && this.extensionEnabled("QUOTA")) {
                        req.skipSpace();
                        ImapPath qroot = new ImapPath(req.readAstring(), this.mCredentials);
                        this.checkEOF(tag, req);
                        return this.doGETQUOTA(tag, qroot);
                    }
                    if (command.equals("GETACL") && this.extensionEnabled("ACL")) {
                        req.skipSpace();
                        ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                        this.checkEOF(tag, req);
                        return this.doGETACL(tag, path);
                    }
                    if (!command.equals("GETQUOTAROOT") || !this.extensionEnabled("QUOTA")) continue block22;
                    req.skipSpace();
                    ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                    this.checkEOF(tag, req);
                    return this.doGETQUOTAROOT(tag, path);
                }
                case 'I': {
                    if (command.equals("ID") && this.extensionEnabled("ID")) {
                        req.skipSpace();
                        Map<String, String> params = req.readParameters(true);
                        this.checkEOF(tag, req);
                        return this.doID(tag, params);
                    }
                    if (!command.equals("IDLE") || !this.extensionEnabled("IDLE")) continue block22;
                    this.checkEOF(tag, req);
                    return this.doIDLE(tag, true, true, req);
                }
                case 'L': {
                    if (command.equals("LOGIN")) {
                        req.skipSpace();
                        String user = req.readAstring();
                        req.skipSpace();
                        String pass = req.readAstring();
                        this.checkEOF(tag, req);
                        return this.doLOGIN(tag, user, pass);
                    }
                    if (command.equals("LOGOUT")) {
                        this.checkEOF(tag, req);
                        return this.doLOGOUT(tag);
                    }
                    if (command.equals("LIST")) {
                        LinkedHashSet<String> patterns = new LinkedHashSet<String>(2);
                        boolean parenthesized = false;
                        byte selectOptions = 0;
                        byte returnOptions = 0;
                        byte status = 0;
                        req.skipSpace();
                        if (req.peekChar() == 40 && this.extensionEnabled("LIST-EXTENDED")) {
                            req.skipChar('(');
                            while (req.peekChar() != 41) {
                                String option;
                                if (selectOptions != 0) {
                                    req.skipSpace();
                                }
                                if ((option = req.readATOM()).equals("RECURSIVEMATCH")) {
                                    selectOptions = (byte)(selectOptions | 4);
                                    continue;
                                }
                                if (option.equals("SUBSCRIBED")) {
                                    selectOptions = (byte)(selectOptions | 1);
                                    continue;
                                }
                                if (option.equals("REMOTE")) {
                                    selectOptions = (byte)(selectOptions | 2);
                                    continue;
                                }
                                throw new ImapParseException(tag, "unknown LIST select option \"" + option + '\"');
                            }
                            if ((selectOptions & 5) == 4) {
                                throw new ImapParseException(tag, "must include SUBSCRIBED when specifying RECURSIVEMATCH", false);
                            }
                            req.skipChar(')');
                            req.skipSpace();
                        }
                        String base = req.readFolder();
                        req.skipSpace();
                        if (req.peekChar() == 40 && this.extensionEnabled("LIST-EXTENDED")) {
                            parenthesized = true;
                            req.skipChar('(');
                        }
                        do {
                            if (!patterns.isEmpty()) {
                                req.skipSpace();
                            }
                            patterns.add(req.readFolderPattern());
                        } while (parenthesized && req.peekChar() != 41);
                        if (parenthesized) {
                            req.skipChar(')');
                        }
                        if (req.peekChar() == 32 && this.extensionEnabled("LIST-EXTENDED")) {
                            req.skipSpace();
                            req.skipAtom("RETURN");
                            req.skipSpace();
                            req.skipChar('(');
                            while (req.peekChar() != 41) {
                                String option;
                                if (returnOptions != 0) {
                                    req.skipSpace();
                                }
                                if ((option = req.readATOM()).equals("SUBSCRIBED")) {
                                    returnOptions = (byte)(returnOptions | 1);
                                    continue;
                                }
                                if (option.equals("CHILDREN")) {
                                    returnOptions = (byte)(returnOptions | 2);
                                    continue;
                                }
                                if (option.equals("STATUS") && this.extensionEnabled("X-DRAFT-I00-LIST-STATUS")) {
                                    req.skipSpace();
                                    status = this.parseStatusFields(req);
                                    continue;
                                }
                                throw new ImapParseException(tag, "unknown LIST return option \"" + option + '\"');
                            }
                            req.skipChar(')');
                        }
                        this.checkEOF(tag, req);
                        return this.doLIST(tag, base, patterns, selectOptions, returnOptions, status);
                    }
                    if (command.equals("LSUB")) {
                        req.skipSpace();
                        String base = req.readFolder();
                        req.skipSpace();
                        String pattern = req.readFolderPattern();
                        this.checkEOF(tag, req);
                        return this.doLSUB(tag, base, pattern);
                    }
                    if (!command.equals("LISTRIGHTS") || !this.extensionEnabled("ACL")) continue block22;
                    req.skipSpace();
                    ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                    req.skipSpace();
                    String principal = req.readAstring();
                    this.checkEOF(tag, req);
                    return this.doLISTRIGHTS(tag, path, principal);
                }
                case 'M': {
                    if (!command.equals("MYRIGHTS") || !this.extensionEnabled("ACL")) continue block22;
                    req.skipSpace();
                    ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                    this.checkEOF(tag, req);
                    return this.doMYRIGHTS(tag, path);
                }
                case 'N': {
                    if (command.equals("NOOP")) {
                        this.checkEOF(tag, req);
                        return isProxied ? this.mProxy.proxy(req) : this.doNOOP(tag);
                    }
                    if (!command.equals("NAMESPACE") || !this.extensionEnabled("NAMESPACE")) continue block22;
                    this.checkEOF(tag, req);
                    return this.doNAMESPACE(tag);
                }
                case 'R': {
                    if (!command.equals("RENAME")) break;
                    req.skipSpace();
                    ImapPath folder = new ImapPath(req.readFolder(), this.mCredentials, ImapPath.Scope.NAME);
                    req.skipSpace();
                    ImapPath path = new ImapPath(req.readFolder(), this.mCredentials, ImapPath.Scope.NAME);
                    this.checkEOF(tag, req);
                    return this.doRENAME(tag, folder, path);
                }
                case 'S': {
                    if (command.equals("STORE")) {
                        StoreAction operation = StoreAction.REPLACE;
                        boolean silent = false;
                        int modseq = -1;
                        req.skipSpace();
                        String sequence = req.readSequence();
                        req.skipSpace();
                        if (req.peekChar() == 40 && this.extensionEnabled("CONDSTORE")) {
                            req.skipChar('(');
                            req.skipAtom("UNCHANGEDSINCE");
                            req.skipSpace();
                            modseq = req.parseInteger(req.readNumber(true));
                            req.skipChar(')');
                            req.skipSpace();
                        }
                        switch (req.peekChar()) {
                            case 43: {
                                req.skipChar('+');
                                operation = StoreAction.ADD;
                                break;
                            }
                            case 45: {
                                req.skipChar('-');
                                operation = StoreAction.REMOVE;
                            }
                        }
                        String cmd = req.readATOM();
                        if (cmd.equals("FLAGS.SILENT")) {
                            silent = true;
                        } else if (!cmd.equals("FLAGS")) {
                            throw new ImapParseException(tag, "invalid store-att-flags");
                        }
                        req.skipSpace();
                        List<String> flags = req.readFlags();
                        this.checkEOF(tag, req);
                        return isProxied ? this.mProxy.proxy(req) : this.doSTORE(tag, sequence, flags, operation, silent, modseq, byUID);
                    }
                    if (command.equals("SELECT")) {
                        byte params = 0;
                        QResyncInfo qri = null;
                        req.skipSpace();
                        ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                        if (req.peekChar() == 32) {
                            req.skipSpace();
                            req.skipChar('(');
                            while (req.peekChar() != 41) {
                                String param;
                                if (params != 0) {
                                    req.skipSpace();
                                }
                                if ((param = req.readATOM()).equals("CONDSTORE") && this.extensionEnabled("CONDSTORE")) {
                                    params = (byte)(params | 2);
                                    continue;
                                }
                                if (param.equals("QRESYNC") && this.sessionActivated(ImapExtension.QRESYNC)) {
                                    params = (byte)(params | 2);
                                    qri = new QResyncInfo();
                                    req.skipSpace();
                                    req.skipChar('(');
                                    qri.uvv = req.parseInteger(req.readNumber());
                                    req.skipSpace();
                                    qri.modseq = req.parseInteger(req.readNumber());
                                    if (req.peekChar() == 32) {
                                        req.skipSpace();
                                        if (req.peekChar() != 40) {
                                            qri.knownUIDs = req.readSequence(false);
                                        }
                                        if (qri.knownUIDs == null || req.peekChar() == 32) {
                                            if (qri.knownUIDs != null) {
                                                req.skipSpace();
                                            }
                                            req.skipChar('(');
                                            qri.seqMilestones = req.readSequence(false);
                                            req.skipSpace();
                                            qri.uidMilestones = req.readSequence(false);
                                            req.skipChar(')');
                                        }
                                    }
                                    req.skipChar(')');
                                    continue;
                                }
                                throw new ImapParseException(tag, "unknown SELECT parameter \"" + param + '\"');
                            }
                            req.skipChar(')');
                        }
                        this.checkEOF(tag, req);
                        return this.doSELECT(tag, path, params, qri);
                    }
                    if (command.equals("SEARCH")) {
                        Integer options = null;
                        req.skipSpace();
                        if ("RETURN".equals(req.peekATOM()) && this.extensionEnabled("ESEARCH")) {
                            options = 0;
                            req.skipAtom("RETURN");
                            req.skipSpace();
                            req.skipChar('(');
                            while (req.peekChar() != 41) {
                                String option;
                                if (options != 0) {
                                    req.skipSpace();
                                }
                                if ((option = req.readATOM()).equals("MIN")) {
                                    options = options | 1;
                                    continue;
                                }
                                if (option.equals("MAX")) {
                                    options = options | 2;
                                    continue;
                                }
                                if (option.equals("ALL")) {
                                    options = options | 4;
                                    continue;
                                }
                                if (option.equals("COUNT")) {
                                    options = options | 8;
                                    continue;
                                }
                                if (option.equals("SAVE") && this.extensionEnabled("SEARCHRES")) {
                                    options = options | 0x10;
                                    continue;
                                }
                                throw new ImapParseException(tag, "unknown RETURN option \"" + option + '\"');
                            }
                            req.skipChar(')');
                            req.skipSpace();
                            if (options == 0) {
                                options = 4;
                            }
                        }
                        String charset = null;
                        if ("CHARSET".equals(req.peekATOM())) {
                            req.skipAtom("CHARSET");
                            req.skipSpace();
                            charset = req.readCharset();
                            req.skipSpace();
                        }
                        ImapSearch i4search = req.readSearch(charset);
                        this.checkEOF(tag, req);
                        return isProxied ? this.mProxy.proxy(req) : this.doSEARCH(tag, i4search, byUID, options);
                    }
                    if (command.equals("STARTTLS") && this.extensionEnabled("STARTTLS")) {
                        this.checkEOF(tag, req);
                        return this.doSTARTTLS(tag);
                    }
                    if (command.equals("STATUS")) {
                        req.skipSpace();
                        ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                        req.skipSpace();
                        byte status = this.parseStatusFields(req);
                        this.checkEOF(tag, req);
                        return this.doSTATUS(tag, path, status);
                    }
                    if (command.equals("SORT") && this.extensionEnabled("SORT")) {
                        Integer options = null;
                        req.skipSpace();
                        if ("RETURN".equals(req.peekATOM()) && this.extensionEnabled("ESORT")) {
                            options = 0;
                            req.skipAtom("RETURN");
                            req.skipSpace();
                            req.skipChar('(');
                            while (req.peekChar() != 41) {
                                String option;
                                if (options != 0) {
                                    req.skipSpace();
                                }
                                if ((option = req.readATOM()).equals("MIN")) {
                                    options = options | 1;
                                    continue;
                                }
                                if (option.equals("MAX")) {
                                    options = options | 2;
                                    continue;
                                }
                                if (option.equals("ALL")) {
                                    options = options | 4;
                                    continue;
                                }
                                if (option.equals("COUNT")) {
                                    options = options | 8;
                                    continue;
                                }
                                if (option.equals("SAVE") && this.extensionEnabled("SEARCHRES")) {
                                    options = options | 0x10;
                                    continue;
                                }
                                throw new ImapParseException(tag, "unknown RETURN option \"" + option + '\"');
                            }
                            req.skipChar(')');
                            req.skipSpace();
                            if (options == 0) {
                                options = 4;
                            }
                        }
                        req.skipChar('(');
                        boolean desc = false;
                        ArrayList<SortBy> order = new ArrayList<SortBy>(2);
                        do {
                            SortBy sort;
                            String key;
                            if (desc || !order.isEmpty()) {
                                req.skipSpace();
                            }
                            if ((key = req.readATOM()).equals("REVERSE") && !desc) {
                                desc = true;
                                continue;
                            }
                            if (key.equals("ARRIVAL")) {
                                sort = desc ? SortBy.DATE_DESCENDING : SortBy.DATE_ASCENDING;
                            } else if (key.equals("CC")) {
                                sort = SortBy.NONE;
                            } else if (key.equals("DATE")) {
                                sort = desc ? SortBy.DATE_DESCENDING : SortBy.DATE_ASCENDING;
                            } else if (key.equals("FROM")) {
                                sort = desc ? SortBy.NAME_DESCENDING : SortBy.NAME_ASCENDING;
                            } else if (key.equals("SIZE")) {
                                sort = desc ? SortBy.SIZE_DESCENDING : SortBy.SIZE_ASCENDING;
                            } else if (key.equals("SUBJECT")) {
                                sort = desc ? SortBy.SUBJ_DESCENDING : SortBy.SUBJ_ASCENDING;
                            } else if (key.equals("TO")) {
                                sort = SortBy.NONE;
                            } else {
                                throw new ImapParseException(tag, "unknown SORT key \"" + key + '\"');
                            }
                            order.add(sort);
                            desc = false;
                        } while (desc || req.peekChar() != 41);
                        req.skipChar(')');
                        req.skipSpace();
                        String charset = req.readCharset();
                        req.skipSpace();
                        ImapSearch i4search = req.readSearch(charset);
                        this.checkEOF(tag, req);
                        return isProxied ? this.mProxy.proxy(req) : this.doSORT(tag, i4search, byUID, options, order);
                    }
                    if (command.equals("SUBSCRIBE")) {
                        req.skipSpace();
                        ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                        this.checkEOF(tag, req);
                        return this.doSUBSCRIBE(tag, path);
                    }
                    if (command.equals("SETACL") && this.extensionEnabled("ACL")) {
                        StoreAction action = StoreAction.REPLACE;
                        req.skipSpace();
                        ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                        req.skipSpace();
                        String principal = req.readAstring();
                        req.skipSpace();
                        String i4rights = req.readAstring();
                        this.checkEOF(tag, req);
                        if (i4rights.startsWith("+")) {
                            action = StoreAction.ADD;
                            i4rights = i4rights.substring(1);
                        } else if (i4rights.startsWith("-")) {
                            action = StoreAction.REMOVE;
                            i4rights = i4rights.substring(1);
                        }
                        return this.doSETACL(tag, path, principal, i4rights, action);
                    }
                    if (!command.equals("SETQUOTA") || !this.extensionEnabled("QUOTA")) continue block22;
                    HashMap<String, String> limits = new HashMap<String, String>();
                    req.skipSpace();
                    String qroot = req.readAstring();
                    req.skipSpace();
                    req.skipChar('(');
                    while (req.peekChar() != 41) {
                        if (!limits.isEmpty()) {
                            req.skipSpace();
                        }
                        String resource = req.readATOM();
                        req.skipSpace();
                        limits.put(resource, req.readNumber());
                    }
                    req.skipChar(')');
                    this.checkEOF(tag, req);
                    return this.doSETQUOTA(tag, qroot, limits);
                }
                case 'T': {
                    if (!command.equals("THREAD") || !this.extensionEnabled("THREAD=ORDEREDSUBJECT")) continue block22;
                    req.skipSpace();
                    req.skipAtom("ORDEREDSUBJECT");
                    req.skipSpace();
                    String charset = req.readCharset();
                    req.skipSpace();
                    ImapSearch i4search = req.readSearch(charset);
                    this.checkEOF(tag, req);
                    return isProxied ? this.mProxy.proxy(req) : this.doTHREAD(tag, i4search, byUID);
                }
                case 'U': {
                    if (command.equals("UID")) {
                        req.skipSpace();
                        command = req.readATOM();
                        if (command.equals("FETCH") || command.equals("SEARCH") || command.equals("COPY") || command.equals("STORE") || command.equals("EXPUNGE") && this.extensionEnabled("UIDPLUS") || command.equals("SORT") && this.extensionEnabled("SORT") || command.equals("THREAD") && this.extensionEnabled("THREAD=ORDEREDSUBJECT")) {
                            byUID = true;
                            break;
                        }
                        throw new ImapParseException(tag, "command not permitted with UID");
                    }
                    if (command.equals("UNSUBSCRIBE")) {
                        req.skipSpace();
                        ImapPath path = new ImapPath(req.readFolder(), this.mCredentials);
                        this.checkEOF(tag, req);
                        return this.doUNSUBSCRIBE(tag, path);
                    }
                    if (!command.equals("UNSELECT") || !this.extensionEnabled("UNSELECT")) continue block22;
                    this.checkEOF(tag, req);
                    return this.doUNSELECT(tag);
                }
            }
        } while (byUID);
        throw new ImapParseException(tag, "command not implemented");
    }

    byte parseStatusFields(ImapRequest req) throws ImapParseException {
        byte status = 0;
        req.skipChar('(');
        do {
            String flag;
            if (status != 0) {
                req.skipSpace();
            }
            if ((flag = req.readATOM()).equals("MESSAGES")) {
                status = (byte)(status | 1);
                continue;
            }
            if (flag.equals("RECENT")) {
                status = (byte)(status | 2);
                continue;
            }
            if (flag.equals("UIDNEXT")) {
                status = (byte)(status | 4);
                continue;
            }
            if (flag.equals("UIDVALIDITY")) {
                status = (byte)(status | 8);
                continue;
            }
            if (flag.equals("UNSEEN")) {
                status = (byte)(status | 0x10);
                continue;
            }
            if (flag.equals("HIGHESTMODSEQ")) {
                status = (byte)(status | 0x20);
                continue;
            }
            throw new ImapParseException(req.getTag(), "unknown STATUS attribute \"" + flag + '\"');
        } while (req.peekChar() != 41);
        req.skipChar(')');
        return status;
    }

    State getState() {
        if (this.mGoodbyeSent) {
            return State.LOGOUT;
        }
        if (this.mSelectedFolder != null || this.mProxy != null) {
            return State.SELECTED;
        }
        if (this.isAuthenticated()) {
            return State.AUTHENTICATED;
        }
        return State.NOT_AUTHENTICATED;
    }

    protected boolean isAuthenticated() {
        return this.mCredentials != null;
    }

    boolean checkState(String tag, State required) throws IOException {
        State state = this.getState();
        if (required == State.NOT_AUTHENTICATED && state != State.NOT_AUTHENTICATED) {
            this.sendNO(tag, "must be in NOT AUTHENTICATED state");
            return false;
        }
        if (required == State.AUTHENTICATED && (state == State.NOT_AUTHENTICATED || state == State.LOGOUT)) {
            this.sendNO(tag, "must be in AUTHENTICATED or SELECTED state");
            return false;
        }
        if (required == State.SELECTED && state != State.SELECTED) {
            this.sendNO(tag, "must be in SELECTED state");
            return false;
        }
        return true;
    }

    ImapFolder getSelectedFolder() {
        return this.getState() == State.LOGOUT ? null : this.mSelectedFolder;
    }

    void unsetSelectedFolder(boolean sendClosed) throws IOException {
        ImapFolder i4selected = this.mSelectedFolder;
        this.mSelectedFolder = null;
        if (i4selected != null) {
            i4selected.unregister();
            if (sendClosed && this.sessionActivated(ImapExtension.QRESYNC)) {
                this.sendUntagged("OK [CLOSED] mailbox closed");
            }
        }
        ImapProxy proxy = this.mProxy;
        this.mProxy = null;
        if (proxy != null) {
            proxy.dropConnection();
            if (sendClosed && this.sessionActivated(ImapExtension.QRESYNC)) {
                this.sendUntagged("OK [CLOSED] mailbox closed");
            }
        }
    }

    void setSelectedFolder(ImapFolder i4folder) throws ServiceException, IOException {
        if (i4folder == this.mSelectedFolder) {
            if (this.sessionActivated(ImapExtension.QRESYNC)) {
                this.sendUntagged("OK [CLOSED] mailbox closed");
            }
            return;
        }
        this.unsetSelectedFolder(true);
        if (i4folder == null) {
            return;
        }
        try {
            i4folder.register();
        }
        catch (ServiceException e) {
            i4folder.unregister();
            throw e;
        }
        this.mSelectedFolder = i4folder;
        ZimbraLog.imap.info("selected folder " + this.mSelectedFolder.toString());
    }

    boolean canContinue(ServiceException e) {
        return !e.getCode().equals("mail.MAINTENANCE");
    }

    OperationContext getContext() throws ServiceException {
        if (!this.isAuthenticated()) {
            throw ServiceException.AUTH_REQUIRED();
        }
        return this.mCredentials.getContext().setSession(this.mSelectedFolder);
    }

    boolean doCAPABILITY(String tag) throws IOException {
        this.sendUntagged(this.getCapabilityString());
        this.sendOK(tag, "CAPABILITY completed");
        return true;
    }

    protected String getCapabilityString() {
        StringBuilder capability = new StringBuilder("CAPABILITY IMAP4rev1");
        if (!this.isAuthenticated()) {
            if (!this.mStartedTLS && !this.mConfig.allowCleartextLogins()) {
                capability.append(" LOGINDISABLED");
            }
            if (!this.mStartedTLS && this.extensionEnabled("STARTTLS")) {
                capability.append(" STARTTLS");
            }
            ImapAuthenticatorUser authUser = new ImapAuthenticatorUser(this, null);
            for (String mechanism : Authenticator.listMechanisms()) {
                if (!this.mechanismEnabled(mechanism) || Authenticator.getAuthenticator(mechanism, authUser) == null) continue;
                capability.append(" AUTH=").append(mechanism);
            }
        }
        for (String extension : SUPPORTED_EXTENSIONS) {
            if (!this.extensionEnabled(extension)) continue;
            capability.append(' ').append(extension);
        }
        return capability.toString();
    }

    boolean extensionEnabled(String extension) {
        if (this.mConfig.isExtensionDisabled(extension)) {
            return false;
        }
        if (extension.equalsIgnoreCase("SEARCHRES")) {
            return this.extensionEnabled("ESEARCH");
        }
        if (extension.equalsIgnoreCase("RIGHTS=ektx")) {
            return this.extensionEnabled("ACL");
        }
        if (extension.equalsIgnoreCase("QRESYNC")) {
            return this.extensionEnabled("CONDSTORE");
        }
        if (extension.equalsIgnoreCase("ESORT")) {
            return this.extensionEnabled("SORT");
        }
        if (extension.equalsIgnoreCase("X-DRAFT-I00-LIST-STATUS")) {
            return this.extensionEnabled("LIST-EXTENDED");
        }
        return !extension.equalsIgnoreCase("IDLE") || this.mCredentials == null || !this.mCredentials.isHackEnabled(ImapCredentials.EnabledHack.NO_IDLE);
    }

    private boolean mechanismEnabled(String mechanism) {
        return this.extensionEnabled("AUTH=" + mechanism);
    }

    boolean doNOOP(String tag) throws IOException {
        this.sendNotifications(true, false);
        this.sendOK(tag, "NOOP completed");
        return true;
    }

    boolean doID(String tag, Map<String, String> attrs) throws IOException {
        if (attrs != null) {
            String userAgent;
            boolean ignore = false;
            String origIp = attrs.get("X-ORIGINATING-IP");
            if (origIp != null) {
                String curOrigRemoteIp = this.getOrigRemoteIpAddr();
                if (curOrigRemoteIp == null) {
                    this.setOrigRemoteIpAddr(origIp);
                    ZimbraLog.addOrigIpToContext(origIp);
                } else {
                    if (curOrigRemoteIp.equals(origIp)) {
                        ZimbraLog.imap.warn("IMAP ID with X-ORIGINATING-IP is allowed only once per session, command ignored");
                    } else {
                        ZimbraLog.imap.error("IMAP ID with X-ORIGINATING-IP is allowed only once per session, received different IP: " + origIp + ", command ignored");
                    }
                    ignore = true;
                }
            }
            if (!ignore && (userAgent = attrs.get("name")) != null) {
                String curUserAgent;
                String version = attrs.get("version");
                if (version != null) {
                    userAgent = userAgent + "/" + version;
                }
                if ((curUserAgent = this.getUserAgent()) == null) {
                    this.setUserAgent(userAgent);
                    ZimbraLog.addUserAgentToContext(userAgent);
                } else {
                    if (curUserAgent.equals(userAgent)) {
                        ZimbraLog.imap.warn("IMAP ID with name/version is allowed only once per session, command ignored");
                    } else {
                        ZimbraLog.imap.error("IMAP ID with name/version is allowed only once per session, received different name/version: " + userAgent + ", command ignored");
                    }
                    ignore = true;
                }
            }
            if (!ignore) {
                ZimbraLog.imap.debug("IMAP client identified as: " + attrs);
            }
        }
        this.sendNotifications(true, false);
        if (this.isAuthenticated()) {
            this.sendUntagged("ID (" + ID_PARAMS + " \"USER\" \"" + this.mCredentials.getUsername() + "\")");
        } else {
            this.sendUntagged("ID (" + ID_PARAMS + ")");
        }
        this.sendOK(tag, "ID completed");
        return true;
    }

    boolean doENABLE(String tag, List<String> extensions) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        StringBuilder enabled = new StringBuilder("ENABLED");
        ArrayList<ImapExtension> targets = new ArrayList<ImapExtension>(extensions.size());
        for (String ext : extensions) {
            if (!SUPPORTED_EXTENSIONS.contains(ext) || !this.extensionEnabled(ext)) continue;
            if (ext.equals("CONDSTORE")) {
                targets.add(ImapExtension.CONDSTORE);
            } else {
                if (!ext.equals("QRESYNC")) continue;
                targets.add(ImapExtension.CONDSTORE);
                targets.add(ImapExtension.QRESYNC);
            }
            enabled.append(' ').append(ext);
        }
        for (ImapExtension i4x : targets) {
            this.activateExtension(i4x);
        }
        this.sendUntagged(enabled.toString());
        this.sendNotifications(true, false);
        this.sendOK(tag, "ENABLE completed");
        return true;
    }

    void activateExtension(ImapExtension ext) {
        if (ext == null) {
            return;
        }
        if (this.mActiveExtensions == null) {
            this.mActiveExtensions = new HashSet<ImapExtension>(1);
        }
        this.mActiveExtensions.add(ext);
    }

    boolean sessionActivated(ImapExtension ext) {
        return this.mActiveExtensions != null && this.mActiveExtensions.contains((Object)ext);
    }

    abstract boolean doSTARTTLS(String var1) throws IOException;

    boolean doLOGOUT(String tag) throws IOException {
        this.sendBYE();
        this.sendOK(tag, "LOGOUT completed");
        return false;
    }

    boolean doAUTHENTICATE(String tag, String mechanism, byte[] initial) throws IOException {
        if (!this.checkState(tag, State.NOT_AUTHENTICATED)) {
            return true;
        }
        ImapAuthenticatorUser authUser = new ImapAuthenticatorUser(this, tag);
        Authenticator auth = Authenticator.getAuthenticator(mechanism, authUser);
        if (auth == null || !this.mechanismEnabled(mechanism)) {
            this.sendNO(tag, "mechanism not supported: " + mechanism);
            return true;
        }
        this.mAuthenticator = auth;
        this.mAuthenticator.setConnection(this.mConnection);
        if (!this.mAuthenticator.initialize()) {
            this.mAuthenticator = null;
            return true;
        }
        if (initial != null) {
            return this.continueAuthentication(initial);
        }
        this.sendContinuation("");
        return true;
    }

    boolean doLOGIN(String tag, String username, String password) throws IOException {
        if (!this.checkState(tag, State.NOT_AUTHENTICATED)) {
            return true;
        }
        if (!this.mStartedTLS && !this.mConfig.allowCleartextLogins()) {
            this.sendNO(tag, "cleartext logins disabled");
            return true;
        }
        boolean cont = this.authenticate(username, null, password, tag, null);
        if (this.isAuthenticated()) {
            this.sendOK(tag, '[' + this.getCapabilityString() + "] LOGIN completed");
            this.enableInactivityTimer();
        }
        return cont;
    }

    boolean authenticate(String username, String authenticateId, String password, String tag, Authenticator auth) throws IOException {
        String command;
        ImapCredentials.EnabledHack enabledHack = ImapCredentials.EnabledHack.NONE;
        if (username != null && username.length() != 0) {
            for (ImapCredentials.EnabledHack hack : ImapCredentials.EnabledHack.values()) {
                if (hack.toString() == null || !username.endsWith(hack.toString())) continue;
                enabledHack = hack;
                username = username.substring(0, username.length() - hack.toString().length());
                break;
            }
        }
        String mechanism = auth != null ? auth.getMechanism() : null;
        String string = command = auth != null ? "AUTHENTICATE" : "LOGIN";
        if (auth == null) {
            auth = new PlainAuthenticator(new ImapAuthenticatorUser(this, tag));
            authenticateId = username;
        }
        try {
            Account acct = auth.authenticate(username, authenticateId, password, AuthContext.Protocol.imap, this.getOrigRemoteIpAddr(), this.getUserAgent());
            if (acct == null) {
                this.sendNO(tag, command + " failed");
                return true;
            }
            this.startSession(acct, enabledHack, tag, mechanism);
        }
        catch (AccountServiceException.AuthFailedServiceException afe) {
            this.mCredentials = null;
            ZimbraLog.imap.info(afe.getMessage() + " (" + afe.getReason() + ')');
            this.sendNO(tag, command + " failed");
            return true;
        }
        catch (ServiceException e) {
            this.mCredentials = null;
            ZimbraLog.imap.warn((Object)(command + " failed"), e);
            if (e.getCode().equals("account.CHANGE_PASSWORD")) {
                this.sendNO(tag, "[ALERT] password must be changed before IMAP login permitted");
            } else if (e.getCode().equals("account.MAINTENANCE_MODE")) {
                this.sendNO(tag, "[ALERT] account undergoing maintenance; please try again later");
            } else {
                this.sendNO(tag, command + " failed");
            }
            return this.canContinue(e);
        }
        return true;
    }

    private ImapCredentials startSession(Account account, ImapCredentials.EnabledHack hack, String tag, String mechanism) throws ServiceException, IOException {
        String command;
        String string = command = mechanism != null ? "AUTHENTICATE" : "LOGIN";
        if (!account.getBooleanAttr("zimbraImapEnabled", false)) {
            this.sendNO(tag, "account does not have IMAP access enabled");
            return null;
        }
        if (!"X-ZIMBRA".equals(mechanism) && !Provisioning.onLocalServer(account)) {
            String correctHost = account.getAttr("zimbraMailHost");
            ZimbraLog.imap.info(command + " failed; should be on host " + correctHost);
            if (correctHost == null || correctHost.trim().equals("") || !this.extensionEnabled("LOGIN_REFERRALS")) {
                this.sendNO(tag, command + " failed (wrong host)");
            } else {
                this.sendNO(tag, "[REFERRAL imap://" + URLEncoder.encode(account.getName(), "utf-8") + '@' + correctHost + "/] " + command + " failed");
            }
            return null;
        }
        this.mCredentials = new ImapCredentials(account, hack);
        if (this.mCredentials.isLocal()) {
            this.mCredentials.getMailbox().beginTrackingImap();
        }
        ZimbraLog.addAccountNameToContext(this.mCredentials.getUsername());
        ZimbraLog.imap.info("user " + this.mCredentials.getUsername() + " authenticated, " + "mechanism=" + (mechanism == null ? "LOGIN" : mechanism) + (this.mStartedTLS ? " [TLS]" : ""));
        return this.mCredentials;
    }

    boolean doSELECT(String tag, ImapPath path, byte params, QResyncInfo qri) throws IOException, ImapParseException {
        return this.selectFolder(tag, "SELECT", path, params, qri);
    }

    boolean doEXAMINE(String tag, ImapPath path, byte params, QResyncInfo qri) throws IOException, ImapParseException {
        return this.selectFolder(tag, "EXAMINE", path, (byte)(params | 1), qri);
    }

    private boolean selectFolder(String tag, String command, ImapPath path, byte params, QResyncInfo qri) throws IOException, ImapParseException {
        boolean writable;
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        ImapFolder i4folder = null;
        List<Object> permflags = Collections.emptyList();
        try {
            Object mboxobj = path.getOwnerMailbox();
            if (!(mboxobj instanceof Mailbox)) {
                this.unsetSelectedFolder(true);
                ImapProxy proxy = new ImapProxy(this, path);
                if (proxy.select(tag, params, qri)) {
                    this.mProxy = proxy;
                } else {
                    proxy.dropConnection();
                }
                return true;
            }
            ImapFolder i4oldFolder = this.mSelectedFolder;
            if (i4oldFolder != null && !i4oldFolder.isVirtual() && path.isEquivalent(i4oldFolder.getPath())) {
                try {
                    i4oldFolder.reopen(params);
                    i4folder = i4oldFolder;
                }
                catch (ServiceException e) {
                    ZimbraLog.imap.warn((Object)("error quick-reopening folder " + path + "; proceeding with manual reopen"), e);
                }
            }
            if (i4folder == null) {
                i4folder = new ImapFolder(path, params, this, this.mCredentials);
            }
            writable = i4folder.isWritable();
            this.setSelectedFolder(i4folder);
            if (writable) {
                permflags = i4folder.getFlagList(true);
                if (!path.isWritable((short)8)) {
                    permflags.remove("\\Deleted");
                }
                if (path.belongsTo(this.mCredentials)) {
                    permflags.add("\\*");
                }
            }
        }
        catch (ServiceException e) {
            this.unsetSelectedFolder(true);
            if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                ZimbraLog.imap.info(command + " failed: no such folder: " + path);
            } else if (e.getCode().equals("service.PERM_DENIED")) {
                ZimbraLog.imap.info(command + " failed: permission denied: " + path);
            } else {
                ZimbraLog.imap.warn((Object)(command + " failed"), e);
            }
            this.sendNO(tag, command + " failed");
            return this.canContinue(e);
        }
        this.sendUntagged(i4folder.getSize() + " EXISTS");
        this.sendUntagged(i4folder.getRecentCount() + " RECENT");
        if (i4folder.getFirstUnread() > 0) {
            this.sendUntagged("OK [UNSEEN " + i4folder.getFirstUnread() + "] mailbox contains unseen messages");
        }
        this.sendUntagged("OK [UIDVALIDITY " + i4folder.getUIDValidity() + "] UIDs are valid for this mailbox");
        if (!i4folder.isVirtual()) {
            this.sendUntagged("OK [UIDNEXT " + i4folder.getInitialUIDNEXT() + "] next expected UID is " + i4folder.getInitialUIDNEXT());
        }
        this.sendUntagged("FLAGS (" + StringUtil.join(" ", i4folder.getFlagList(false)) + ')');
        this.sendUntagged("OK [PERMANENTFLAGS (" + StringUtil.join(" ", permflags) + ")] junk-related flags are not permanent");
        if (!i4folder.isVirtual()) {
            this.sendUntagged("OK [HIGHESTMODSEQ " + i4folder.getInitialMODSEQ() + "] modseq tracked on this mailbox");
        } else {
            this.sendUntagged("OK [NOMODSEQ] modseq not supported on search folders");
        }
        if (qri != null && qri.uvv == i4folder.getUIDValidity() && !i4folder.isVirtual()) {
            String knownUIDs;
            boolean sentVanished = false;
            String string = knownUIDs = qri.knownUIDs == null ? "1:" + (i4folder.getInitialUIDNEXT() - 1) : qri.knownUIDs;
            if (qri.seqMilestones != null && qri.uidMilestones != null) {
                ImapMessage i4msg;
                int lowwater = 1;
                ImapMessage.ImapMessageSet seqset = i4folder.getSubsequence(tag, qri.seqMilestones, false);
                ImapMessage.ImapMessageSet uidset = i4folder.getSubsequence(tag, qri.uidMilestones, true);
                seqset.remove(null);
                uidset.remove(null);
                Iterator itseq = seqset.iterator();
                Iterator ituid = uidset.iterator();
                while (itseq.hasNext() && ituid.hasNext() && (i4msg = (ImapMessage)itseq.next()) == ituid.next()) {
                    lowwater = i4msg.imapUid + 1;
                }
                if (lowwater > 1) {
                    String constrainedSet = i4folder.cropSubsequence(knownUIDs, true, lowwater, -1);
                    String vanished = i4folder.invertSubsequence(constrainedSet, true, i4folder.getAllMessages());
                    if (!vanished.equals("")) {
                        this.sendUntagged("VANISHED (EARLIER) " + vanished);
                    }
                    sentVanished = true;
                }
            }
            this.fetch(tag, knownUIDs, 8 | (sentVanished ? 0 : 512), null, true, qri.modseq, false);
        }
        this.sendOK(tag, (writable ? "[READ-WRITE] " : "[READ-ONLY] ") + command + " completed");
        return true;
    }

    boolean doCREATE(String tag, ImapPath path) throws IOException {
        block15: {
            if (!this.checkState(tag, State.AUTHENTICATED)) {
                return true;
            }
            if (!path.isCreatable()) {
                ZimbraLog.imap.info("CREATE failed: hidden folder or parent: " + path);
                this.sendNO(tag, "CREATE failed");
                return true;
            }
            try {
                Object mboxobj = path.getOwnerMailbox();
                if (mboxobj instanceof Mailbox) {
                    ((Mailbox)mboxobj).createFolder(this.getContext(), path.asResolvedPath(), (byte)0, (byte)5);
                    break block15;
                }
                if (mboxobj instanceof ZMailbox) {
                    ((ZMailbox)mboxobj).createFolder(null, path.asResolvedPath(), ZFolder.View.message, ZFolder.Color.defaultColor, null, null);
                    break block15;
                }
                throw AccountServiceException.NO_SUCH_ACCOUNT(path.getOwner());
            }
            catch (ServiceException e) {
                String cause = "CREATE failed";
                if (e.getCode().equals("mail.CANNOT_CONTAIN")) {
                    cause = cause + ": superior mailbox has \\Noinferiors set";
                } else if (e.getCode().equals("mail.ALREADY_EXISTS")) {
                    cause = cause + ": mailbox already exists";
                } else if (e.getCode().equals("mail.INVALID_NAME")) {
                    cause = cause + ": invalid mailbox name";
                } else if (e.getCode().equals("service.PERM_DENIED")) {
                    cause = cause + ": permission denied";
                }
                if (cause.equals("CREATE failed")) {
                    ZimbraLog.imap.warn((Object)cause, e);
                } else {
                    ZimbraLog.imap.info(cause + ": " + path);
                }
                this.sendNO(tag, cause);
                return this.canContinue(e);
            }
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "CREATE completed");
        return true;
    }

    boolean doDELETE(String tag, ImapPath path) throws IOException {
        block25: {
            if (!this.checkState(tag, State.AUTHENTICATED)) {
                return true;
            }
            try {
                if (!path.isVisible()) {
                    throw ImapServiceException.FOLDER_NOT_VISIBLE(path.asImapPath());
                }
                Object mboxobj = path.getOwnerMailbox();
                if (mboxobj instanceof Mailbox) {
                    Mailbox mbox = (Mailbox)mboxobj;
                    Folder folder = (Folder)path.getFolder();
                    if (!folder.isDeletable()) {
                        throw ImapServiceException.CANNOT_DELETE_SYSTEM_FOLDER(folder.getPath());
                    }
                    if (this.getState() == State.SELECTED) {
                        if (this.mSelectedFolder != null && path.isEquivalent(this.mSelectedFolder.getPath())) {
                            this.unsetSelectedFolder(true);
                        } else if (this.mProxy != null && path.isEquivalent(this.mProxy.getPath())) {
                            this.unsetSelectedFolder(true);
                        }
                    }
                    if (!folder.hasSubfolders()) {
                        mbox.delete(this.getContext(), folder.getId(), (byte)1);
                        this.mCredentials.unsubscribe(path);
                    } else {
                        mbox.emptyFolder(this.getContext(), folder.getId(), false);
                    }
                    break block25;
                }
                if (mboxobj instanceof ZMailbox) {
                    ZMailbox zmbx = (ZMailbox)mboxobj;
                    ZFolder zfolder = (ZFolder)path.getFolder();
                    if (zfolder.getSubFolders().isEmpty()) {
                        zmbx.deleteFolder(zfolder.getId());
                        this.mCredentials.unsubscribe(path);
                    } else {
                        zmbx.emptyFolder(zfolder.getId(), false);
                    }
                    break block25;
                }
                throw AccountServiceException.NO_SUCH_ACCOUNT(path.getOwner());
            }
            catch (ServiceException e) {
                if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                    ZimbraLog.imap.info("DELETE failed: no such folder: " + path);
                } else if (e.getCode().equals("account.NO_SUCH_ACCOUNT")) {
                    ZimbraLog.imap.info("DELETE failed: no such account: " + path);
                } else if (e.getCode().equals("imap.FOLDER_NOT_VISIBLE")) {
                    ZimbraLog.imap.info("DELETE failed: folder not visible: " + path);
                } else if (e.getCode().equals("imap.CANNOT_DELETE_SYSTEM_FOLDER")) {
                    ZimbraLog.imap.info("DELETE failed: system folder cannot be deleted: " + path);
                } else if (e.getCode().equals("service.PERM_DENIED")) {
                    ZimbraLog.imap.info("DELETE failed: permission denied: " + path);
                } else {
                    ZimbraLog.imap.warn((Object)"DELETE failed", e);
                }
                this.sendNO(tag, "DELETE failed");
                return this.canContinue(e);
            }
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "DELETE completed");
        return true;
    }

    boolean doRENAME(String tag, ImapPath oldPath, ImapPath newPath) throws IOException {
        block18: {
            if (!this.checkState(tag, State.AUTHENTICATED)) {
                return true;
            }
            try {
                Account source = oldPath.getOwnerAccount();
                Account target = newPath.getOwnerAccount();
                if (source == null || target == null) {
                    ZimbraLog.imap.info("RENAME failed: no such account for " + oldPath + " or " + newPath);
                    this.sendNO(tag, "RENAME failed: no such account");
                    return true;
                }
                if (!source.getId().equalsIgnoreCase(target.getId())) {
                    ZimbraLog.imap.info("RENAME failed: cannot move folder between mailboxes");
                    this.sendNO(tag, "RENAME failed: cannot rename mailbox to other user's namespace");
                    return true;
                }
                if (!newPath.isCreatable()) {
                    ZimbraLog.imap.info("RENAME failed: hidden folder or parent: " + newPath);
                    this.sendNO(tag, "RENAME failed");
                    return true;
                }
                if (!oldPath.isVisible()) {
                    throw MailServiceException.NO_SUCH_FOLDER(oldPath.asZimbraPath());
                }
                Object mboxobj = oldPath.getOwnerMailbox();
                if (mboxobj instanceof Mailbox) {
                    int folderId = oldPath.asItemId().getId();
                    if (folderId == 2) {
                        throw ImapServiceException.CANT_RENAME_INBOX();
                    }
                    Mailbox mbox = (Mailbox)mboxobj;
                    mbox.rename(this.getContext(), folderId, (byte)1, "/" + newPath.asResolvedPath());
                    break block18;
                }
                if (mboxobj instanceof ZMailbox) {
                    if (oldPath.asItemId().getId() == 2) {
                        throw ImapServiceException.CANT_RENAME_INBOX();
                    }
                    ZMailbox zmbx = (ZMailbox)mboxobj;
                    ZFolder zfolder = (ZFolder)oldPath.getFolder();
                    zmbx.renameFolder(zfolder.getId(), newPath.asResolvedPath());
                    break block18;
                }
                ZimbraLog.imap.info("RENAME failed: cannot get mailbox for path: " + oldPath);
                this.sendNO(tag, "RENAME failed");
                return true;
            }
            catch (ServiceException e) {
                if (e.getCode().equals("imap.CANNOT_RENAME_INBOX")) {
                    ZimbraLog.imap.info("RENAME failed: RENAME of INBOX not supported");
                    this.sendNO(tag, "RENAME failed: RENAME of INBOX not supported");
                    return true;
                }
                if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                    ZimbraLog.imap.info("RENAME failed: no such folder: " + oldPath);
                } else if (e.getCode().equals("mail.IMMUTABLE_OBJECT")) {
                    ZimbraLog.imap.info("RENAME failed: cannot rename system folder: " + oldPath);
                } else if (e.getCode().equals("mail.CANNOT_CONTAIN")) {
                    ZimbraLog.imap.info("RENAME failed: invalid target folder: " + newPath);
                } else {
                    ZimbraLog.imap.warn((Object)"RENAME failed", e);
                }
                this.sendNO(tag, "RENAME failed");
                return this.canContinue(e);
            }
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "RENAME completed");
        return true;
    }

    boolean doSUBSCRIBE(String tag, ImapPath path) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        try {
            path.canonicalize();
            if (path.belongsTo(this.mCredentials)) {
                if (!path.isVisible()) {
                    throw ImapServiceException.FOLDER_NOT_VISIBLE(path.asImapPath());
                }
                Mailbox mbox = (Mailbox)path.getOwnerMailbox();
                Folder folder = (Folder)path.getFolder();
                if (!folder.isTagged(-20)) {
                    mbox.alterTag(this.getContext(), folder.getId(), (byte)1, -20, true);
                }
            } else {
                this.mCredentials.subscribe(path);
            }
        }
        catch (ServiceException e) {
            if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                ZimbraLog.imap.info("SUBSCRIBE failed: no such folder: " + path);
            } else if (e.getCode().equals("service.PERM_DENIED")) {
                ZimbraLog.imap.info("SUBSCRIBE failed: permission denied on folder: " + path);
            } else if (e.getCode().equals("imap.FOLDER_NOT_VISIBLE")) {
                ZimbraLog.imap.info("SUBSCRIBE failed: folder not visible: " + path);
            } else {
                ZimbraLog.imap.warn((Object)"SUBSCRIBE failed", e);
            }
            this.sendNO(tag, "SUBSCRIBE failed");
            return this.canContinue(e);
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "SUBSCRIBE completed");
        return true;
    }

    boolean doUNSUBSCRIBE(String tag, ImapPath path) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        try {
            if (path.belongsTo(this.mCredentials)) {
                try {
                    Mailbox mbox = this.mCredentials.getMailbox();
                    Folder folder = (Folder)path.getFolder();
                    if (folder.isTagged(-20)) {
                        mbox.alterTag(this.getContext(), folder.getId(), (byte)1, -20, false);
                    }
                }
                catch (MailServiceException.NoSuchItemException nsie) {
                    // empty catch block
                }
            }
            this.mCredentials.unsubscribe(path);
        }
        catch (MailServiceException.NoSuchItemException nsie) {
            ZimbraLog.imap.info("UNSUBSCRIBE failure skipped: no such folder: " + path);
        }
        catch (ServiceException e) {
            ZimbraLog.imap.warn((Object)"UNSUBSCRIBE failed", e);
            this.sendNO(tag, "UNSUBSCRIBE failed");
            return this.canContinue(e);
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "UNSUBSCRIBE completed");
        return true;
    }

    boolean doLIST(String tag, String referenceName, Set<String> mailboxNames, byte selectOptions, byte returnOptions, byte status) throws IOException {
        boolean selectSubscribed;
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        if (selectOptions == 0 && returnOptions == 0 && mailboxNames.size() == 1 && mailboxNames.contains("")) {
            this.sendNotifications(true, false);
            this.sendUntagged("LIST (\\NoSelect) \"/\" \"\"");
            this.sendOK(tag, "LIST completed");
            return true;
        }
        if (this.extensionEnabled("CHILDREN")) {
            returnOptions = (byte)(returnOptions | 2);
        }
        boolean bl = selectSubscribed = (selectOptions & 1) != 0;
        if (selectSubscribed) {
            returnOptions = (byte)(returnOptions | 1);
        }
        boolean returnSubscribed = (returnOptions & 1) != 0;
        Set<String> remoteSubscriptions = null;
        boolean selectRecursive = (selectOptions & 4) != 0;
        TreeMap<ImapPath, Object> matches = new TreeMap<ImapPath, Object>();
        try {
            if (returnSubscribed) {
                remoteSubscriptions = this.mCredentials.listSubscriptions();
            }
            HashMap<ImapPath, ItemId> paths = new HashMap<ImapPath, ItemId>();
            HashSet<ImapPath> selected = new HashSet<ImapPath>();
            ArrayList<Pattern> patterns = new ArrayList<Pattern>(mailboxNames.size());
            for (String mailboxName : mailboxNames) {
                if (mailboxName.equals("")) continue;
                Pair<String, Pattern> resolved = ImapHandler.resolvePath(referenceName, mailboxName);
                String resolvedPath = resolved.getFirst();
                Pattern pattern = resolved.getSecond();
                ImapPath patternPath = new ImapPath(resolvedPath, this.mCredentials, ImapPath.Scope.UNPARSED);
                String owner = patternPath.getOwner();
                if (owner != null && (owner.indexOf(42) != -1 || owner.indexOf(37) != -1)) {
                    ZimbraLog.imap.info("LIST failed: wildcards not permitted in username " + patternPath);
                    this.sendNO(tag, "LIST failed: wildcards not permitted in username");
                    return true;
                }
                if (owner != null && patternPath.belongsTo(this.mCredentials)) continue;
                if (owner != null && ("/home/" + owner).equalsIgnoreCase(resolvedPath)) {
                    matches.put(patternPath, "LIST (\\NoSelect) \"/\" " + patternPath.asUtf7String());
                    continue;
                }
                Account acct = patternPath.getOwnerAccount();
                if (acct == null) continue;
                patterns.add(pattern);
                this.accumulatePaths(patternPath.getOwnerMailbox(), owner, null, paths);
                if (selectSubscribed) {
                    for (ImapPath path : paths.keySet()) {
                        if (!this.isPathSubscribed(path, remoteSubscriptions)) continue;
                        selected.add(path);
                    }
                    if (remoteSubscriptions == null) continue;
                    for (String sub : remoteSubscriptions) {
                        ImapPath spath = new ImapPath(sub, this.mCredentials);
                        if (selected.contains(spath) || owner == null != (spath.getOwner() == null)) continue;
                        selected.add(spath);
                    }
                    continue;
                }
                selected.addAll(paths.keySet());
            }
            block5: for (ImapPath path : selected) {
                for (Pattern pattern : patterns) {
                    if (!ImapHandler.pathMatches(path, pattern)) continue;
                    String hit = "LIST (" + this.getFolderAttrs(path, returnOptions, paths, remoteSubscriptions) + ") \"/\" " + path.asUtf7String();
                    if (status == 0) {
                        matches.put(path, hit);
                        continue block5;
                    }
                    matches.put(path, new String[]{hit, this.status(tag, path, status)});
                    continue block5;
                }
            }
            if (selectRecursive) {
                for (ImapPath path : selected) {
                    if (matches.containsKey(path)) continue;
                    String folderName = path.asZimbraPath();
                    int index = folderName.length() + 1;
                    while ((index = folderName.lastIndexOf(47, index - 1)) != -1) {
                        ImapPath parent = new ImapPath(path.getOwner(), folderName.substring(0, index), this.mCredentials);
                        for (Pattern pattern : patterns) {
                            if (!ImapHandler.pathMatches(parent, pattern)) continue;
                            for (ImapPath cached : paths.keySet()) {
                                if (!cached.equals(parent)) continue;
                                parent = cached;
                                break;
                            }
                            matches.put(parent, "LIST (" + this.getFolderAttrs(parent, returnOptions, paths, remoteSubscriptions) + ") \"/\" " + parent.asUtf7String() + " (CHILDINFO (\"SUBSCRIBED\"))");
                        }
                    }
                }
            }
        }
        catch (ServiceException e) {
            ZimbraLog.imap.warn((Object)"LIST failed", e);
            this.sendNO(tag, "LIST failed");
            return this.canContinue(e);
        }
        if (!matches.isEmpty()) {
            for (Object match : matches.values()) {
                if (match instanceof String[]) {
                    for (String response : (String[])match) {
                        this.sendUntagged(response);
                    }
                    continue;
                }
                this.sendUntagged((String)match);
            }
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "LIST completed");
        return true;
    }

    private static Pair<String, Pattern> resolvePath(String referenceName, String mailboxName) {
        int startWildcards = referenceName.length();
        String resolved = mailboxName;
        if (!mailboxName.startsWith("/") && !referenceName.trim().equals("")) {
            resolved = referenceName.endsWith("/") ? referenceName + mailboxName : referenceName + '/' + mailboxName;
        } else {
            startWildcards = 0;
        }
        String unescaped = resolved.toUpperCase();
        StringBuffer escaped = new StringBuffer();
        for (int i = 0; i < unescaped.length(); ++i) {
            char c = unescaped.charAt(i);
            if (c == '*' && i >= startWildcards) {
                escaped.append(".*");
                continue;
            }
            if (c == '%' && i >= startWildcards) {
                escaped.append("[^/]*");
                continue;
            }
            if (c > '\u007f' || !REGEXP_ESCAPED[c]) {
                escaped.append(c);
                continue;
            }
            escaped.append('\\').append(c);
        }
        return new Pair<String, Pattern>(resolved, Pattern.compile(escaped.toString()));
    }

    private void accumulatePaths(Object mboxobj, String owner, ImapPath relativeTo, Map<ImapPath, ItemId> paths) throws ServiceException {
        block4: {
            String root;
            block3: {
                String string = root = relativeTo == null ? "" : "/" + relativeTo.asResolvedPath();
                if (!(mboxobj instanceof Mailbox)) break block3;
                Mailbox mbox = (Mailbox)mboxobj;
                Collection<Folder> folders = mbox.getVisibleFolders(this.getContext());
                if (folders == null) {
                    folders = mbox.getFolderById(this.getContext(), relativeTo == null ? 1 : relativeTo.asItemId().getId()).getSubfolderHierarchy();
                }
                for (Folder folder : folders) {
                    boolean alreadyTraversed;
                    ImapPath path;
                    if (!folder.getPath().startsWith(root) || folder.getPath().equals(root) || !(path = relativeTo == null ? new ImapPath(owner, folder, this.mCredentials) : new ImapPath(owner, folder, relativeTo)).isVisible()) continue;
                    boolean bl = alreadyTraversed = paths.put(path, path.asItemId()) != null;
                    if (!(folder instanceof Mountpoint) || alreadyTraversed) continue;
                    this.accumulatePaths(path.getOwnerMailbox(), owner, path, paths);
                }
                break block4;
            }
            if (!(mboxobj instanceof ZMailbox)) break block4;
            ZMailbox zmbx = (ZMailbox)mboxobj;
            for (ZFolder zfolder : zmbx.getAllFolders()) {
                ImapPath path;
                if (!zfolder.getPath().startsWith(root) || zfolder.getPath().equals(root) || !(path = relativeTo == null ? new ImapPath(owner, zfolder, this.mCredentials) : new ImapPath(owner, zfolder, relativeTo)).isVisible()) continue;
                paths.put(path, path.asItemId());
            }
        }
    }

    private static boolean pathMatches(ImapPath path, Pattern pattern) {
        return pattern.matcher(path.asImapPath().toUpperCase()).matches();
    }

    private String getFolderAttrs(ImapPath path, byte returnOptions, Map<ImapPath, ItemId> paths, Set<String> subscriptions) throws ServiceException {
        boolean noinferiors;
        StringBuilder attrs = new StringBuilder();
        ItemId iid = paths.get(path);
        if (iid == null) {
            attrs.append(attrs.length() == 0 ? "" : " ").append("\\NonExistent");
        }
        if ((returnOptions & 1) != 0 && this.isPathSubscribed(path, subscriptions)) {
            attrs.append(attrs.length() == 0 ? "" : " ").append("\\Subscribed");
        }
        if (iid == null) {
            return attrs.toString();
        }
        boolean bl = noinferiors = iid.getId() == 4;
        if (noinferiors) {
            attrs.append(attrs.length() == 0 ? "" : " ").append("\\NoInferiors");
        }
        if (!path.isSelectable()) {
            attrs.append(attrs.length() == 0 ? "" : " ").append("\\NoSelect");
        }
        if (!noinferiors && (returnOptions & 2) != 0) {
            String prefix = path.asZimbraPath().toUpperCase() + '/';
            boolean children = false;
            for (ImapPath other : paths.keySet()) {
                if (!other.asZimbraPath().toUpperCase().startsWith(prefix) || !other.isVisible()) continue;
                children = true;
                break;
            }
            attrs.append(attrs.length() == 0 ? "" : " ").append(children ? "\\HasChildren" : "\\HasNoChildren");
        }
        return attrs.toString();
    }

    private boolean isPathSubscribed(ImapPath path, Set<String> subscriptions) throws ServiceException {
        if (path.belongsTo(this.mCredentials)) {
            Folder folder = (Folder)path.getFolder();
            return folder.isTagged(-20);
        }
        if (subscriptions != null && !subscriptions.isEmpty()) {
            for (String sub : subscriptions) {
                if (!sub.equalsIgnoreCase(path.asImapPath())) continue;
                return true;
            }
        }
        return false;
    }

    boolean doLSUB(String tag, String referenceName, String mailboxName) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        Pair<String, Pattern> resolved = ImapHandler.resolvePath(referenceName, mailboxName);
        String resolvedPath = resolved.getFirst();
        Pattern pattern = resolved.getSecond();
        Pattern childPattern = Pattern.compile(pattern.pattern() + "/.*");
        ImapPath patternPath = new ImapPath(resolvedPath, this.mCredentials, ImapPath.Scope.UNPARSED);
        ArrayList<String> subscriptions = null;
        try {
            String owner = patternPath.getOwner();
            if (owner == null || owner.indexOf(42) != -1 || owner.indexOf(37) != -1 || !patternPath.belongsTo(this.mCredentials)) {
                Set<String> remoteSubscriptions;
                HashMap<ImapPath, Boolean> hits = new HashMap<ImapPath, Boolean>();
                if (owner == null) {
                    Mailbox mbox = this.mCredentials.getMailbox();
                    for (Folder folder : mbox.getFolderById(this.getContext(), 1).getSubfolderHierarchy()) {
                        if (!folder.isTagged(-20)) continue;
                        this.checkSubscription(new ImapPath(null, folder, this.mCredentials), pattern, childPattern, hits);
                    }
                }
                if ((remoteSubscriptions = this.mCredentials.listSubscriptions()) != null && !remoteSubscriptions.isEmpty()) {
                    Iterator<Object> i$ = remoteSubscriptions.iterator();
                    while (i$.hasNext()) {
                        String string;
                        ImapPath subscribed;
                        if (owner == null != ((subscribed = new ImapPath(string = (String)i$.next(), this.mCredentials)).getOwner() == null)) continue;
                        this.checkSubscription(subscribed, pattern, childPattern, hits);
                    }
                }
                subscriptions = new ArrayList<String>(hits.size());
                for (Map.Entry entry : hits.entrySet()) {
                    String attrs = (Boolean)entry.getValue() != false ? "" : "\\NoSelect";
                    subscriptions.add("LSUB (" + attrs + ") \"/\" " + ((ImapPath)entry.getKey()).asUtf7String());
                }
            }
        }
        catch (ServiceException e) {
            ZimbraLog.imap.warn((Object)"LSUB failed", e);
            this.sendNO(tag, "LSUB failed");
            return this.canContinue(e);
        }
        if (subscriptions != null) {
            for (String sub : subscriptions) {
                this.sendUntagged(sub);
            }
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "LSUB completed");
        return true;
    }

    private boolean checkSubscription(ImapPath path, Pattern pattern, Pattern childPattern, Map<ImapPath, Boolean> hits) {
        if (ImapHandler.pathMatches(path, pattern)) {
            hits.put(path, Boolean.TRUE);
            return true;
        }
        if (!ImapHandler.pathMatches(path, childPattern)) {
            return false;
        }
        boolean matched = false;
        int delimiter = path.asImapPath().lastIndexOf(47);
        while (delimiter > 0) {
            if (!hits.containsKey(path = new ImapPath(path.asImapPath().substring(0, delimiter), this.mCredentials)) && ImapHandler.pathMatches(path, pattern)) {
                hits.put(path, Boolean.FALSE);
                matched = true;
            }
            delimiter = path.asImapPath().lastIndexOf(47);
        }
        return matched;
    }

    boolean doSTATUS(String tag, ImapPath path, byte status) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        try {
            path.canonicalize();
            if (!path.isVisible()) {
                ZimbraLog.imap.info("STATUS failed: folder not visible: " + path);
                this.sendNO(tag, "STATUS failed");
                return true;
            }
            this.sendUntagged(this.status(tag, path, status));
        }
        catch (ServiceException e) {
            if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                ZimbraLog.imap.info("STATUS failed: no such folder: " + path);
            } else {
                ZimbraLog.imap.warn((Object)"STATUS failed", e);
            }
            this.sendNO(tag, "STATUS failed");
            return this.canContinue(e);
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "STATUS completed");
        return true;
    }

    String status(String tag, ImapPath path, byte status) throws ServiceException {
        int modseq;
        int unread;
        int uvv;
        int uidnext;
        int recent;
        int messages;
        StringBuilder data = new StringBuilder("STATUS ").append(path.asUtf7String()).append(" (");
        int empty = data.length();
        Object mboxobj = path.getOwnerMailbox();
        if (mboxobj instanceof Mailbox) {
            Mailbox mbox = (Mailbox)mboxobj;
            Folder folder = (Folder)path.getFolder();
            messages = (int)folder.getItemCount();
            recent = (status & 2) == 0 ? -1 : (messages == 0 ? 0 : (this.mSelectedFolder != null && path.isEquivalent(this.mSelectedFolder.getPath()) ? this.mSelectedFolder.getRecentCount() : mbox.getImapRecent(this.getContext(), folder.getId())));
            uidnext = folder instanceof SearchFolder ? -1 : folder.getImapUIDNEXT();
            uvv = ImapFolder.getUIDValidity(folder);
            unread = folder.getUnreadCount();
            modseq = folder instanceof SearchFolder ? 0 : folder.getImapMODSEQ();
        } else if (mboxobj instanceof ZMailbox) {
            ZFolder zfolder = (ZFolder)path.getFolder();
            if (zfolder == null) {
                throw MailServiceException.NO_SUCH_FOLDER(path.asImapPath());
            }
            messages = zfolder.getMessageCount();
            recent = 0;
            uidnext = zfolder.getImapUIDNEXT();
            uvv = ImapFolder.getUIDValidity(zfolder);
            unread = zfolder.getUnreadCount();
            modseq = zfolder.getImapMODSEQ();
        } else {
            throw AccountServiceException.NO_SUCH_ACCOUNT(path.getOwner());
        }
        if (messages >= 0 && (status & 1) != 0) {
            data.append(data.length() != empty ? " " : "").append("MESSAGES ").append(messages);
        }
        if (recent >= 0 && (status & 2) != 0) {
            data.append(data.length() != empty ? " " : "").append("RECENT ").append(recent);
        }
        if (uidnext > 0 && (status & 4) != 0) {
            data.append(data.length() != empty ? " " : "").append("UIDNEXT ").append(uidnext);
        }
        if (uvv > 0 && (status & 8) != 0) {
            data.append(data.length() != empty ? " " : "").append("UIDVALIDITY ").append(uvv);
        }
        if (unread >= 0 && (status & 0x10) != 0) {
            data.append(data.length() != empty ? " " : "").append("UNSEEN ").append(unread);
        }
        if (modseq >= 0 && (status & 0x20) != 0) {
            data.append(data.length() != empty ? " " : "").append("HIGHESTMODSEQ ").append(modseq);
        }
        return data.append(')').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doAPPEND(String tag, ImapPath path, List<AppendMessage> appends) throws IOException, ImapParseException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        Object mboxobj = null;
        ArrayList<Tag> newTags = new ArrayList<Tag>();
        ArrayList<Integer> createdIds = new ArrayList<Integer>(appends.size());
        StringBuilder appendHint = this.extensionEnabled("UIDPLUS") ? new StringBuilder() : null;
        try {
            int uvv;
            if (!path.isVisible()) {
                throw ImapServiceException.FOLDER_NOT_VISIBLE(path.asImapPath());
            }
            if (!path.isWritable((short)4)) {
                throw ImapServiceException.FOLDER_NOT_WRITABLE(path.asImapPath());
            }
            mboxobj = path.getOwnerMailbox();
            Object folderobj = path.getFolder();
            Object object = mboxobj;
            synchronized (object) {
                ImapFlagCache flagset = ImapFlagCache.getSystemFlags(mboxobj instanceof Mailbox ? (Mailbox)mboxobj : this.mCredentials.getMailbox());
                ImapFlagCache tagset = mboxobj instanceof Mailbox ? new ImapFlagCache((Mailbox)mboxobj, this.getContext()) : new ImapFlagCache();
                for (AppendMessage append : appends) {
                    append.checkFlags(flagset, tagset, newTags);
                }
            }
            for (AppendMessage append : appends) {
                append.checkContent();
            }
            for (AppendMessage append : appends) {
                int id = append.storeContent(mboxobj, folderobj);
                if (id <= 0) continue;
                createdIds.add(id);
            }
            int n = uvv = folderobj instanceof Folder ? ImapFolder.getUIDValidity((Folder)folderobj) : ImapFolder.getUIDValidity((ZFolder)folderobj);
            if (appendHint != null && uvv > 0) {
                appendHint.append("[APPENDUID ").append(uvv).append(' ').append(ImapFolder.encodeSubsequence(createdIds)).append("] ");
            }
        }
        catch (ServiceException e) {
            for (AppendMessage append : appends) {
                append.cleanup();
            }
            this.deleteTags(newTags);
            this.deleteMessages(mboxobj, createdIds);
            String msg = "APPEND failed";
            if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                ZimbraLog.imap.info("APPEND failed: no such folder: " + path);
                if (path.isCreatable()) {
                    msg = "[TRYCREATE] APPEND failed: no such mailbox";
                }
            } else if (e.getCode().equals("mail.INVALID_NAME")) {
                ZimbraLog.imap.info("APPEND failed: " + e.getMessage());
            } else if (e.getCode().equals("imap.FOLDER_NOT_VISIBLE")) {
                ZimbraLog.imap.info("APPEND failed: folder not visible: " + path);
            } else if (e.getCode().equals("imap.FOLDER_NOT_WRITABLE")) {
                ZimbraLog.imap.info("APPEND failed: folder not writable: " + path);
            } else {
                ZimbraLog.imap.warn((Object)"APPEND failed", e);
            }
            this.sendNO(tag, msg);
            return this.canContinue(e);
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, (appendHint == null ? "" : appendHint.toString()) + "APPEND completed");
        return true;
    }

    private void deleteTags(List<Tag> ltags) {
        if (ltags == null || ltags.isEmpty()) {
            return;
        }
        for (Tag ltag : ltags) {
            try {
                ltag.getMailbox().delete(this.getContext(), ltag, null);
            }
            catch (ServiceException e) {
                ZimbraLog.imap.warn((Object)("failed to delete tag: " + ltag.getName()), e);
            }
        }
    }

    public void deleteMessages(Object mboxobj, List<Integer> ids) {
        for (int id : ids) {
            try {
                if (mboxobj instanceof Mailbox) {
                    ((Mailbox)mboxobj).delete(this.getContext(), id, (byte)5);
                    continue;
                }
                ((ZMailbox)mboxobj).deleteMessage(String.valueOf(id));
            }
            catch (ServiceException e) {
                ZimbraLog.imap.warn("failed to delete message: " + id);
            }
        }
    }

    boolean doIDLE(String tag, boolean begin, boolean success, ImapRequest req) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        if (begin) {
            this.mIdleTag = tag;
            if (this.mProxy != null) {
                this.mProxy.idle(req, begin);
            } else {
                this.sendNotifications(true, false);
                this.sendContinuation("idling");
            }
        } else {
            tag = this.mIdleTag;
            this.mIdleTag = null;
            if (this.mProxy != null) {
                this.mProxy.idle(req, begin);
            } else if (success) {
                this.sendOK(tag, "IDLE completed");
            } else {
                this.sendBAD(tag, "IDLE stopped without DONE");
            }
        }
        return true;
    }

    boolean doSETQUOTA(String tag, String qroot, Map<String, String> limits) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        this.sendNO(tag, "SETQUOTA failed");
        return true;
    }

    boolean doGETQUOTA(String tag, ImapPath qroot) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        try {
            if (!qroot.belongsTo(this.mCredentials)) {
                ZimbraLog.imap.info("GETQUOTA failed: cannot get quota for other user's mailbox: " + qroot);
                this.sendNO(tag, "GETQUOTA failed: permission denied");
                return true;
            }
            long quota = this.mCredentials.getAccount().getLongAttr("zimbraMailQuota", 0L);
            if (!qroot.asImapPath().equals("") || quota <= 0L) {
                ZimbraLog.imap.info("GETQUOTA failed: unknown quota root: '" + qroot + "'");
                this.sendNO(tag, "GETQUOTA failed: unknown quota root");
                return true;
            }
            this.sendUntagged("QUOTA \"\" (STORAGE " + this.mCredentials.getMailbox().getSize() / 1024L + ' ' + quota / 1024L + ')');
        }
        catch (ServiceException e) {
            ZimbraLog.imap.warn((Object)"GETQUOTA failed", e);
            this.sendNO(tag, "GETQUOTA failed");
            return this.canContinue(e);
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "GETQUOTA completed");
        return true;
    }

    boolean doGETQUOTAROOT(String tag, ImapPath qroot) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        try {
            if (!qroot.belongsTo(this.mCredentials)) {
                ZimbraLog.imap.info("GETQUOTAROOT failed: cannot get quota root for other user's mailbox: " + qroot);
                this.sendNO(tag, "GETQUOTAROOT failed: permission denied");
                return true;
            }
            if (!qroot.isVisible()) {
                ZimbraLog.imap.info("GETQUOTAROOT failed: folder not visible: '" + qroot + "'");
                this.sendNO(tag, "GETQUOTAROOT failed");
                return true;
            }
            long quota = this.mCredentials.getAccount().getLongAttr("zimbraMailQuota", 0L);
            this.sendUntagged("QUOTAROOT " + qroot.asUtf7String() + (quota > 0L ? " \"\"" : ""));
            if (quota > 0L) {
                this.sendUntagged("QUOTA \"\" (STORAGE " + this.mCredentials.getMailbox().getSize() / 1024L + ' ' + quota / 1024L + ')');
            }
        }
        catch (ServiceException e) {
            if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                ZimbraLog.imap.info("GETQUOTAROOT failed: no such folder: " + qroot);
            } else {
                ZimbraLog.imap.warn((Object)"GETQUOTAROOT failed", e);
            }
            this.sendNO(tag, "GETQUOTAROOT failed");
            return this.canContinue(e);
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "GETQUOTAROOT completed");
        return true;
    }

    boolean doNAMESPACE(String tag) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        this.sendUntagged("NAMESPACE ((\"\" \"/\")) ((\"/home/\" \"/\")) NIL");
        this.sendNotifications(true, false);
        this.sendOK(tag, "NAMESPACE completed");
        return true;
    }

    private boolean allRightsPresent(String i4rights, String linked) {
        for (int i = 0; i < linked.length(); ++i) {
            if (i4rights.indexOf(linked.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    boolean doSETACL(String tag, ImapPath path, String principal, String i4rights, StoreAction action) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        short rights = 0;
        for (int i = 0; i < i4rights.length(); ++i) {
            char c = i4rights.charAt(i);
            if (IMAP_READ_RIGHTS.indexOf(c) != -1) {
                if (!this.allRightsPresent(i4rights, IMAP_READ_RIGHTS)) continue;
                rights = (short)(rights | 1);
                continue;
            }
            if (IMAP_WRITE_RIGHTS.indexOf(c) != -1) {
                if (!this.allRightsPresent(i4rights, IMAP_WRITE_RIGHTS)) continue;
                rights = (short)(rights | 2);
                continue;
            }
            if (IMAP_INSERT_RIGHTS.indexOf(c) != -1) {
                if (!this.allRightsPresent(i4rights, IMAP_INSERT_RIGHTS)) continue;
                rights = (short)(rights | 4);
                continue;
            }
            if (IMAP_DELETE_RIGHTS.indexOf(c) != -1) {
                if (!this.allRightsPresent(i4rights, IMAP_DELETE_RIGHTS)) continue;
                rights = (short)(rights | 8);
                continue;
            }
            if (IMAP_ADMIN_RIGHTS.indexOf(c) != -1) {
                if (!this.allRightsPresent(i4rights, IMAP_ADMIN_RIGHTS)) continue;
                rights = (short)(rights | 0x100);
                continue;
            }
            ZimbraLog.imap.info("SETACL failed: invalid rights string: " + i4rights);
            this.sendBAD(tag, "SETACL failed: invalid right");
            return true;
        }
        try {
            short newRights;
            byte granteeType;
            if ((path.getFolderRights() & 0x100) == 0) {
                ZimbraLog.imap.info("SETACL failed: user does not have admin access: " + path);
                this.sendNO(tag, "SETACL failed");
                return true;
            }
            if (action != StoreAction.REPLACE && rights == 0) {
                this.sendNotifications(true, false);
                this.sendOK(tag, "SETACL completed");
                return true;
            }
            String granteeId = null;
            if (principal.equals("anyone")) {
                granteeId = "00000000-0000-0000-0000-000000000000";
                granteeType = 3;
            } else {
                granteeType = 1;
                MailTarget entry = Provisioning.getInstance().get(Provisioning.AccountBy.name, principal);
                if (entry == null) {
                    entry = Provisioning.getInstance().get(Provisioning.DistributionListBy.name, principal);
                    granteeType = 2;
                }
                if (entry != null) {
                    granteeId = ((NamedEntry)entry).getId();
                }
            }
            if (granteeId == null) {
                ZimbraLog.imap.info("SETACL failed: cannot resolve principal: " + principal);
                this.sendNO(tag, "SETACL failed");
                return true;
            }
            short oldRights = 0;
            Object folderobj = path.getFolder();
            if (folderobj instanceof Folder) {
                ACL acl = ((Folder)folderobj).getEffectiveACL();
                if (acl != null) {
                    for (ACL.Grant grant : acl.getGrants()) {
                        if (!granteeId.equalsIgnoreCase(grant.getGranteeId()) && (granteeType != 3 || grant.getGranteeType() != 3 && grant.getGranteeType() != 6)) continue;
                        oldRights = (short)(oldRights | grant.getGrantedRights());
                    }
                }
            } else {
                for (ZGrant zgrant : ((ZFolder)folderobj).getGrants()) {
                    if (!granteeId.equalsIgnoreCase(zgrant.getGranteeId()) && (granteeType != 3 || zgrant.getGranteeType() != ZGrant.GranteeType.all && zgrant.getGranteeType() != ZGrant.GranteeType.pub)) continue;
                    oldRights = (short)(oldRights | ACL.stringToRights(zgrant.getPermissions()));
                }
            }
            if ((newRights = action == StoreAction.REMOVE ? (short)(oldRights & ~rights) : (action == StoreAction.ADD ? (short)(oldRights | rights) : rights)) != oldRights) {
                if (folderobj instanceof Folder) {
                    Mailbox mbox = (Mailbox)path.getOwnerMailbox();
                    mbox.grantAccess(this.getContext(), ((Folder)folderobj).getId(), granteeId, granteeType, newRights, null);
                } else {
                    ZMailbox zmbx = (ZMailbox)path.getOwnerMailbox();
                    ZGrant.GranteeType type = granteeType == 3 ? ZGrant.GranteeType.all : ZGrant.GranteeType.usr;
                    zmbx.modifyFolderGrant(((ZFolder)folderobj).getId(), type, principal, ACL.rightsToString(newRights), null);
                }
            }
        }
        catch (ServiceException e) {
            if (e.getCode().equals("service.PERM_DENIED")) {
                ZimbraLog.imap.info("SETACL failed: permission denied on folder: " + path);
            } else if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                ZimbraLog.imap.info("SETACL failed: no such folder: " + path);
            } else if (e.getCode().equals("account.NO_SUCH_ACCOUNT")) {
                ZimbraLog.imap.info("SETACL failed: no such account: " + principal);
            } else {
                ZimbraLog.imap.warn((Object)"SETACL failed", e);
            }
            this.sendNO(tag, "SETACL failed");
            return true;
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "SETACL completed");
        return true;
    }

    boolean doDELETEACL(String tag, ImapPath path, String principal) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        try {
            if ((path.getFolderRights() & 0x100) == 0) {
                ZimbraLog.imap.info("DELETEACL failed: user does not have admin access: " + path);
                this.sendNO(tag, "DELETEACL failed");
                return true;
            }
            String granteeId = null;
            if (principal.equals("anyone")) {
                granteeId = "00000000-0000-0000-0000-000000000000";
            } else {
                MailTarget entry = Provisioning.getInstance().get(Provisioning.AccountBy.name, principal);
                if (entry == null) {
                    entry = Provisioning.getInstance().get(Provisioning.DistributionListBy.name, principal);
                }
                if (entry != null) {
                    granteeId = ((NamedEntry)entry).getId();
                }
            }
            if (granteeId == null) {
                ZimbraLog.imap.info("DELETEACL failed: cannot resolve principal: " + principal);
                this.sendNO(tag, "DELETEACL failed");
                return true;
            }
            Object mboxobj = path.getOwnerMailbox();
            if (mboxobj instanceof Mailbox) {
                Mailbox mbox = (Mailbox)mboxobj;
                Folder folder = (Folder)path.getFolder();
                if (folder.getEffectiveACL() != null) {
                    mbox.revokeAccess(this.getContext(), folder.getId(), granteeId);
                    if (granteeId == "00000000-0000-0000-0000-000000000000") {
                        mbox.revokeAccess(this.getContext(), folder.getId(), "99999999-9999-9999-9999-999999999999");
                    }
                }
            } else {
                ZMailbox zmbx = (ZMailbox)mboxobj;
                ZFolder zfolder = (ZFolder)path.getFolder();
                if (!zfolder.getGrants().isEmpty()) {
                    zmbx.modifyFolderRevokeGrant(zfolder.getId(), granteeId);
                    if (granteeId == "00000000-0000-0000-0000-000000000000") {
                        zmbx.modifyFolderRevokeGrant(zfolder.getId(), "99999999-9999-9999-9999-999999999999");
                    }
                }
            }
        }
        catch (ServiceException e) {
            if (e.getCode().equals("service.PERM_DENIED")) {
                ZimbraLog.imap.info("DELETEACL failed: permission denied on folder: " + path);
            } else if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                ZimbraLog.imap.info("DELETEACL failed: no such folder: " + path);
            } else if (e.getCode().equals("account.NO_SUCH_ACCOUNT")) {
                ZimbraLog.imap.info("DELETEACL failed: no such account: " + principal);
            } else {
                ZimbraLog.imap.warn((Object)"DELETEACL failed", e);
            }
            this.sendNO(tag, "DELETEACL failed");
            return true;
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "DELETEACL completed");
        return true;
    }

    boolean doGETACL(String tag, ImapPath path) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        StringBuilder i4acl = new StringBuilder("ACL ").append(path.asUtf7String());
        try {
            if ((path.getFolderRights() & 0x100) == 0) {
                ZimbraLog.imap.info("GETACL failed: user does not have admin access: " + path);
                this.sendNO(tag, "GETACL failed");
                return true;
            }
            Account owner = path.getOwnerAccount();
            if (owner != null) {
                i4acl.append(" \"").append(owner.getName()).append("\" ").append(IMAP_CONCATENATED_RIGHTS);
            }
            Short anyoneRights = null;
            Object folderobj = path.getFolder();
            if (folderobj instanceof Folder) {
                ACL acl = ((Folder)folderobj).getEffectiveACL();
                if (acl != null) {
                    for (ACL.Grant grant : acl.getGrants()) {
                        NamedEntry entry;
                        byte type = grant.getGranteeType();
                        short rights = grant.getGrantedRights();
                        if (type == 3 || type == 6) {
                            anyoneRights = (short)((anyoneRights == null ? (short)0 : anyoneRights) | rights);
                            continue;
                        }
                        if (type != 1 && type != 2 || (entry = FolderAction.lookupGranteeByZimbraId(grant.getGranteeId(), type)) == null) continue;
                        i4acl.append(" \"").append(entry.getName()).append("\" ").append(this.exportRights(rights));
                    }
                }
            } else {
                for (ZGrant zgrant : ((ZFolder)folderobj).getGrants()) {
                    byte granteeType;
                    ZGrant.GranteeType ztype = zgrant.getGranteeType();
                    short rights = ACL.stringToRights(zgrant.getPermissions());
                    if (ztype == ZGrant.GranteeType.pub || ztype == ZGrant.GranteeType.all) {
                        anyoneRights = (short)((anyoneRights == null ? (short)0 : anyoneRights) | rights);
                        continue;
                    }
                    if (ztype != ZGrant.GranteeType.usr && ztype != ZGrant.GranteeType.grp) continue;
                    byte by = granteeType = ztype == ZGrant.GranteeType.usr ? (byte)1 : 2;
                    NamedEntry entry = FolderAction.lookupGranteeByZimbraId(zgrant.getGranteeId(), granteeType);
                    if (entry == null) continue;
                    i4acl.append(" \"").append(entry.getName()).append("\" ").append(this.exportRights(rights));
                }
            }
            if (anyoneRights != null) {
                i4acl.append(" anyone ").append(this.exportRights(anyoneRights));
            }
        }
        catch (ServiceException e) {
            if (e.getCode().equals("service.PERM_DENIED")) {
                ZimbraLog.imap.info("GETACL failed: permission denied on folder: " + path);
            } else if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                ZimbraLog.imap.info("GETACL failed: no such folder: " + path);
            } else {
                ZimbraLog.imap.warn((Object)"GETACL failed", e);
            }
            this.sendNO(tag, "GETACL failed");
            return true;
        }
        this.sendUntagged(i4acl.toString());
        this.sendNotifications(true, false);
        this.sendOK(tag, "GETACL completed");
        return true;
    }

    private String exportRights(short rights) {
        StringBuilder imapRights = new StringBuilder(12);
        if ((rights & 1) == 1) {
            imapRights.append(IMAP_READ_RIGHTS);
        }
        if ((rights & 2) == 2) {
            imapRights.append(IMAP_WRITE_RIGHTS);
        }
        if ((rights & 4) == 4) {
            imapRights.append("ic");
        }
        if ((rights & this.SUBFOLDER_RIGHTS) == this.SUBFOLDER_RIGHTS) {
            imapRights.append("k");
        }
        if ((rights & 8) == 8) {
            imapRights.append(IMAP_DELETE_RIGHTS);
        }
        if ((rights & 0x100) == 256) {
            imapRights.append(IMAP_ADMIN_RIGHTS);
        }
        return imapRights.length() == 0 ? "\"\"" : imapRights.toString();
    }

    boolean doLISTRIGHTS(String tag, ImapPath path, String principal) throws IOException {
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        boolean isOwner = false;
        try {
            if (!principal.equals("anyone")) {
                Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, principal);
                if (acct == null) {
                    throw AccountServiceException.NO_SUCH_ACCOUNT(principal);
                }
                isOwner = path.belongsTo(acct.getId());
            }
            if ((path.getFolderRights() & 0x100) == 0) {
                throw ServiceException.PERM_DENIED("you must have admin privileges to perform LISTRIGHTS");
            }
        }
        catch (ServiceException e) {
            if (e.getCode().equals("service.PERM_DENIED")) {
                ZimbraLog.imap.info("LISTRIGHTS failed: permission denied on folder: " + path);
            } else if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                ZimbraLog.imap.info("LISTRIGHTS failed: no such folder: " + path);
            } else if (e.getCode().equals("account.NO_SUCH_ACCOUNT")) {
                ZimbraLog.imap.info("LISTRIGHTS failed: no such account: " + principal);
            } else {
                ZimbraLog.imap.warn((Object)"LISTRIGHTS failed", e);
            }
            this.sendNO(tag, "LISTRIGHTS failed");
            return this.canContinue(e);
        }
        if (isOwner) {
            this.sendUntagged("LISTRIGHTS " + path.asUtf7String() + " \"" + principal + "\" " + IMAP_CONCATENATED_RIGHTS);
        } else {
            this.sendUntagged("LISTRIGHTS " + path.asUtf7String() + " \"" + principal + "\" \"\" " + IMAP_DELIMITED_RIGHTS);
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "LISTRIGHTS completed");
        return true;
    }

    boolean doMYRIGHTS(String tag, ImapPath path) throws IOException {
        short rights;
        if (!this.checkState(tag, State.AUTHENTICATED)) {
            return true;
        }
        try {
            if (!path.isVisible()) {
                throw ServiceException.PERM_DENIED("path not visible");
            }
            rights = path.getFolderRights();
        }
        catch (ServiceException e) {
            if (e.getCode().equals("service.PERM_DENIED")) {
                ZimbraLog.imap.info("MYRIGHTS failed: permission denied on folder: " + path);
            } else if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                ZimbraLog.imap.info("MYRIGHTS failed: no such folder: " + path);
            } else if (e.getCode().equals("account.NO_SUCH_ACCOUNT")) {
                ZimbraLog.imap.info("MYRIGHTS failed: no such account: " + path.getOwner());
            } else {
                ZimbraLog.imap.warn((Object)"MYRIGHTS failed", e);
            }
            this.sendNO(tag, "MYRIGHTS failed");
            return this.canContinue(e);
        }
        this.sendUntagged("MYRIGHTS " + path.asUtf7String() + ' ' + this.exportRights(rights));
        this.sendNotifications(true, false);
        this.sendOK(tag, "MYRIGHTS completed");
        return true;
    }

    boolean doCHECK(String tag) throws IOException {
        if (!this.checkState(tag, State.SELECTED)) {
            return true;
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, "CHECK completed");
        return true;
    }

    boolean doCLOSE(String tag) throws IOException, ImapParseException {
        if (!this.checkState(tag, State.SELECTED)) {
            return true;
        }
        ImapProxy proxy = this.mProxy;
        if (proxy != null) {
            proxy.proxy(tag, "CLOSE");
            this.unsetSelectedFolder(false);
            return true;
        }
        ImapFolder i4folder = this.mSelectedFolder;
        boolean expunged = false;
        try {
            if (i4folder.isWritable() && i4folder.getPath().isWritable((short)8)) {
                expunged = this.expungeMessages(tag, i4folder, null);
            }
        }
        catch (ServiceException e) {
            ZimbraLog.imap.warn((Object)"error during CLOSE", e);
        }
        String status = "";
        try {
            if (expunged && !i4folder.isVirtual() && this.sessionActivated(ImapExtension.QRESYNC)) {
                status = "[HIGHESTMODSEQ " + i4folder.getCurrentMODSEQ() + "] ";
            }
        }
        catch (ServiceException e) {
            ZimbraLog.imap.info((Object)"error while determining HIGHESTMODSEQ of selected folder", e);
        }
        this.unsetSelectedFolder(true);
        this.sendOK(tag, status + "CLOSE completed");
        return true;
    }

    boolean doUNSELECT(String tag) throws IOException {
        if (!this.checkState(tag, State.SELECTED)) {
            return true;
        }
        this.unsetSelectedFolder(true);
        this.sendOK(tag, "UNSELECT completed");
        return true;
    }

    boolean doEXPUNGE(String tag, boolean byUID, String sequenceSet) throws IOException, ImapParseException {
        boolean expunged;
        if (!this.checkState(tag, State.SELECTED)) {
            return true;
        }
        if (!this.mSelectedFolder.isWritable()) {
            this.sendNO(tag, "mailbox selected READ-ONLY");
            return true;
        }
        String command = byUID ? "UID EXPUNGE" : "EXPUNGE";
        try {
            if (!this.mSelectedFolder.getPath().isWritable((short)8)) {
                throw ServiceException.PERM_DENIED("you do not have permission to delete messages from this folder");
            }
            expunged = this.expungeMessages(tag, this.mSelectedFolder, sequenceSet);
        }
        catch (ServiceException e) {
            ZimbraLog.imap.warn((Object)(command + " failed"), e);
            this.sendNO(tag, command + " failed");
            return this.canContinue(e);
        }
        String status = "";
        try {
            if (expunged && byUID && !this.mSelectedFolder.isVirtual() && this.sessionActivated(ImapExtension.QRESYNC)) {
                status = "[HIGHESTMODSEQ " + this.mSelectedFolder.getCurrentMODSEQ() + "] ";
            }
        }
        catch (ServiceException e) {
            ZimbraLog.imap.info((Object)"error while determining HIGHESTMODSEQ of selected folder", e);
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, status + command + " completed");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean expungeMessages(String tag, ImapFolder i4folder, String sequenceSet) throws ServiceException, IOException, ImapParseException {
        ImapMessage.ImapMessageSet i4set;
        Mailbox mailbox = this.mSelectedFolder.getMailbox();
        synchronized (mailbox) {
            i4set = sequenceSet == null ? null : i4folder.getSubsequence(tag, sequenceSet, true);
        }
        ArrayList<Integer> ids = new ArrayList<Integer>(30);
        boolean changed = false;
        long checkpoint = System.currentTimeMillis();
        int max = i4folder.getSize();
        for (int i = 1; i <= max; ++i) {
            ImapMessage i4msg = i4folder.getBySequence(i);
            if (i4msg != null && !i4msg.isExpunged() && (i4msg.flags & Flag.BITMASK_DELETED) > 0 && (i4set == null || i4set.contains(i4msg))) {
                ids.add(i4msg.msgId);
                changed = true;
            }
            if (ids.size() < (i == max ? 1 : 30)) continue;
            try {
                ZimbraLog.imap.debug("  ** deleting: " + ids);
                int[] idsArray = new int[ids.size()];
                int counter = 0;
                Iterator i$ = ids.iterator();
                while (i$.hasNext()) {
                    int id = (Integer)i$.next();
                    idsArray[counter++] = id;
                }
                this.mSelectedFolder.getMailbox().delete(this.getContext(), idsArray, (byte)-1, null);
            }
            catch (MailServiceException.NoSuchItemException e) {
                Iterator i$ = ids.iterator();
                while (i$.hasNext()) {
                    int id = (Integer)i$.next();
                    try {
                        ZimbraLog.imap.debug("  ** fallback deleting: " + id);
                        this.mSelectedFolder.getMailbox().delete(this.getContext(), new int[]{id}, (byte)-1, null);
                    }
                    catch (MailServiceException.NoSuchItemException nsie) {
                        i4msg = i4folder.getById(id);
                        if (i4msg == null) continue;
                        i4msg.setExpunged(true);
                    }
                }
            }
            ids.clear();
            long now = System.currentTimeMillis();
            if (now - checkpoint <= 15000L) continue;
            this.sendIdleUntagged();
            checkpoint = now;
        }
        return changed;
    }

    boolean doSEARCH(String tag, ImapSearch i4search, boolean byUID, Integer options) throws IOException, ImapParseException {
        return this.search(tag, "SEARCH", i4search, byUID, options, null);
    }

    boolean doSORT(String tag, ImapSearch i4search, boolean byUID, Integer options, List<SortBy> order) throws IOException, ImapParseException {
        return this.search(tag, "SORT", i4search, byUID, options, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean search(String tag, String command, ImapSearch i4search, boolean byUID, Integer options, List<SortBy> order) throws IOException, ImapParseException {
        ImapMessage.ImapMessageSet hits;
        int modseq;
        boolean unsorted;
        boolean saveResults;
        ImapFolder i4folder;
        block38: {
            if (!this.checkState(tag, State.SELECTED)) {
                return true;
            }
            i4folder = this.mSelectedFolder;
            boolean requiresMODSEQ = i4search.requiresMODSEQ();
            if (requiresMODSEQ) {
                this.activateExtension(ImapExtension.CONDSTORE);
            }
            if (requiresMODSEQ && !this.sessionActivated(ImapExtension.CONDSTORE)) {
                throw new ImapParseException(tag, "NOMODSEQ", "cannot SEARCH MODSEQ in this mailbox", true);
            }
            SortBy sort = SortBy.NONE;
            if (order != null && !order.isEmpty()) {
                SortBy level;
                Iterator<SortBy> i$ = order.iterator();
                while (i$.hasNext() && (sort = (level = i$.next())) == SortBy.NONE) {
                }
            }
            saveResults = options != null && (options & 0x10) != 0;
            unsorted = sort == SortBy.NONE;
            modseq = 0;
            try {
                Mailbox mbox = i4folder.getMailbox();
                if (unsorted && i4search.canBeRunLocally()) {
                    Mailbox mailbox = mbox;
                    synchronized (mailbox) {
                        hits = i4search.evaluate(i4folder);
                        hits.remove(null);
                        break block38;
                    }
                }
                ZimbraQueryResults zqr = this.runSearch(i4search, i4folder, sort, requiresMODSEQ ? Mailbox.SearchResultMode.MODSEQ : Mailbox.SearchResultMode.IDS);
                hits = unsorted ? new ImapMessage.ImapMessageSet() : new ArrayList();
                try {
                    ZimbraHit hit = zqr.getNext();
                    while (hit != null) {
                        ImapMessage i4msg = i4folder.getById(hit.getItemId());
                        if (i4msg != null && !i4msg.isExpunged()) {
                            hits.add(i4msg);
                            if (requiresMODSEQ) {
                                modseq = Math.max(modseq, Math.max(hit.getModifiedSequence(), i4msg.getFlagModseq(i4folder.getTagset())));
                            }
                        }
                        hit = zqr.getNext();
                    }
                    Object var19_24 = null;
                }
                catch (Throwable throwable) {
                    Object var19_25 = null;
                    zqr.doneWithSearchResults();
                    throw throwable;
                }
                zqr.doneWithSearchResults();
                {
                }
            }
            catch (ParseException pe) {
                if (saveResults) {
                    i4folder.saveSearchResults(new ImapMessage.ImapMessageSet());
                }
                ZimbraLog.imap.warn((Object)(command + " failed (bad query)"), pe);
                this.sendNO(tag, command + " failed");
                return true;
            }
            catch (ServiceException e) {
                if (saveResults) {
                    i4folder.saveSearchResults(new ImapMessage.ImapMessageSet());
                }
                ZimbraLog.imap.warn((Object)(command + " failed"), e);
                this.sendNO(tag, command + " failed");
                return true;
            }
        }
        int size = hits.size();
        ImapMessage first = null;
        ImapMessage last = null;
        if (size != 0 && options != null && (options & 3) != 0) {
            if (unsorted) {
                first = (ImapMessage)hits.first();
                last = (ImapMessage)hits.last();
            } else {
                first = (ImapMessage)((List)((Object)hits)).get(0);
                last = (ImapMessage)((List)((Object)hits)).get(size - 1);
            }
        }
        StringBuilder result = null;
        if (options == null) {
            result = new StringBuilder(command);
            for (ImapMessage i4msg : hits) {
                result.append(' ').append(ImapHandler.getMessageId(i4msg, byUID));
            }
        } else if (options != 16) {
            result = new StringBuilder("E" + command + " (TAG \"").append(tag).append("\")");
            if (byUID) {
                result.append(" UID");
            }
            if (first != null && (options & 1) != 0) {
                result.append(" MIN ").append(ImapHandler.getMessageId(first, byUID));
            }
            if (last != null && (options & 2) != 0) {
                result.append(" MAX ").append(ImapHandler.getMessageId(last, byUID));
            }
            if ((options & 8) != 0) {
                result.append(" COUNT ").append(size);
            }
            if (size != 0 && (options & 4) != 0) {
                result.append(" ALL ").append(ImapFolder.encodeSubsequence(hits, byUID));
            }
        }
        if (modseq > 0 && result != null) {
            result.append(" (MODSEQ ").append(modseq).append(')');
        }
        if (saveResults) {
            if (size == 0 || options == 16 || (options & 0xC) != 0) {
                i4folder.saveSearchResults(unsorted ? hits : new ImapMessage.ImapMessageSet(hits));
            } else {
                ImapMessage.ImapMessageSet saved = new ImapMessage.ImapMessageSet();
                if (first != null && (options & 1) != 0) {
                    saved.add(first);
                }
                if (last != null && (options & 2) != 0) {
                    saved.add(last);
                }
                i4folder.saveSearchResults(saved);
            }
        }
        if (result != null) {
            this.sendUntagged(result.toString());
        }
        this.sendNotifications(false, false);
        this.sendOK(tag, (byUID ? "UID " : "") + command + " completed");
        return true;
    }

    private static int getMessageId(ImapMessage i4msg, boolean byUID) {
        return byUID ? i4msg.imapUid : i4msg.sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZimbraQueryResults runSearch(ImapSearch i4search, ImapFolder i4folder, SortBy sort, Mailbox.SearchResultMode resultMode) throws ImapParseException, ServiceException, ParseException {
        String search;
        Mailbox mbox = i4folder.getMailbox();
        if (mbox == null) {
            throw ServiceException.FAILURE("unexpected session close during search", null);
        }
        Account acct = this.mCredentials == null ? null : this.mCredentials.getAccount();
        ICalTimeZone tz = acct == null ? null : WellKnownTimeZones.getTimeZoneById(acct.getAttr("zimbraPrefTimeZoneId"));
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            search = i4search.toZimbraSearch(i4folder);
            search = !i4folder.isVirtual() ? "in:" + i4folder.getQuotedPath() + ' ' + search : (i4folder.getSize() <= 600 ? ImapSearch.sequenceAsSearchTerm(i4folder, i4folder.getAllMessages(), false) + ' ' + search : '(' + i4folder.getQuery() + ") " + search);
            ZimbraLog.imap.info("[ search is: " + search + " ]");
        }
        SearchParams params = new SearchParams();
        params.setIncludeTagDeleted(true);
        params.setQueryStr(search);
        params.setTypes(ITEM_TYPES);
        params.setSortBy(sort);
        params.setChunkSize(2000);
        params.setPrefetch(false);
        params.setMode(resultMode);
        params.setTimeZone(tz);
        try {
            return mbox.search(SoapProtocol.Soap12, this.getContext(), params);
        }
        catch (IOException ioe) {
            throw ServiceException.FAILURE("error during proxied query: " + search, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doTHREAD(String tag, ImapSearch i4search, boolean byUID) throws IOException, ImapParseException {
        if (!this.checkState(tag, State.SELECTED)) {
            return true;
        }
        ImapFolder i4folder = this.mSelectedFolder;
        boolean requiresMODSEQ = i4search.requiresMODSEQ();
        if (requiresMODSEQ) {
            this.activateExtension(ImapExtension.CONDSTORE);
        }
        if (requiresMODSEQ && !this.sessionActivated(ImapExtension.CONDSTORE)) {
            throw new ImapParseException(tag, "NOMODSEQ", "cannot THREAD MODSEQ in this mailbox", true);
        }
        LinkedHashMap<Integer, List<ImapMessage>> threads = new LinkedHashMap<Integer, List<ImapMessage>>();
        try {
            ZimbraQueryResults zqr = this.runSearch(i4search, i4folder, SortBy.DATE_ASCENDING, Mailbox.SearchResultMode.PARENT);
            try {
                ZimbraHit hit = zqr.getNext();
                while (hit != null) {
                    ImapMessage i4msg = i4folder.getById(hit.getItemId());
                    if (i4msg != null && !i4msg.isExpunged()) {
                        int parentId = hit.getParentId();
                        if (parentId <= 0) {
                            threads.put(-i4msg.msgId, Arrays.asList(i4msg));
                        } else {
                            LinkedList<ImapMessage> contents = (LinkedList<ImapMessage>)threads.get(parentId);
                            if (contents == null) {
                                contents = new LinkedList<ImapMessage>();
                                contents.add(i4msg);
                                threads.put(parentId, contents);
                            } else {
                                contents.add(i4msg);
                            }
                        }
                    }
                    hit = zqr.getNext();
                }
                Object var13_15 = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                zqr.doneWithSearchResults();
                throw throwable;
            }
            zqr.doneWithSearchResults();
            {
            }
        }
        catch (ParseException pe) {
            ZimbraLog.imap.warn((Object)"THREAD failed (bad query)", pe);
            this.sendNO(tag, "THREAD failed");
            return true;
        }
        catch (ServiceException e) {
            ZimbraLog.imap.warn((Object)"THREAD failed", e);
            this.sendNO(tag, "THREAD failed");
            return true;
        }
        StringBuilder result = new StringBuilder("THREAD");
        if (!threads.isEmpty()) {
            result.append(' ');
            for (List thread : threads.values()) {
                Iterator it = thread.iterator();
                result.append('(').append(ImapHandler.getMessageId((ImapMessage)it.next(), byUID));
                if (it.hasNext()) {
                    result.append(' ');
                    if (thread.size() == 2) {
                        result.append(ImapHandler.getMessageId((ImapMessage)it.next(), byUID));
                    } else {
                        while (it.hasNext()) {
                            result.append('(').append(ImapHandler.getMessageId((ImapMessage)it.next(), byUID)).append(')');
                        }
                    }
                }
                result.append(')');
            }
        }
        this.sendUntagged(result.toString());
        this.sendNotifications(false, false);
        this.sendOK(tag, (byUID ? "UID " : "") + "THREAD completed");
        return true;
    }

    boolean doFETCH(String tag, String sequenceSet, int attributes, List<ImapPartSpecifier> parts, boolean byUID, int changedSince) throws IOException, ImapParseException {
        return this.fetch(tag, sequenceSet, attributes, parts, byUID, changedSince, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean fetch(String tag, String sequenceSet, int attributes, List<ImapPartSpecifier> parts, boolean byUID, int changedSince, boolean standalone) throws IOException, ImapParseException {
        boolean allPresent;
        ImapMessage.ImapMessageSet i4set;
        Mailbox mbox;
        ArrayList<ImapPartSpecifier> fullMessage;
        boolean modseqEnabled;
        boolean markRead;
        String command;
        ImapFolder i4folder;
        block50: {
            if (!this.checkState(tag, State.SELECTED)) {
                return true;
            }
            i4folder = this.mSelectedFolder;
            if (byUID) {
                attributes |= 0x80;
            }
            command = byUID ? "UID FETCH" : "FETCH";
            boolean bl = markRead = i4folder.isWritable() && (attributes & 0x1000) != 0;
            if ((attributes & 0x200) != 0) {
                if (!byUID) throw new ImapParseException(tag, "cannot specify VANISHED without CHANGEDSINCE");
                if (changedSince < 0) {
                    throw new ImapParseException(tag, "cannot specify VANISHED without CHANGEDSINCE");
                }
            }
            if (changedSince >= 0) {
                attributes |= 0x100;
            }
            if ((attributes & 0x100) != 0) {
                this.activateExtension(ImapExtension.CONDSTORE);
            }
            if (!(modseqEnabled = this.sessionActivated(ImapExtension.CONDSTORE)) && (attributes & 0x100) != 0) {
                throw new ImapParseException(tag, "NOMODSEQ", "cannot FETCH MODSEQ in this mailbox", true);
            }
            fullMessage = new ArrayList<ImapPartSpecifier>();
            if (parts != null && !parts.isEmpty()) {
                Iterator<ImapPartSpecifier> it = parts.iterator();
                while (it.hasNext()) {
                    ImapPartSpecifier pspec = it.next();
                    if (!pspec.isEntireMessage()) continue;
                    it.remove();
                    fullMessage.add(pspec);
                }
            }
            Mailbox mailbox = mbox = i4folder.getMailbox();
            synchronized (mailbox) {
                i4set = i4folder.getSubsequence(tag, sequenceSet, byUID);
            }
            allPresent = byUID || !i4set.contains(null);
            i4set.remove(null);
            if (byUID && (attributes & 0x200) != 0) {
                String vanished;
                int highwater = Integer.MAX_VALUE;
                try {
                    highwater = i4folder.getCurrentMODSEQ();
                }
                catch (ServiceException e) {
                    // empty catch block
                }
                if (highwater > changedSince && !(vanished = i4folder.invertSubsequence(sequenceSet, true, i4set)).equals("")) {
                    this.sendUntagged("VANISHED (EARLIER) " + vanished);
                }
            }
            if (changedSince >= 0) {
                try {
                    HashSet<Integer> folderId = new HashSet<Integer>(Arrays.asList(i4folder.getId()));
                    ImapMessage.ImapMessageSet modified = new ImapMessage.ImapMessageSet();
                    for (int id : mbox.getModifiedItems(this.getContext(), changedSince, (byte)-1, folderId).getFirst()) {
                        ImapMessage i4msg = i4folder.getById(id);
                        if (i4msg == null) continue;
                        modified.add(i4msg);
                    }
                    ImapFlagCache i4cache = i4folder.getTagset();
                    if (i4cache.getMaximumModseq() > changedSince) {
                        for (ImapMessage i4msg : i4set) {
                            if (i4msg.getFlagModseq(i4cache) <= changedSince) continue;
                            modified.add(i4msg);
                        }
                    }
                    i4set.retainAll(modified);
                }
                catch (ServiceException e) {
                    if (!standalone) break block50;
                    ZimbraLog.imap.warn((Object)(command + " failed"), e);
                    this.sendNO(tag, command + " failed");
                    return this.canContinue(e);
                }
            }
        }
        Mailbox e = mbox;
        synchronized (e) {
            if (i4folder.areTagsDirty()) {
                this.sendUntagged("FLAGS (" + StringUtil.join(" ", i4folder.getFlagList(false)) + ')');
                i4folder.cleanTags();
            }
        }
        for (ImapMessage i4msg : i4set) {
            ByteArrayOutputStream baosDebug;
            block52: {
                Object var28_38;
                OutputStream os = this.mOutputStream;
                baosDebug = ZimbraLog.imap.isDebugEnabled() ? new ByteArrayOutputStream() : null;
                PrintStream result = new PrintStream((OutputStream)new ByteUtil.TeeOutputStream(os, baosDebug), false, "utf-8");
                try {
                    block51: {
                        try {
                            boolean markMessage = markRead && (i4msg.flags & Flag.BITMASK_UNREAD) != 0;
                            boolean empty = true;
                            MailItem item = null;
                            result.print("* " + i4msg.sequence + " FETCH (");
                            if (!fullMessage.isEmpty() || parts != null && !parts.isEmpty() || (attributes & 0xFFFFFF77) != 0) {
                                item = mbox.getItemById(this.getContext(), i4msg.msgId, i4msg.getType());
                            }
                            if ((attributes & 0x80) != 0) {
                                result.print((empty ? "" : " ") + "UID " + i4msg.imapUid);
                                empty = false;
                            }
                            if ((attributes & 0x10) != 0) {
                                result.print((empty ? "" : " ") + "INTERNALDATE \"" + DateUtil.toImapDateTime(new Date(item.getDate())) + '\"');
                                empty = false;
                            }
                            if ((attributes & 0x20) != 0) {
                                result.print((empty ? "" : " ") + "RFC822.SIZE " + i4msg.getSize(item));
                                empty = false;
                            }
                            if ((attributes & 0x40) != 0) {
                                result.print((empty ? "" : " ") + "BINARY.SIZE[] " + i4msg.getSize(item));
                                empty = false;
                            }
                            if (!fullMessage.isEmpty()) {
                                for (ImapPartSpecifier pspec : fullMessage) {
                                    result.print(empty ? "" : " ");
                                    pspec.write(result, os, item);
                                    empty = false;
                                }
                            }
                            if (parts != null && !parts.isEmpty() || (attributes & 7) != 0) {
                                MimeMessage mm = ImapMessage.getMimeMessage(item);
                                if ((attributes & 1) != 0) {
                                    result.print(empty ? "" : " ");
                                    result.print("BODY ");
                                    ImapMessage.serializeStructure(result, mm, false);
                                    empty = false;
                                }
                                if ((attributes & 2) != 0) {
                                    result.print(empty ? "" : " ");
                                    result.print("BODYSTRUCTURE ");
                                    ImapMessage.serializeStructure(result, mm, true);
                                    empty = false;
                                }
                                if ((attributes & 4) != 0) {
                                    result.print(empty ? "" : " ");
                                    result.print("ENVELOPE ");
                                    ImapMessage.serializeEnvelope(result, mm);
                                    empty = false;
                                }
                                if (parts != null) {
                                    for (ImapPartSpecifier pspec : parts) {
                                        result.print(empty ? "" : " ");
                                        pspec.write(result, os, mm);
                                        empty = false;
                                    }
                                }
                            }
                            if (markMessage) {
                                mbox.alterTag(this.getContext(), i4msg.msgId, i4msg.getType(), -10, false, null);
                            }
                            ImapFolder.DirtyMessage unsolicited = i4folder.undirtyMessage(i4msg);
                            if ((attributes & 8) != 0 || unsolicited != null) {
                                result.print(empty ? "" : " ");
                                result.print(i4msg.getFlags(i4folder));
                                empty = false;
                            }
                            if ((attributes & 0x100) == 0 && (!modseqEnabled || unsolicited == null)) break block51;
                            int modseq = unsolicited == null ? i4msg.getModseq(item, i4folder.getTagset()) : unsolicited.modseq;
                            result.print((empty ? "" : " ") + "MODSEQ (" + modseq + ')');
                            empty = false;
                        }
                        catch (ImapPartSpecifier.BinaryDecodingException e2) {
                            baosDebug = null;
                            os = null;
                            throw new ImapParseException(tag, "UNKNOWN-CTE", command + "failed: unknown content-type-encoding", false);
                        }
                        catch (ServiceException e3) {
                            ZimbraLog.imap.warn((Object)("ignoring error during " + command + ": "), e3);
                            var28_38 = null;
                            if (os != null) {
                                result.write(41);
                                os.write(LINE_SEPARATOR_BYTES, 0, LINE_SEPARATOR_BYTES.length);
                                os.flush();
                            }
                            if (baosDebug == null) continue;
                            ZimbraLog.imap.debug("  S: " + baosDebug);
                            continue;
                        }
                        catch (MessagingException e4) {
                            ZimbraLog.imap.warn((Object)("ignoring error during " + command + ": "), e4);
                            var28_38 = null;
                            if (os != null) {
                                result.write(41);
                                os.write(LINE_SEPARATOR_BYTES, 0, LINE_SEPARATOR_BYTES.length);
                                os.flush();
                            }
                            if (baosDebug == null) continue;
                            ZimbraLog.imap.debug("  S: " + baosDebug);
                            continue;
                        }
                    }
                    var28_38 = null;
                    if (os == null) break block52;
                    result.write(41);
                }
                catch (Throwable throwable) {
                    var28_38 = null;
                    if (os != null) {
                        result.write(41);
                        os.write(LINE_SEPARATOR_BYTES, 0, LINE_SEPARATOR_BYTES.length);
                        os.flush();
                    }
                    if (baosDebug == null) throw throwable;
                    ZimbraLog.imap.debug("  S: " + baosDebug);
                    throw throwable;
                }
                os.write(LINE_SEPARATOR_BYTES, 0, LINE_SEPARATOR_BYTES.length);
                os.flush();
            }
            if (baosDebug == null) continue;
            ZimbraLog.imap.debug("  S: " + baosDebug);
        }
        if (!standalone) return true;
        this.sendNotifications(false, false);
        if (allPresent) {
            this.sendOK(tag, command + " completed");
            return true;
        }
        this.sendNO(tag, "some of the requested messages no longer exist");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doSTORE(String tag, String sequenceSet, List<String> flagNames, StoreAction operation, boolean silent, int modseq, boolean byUID) throws IOException, ImapParseException {
        ImapMessage.ImapMessageSet i4set;
        Mailbox mbox;
        boolean modseqEnabled;
        if (!this.checkState(tag, State.SELECTED)) {
            return true;
        }
        if (!this.mSelectedFolder.isWritable()) {
            this.sendNO(tag, "mailbox selected READ-ONLY");
            return true;
        }
        if (modseq >= 0) {
            this.activateExtension(ImapExtension.CONDSTORE);
        }
        if (!(modseqEnabled = this.sessionActivated(ImapExtension.CONDSTORE)) && modseq >= 0) {
            throw new ImapParseException(tag, "NOMODSEQ", "cannot STORE UNCHANGEDSINCE in this mailbox", true);
        }
        ImapMessage.ImapMessageSet modifyConflicts = modseqEnabled ? new ImapMessage.ImapMessageSet() : null;
        String command = byUID ? "UID STORE" : "STORE";
        ArrayList<Tag> newTags = operation != StoreAction.REMOVE ? new ArrayList<Tag>() : null;
        Mailbox mailbox = mbox = this.mSelectedFolder.getMailbox();
        synchronized (mailbox) {
            i4set = this.mSelectedFolder.getSubsequence(tag, sequenceSet, byUID);
        }
        boolean allPresent = byUID || !i4set.contains(null);
        i4set.remove(null);
        try {
            HashSet<ImapFlagCache.ImapFlag> i4flags = new HashSet<ImapFlagCache.ImapFlag>(flagNames.size());
            Mailbox mailbox2 = mbox;
            synchronized (mailbox2) {
                for (String name : flagNames) {
                    ImapFlagCache.ImapFlag i4flag = this.mSelectedFolder.getFlagByName(name);
                    if (!(i4flag != null && i4flag.mListed || operation == StoreAction.REMOVE)) {
                        i4flag = this.mSelectedFolder.getTagset().createTag(this.getContext(), name, newTags);
                    }
                    if (i4flag == null) continue;
                    i4flags.add(i4flag);
                }
                if (this.mSelectedFolder.areTagsDirty()) {
                    this.sendUntagged("FLAGS (" + StringUtil.join(" ", this.mSelectedFolder.getFlagList(false)) + ')');
                    this.mSelectedFolder.cleanTags();
                }
            }
            if (operation != StoreAction.REMOVE) {
                for (ImapFlagCache.ImapFlag i4flag : i4flags) {
                    if (i4flag.mId == -8) {
                        if (this.mSelectedFolder.getPath().isWritable((short)8)) continue;
                        throw ServiceException.PERM_DENIED("you do not have permission to set the \\Deleted flag");
                    }
                    if (!i4flag.mPermanent || this.mSelectedFolder.getPath().isWritable((short)2)) continue;
                    throw ServiceException.PERM_DENIED("you do not have permission to set the " + i4flag.mName + " flag");
                }
            }
            long tags = 0L;
            int flags = Flag.BITMASK_UNREAD;
            short sflags = 0;
            if (operation == StoreAction.REPLACE) {
                for (ImapFlagCache.ImapFlag i4flag : i4flags) {
                    if (Tag.validateId(i4flag.mId)) {
                        tags = i4flag.mPositive ? tags | i4flag.mBitmask : tags & (i4flag.mBitmask ^ 0xFFFFFFFFFFFFFFFFL);
                        continue;
                    }
                    if (!i4flag.mPermanent) {
                        sflags = (byte)(i4flag.mPositive ? (long)sflags | i4flag.mBitmask : (long)sflags & (i4flag.mBitmask ^ 0xFFFFFFFFFFFFFFFFL));
                        continue;
                    }
                    flags = (int)(i4flag.mPositive ? (long)flags | i4flag.mBitmask : (long)flags & (i4flag.mBitmask ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
            long checkpoint = System.currentTimeMillis();
            int i = 0;
            ArrayList<ImapMessage> i4list = new ArrayList<ImapMessage>(100);
            ArrayList<Integer> idlist = new ArrayList<Integer>(100);
            for (ImapMessage msg : i4set) {
                i4list.add(msg);
                idlist.add(msg.msgId);
                if (++i % 100 != 0 && i != i4set.size()) continue;
                Mailbox mailbox3 = mbox;
                synchronized (mailbox3) {
                    Object var34_50;
                    if (modseq >= 0) {
                        MailItem[] items = mbox.getItemById(this.getContext(), idlist, (byte)-1);
                        for (int idx = items.length - 1; idx >= 0; --idx) {
                            ImapMessage i4msg = (ImapMessage)i4list.get(idx);
                            if (i4msg.getModseq(items[idx], this.mSelectedFolder.getTagset()) <= modseq) continue;
                            modifyConflicts.add(i4msg);
                            i4list.remove(idx);
                            idlist.remove(idx);
                            allPresent = false;
                        }
                    }
                    try {
                        if (silent && !modseqEnabled) {
                            this.mSelectedFolder.disableNotifications();
                        }
                        if (operation == StoreAction.REPLACE) {
                            mbox.setTags(this.getContext(), ArrayUtil.toIntArray(idlist), (byte)-1, flags, tags, null);
                            for (ImapMessage i4msg : i4list) {
                                i4msg.setSessionFlags(sflags, this.mSelectedFolder);
                            }
                        } else {
                            for (ImapFlagCache.ImapFlag i4flag : i4flags) {
                                boolean add = operation == StoreAction.ADD ^ !i4flag.mPositive;
                                if (i4flag.mPermanent) {
                                    mbox.alterTag(this.getContext(), ArrayUtil.toIntArray(idlist), (byte)-1, i4flag.mId, add, null);
                                    continue;
                                }
                                for (ImapMessage i4msg : i4list) {
                                    i4msg.setSessionFlags((short)(add ? (long)i4msg.sflags | i4flag.mBitmask : (long)i4msg.sflags & (i4flag.mBitmask ^ 0xFFFFFFFFFFFFFFFFL)), this.mSelectedFolder);
                                }
                            }
                        }
                        var34_50 = null;
                        this.mSelectedFolder.enableNotifications();
                    }
                    catch (Throwable throwable) {
                        var34_50 = null;
                        this.mSelectedFolder.enableNotifications();
                        throw throwable;
                    }
                }
                if (!silent || modseqEnabled) {
                    for (ImapMessage i4msg : i4list) {
                        ImapFolder.DirtyMessage dirty = this.mSelectedFolder.undirtyMessage(i4msg);
                        if (silent && (dirty == null || dirty.modseq <= 0)) continue;
                        StringBuilder ntfn = new StringBuilder();
                        boolean empty = true;
                        ntfn.append(i4msg.sequence).append(" FETCH (");
                        if (!silent) {
                            ntfn.append(i4msg.getFlags(this.mSelectedFolder));
                            empty = false;
                        }
                        if (byUID) {
                            ntfn.append(empty ? "" : " ").append("UID ").append(i4msg.imapUid);
                            empty = false;
                        }
                        if (dirty != null && dirty.modseq > 0 && modseqEnabled) {
                            ntfn.append(empty ? "" : " ").append("MODSEQ (").append(dirty.modseq).append(')');
                            empty = false;
                        }
                        this.sendUntagged(ntfn.append(')').toString());
                    }
                } else {
                    long now = System.currentTimeMillis();
                    if (now - checkpoint > 15000L) {
                        this.sendIdleUntagged();
                        checkpoint = now;
                    }
                }
                i4list.clear();
                idlist.clear();
            }
        }
        catch (ServiceException e) {
            this.deleteTags(newTags);
            if (e.getCode().equals("mail.INVALID_NAME")) {
                ZimbraLog.imap.info(command + " failed: " + e.getMessage());
            } else {
                ZimbraLog.imap.warn((Object)(command + " failed"), e);
            }
            this.sendNO(tag, command + " failed");
            return this.canContinue(e);
        }
        boolean hadConflicts = modifyConflicts != null && !modifyConflicts.isEmpty();
        String conflicts = hadConflicts ? " [MODIFIED " + ImapFolder.encodeSubsequence(modifyConflicts, byUID) + ']' : "";
        this.sendNotifications(false, false);
        if (silent || allPresent) {
            this.sendOK(tag, command + conflicts + " completed");
        } else {
            this.sendNO(tag, command + conflicts + " completed");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doCOPY(String tag, String sequenceSet, ImapPath path, boolean byUID) throws IOException, ImapParseException {
        ImapMessage.ImapMessageSet i4set;
        Mailbox mbox;
        if (!this.checkState(tag, State.SELECTED)) {
            return true;
        }
        String command = byUID ? "UID COPY" : "COPY";
        String copyuid = "";
        ArrayList<MailItem> copies = new ArrayList<MailItem>();
        Mailbox mailbox = mbox = this.mSelectedFolder.getMailbox();
        synchronized (mailbox) {
            i4set = this.mSelectedFolder.getSubsequence(tag, sequenceSet, byUID);
        }
        if (!byUID && i4set.contains(null)) {
            this.sendNO(tag, "COPY rejected because some of the requested messages were expunged");
            return true;
        }
        i4set.remove(null);
        try {
            int uvv;
            ItemId iidTarget;
            if (!path.isVisible()) {
                throw ImapServiceException.FOLDER_NOT_VISIBLE(path.asImapPath());
            }
            if (!path.isWritable((short)4)) {
                throw ImapServiceException.FOLDER_NOT_WRITABLE(path.asImapPath());
            }
            Object mboxobj = path.getOwnerMailbox();
            boolean sameMailbox = false;
            if (mboxobj instanceof Mailbox) {
                sameMailbox = mbox.getAccountId().equalsIgnoreCase(((Mailbox)mboxobj).getAccountId());
                Folder folder = (Folder)path.getFolder();
                iidTarget = new ItemId(folder);
                uvv = ImapFolder.getUIDValidity(folder);
            } else if (mboxobj instanceof ZMailbox) {
                ZFolder zfolder = (ZFolder)path.getFolder();
                iidTarget = new ItemId(zfolder.getId(), path.getOwnerAccount().getId());
                uvv = ImapFolder.getUIDValidity(zfolder);
            } else {
                throw AccountServiceException.NO_SUCH_ACCOUNT(path.getOwner());
            }
            long checkpoint = System.currentTimeMillis();
            ArrayList<Integer> srcUIDs = this.extensionEnabled("UIDPLUS") ? new ArrayList<Integer>() : null;
            ArrayList<Integer> copyUIDs = this.extensionEnabled("UIDPLUS") ? new ArrayList<Integer>() : null;
            int i = 0;
            ArrayList<ImapMessage> i4list = new ArrayList<ImapMessage>(50);
            ArrayList<Integer> idlist = new ArrayList<Integer>(50);
            ArrayList<Integer> createdList = new ArrayList<Integer>(50);
            for (ImapMessage i4msg : i4set) {
                i4list.add(i4msg);
                idlist.add(i4msg.msgId);
                if (++i % 50 != 0 && i != i4set.size()) continue;
                if (sameMailbox) {
                    List<MailItem> copyMsgs;
                    try {
                        int type = -1;
                        int[] nArray = new int[i4list.size()];
                        int counter = 0;
                        for (ImapMessage curMsg : i4list) {
                            nArray[counter++] = curMsg.msgId;
                            if (counter == 1) {
                                type = curMsg.getType();
                                continue;
                            }
                            if (curMsg.getType() == type) continue;
                            type = -1;
                        }
                        copyMsgs = mbox.imapCopy(this.getContext(), nArray, (byte)type, iidTarget.getId());
                    }
                    catch (IOException e) {
                        throw ServiceException.FAILURE("Caught IOException executing " + this, e);
                    }
                    copies.addAll(copyMsgs);
                    for (MailItem mailItem : copyMsgs) {
                        createdList.add(mailItem.getImapUid());
                    }
                } else {
                    ItemActionHelper op = ItemActionHelper.COPY(this.getContext(), mbox, null, idlist, (byte)-1, null, iidTarget);
                    for (String string : op.getCreatedIds()) {
                        createdList.add(new ItemId(string, this.mSelectedFolder.getAuthenticatedAccountId()).getId());
                    }
                }
                if (createdList.size() != i4list.size()) {
                    throw ServiceException.FAILURE("mismatch between original and target count during IMAP COPY", null);
                }
                if (srcUIDs != null) {
                    for (ImapMessage source : i4list) {
                        srcUIDs.add(source.imapUid);
                    }
                    for (Integer target : createdList) {
                        copyUIDs.add(target);
                    }
                }
                i4list.clear();
                idlist.clear();
                createdList.clear();
                long now = System.currentTimeMillis();
                if (now - checkpoint <= 15000L) continue;
                this.sendIdleUntagged();
                checkpoint = now;
            }
            if (uvv > 0 && srcUIDs != null && srcUIDs.size() > 0) {
                copyuid = "[COPYUID " + uvv + ' ' + ImapFolder.encodeSubsequence(srcUIDs) + ' ' + ImapFolder.encodeSubsequence(copyUIDs) + "] ";
            }
        }
        catch (IOException e) {
            ZimbraLog.imap.warn((Object)(command + " failed"), e);
            this.sendNO(tag, command + " failed");
            return true;
        }
        catch (ServiceException e) {
            String rcode = "";
            if (e.getCode().equals("mail.NO_SUCH_FOLDER")) {
                ZimbraLog.imap.info(command + " failed: no such folder: " + path);
                if (path.isCreatable()) {
                    rcode = "[TRYCREATE] ";
                }
            } else if (e.getCode().equals("imap.FOLDER_NOT_VISIBLE")) {
                ZimbraLog.imap.info(command + " failed: folder not visible: " + path);
            } else if (e.getCode().equals("imap.FOLDER_NOT_WRITABLE")) {
                ZimbraLog.imap.info(command + " failed: folder not writable: " + path);
            } else {
                ZimbraLog.imap.warn((Object)(command + " failed"), e);
            }
            this.sendNO(tag, rcode + command + " failed");
            return this.canContinue(e);
        }
        this.sendNotifications(true, false);
        this.sendOK(tag, copyuid + command + " completed");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotifications(boolean notifyExpunges, boolean flush) throws IOException {
        ImapProxy proxy = this.mProxy;
        if (proxy != null) {
            proxy.fetchNotifications();
            return;
        }
        ImapFolder i4folder = this.mSelectedFolder;
        if (i4folder == null) {
            return;
        }
        Mailbox mbox = i4folder.getMailbox();
        if (mbox == null) {
            return;
        }
        ArrayList<String> notifications = new ArrayList<String>();
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            if (i4folder.areTagsDirty()) {
                notifications.add("FLAGS (" + StringUtil.join(" ", i4folder.getFlagList(false)) + ')');
                i4folder.cleanTags();
            }
            int oldRecent = i4folder.getRecentCount();
            boolean removed = false;
            boolean received = i4folder.checkpointSize();
            if (notifyExpunges) {
                List<Integer> expunged = i4folder.collapseExpunged();
                boolean bl = removed = !expunged.isEmpty();
                if (removed) {
                    if (this.sessionActivated(ImapExtension.QRESYNC)) {
                        notifications.add("VANISHED " + ImapFolder.encodeSubsequence(expunged));
                    } else {
                        for (Integer index : expunged) {
                            notifications.add(index + " EXPUNGE");
                        }
                    }
                }
            }
            i4folder.checkpointSize();
            boolean sendModseq = this.sessionActivated(ImapExtension.CONDSTORE);
            Iterator<ImapFolder.DirtyMessage> it = i4folder.dirtyIterator();
            while (it.hasNext()) {
                ImapFolder.DirtyMessage dirty = it.next();
                if (dirty.i4msg.isAdded()) {
                    dirty.i4msg.setAdded(false);
                    continue;
                }
                notifications.add(dirty.i4msg.sequence + " FETCH (" + dirty.i4msg.getFlags(i4folder) + (sendModseq && dirty.modseq > 0 ? " MODSEQ (" + dirty.modseq + ')' : "") + ')');
            }
            i4folder.clearDirty();
            if (received || removed) {
                notifications.add(i4folder.getSize() + " EXISTS");
            }
            if (received || oldRecent != i4folder.getRecentCount()) {
                notifications.add(i4folder.getRecentCount() + " RECENT");
            }
        }
        for (String ntfn : notifications) {
            this.sendUntagged(ntfn);
        }
        if (flush) {
            this.flushOutput();
        }
    }

    @Override
    public void dropConnection() {
        this.dropConnection(true);
    }

    protected abstract void dropConnection(boolean var1);

    protected abstract void flushOutput() throws IOException;

    protected abstract void enableInactivityTimer() throws IOException;

    protected abstract void completeAuthentication() throws IOException;

    void sendIdleUntagged() throws IOException {
        this.sendUntagged("NOOP", true);
    }

    void sendOK(String tag, String response) throws IOException {
        this.sendResponse(tag, "OK " + (response.equals("") ? " " : response), true);
    }

    void sendNO(String tag, String response) throws IOException {
        this.sendResponse(tag, "NO " + (response.equals("") ? " " : response), true);
    }

    void sendBAD(String tag, String response) throws IOException {
        this.sendResponse(tag, "BAD " + (response.equals("") ? " " : response), true);
    }

    void sendUntagged(String response) throws IOException {
        this.sendResponse("*", response, false);
    }

    void sendUntagged(String response, boolean flush) throws IOException {
        this.sendResponse("*", response, flush);
    }

    void sendContinuation(String response) throws IOException {
        this.sendResponse("+", response, true);
    }

    void sendBYE() {
        this.sendBYE(this.mConfig.getGoodbye());
    }

    void sendBYE(String msg) {
        try {
            this.sendUntagged("BYE " + msg, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mGoodbyeSent = true;
    }

    void sendResponse(String tag, String msg, boolean flush) throws IOException {
        String response = (tag == null ? "" : tag + ' ') + (msg == null ? "" : msg);
        if (ZimbraLog.imap.isDebugEnabled()) {
            ZimbraLog.imap.debug("S: " + response);
        } else if (msg != null && msg.startsWith("BAD")) {
            ZimbraLog.imap.info("S: " + response);
        }
        this.sendLine(response, flush);
    }

    abstract void sendLine(String var1, boolean var2) throws IOException;

    static {
        ImapHandler.REGEXP_ESCAPED[46] = true;
        ImapHandler.REGEXP_ESCAPED[41] = true;
        ImapHandler.REGEXP_ESCAPED[40] = true;
        ImapHandler.REGEXP_ESCAPED[124] = true;
        ImapHandler.REGEXP_ESCAPED[93] = true;
        ImapHandler.REGEXP_ESCAPED[91] = true;
        ImapHandler.REGEXP_ESCAPED[63] = true;
        ImapHandler.REGEXP_ESCAPED[36] = true;
        ImapHandler.REGEXP_ESCAPED[94] = true;
        ImapHandler.REGEXP_ESCAPED[42] = true;
        ImapHandler.REGEXP_ESCAPED[125] = true;
        ImapHandler.REGEXP_ESCAPED[123] = true;
        ImapHandler.REGEXP_ESCAPED[92] = true;
        ITEM_TYPES = ArrayUtil.toByteArray(ImapMessage.SUPPORTED_TYPES);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StoreAction {
        REPLACE,
        ADD,
        REMOVE;

    }

    static class QResyncInfo {
        int uvv;
        int modseq;
        String knownUIDs;
        String seqMilestones;
        String uidMilestones;

        QResyncInfo() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ImapExtension {
        CONDSTORE,
        QRESYNC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        NOT_AUTHENTICATED,
        AUTHENTICATED,
        SELECTED,
        LOGOUT;

    }
}

