/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.imap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.imap.ImapCredentials;
import com.zimbra.cs.imap.ImapFlagCache;
import com.zimbra.cs.imap.ImapHandler;
import com.zimbra.cs.imap.ImapMessage;
import com.zimbra.cs.imap.ImapParseException;
import com.zimbra.cs.imap.ImapPath;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.index.ZimbraHit;
import com.zimbra.cs.index.ZimbraQueryResults;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.SearchFolder;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.session.PendingModifications;
import com.zimbra.cs.session.Session;
import com.zimbra.cs.zclient.ZFolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapFolder
extends Session
implements Iterable<ImapMessage> {
    public static final int IMAP_IDLE_TIMEOUT_SEC = 1800;
    public static final long IMAP_IDLE_TIMEOUT_MSEC = 1800000L;
    static final byte SELECT_READONLY = 1;
    static final byte SELECT_CONDSTORE = 2;
    private int mFolderId;
    private ImapPath mPath;
    private boolean mWritable;
    private String mQuery;
    private List<ImapMessage> mSequence;
    private Map<Integer, ImapMessage> mMessageIds;
    private int mRecentCount;
    private int mUIDValidityValue;
    private int mInitialUIDNEXT = -1;
    private int mInitialMODSEQ = -1;
    private int mInitialRECENT = -1;
    private int mInitialFirstUnread = -1;
    private int mLastSize = 0;
    private ImapFlagCache mFlags;
    private ImapFlagCache mTags;
    private ImapCredentials mCredentials;
    private ImapHandler mHandler;
    private boolean mNotificationsSuspended;
    private ImapMessage.ImapMessageSet mSavedSearchResults;
    private boolean mTagsAreDirty;
    private Map<Integer, DirtyMessage> mDirtyMessages = new TreeMap<Integer, DirtyMessage>();

    ImapFolder(ImapPath path, byte params, ImapHandler handler, ImapCredentials creds) throws ServiceException {
        super(creds.getAccountId(), path.getOwnerAccount().getId(), Session.Type.IMAP);
        this.mHandler = handler;
        this.mCredentials = creds;
        this.mPath = path;
        if (!this.mPath.isSelectable()) {
            throw ServiceException.PERM_DENIED("cannot select folder: " + this.mPath);
        }
        boolean bl = this.mWritable = (params & 1) == 0 && this.mPath.isWritable();
        if ((params & 2) != 0) {
            this.mHandler.activateExtension(ImapHandler.ImapExtension.CONDSTORE);
        }
        this.mInitialRECENT = ((Folder)path.getFolder()).getImapRECENTCutoff();
    }

    @Override
    public Session register() throws ServiceException {
        super.register();
        this.mMailbox.beginTrackingImap();
        OperationContext octxt = this.mCredentials.getContext().setSession(this);
        Folder folder = (Folder)this.mPath.getFolder();
        this.mFolderId = folder.getId();
        this.loadFolder(octxt, folder);
        this.mUIDValidityValue = ImapFolder.getUIDValidity(folder);
        this.mInitialUIDNEXT = folder.getImapUIDNEXT();
        this.mInitialMODSEQ = folder.getImapMODSEQ();
        this.mFlags = ImapFlagCache.getSystemFlags(this.mMailbox);
        this.mTags = new ImapFlagCache(this.mMailbox, octxt);
        return this;
    }

    @Override
    public Session unregister() {
        this.snapshotRECENT();
        return super.unregister();
    }

    private void snapshotRECENT() {
        try {
            Mailbox mbox = this.mMailbox;
            if (mbox != null && this.isWritable()) {
                mbox.recordImapSession(this.mFolderId);
            }
        }
        catch (MailServiceException.NoSuchItemException nsie) {
        }
        catch (Exception e) {
            ZimbraLog.session.warn((Object)"exception recording unloaded session's RECENT limit", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFolder(OperationContext octxt, Folder folder) throws ServiceException {
        boolean debug = ZimbraLog.imap.isDebugEnabled();
        if (debug) {
            ZimbraLog.imap.debug("  ** loading folder: " + this.mPath);
        }
        if (folder instanceof SearchFolder) {
            String types = ((SearchFolder)folder).getReturnTypes().toLowerCase();
            if (types.equals("")) {
                types = "conversation";
            }
            this.mQuery = types.indexOf("conversation") != -1 || types.indexOf("message") != -1 ? ((SearchFolder)folder).getQuery() : "item:none";
        }
        List<ImapMessage> i4list = null;
        if (this.isVirtual()) {
            i4list = this.loadVirtualFolder(octxt, (SearchFolder)folder);
        }
        Mailbox mailbox = this.mMailbox;
        synchronized (mailbox) {
            if (i4list == null) {
                i4list = this.mMailbox.openImapFolder(octxt, folder.getId());
            }
            Collections.sort(i4list);
            ArrayList<ImapMessage> unnumbered = new ArrayList<ImapMessage>();
            ArrayList<Integer> renumber = new ArrayList<Integer>();
            while (!i4list.isEmpty() && i4list.get((int)0).imapUid <= 0) {
                ImapMessage i4msg = i4list.remove(0);
                unnumbered.add(i4msg);
                renumber.add(i4msg.msgId);
            }
            if (!renumber.isEmpty()) {
                List<Integer> newIds = this.mMailbox.resetImapUid(octxt, renumber);
                for (int i = 0; i < newIds.size(); ++i) {
                    ((ImapMessage)unnumbered.get((int)i)).imapUid = newIds.get(i);
                }
                i4list.addAll(unnumbered);
            }
            this.mSequence = new ArrayList<ImapMessage>();
            StringBuilder added = debug ? new StringBuilder("  ** added: ") : null;
            for (ImapMessage i4msg : i4list) {
                this.cache(i4msg, i4msg.imapUid > this.mInitialRECENT);
                if (this.mInitialFirstUnread == -1 && (i4msg.flags & Flag.BITMASK_UNREAD) != 0) {
                    this.mInitialFirstUnread = i4msg.sequence;
                }
                if (!debug) continue;
                added.append(' ').append(i4msg.msgId);
            }
            if (debug) {
                ZimbraLog.imap.debug(added);
            }
            this.mLastSize = this.mSequence.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImapMessage> loadVirtualFolder(OperationContext octxt, SearchFolder search) throws ServiceException {
        SearchParams params = new SearchParams();
        params.setQueryStr(this.mQuery);
        params.setIncludeTagDeleted(true);
        params.setTypes(ImapHandler.ITEM_TYPES);
        params.setSortBy(SortBy.DATE_ASCENDING);
        params.setChunkSize(1000);
        params.setMode(Mailbox.SearchResultMode.IMAP);
        Mailbox mbox = search.getMailbox();
        ArrayList<ImapMessage> i4list = new ArrayList<ImapMessage>();
        try {
            ZimbraQueryResults zqr = mbox.search(SoapProtocol.Soap12, octxt, params);
            try {
                ZimbraHit hit = zqr.getNext();
                while (hit != null) {
                    i4list.add(hit.getImapMessage());
                    hit = zqr.getNext();
                }
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                zqr.doneWithSearchResults();
                throw throwable;
            }
            zqr.doneWithSearchResults();
            {
            }
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw ServiceException.FAILURE("failure opening searchfolder", e);
        }
        return i4list;
    }

    void reopen(byte params) throws ServiceException {
        if (this.isVirtual()) {
            throw ServiceException.INVALID_REQUEST("cannot reopen virtual folders", null);
        }
        Folder folder = (Folder)this.mPath.getFolder();
        if (!this.mPath.isSelectable()) {
            throw ServiceException.PERM_DENIED("cannot select folder: " + this.mPath);
        }
        if (folder.getId() != this.mFolderId) {
            throw ServiceException.INVALID_REQUEST("folder IDs do not match (was " + this.mFolderId + ", is " + folder.getId() + ')', null);
        }
        this.snapshotRECENT();
        this.mUIDValidityValue = ImapFolder.getUIDValidity(folder);
        this.mInitialUIDNEXT = folder.getImapUIDNEXT();
        this.mInitialMODSEQ = folder.getImapMODSEQ();
        this.mInitialRECENT = folder.getImapRECENTCutoff();
        boolean bl = this.mWritable = (params & 1) == 0 && this.mPath.isWritable();
        if ((params & 2) != 0) {
            this.mHandler.activateExtension(ImapHandler.ImapExtension.CONDSTORE);
        }
        this.mNotificationsSuspended = false;
        this.mDirtyMessages.clear();
        this.collapseExpunged();
        this.mRecentCount = 0;
        this.mInitialFirstUnread = -1;
        for (ImapMessage i4msg : this.mSequence) {
            if (this.mInitialFirstUnread == -1 && (i4msg.flags & Flag.BITMASK_UNREAD) != 0) {
                this.mInitialFirstUnread = i4msg.sequence;
            }
            i4msg.setAdded(false);
            if (i4msg.imapUid > this.mInitialRECENT) {
                i4msg.sflags = (short)(i4msg.sflags | 1);
                ++this.mRecentCount;
                continue;
            }
            i4msg.sflags = (short)(i4msg.sflags & 0xFFFFFFFE);
        }
        this.mLastSize = this.mSequence.size();
        this.mSavedSearchResults = null;
    }

    @Override
    protected boolean isMailboxListener() {
        return true;
    }

    @Override
    protected boolean isRegisteredInCache() {
        return true;
    }

    @Override
    public void doEncodeState(Element parent) {
        ImapCredentials.EnabledHack[] hacks = this.mCredentials.getEnabledHacks();
        Element imap = parent.addElement("imap");
        if (this.mSequence != null) {
            imap.addAttribute("size", this.getSize());
        }
        imap.addAttribute("hack", hacks == null ? null : Arrays.toString((Object[])hacks));
        imap.addAttribute("folder", this.mPath.asImapPath()).addAttribute("query", this.mQuery);
        imap.addAttribute("writable", this.isWritable()).addAttribute("dirty", this.mDirtyMessages.size());
    }

    @Override
    protected long getSessionIdleLifetime() {
        return 1800000L;
    }

    ImapHandler getHandler() {
        return this.mHandler;
    }

    void setHandler(ImapHandler handler) {
        this.mHandler = handler;
    }

    public int getId() {
        return this.mFolderId;
    }

    int getSize() {
        return this.mSequence == null ? 0 : this.mSequence.size();
    }

    int getRecentCount() {
        return this.isVirtual() ? 0 : this.mRecentCount;
    }

    String getQuery() {
        return this.mQuery == null ? "" : this.mQuery;
    }

    int getUIDValidity() {
        return this.mUIDValidityValue;
    }

    int getInitialUIDNEXT() {
        return this.mInitialUIDNEXT;
    }

    int getInitialMODSEQ() {
        return this.mInitialMODSEQ;
    }

    int getCurrentMODSEQ() throws ServiceException {
        return this.mMailbox.getFolderById(null, this.mFolderId).getImapMODSEQ();
    }

    int getFirstUnread() {
        return this.mInitialFirstUnread;
    }

    ImapCredentials getCredentials() {
        return this.mCredentials;
    }

    boolean isVirtual() {
        return this.mQuery != null;
    }

    public boolean isWritable() {
        return this.mWritable;
    }

    boolean isExtensionActivated(ImapHandler.ImapExtension ext) {
        switch (ext) {
            case CONDSTORE: {
                return !this.isVirtual() && this.mHandler.sessionActivated(ext);
            }
        }
        return false;
    }

    @Override
    public Iterator<ImapMessage> iterator() {
        return this.mSequence.iterator();
    }

    ImapPath getPath() {
        return this.mPath;
    }

    void updatePath(Folder folder) {
        this.mPath = new ImapPath(null, folder.getPath(), this.mPath.getCredentials());
    }

    String getQuotedPath() throws ServiceException {
        return '\"' + this.mPath.asResolvedPath() + '\"';
    }

    @Override
    public String toString() {
        return this.mPath.toString();
    }

    static int getUIDValidity(Folder folder) {
        return Math.max(folder.getSavedSequence(), 1);
    }

    static int getUIDValidity(ZFolder zfolder) {
        return zfolder.getContentSequence();
    }

    private int uidSearch(int uid) {
        int low = 0;
        int high = this.getSize() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int targetUid = this.mSequence.get((int)mid).imapUid;
            if (targetUid < uid) {
                low = mid + 1;
                continue;
            }
            if (targetUid > uid) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    ImapMessage getById(int id) {
        ImapMessage i4msg;
        if (id <= 0 || this.getSize() == 0) {
            return null;
        }
        int sequence = this.uidSearch(id);
        if (sequence >= 0 && sequence < this.mSequence.size() && (i4msg = this.mSequence.get(sequence)) != null && i4msg.msgId == id && !i4msg.isExpunged()) {
            return this.checkRemoved(i4msg);
        }
        if (this.mMessageIds == null) {
            this.mMessageIds = new HashMap<Integer, ImapMessage>();
            for (ImapMessage i4msg2 : this.mSequence) {
                if (i4msg2 == null || i4msg2.msgId == i4msg2.imapUid) continue;
                this.mMessageIds.put(i4msg2.msgId, i4msg2);
            }
        }
        return this.checkRemoved(this.mMessageIds.get(new Integer(id)));
    }

    ImapMessage getByImapId(int uid) {
        return uid > 0 ? this.getBySequence(this.uidSearch(uid) + 1) : null;
    }

    ImapMessage getBySequence(int seq) {
        return this.checkRemoved(seq > 0 && seq <= this.getSize() ? this.mSequence.get(seq - 1) : null);
    }

    private ImapMessage getLastMessage() {
        return this.getBySequence(this.getSize());
    }

    private ImapMessage checkRemoved(ImapMessage i4msg) {
        return i4msg == null || i4msg.isExpunged() ? null : i4msg;
    }

    ImapMessage cache(ImapMessage i4msg, boolean recent) {
        if (this.mSequence == null) {
            return null;
        }
        if (this.mFolderId == 4) {
            i4msg.sflags = (short)(i4msg.sflags | 0xA);
        }
        if (recent) {
            i4msg.sflags = (short)(i4msg.sflags | 1);
            ++this.mRecentCount;
        }
        this.mSequence.add(i4msg);
        this.setIndex(i4msg, this.mSequence.size());
        return i4msg;
    }

    private void setIndex(ImapMessage i4msg, int position) {
        i4msg.sequence = position;
        if (this.mMessageIds != null) {
            if (i4msg.msgId != i4msg.imapUid) {
                this.mMessageIds.put(new Integer(i4msg.msgId), i4msg);
            } else {
                this.mMessageIds.remove(new Integer(i4msg.msgId));
            }
        }
    }

    private void uncache(ImapMessage i4msg) {
        if (this.mMessageIds != null) {
            this.mMessageIds.remove(new Integer(i4msg.msgId));
        }
        this.mDirtyMessages.remove(new Integer(i4msg.imapUid));
        if ((i4msg.sflags & 1) != 0) {
            --this.mRecentCount;
        }
    }

    boolean areTagsDirty() {
        return this.mTagsAreDirty;
    }

    void cleanTags() {
        this.mTagsAreDirty = false;
    }

    ImapFlagCache.ImapFlag cacheTag(Tag ltag) {
        assert (!(ltag instanceof Flag));
        if (ltag instanceof Flag) {
            return null;
        }
        this.mTagsAreDirty = true;
        return this.mTags.cache(new ImapFlagCache.ImapFlag(ltag.getName(), ltag, true));
    }

    void dirtyTag(int id, int modseq) {
        this.dirtyTag(id, modseq, false);
    }

    void dirtyTag(int id, int modseq, boolean removeTag) {
        this.mTagsAreDirty = true;
        if (this.getSize() == 0) {
            return;
        }
        long mask = 1L << Tag.getIndex(id);
        for (ImapMessage i4msg : this.mSequence) {
            if (i4msg == null || (i4msg.tags & mask) == 0L) continue;
            this.dirtyMessage(i4msg, modseq);
            if (!removeTag) continue;
            i4msg.tags &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    ImapFlagCache.ImapFlag getFlagByName(String name) {
        ImapFlagCache.ImapFlag i4flag = this.mFlags.getByName(name);
        return i4flag != null ? i4flag : this.mTags.getByName(name);
    }

    ImapFlagCache.ImapFlag getTagByMask(long mask) {
        return this.mTags.getByMask(mask);
    }

    List<String> getFlagList(boolean permanentOnly) {
        List<String> names = this.mFlags.listNames(permanentOnly);
        for (String tagname : this.mTags.listNames(permanentOnly)) {
            if (this.mFlags.getByName(tagname) != null) continue;
            names.add(tagname);
        }
        return names;
    }

    ImapFlagCache getTagset() {
        return this.mTags;
    }

    void clearTagCache() {
        this.mTags.clear();
    }

    boolean isMessageDirty(ImapMessage i4msg) {
        return this.mDirtyMessages.containsKey(i4msg.imapUid);
    }

    void dirtyMessage(ImapMessage i4msg, int modseq) {
        if (this.mNotificationsSuspended || i4msg != this.getBySequence(i4msg.sequence)) {
            return;
        }
        DirtyMessage dirty = this.mDirtyMessages.get(i4msg.imapUid);
        if (dirty == null) {
            this.mDirtyMessages.put(i4msg.imapUid, new DirtyMessage(i4msg, modseq));
        } else if (modseq > dirty.modseq) {
            dirty.modseq = modseq;
        }
    }

    DirtyMessage undirtyMessage(ImapMessage i4msg) {
        DirtyMessage dirty = this.mDirtyMessages.remove(i4msg.imapUid);
        if (dirty != null) {
            dirty.i4msg.setAdded(false);
        }
        return dirty;
    }

    Iterator<DirtyMessage> dirtyIterator() {
        return this.mDirtyMessages.values().iterator();
    }

    void clearDirty() {
        this.mDirtyMessages.clear();
    }

    boolean checkpointSize() {
        int last = this.mLastSize;
        this.mLastSize = this.getSize();
        return last != this.mLastSize;
    }

    void disableNotifications() {
        this.mNotificationsSuspended = true;
    }

    void enableNotifications() {
        this.mNotificationsSuspended = false;
    }

    void saveSearchResults(ImapMessage.ImapMessageSet i4set) {
        i4set.remove(null);
        this.mSavedSearchResults = i4set;
    }

    ImapMessage.ImapMessageSet getSavedSearchResults() {
        if (this.mSavedSearchResults == null) {
            this.mSavedSearchResults = new ImapMessage.ImapMessageSet();
        }
        return this.mSavedSearchResults;
    }

    void markMessageExpunged(ImapMessage i4msg) {
        if (this.mSavedSearchResults != null) {
            this.mSavedSearchResults.remove(i4msg);
        }
        i4msg.setExpunged(true);
    }

    ImapMessage.ImapMessageSet getAllMessages() {
        ImapMessage.ImapMessageSet result = new ImapMessage.ImapMessageSet();
        if (this.getSize() > 0) {
            for (ImapMessage i4msg : this.mSequence) {
                if (i4msg == null) continue;
                result.add(i4msg);
            }
        }
        return result;
    }

    ImapMessage.ImapMessageSet getFlaggedMessages(ImapFlagCache.ImapFlag i4flag) {
        ImapMessage.ImapMessageSet result = new ImapMessage.ImapMessageSet();
        if (i4flag != null && this.getSize() > 0) {
            for (ImapMessage i4msg : this.mSequence) {
                if (i4msg == null || !i4flag.matches(i4msg)) continue;
                result.add(i4msg);
            }
        }
        return result;
    }

    private int parseId(String id) {
        try {
            return (int)Math.max(-1L, Math.min(Integer.MAX_VALUE, Long.parseLong(id)));
        }
        catch (NumberFormatException nfe) {
            return Integer.MAX_VALUE;
        }
    }

    private List<Pair<Integer, Integer>> normalizeSubsequence(String subseqStr, boolean byUID) {
        if (subseqStr == null || subseqStr.trim().equals("")) {
            return Collections.emptyList();
        }
        ImapMessage i4msg = this.getLastMessage();
        int lastID = i4msg == null ? (byUID ? Integer.MAX_VALUE : this.getSize()) : (byUID ? i4msg.imapUid : i4msg.sequence);
        ArrayList<Pair<Integer, Integer>> normalized = new ArrayList<Pair<Integer, Integer>>(5);
        for (String subset : subseqStr.split(",")) {
            int lower;
            int upper;
            if (subset.indexOf(58) == -1) {
                upper = subset.equals("*") ? lastID : this.parseId(subset);
                lower = upper;
            } else {
                String[] range = subset.split(":", 2);
                lower = range[0].equals("*") ? lastID : this.parseId(range[0]);
                int n = upper = range[1].equals("*") ? lastID : this.parseId(range[1]);
                if (lower > upper) {
                    int tmp = upper;
                    upper = lower;
                    lower = tmp;
                }
            }
            int insertpos = 0;
            for (int i = 0; i < normalized.size(); ++i) {
                Pair range = (Pair)normalized.get(i);
                int lrange = (Integer)range.getFirst();
                int urange = (Integer)range.getSecond();
                if (lower > urange + 1) {
                    ++insertpos;
                    continue;
                }
                if (upper < lrange - 1) break;
                normalized.remove(i--);
                lower = Math.min(lower, lrange);
                upper = Math.max(upper, urange);
            }
            normalized.add(insertpos, new Pair<Integer, Integer>(lower, upper));
        }
        return normalized;
    }

    ImapMessage.ImapMessageSet getSubsequence(String tag, String subseqStr, boolean byUID) throws ImapParseException {
        return this.getSubsequence(tag, subseqStr, byUID, false);
    }

    ImapMessage.ImapMessageSet getSubsequence(String tag, String subseqStr, boolean byUID, boolean isSEARCH) throws ImapParseException {
        ImapMessage.ImapMessageSet result = new ImapMessage.ImapMessageSet();
        if (subseqStr == null || subseqStr.trim().equals("")) {
            return result;
        }
        if (subseqStr.equals("$")) {
            return this.getSavedSearchResults();
        }
        for (Pair<Integer, Integer> range : this.normalizeSubsequence(subseqStr, byUID)) {
            int lower = range.getFirst();
            int upper = range.getSecond();
            if (!(byUID || lower >= 1 && upper <= this.getSize() || isSEARCH)) {
                throw new ImapParseException(tag, "invalid message sequence number: " + subseqStr);
            }
            if (lower == upper) {
                result.add(byUID ? this.getByImapId(lower) : this.getBySequence(lower));
                continue;
            }
            if (!byUID) {
                upper = Math.min(this.getSize(), upper);
                for (int seq = Math.max(0, lower); seq <= upper; ++seq) {
                    result.add(this.getBySequence(seq));
                }
                continue;
            }
            int start = this.uidSearch(lower);
            int end = this.uidSearch(upper);
            if (start < 0) {
                start = -start - 1;
            }
            if (end < 0) {
                end = -end - 2;
            }
            for (int seq = start; seq <= end; ++seq) {
                ImapMessage i4msg = this.getBySequence(seq + 1);
                if (i4msg == null) continue;
                result.add(i4msg);
            }
        }
        return result;
    }

    String cropSubsequence(String subseqStr, boolean byUID, int croplow, int crophigh) {
        if (croplow <= 0 && crophigh <= 0) {
            return subseqStr;
        }
        StringBuilder sb = new StringBuilder(subseqStr.length());
        for (Pair<Integer, Integer> range : this.normalizeSubsequence(subseqStr, byUID)) {
            int lower = range.getFirst();
            int upper = range.getSecond();
            if (croplow > 0 && upper < croplow || crophigh > 0 && lower > crophigh) continue;
            if (croplow > 0) {
                lower = Math.max(lower, croplow);
            }
            if (crophigh > 0) {
                upper = Math.min(upper, crophigh);
            }
            sb.append(sb.length() == 0 ? "" : ",").append(lower).append(lower == upper ? "" : ":" + upper);
        }
        return sb.toString();
    }

    String invertSubsequence(String subseqStr, boolean byUID, Set<ImapMessage> i4set) {
        int id;
        StringBuilder sb = new StringBuilder();
        Iterator<ImapMessage> i4it = i4set.iterator();
        Iterator<Pair<Integer, Integer>> itrange = this.normalizeSubsequence(subseqStr, byUID).iterator();
        if (!itrange.hasNext()) {
            return subseqStr;
        }
        Pair<Integer, Integer> range = itrange.next();
        int lower = range.getFirst();
        int upper = range.getSecond();
        int n = !i4it.hasNext() ? -1 : (id = byUID ? i4it.next().imapUid : i4it.next().sequence);
        while (lower != -1) {
            if (lower > upper) {
                if (!itrange.hasNext()) break;
                range = itrange.next();
                lower = range.getFirst();
                upper = range.getSecond();
                continue;
            }
            if (id == -1 || id > upper) {
                sb.append(sb.length() == 0 ? "" : ",").append(lower).append(lower == upper ? "" : ":" + upper);
                if (!itrange.hasNext()) break;
                range = itrange.next();
                lower = range.getFirst();
                upper = range.getSecond();
                continue;
            }
            if (id <= lower) {
                if (id == lower) {
                    ++lower;
                }
                id = !i4it.hasNext() ? -1 : (byUID ? i4it.next().imapUid : i4it.next().sequence);
                continue;
            }
            sb.append(sb.length() == 0 ? "" : ",").append(lower).append(lower == id - 1 ? "" : ":" + (id - 1));
            lower = id + 1;
            id = !i4it.hasNext() ? -1 : (byUID ? i4it.next().imapUid : i4it.next().sequence);
        }
        return sb.toString();
    }

    static String encodeSubsequence(List<Integer> items) {
        boolean done;
        if (items == null || items.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int start = -1;
        int last = -1;
        Iterator<Integer> it = items.iterator();
        do {
            int next;
            done = !it.hasNext();
            int n = next = done ? -1 : it.next();
            if (last == -1) {
                last = start = next;
                continue;
            }
            if (done || next != last + 1) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(start);
                if (start != last) {
                    sb.append(':').append(last);
                }
                last = start = next;
                continue;
            }
            last = next;
        } while (!done);
        return sb.toString();
    }

    static String encodeSubsequence(Collection<ImapMessage> items, boolean byUID) {
        boolean done;
        if (items == null || items.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int start = -1;
        int last = -1;
        Iterator<ImapMessage> it = items.iterator();
        do {
            int next;
            boolean bl = done = !it.hasNext();
            int n = done ? -1 : (next = byUID ? it.next().imapUid : it.next().sequence);
            if (last == -1) {
                last = start = next;
                continue;
            }
            if (done || next != last + 1) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(start);
                if (start != last) {
                    sb.append(':').append(last);
                }
                last = start = next;
                continue;
            }
            last = next;
        } while (!done);
        return sb.toString();
    }

    List<Integer> collapseExpunged() {
        if (this.getSize() == 0) {
            return Collections.emptyList();
        }
        boolean byUID = this.mHandler.sessionActivated(ImapHandler.ImapExtension.QRESYNC);
        boolean debug = ZimbraLog.imap.isDebugEnabled();
        if (debug) {
            ZimbraLog.imap.debug("  ** iterating (collapseExpunged)");
        }
        boolean trimmed = false;
        int seq = 1;
        ArrayList<Integer> removed = new ArrayList<Integer>();
        ListIterator<ImapMessage> lit = this.mSequence.listIterator();
        while (lit.hasNext()) {
            ImapMessage i4msg = lit.next();
            if (i4msg.isExpunged()) {
                if (debug) {
                    ZimbraLog.imap.debug("  ** removing: " + i4msg.msgId);
                }
                this.uncache(i4msg);
                lit.remove();
                if (!i4msg.isAdded()) {
                    removed.add(byUID ? i4msg.imapUid : seq);
                }
                --seq;
                trimmed = true;
            } else if (trimmed) {
                this.setIndex(i4msg, seq);
            }
            ++seq;
        }
        return removed;
    }

    @Override
    public void notifyPendingChanges(PendingModifications pns, int changeId, Session source) {
        ImapHandler handler;
        block18: {
            if (!pns.hasNotifications()) {
                return;
            }
            AddedItems added = new AddedItems();
            if (pns.deleted != null) {
                this.handleDeletes(changeId, pns.deleted.values());
            }
            if (pns.created != null) {
                this.handleCreates(changeId, pns.created.values(), added);
            }
            if (pns.modified != null) {
                this.handleModifies(changeId, pns.modified.values(), added);
            }
            if (this.mSequence != null && !added.isEmpty()) {
                Session s;
                ImapFolder i4folder;
                boolean debug = ZimbraLog.imap.isDebugEnabled();
                added.sort();
                boolean recent = true;
                Iterator<Session> i$ = this.mMailbox.getListeners(Session.Type.IMAP).iterator();
                while (i$.hasNext() && (i4folder = (ImapFolder)(s = i$.next())) != this) {
                    if (!i4folder.isWritable() || i4folder.getId() != this.mFolderId) continue;
                    recent = false;
                    break;
                }
                if (added.numbered != null) {
                    StringBuilder addlog = debug ? new StringBuilder("  ** adding messages (ntfn):") : null;
                    for (ImapMessage i4msg : added.numbered) {
                        this.cache(i4msg, recent);
                        if (debug) {
                            addlog.append(' ').append(i4msg.msgId);
                        }
                        i4msg.setAdded(true);
                        this.dirtyMessage(i4msg, changeId);
                    }
                    if (debug) {
                        ZimbraLog.imap.debug(addlog);
                    }
                }
                if (added.unnumbered != null) {
                    ArrayList<Integer> renumber = new ArrayList<Integer>();
                    StringBuilder chglog = debug ? new StringBuilder("  ** moved; changing imap uid (ntfn):") : null;
                    for (ImapMessage i4msg : added.unnumbered) {
                        renumber.add(i4msg.msgId);
                        if (!debug) continue;
                        chglog.append(' ').append(i4msg.msgId);
                    }
                    try {
                        if (debug) {
                            ZimbraLog.imap.debug(chglog);
                        }
                        this.getMailbox().resetImapUid(this.mCredentials.getContext().setSession(this), renumber);
                    }
                    catch (ServiceException e) {
                        if (!debug) break block18;
                        ZimbraLog.imap.debug("  ** moved; imap uid change failed; msg hidden (ntfn): " + renumber);
                    }
                }
            }
        }
        if ((handler = this.mHandler) != null && handler.isIdle()) {
            try {
                handler.sendNotifications(true, true);
            }
            catch (IOException e) {
                ZimbraLog.imap.debug((Object)"dropping connection due to IOException during IDLE notification", e);
                handler.dropConnection(false);
            }
        }
    }

    private void handleDeletes(int changeId, Collection<Object> deleted) {
        for (Object obj : deleted) {
            int id;
            int n = id = obj instanceof MailItem ? ((MailItem)obj).getId() : ((Integer)obj).intValue();
            if (Tag.validateId(id)) {
                this.mTags.uncache(1L << Tag.getIndex(id));
                this.dirtyTag(id, changeId, true);
                continue;
            }
            if (id <= 0) continue;
            if (id == this.mFolderId) {
                this.mHandler.dropConnection(true);
                continue;
            }
            ImapMessage i4msg = this.getById(id);
            if (i4msg == null) continue;
            this.markMessageExpunged(i4msg);
            ZimbraLog.imap.debug("  ** deleted (ntfn): " + i4msg.msgId);
        }
    }

    private void handleCreates(int changeId, Collection<MailItem> created, AddedItems newItems) {
        for (MailItem item : created) {
            int msgId;
            if (item instanceof Tag) {
                this.cacheTag((Tag)item);
                continue;
            }
            if (item == null || item.getId() <= 0 || !(item instanceof Message) && !(item instanceof Contact) || item.getFolderId() != this.mFolderId || this.getById(msgId = item.getId()) != null) continue;
            ImapMessage i4msg = this.getByImapId(item.getImapUid());
            if (i4msg == null) {
                newItems.add(item);
            }
            ZimbraLog.imap.debug("  ** created (ntfn): " + msgId);
        }
    }

    private void handleModifies(int changeId, Collection<PendingModifications.Change> modified, AddedItems newItems) {
        boolean debug = ZimbraLog.imap.isDebugEnabled();
        for (PendingModifications.Change chg : modified) {
            boolean inFolder;
            if (chg.what instanceof Tag && (chg.why & 0x1000) != 0) {
                Tag ltag = (Tag)chg.what;
                this.mTags.uncache(ltag.getBitmask());
                this.cacheTag(ltag);
                this.dirtyTag(ltag.getId(), changeId);
                continue;
            }
            if (chg.what instanceof Folder && ((Folder)chg.what).getId() == this.mFolderId) {
                Folder folder = (Folder)chg.what;
                if ((chg.why & 4) != 0 && (folder.getFlagBitmask() & Flag.BITMASK_DELETED) != 0) {
                    this.mHandler.dropConnection(true);
                    continue;
                }
                if ((chg.why & 0x1100) == 0) continue;
                this.updatePath(folder);
                continue;
            }
            if (!(chg.what instanceof Message) && !(chg.what instanceof Contact)) continue;
            MailItem item = (MailItem)chg.what;
            boolean bl = inFolder = this.isVirtual() || item.getFolderId() == this.mFolderId;
            if (!inFolder && (chg.why & 0x100) == 0) continue;
            ImapMessage i4msg = this.getById(item.getId());
            if (i4msg == null) {
                if (!inFolder || this.isVirtual()) continue;
                newItems.add(item);
                if (!debug) continue;
                ZimbraLog.imap.debug("  ** moved (ntfn): " + item.getId());
                continue;
            }
            if (!inFolder && !this.isVirtual()) {
                this.markMessageExpunged(i4msg);
                continue;
            }
            if ((chg.why & 0x80) != 0) {
                this.markMessageExpunged(i4msg);
                if (!this.isVirtual()) {
                    newItems.add(item);
                }
                if (!debug) continue;
                ZimbraLog.imap.debug("  ** imap uid changed (ntfn): " + item.getId());
                continue;
            }
            if ((chg.why & 7) == 0) continue;
            i4msg.setPermanentFlags(item.getFlagBitmask(), item.getTagBitmask(), changeId, this);
        }
    }

    @Override
    protected void cleanup() {
        if (this.mHandler != null) {
            ZimbraLog.imap.debug("dropping connection because Session is closing");
            this.mHandler.dropConnection(true);
        }
    }

    private static class AddedItems {
        List<ImapMessage> numbered;
        List<ImapMessage> unnumbered;

        AddedItems() {
        }

        boolean isEmpty() {
            return this.numbered == null && this.unnumbered == null;
        }

        void add(MailItem item) {
            if (item.getImapUid() > 0) {
                (this.numbered == null ? (this.numbered = new ArrayList<ImapMessage>()) : this.numbered).add(new ImapMessage(item));
            } else {
                (this.unnumbered == null ? (this.unnumbered = new ArrayList<ImapMessage>()) : this.unnumbered).add(new ImapMessage(item));
            }
        }

        void sort() {
            if (this.numbered != null) {
                Collections.sort(this.numbered);
            }
            if (this.unnumbered != null) {
                Collections.sort(this.unnumbered);
            }
        }
    }

    static final class DirtyMessage {
        ImapMessage i4msg;
        int modseq;

        DirtyMessage(ImapMessage m, int s) {
            this.i4msg = m;
            this.modseq = s;
        }
    }
}

